"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationSettings = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings gitlab_application_settings}
*/
class ApplicationSettings extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings gitlab_application_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationSettingsConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'gitlab_application_settings',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '15.10.0',
                providerVersionConstraint: '~> 15.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._abuseNotificationEmail = config.abuseNotificationEmail;
        this._adminMode = config.adminMode;
        this._afterSignOutPath = config.afterSignOutPath;
        this._afterSignUpText = config.afterSignUpText;
        this._akismetApiKey = config.akismetApiKey;
        this._akismetEnabled = config.akismetEnabled;
        this._allowGroupOwnersToManageLdap = config.allowGroupOwnersToManageLdap;
        this._allowLocalRequestsFromSystemHooks = config.allowLocalRequestsFromSystemHooks;
        this._allowLocalRequestsFromWebHooksAndServices = config.allowLocalRequestsFromWebHooksAndServices;
        this._archiveBuildsInHumanReadable = config.archiveBuildsInHumanReadable;
        this._assetProxyAllowlist = config.assetProxyAllowlist;
        this._assetProxyEnabled = config.assetProxyEnabled;
        this._assetProxySecretKey = config.assetProxySecretKey;
        this._assetProxyUrl = config.assetProxyUrl;
        this._authorizedKeysEnabled = config.authorizedKeysEnabled;
        this._autoDevopsDomain = config.autoDevopsDomain;
        this._autoDevopsEnabled = config.autoDevopsEnabled;
        this._automaticPurchasedStorageAllocation = config.automaticPurchasedStorageAllocation;
        this._checkNamespacePlan = config.checkNamespacePlan;
        this._commitEmailHostname = config.commitEmailHostname;
        this._containerExpirationPoliciesEnableHistoricEntries = config.containerExpirationPoliciesEnableHistoricEntries;
        this._containerRegistryCleanupTagsServiceMaxListSize = config.containerRegistryCleanupTagsServiceMaxListSize;
        this._containerRegistryDeleteTagsServiceTimeout = config.containerRegistryDeleteTagsServiceTimeout;
        this._containerRegistryExpirationPoliciesCaching = config.containerRegistryExpirationPoliciesCaching;
        this._containerRegistryExpirationPoliciesWorkerCapacity = config.containerRegistryExpirationPoliciesWorkerCapacity;
        this._containerRegistryTokenExpireDelay = config.containerRegistryTokenExpireDelay;
        this._deactivateDormantUsers = config.deactivateDormantUsers;
        this._defaultArtifactsExpireIn = config.defaultArtifactsExpireIn;
        this._defaultBranchName = config.defaultBranchName;
        this._defaultBranchProtection = config.defaultBranchProtection;
        this._defaultCiConfigPath = config.defaultCiConfigPath;
        this._defaultGroupVisibility = config.defaultGroupVisibility;
        this._defaultProjectCreation = config.defaultProjectCreation;
        this._defaultProjectVisibility = config.defaultProjectVisibility;
        this._defaultProjectsLimit = config.defaultProjectsLimit;
        this._defaultSnippetVisibility = config.defaultSnippetVisibility;
        this._delayedGroupDeletion = config.delayedGroupDeletion;
        this._delayedProjectDeletion = config.delayedProjectDeletion;
        this._deleteInactiveProjects = config.deleteInactiveProjects;
        this._deletionAdjournedPeriod = config.deletionAdjournedPeriod;
        this._diffMaxFiles = config.diffMaxFiles;
        this._diffMaxLines = config.diffMaxLines;
        this._diffMaxPatchBytes = config.diffMaxPatchBytes;
        this._disableFeedToken = config.disableFeedToken;
        this._disabledOauthSignInSources = config.disabledOauthSignInSources;
        this._dnsRebindingProtectionEnabled = config.dnsRebindingProtectionEnabled;
        this._domainAllowlist = config.domainAllowlist;
        this._domainDenylist = config.domainDenylist;
        this._domainDenylistEnabled = config.domainDenylistEnabled;
        this._dsaKeyRestriction = config.dsaKeyRestriction;
        this._ecdsaKeyRestriction = config.ecdsaKeyRestriction;
        this._ecdsaSkKeyRestriction = config.ecdsaSkKeyRestriction;
        this._ed25519KeyRestriction = config.ed25519KeyRestriction;
        this._ed25519SkKeyRestriction = config.ed25519SkKeyRestriction;
        this._eksAccessKeyId = config.eksAccessKeyId;
        this._eksAccountId = config.eksAccountId;
        this._eksIntegrationEnabled = config.eksIntegrationEnabled;
        this._eksSecretAccessKey = config.eksSecretAccessKey;
        this._elasticsearchAws = config.elasticsearchAws;
        this._elasticsearchAwsAccessKey = config.elasticsearchAwsAccessKey;
        this._elasticsearchAwsRegion = config.elasticsearchAwsRegion;
        this._elasticsearchAwsSecretAccessKey = config.elasticsearchAwsSecretAccessKey;
        this._elasticsearchIndexedFieldLengthLimit = config.elasticsearchIndexedFieldLengthLimit;
        this._elasticsearchIndexedFileSizeLimitKb = config.elasticsearchIndexedFileSizeLimitKb;
        this._elasticsearchIndexing = config.elasticsearchIndexing;
        this._elasticsearchLimitIndexing = config.elasticsearchLimitIndexing;
        this._elasticsearchMaxBulkConcurrency = config.elasticsearchMaxBulkConcurrency;
        this._elasticsearchMaxBulkSizeMb = config.elasticsearchMaxBulkSizeMb;
        this._elasticsearchNamespaceIds = config.elasticsearchNamespaceIds;
        this._elasticsearchPassword = config.elasticsearchPassword;
        this._elasticsearchProjectIds = config.elasticsearchProjectIds;
        this._elasticsearchSearch = config.elasticsearchSearch;
        this._elasticsearchUrl = config.elasticsearchUrl;
        this._elasticsearchUsername = config.elasticsearchUsername;
        this._emailAdditionalText = config.emailAdditionalText;
        this._emailAuthorInBody = config.emailAuthorInBody;
        this._enabledGitAccessProtocol = config.enabledGitAccessProtocol;
        this._enforceNamespaceStorageLimit = config.enforceNamespaceStorageLimit;
        this._enforceTerms = config.enforceTerms;
        this._externalAuthClientCert = config.externalAuthClientCert;
        this._externalAuthClientKey = config.externalAuthClientKey;
        this._externalAuthClientKeyPass = config.externalAuthClientKeyPass;
        this._externalAuthorizationServiceDefaultLabel = config.externalAuthorizationServiceDefaultLabel;
        this._externalAuthorizationServiceEnabled = config.externalAuthorizationServiceEnabled;
        this._externalAuthorizationServiceTimeout = config.externalAuthorizationServiceTimeout;
        this._externalAuthorizationServiceUrl = config.externalAuthorizationServiceUrl;
        this._externalPipelineValidationServiceTimeout = config.externalPipelineValidationServiceTimeout;
        this._externalPipelineValidationServiceToken = config.externalPipelineValidationServiceToken;
        this._externalPipelineValidationServiceUrl = config.externalPipelineValidationServiceUrl;
        this._fileTemplateProjectId = config.fileTemplateProjectId;
        this._firstDayOfWeek = config.firstDayOfWeek;
        this._geoNodeAllowedIps = config.geoNodeAllowedIps;
        this._geoStatusTimeout = config.geoStatusTimeout;
        this._gitRateLimitUsersAllowlist = config.gitRateLimitUsersAllowlist;
        this._gitTwoFactorSessionExpiry = config.gitTwoFactorSessionExpiry;
        this._gitalyTimeoutDefault = config.gitalyTimeoutDefault;
        this._gitalyTimeoutFast = config.gitalyTimeoutFast;
        this._gitalyTimeoutMedium = config.gitalyTimeoutMedium;
        this._grafanaEnabled = config.grafanaEnabled;
        this._grafanaUrl = config.grafanaUrl;
        this._gravatarEnabled = config.gravatarEnabled;
        this._groupOwnersCanManageDefaultBranchProtection = config.groupOwnersCanManageDefaultBranchProtection;
        this._hashedStorageEnabled = config.hashedStorageEnabled;
        this._helpPageHideCommercialContent = config.helpPageHideCommercialContent;
        this._helpPageSupportUrl = config.helpPageSupportUrl;
        this._helpPageText = config.helpPageText;
        this._helpText = config.helpText;
        this._hideThirdPartyOffers = config.hideThirdPartyOffers;
        this._homePageUrl = config.homePageUrl;
        this._housekeepingEnabled = config.housekeepingEnabled;
        this._housekeepingFullRepackPeriod = config.housekeepingFullRepackPeriod;
        this._housekeepingGcPeriod = config.housekeepingGcPeriod;
        this._housekeepingIncrementalRepackPeriod = config.housekeepingIncrementalRepackPeriod;
        this._htmlEmailsEnabled = config.htmlEmailsEnabled;
        this._id = config.id;
        this._importSources = config.importSources;
        this._inProductMarketingEmailsEnabled = config.inProductMarketingEmailsEnabled;
        this._inactiveProjectsDeleteAfterMonths = config.inactiveProjectsDeleteAfterMonths;
        this._inactiveProjectsMinSizeMb = config.inactiveProjectsMinSizeMb;
        this._inactiveProjectsSendWarningEmailAfterMonths = config.inactiveProjectsSendWarningEmailAfterMonths;
        this._invisibleCaptchaEnabled = config.invisibleCaptchaEnabled;
        this._issuesCreateLimit = config.issuesCreateLimit;
        this._keepLatestArtifact = config.keepLatestArtifact;
        this._localMarkdownVersion = config.localMarkdownVersion;
        this._mailgunEventsEnabled = config.mailgunEventsEnabled;
        this._mailgunSigningKey = config.mailgunSigningKey;
        this._maintenanceMode = config.maintenanceMode;
        this._maintenanceModeMessage = config.maintenanceModeMessage;
        this._maxArtifactsSize = config.maxArtifactsSize;
        this._maxAttachmentSize = config.maxAttachmentSize;
        this._maxExportSize = config.maxExportSize;
        this._maxImportSize = config.maxImportSize;
        this._maxNumberOfRepositoryDownloads = config.maxNumberOfRepositoryDownloads;
        this._maxNumberOfRepositoryDownloadsWithinTimePeriod = config.maxNumberOfRepositoryDownloadsWithinTimePeriod;
        this._maxPagesSize = config.maxPagesSize;
        this._maxPersonalAccessTokenLifetime = config.maxPersonalAccessTokenLifetime;
        this._maxSshKeyLifetime = config.maxSshKeyLifetime;
        this._metricsMethodCallThreshold = config.metricsMethodCallThreshold;
        this._mirrorAvailable = config.mirrorAvailable;
        this._mirrorCapacityThreshold = config.mirrorCapacityThreshold;
        this._mirrorMaxCapacity = config.mirrorMaxCapacity;
        this._mirrorMaxDelay = config.mirrorMaxDelay;
        this._npmPackageRequestsForwarding = config.npmPackageRequestsForwarding;
        this._outboundLocalRequestsWhitelist = config.outboundLocalRequestsWhitelist;
        this._packageRegistryCleanupPoliciesWorkerCapacity = config.packageRegistryCleanupPoliciesWorkerCapacity;
        this._pagesDomainVerificationEnabled = config.pagesDomainVerificationEnabled;
        this._passwordAuthenticationEnabledForGit = config.passwordAuthenticationEnabledForGit;
        this._passwordAuthenticationEnabledForWeb = config.passwordAuthenticationEnabledForWeb;
        this._passwordLowercaseRequired = config.passwordLowercaseRequired;
        this._passwordNumberRequired = config.passwordNumberRequired;
        this._passwordSymbolRequired = config.passwordSymbolRequired;
        this._passwordUppercaseRequired = config.passwordUppercaseRequired;
        this._performanceBarAllowedGroupPath = config.performanceBarAllowedGroupPath;
        this._personalAccessTokenPrefix = config.personalAccessTokenPrefix;
        this._pipelineLimitPerProjectUserSha = config.pipelineLimitPerProjectUserSha;
        this._plantumlEnabled = config.plantumlEnabled;
        this._plantumlUrl = config.plantumlUrl;
        this._pollingIntervalMultiplier = config.pollingIntervalMultiplier;
        this._projectExportEnabled = config.projectExportEnabled;
        this._prometheusMetricsEnabled = config.prometheusMetricsEnabled;
        this._protectedCiVariables = config.protectedCiVariables;
        this._pushEventActivitiesLimit = config.pushEventActivitiesLimit;
        this._pushEventHooksLimit = config.pushEventHooksLimit;
        this._pypiPackageRequestsForwarding = config.pypiPackageRequestsForwarding;
        this._rateLimitingResponseText = config.rateLimitingResponseText;
        this._rawBlobRequestLimit = config.rawBlobRequestLimit;
        this._recaptchaEnabled = config.recaptchaEnabled;
        this._recaptchaPrivateKey = config.recaptchaPrivateKey;
        this._recaptchaSiteKey = config.recaptchaSiteKey;
        this._receiveMaxInputSize = config.receiveMaxInputSize;
        this._repositoryChecksEnabled = config.repositoryChecksEnabled;
        this._repositorySizeLimit = config.repositorySizeLimit;
        this._repositoryStorages = config.repositoryStorages;
        this._repositoryStoragesWeighted = config.repositoryStoragesWeighted;
        this._requireAdminApprovalAfterUserSignup = config.requireAdminApprovalAfterUserSignup;
        this._requireTwoFactorAuthentication = config.requireTwoFactorAuthentication;
        this._restrictedVisibilityLevels = config.restrictedVisibilityLevels;
        this._rsaKeyRestriction = config.rsaKeyRestriction;
        this._searchRateLimit = config.searchRateLimit;
        this._searchRateLimitUnauthenticated = config.searchRateLimitUnauthenticated;
        this._sendUserConfirmationEmail = config.sendUserConfirmationEmail;
        this._sessionExpireDelay = config.sessionExpireDelay;
        this._sharedRunnersEnabled = config.sharedRunnersEnabled;
        this._sharedRunnersMinutes = config.sharedRunnersMinutes;
        this._sharedRunnersText = config.sharedRunnersText;
        this._sidekiqJobLimiterCompressionThresholdBytes = config.sidekiqJobLimiterCompressionThresholdBytes;
        this._sidekiqJobLimiterLimitBytes = config.sidekiqJobLimiterLimitBytes;
        this._sidekiqJobLimiterMode = config.sidekiqJobLimiterMode;
        this._signInText = config.signInText;
        this._signupEnabled = config.signupEnabled;
        this._slackAppEnabled = config.slackAppEnabled;
        this._slackAppId = config.slackAppId;
        this._slackAppSecret = config.slackAppSecret;
        this._slackAppSigningSecret = config.slackAppSigningSecret;
        this._slackAppVerificationToken = config.slackAppVerificationToken;
        this._snippetSizeLimit = config.snippetSizeLimit;
        this._snowplowAppId = config.snowplowAppId;
        this._snowplowCollectorHostname = config.snowplowCollectorHostname;
        this._snowplowCookieDomain = config.snowplowCookieDomain;
        this._snowplowEnabled = config.snowplowEnabled;
        this._sourcegraphEnabled = config.sourcegraphEnabled;
        this._sourcegraphPublicOnly = config.sourcegraphPublicOnly;
        this._sourcegraphUrl = config.sourcegraphUrl;
        this._spamCheckApiKey = config.spamCheckApiKey;
        this._spamCheckEndpointEnabled = config.spamCheckEndpointEnabled;
        this._spamCheckEndpointUrl = config.spamCheckEndpointUrl;
        this._suggestPipelineEnabled = config.suggestPipelineEnabled;
        this._terminalMaxSessionTime = config.terminalMaxSessionTime;
        this._terms = config.terms;
        this._throttleAuthenticatedApiEnabled = config.throttleAuthenticatedApiEnabled;
        this._throttleAuthenticatedApiPeriodInSeconds = config.throttleAuthenticatedApiPeriodInSeconds;
        this._throttleAuthenticatedApiRequestsPerPeriod = config.throttleAuthenticatedApiRequestsPerPeriod;
        this._throttleAuthenticatedPackagesApiEnabled = config.throttleAuthenticatedPackagesApiEnabled;
        this._throttleAuthenticatedPackagesApiPeriodInSeconds = config.throttleAuthenticatedPackagesApiPeriodInSeconds;
        this._throttleAuthenticatedPackagesApiRequestsPerPeriod = config.throttleAuthenticatedPackagesApiRequestsPerPeriod;
        this._throttleAuthenticatedWebEnabled = config.throttleAuthenticatedWebEnabled;
        this._throttleAuthenticatedWebPeriodInSeconds = config.throttleAuthenticatedWebPeriodInSeconds;
        this._throttleAuthenticatedWebRequestsPerPeriod = config.throttleAuthenticatedWebRequestsPerPeriod;
        this._throttleUnauthenticatedApiEnabled = config.throttleUnauthenticatedApiEnabled;
        this._throttleUnauthenticatedApiPeriodInSeconds = config.throttleUnauthenticatedApiPeriodInSeconds;
        this._throttleUnauthenticatedApiRequestsPerPeriod = config.throttleUnauthenticatedApiRequestsPerPeriod;
        this._throttleUnauthenticatedPackagesApiEnabled = config.throttleUnauthenticatedPackagesApiEnabled;
        this._throttleUnauthenticatedPackagesApiPeriodInSeconds = config.throttleUnauthenticatedPackagesApiPeriodInSeconds;
        this._throttleUnauthenticatedPackagesApiRequestsPerPeriod = config.throttleUnauthenticatedPackagesApiRequestsPerPeriod;
        this._throttleUnauthenticatedWebEnabled = config.throttleUnauthenticatedWebEnabled;
        this._throttleUnauthenticatedWebPeriodInSeconds = config.throttleUnauthenticatedWebPeriodInSeconds;
        this._throttleUnauthenticatedWebRequestsPerPeriod = config.throttleUnauthenticatedWebRequestsPerPeriod;
        this._timeTrackingLimitToHours = config.timeTrackingLimitToHours;
        this._twoFactorGracePeriod = config.twoFactorGracePeriod;
        this._uniqueIpsLimitEnabled = config.uniqueIpsLimitEnabled;
        this._uniqueIpsLimitPerUser = config.uniqueIpsLimitPerUser;
        this._uniqueIpsLimitTimeWindow = config.uniqueIpsLimitTimeWindow;
        this._usagePingEnabled = config.usagePingEnabled;
        this._userDeactivationEmailsEnabled = config.userDeactivationEmailsEnabled;
        this._userDefaultExternal = config.userDefaultExternal;
        this._userDefaultInternalRegex = config.userDefaultInternalRegex;
        this._userOauthApplications = config.userOauthApplications;
        this._userShowAddSshKeyMessage = config.userShowAddSshKeyMessage;
        this._versionCheckEnabled = config.versionCheckEnabled;
        this._webIdeClientsidePreviewEnabled = config.webIdeClientsidePreviewEnabled;
        this._whatsNewVariant = config.whatsNewVariant;
        this._wikiPageMaxContentBytes = config.wikiPageMaxContentBytes;
    }
    get abuseNotificationEmail() {
        return this.getStringAttribute('abuse_notification_email');
    }
    set abuseNotificationEmail(value) {
        this._abuseNotificationEmail = value;
    }
    resetAbuseNotificationEmail() {
        this._abuseNotificationEmail = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get abuseNotificationEmailInput() {
        return this._abuseNotificationEmail;
    }
    get adminMode() {
        return this.getBooleanAttribute('admin_mode');
    }
    set adminMode(value) {
        this._adminMode = value;
    }
    resetAdminMode() {
        this._adminMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get adminModeInput() {
        return this._adminMode;
    }
    get afterSignOutPath() {
        return this.getStringAttribute('after_sign_out_path');
    }
    set afterSignOutPath(value) {
        this._afterSignOutPath = value;
    }
    resetAfterSignOutPath() {
        this._afterSignOutPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get afterSignOutPathInput() {
        return this._afterSignOutPath;
    }
    get afterSignUpText() {
        return this.getStringAttribute('after_sign_up_text');
    }
    set afterSignUpText(value) {
        this._afterSignUpText = value;
    }
    resetAfterSignUpText() {
        this._afterSignUpText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get afterSignUpTextInput() {
        return this._afterSignUpText;
    }
    get akismetApiKey() {
        return this.getStringAttribute('akismet_api_key');
    }
    set akismetApiKey(value) {
        this._akismetApiKey = value;
    }
    resetAkismetApiKey() {
        this._akismetApiKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get akismetApiKeyInput() {
        return this._akismetApiKey;
    }
    get akismetEnabled() {
        return this.getBooleanAttribute('akismet_enabled');
    }
    set akismetEnabled(value) {
        this._akismetEnabled = value;
    }
    resetAkismetEnabled() {
        this._akismetEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get akismetEnabledInput() {
        return this._akismetEnabled;
    }
    get allowGroupOwnersToManageLdap() {
        return this.getBooleanAttribute('allow_group_owners_to_manage_ldap');
    }
    set allowGroupOwnersToManageLdap(value) {
        this._allowGroupOwnersToManageLdap = value;
    }
    resetAllowGroupOwnersToManageLdap() {
        this._allowGroupOwnersToManageLdap = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowGroupOwnersToManageLdapInput() {
        return this._allowGroupOwnersToManageLdap;
    }
    get allowLocalRequestsFromSystemHooks() {
        return this.getBooleanAttribute('allow_local_requests_from_system_hooks');
    }
    set allowLocalRequestsFromSystemHooks(value) {
        this._allowLocalRequestsFromSystemHooks = value;
    }
    resetAllowLocalRequestsFromSystemHooks() {
        this._allowLocalRequestsFromSystemHooks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowLocalRequestsFromSystemHooksInput() {
        return this._allowLocalRequestsFromSystemHooks;
    }
    get allowLocalRequestsFromWebHooksAndServices() {
        return this.getBooleanAttribute('allow_local_requests_from_web_hooks_and_services');
    }
    set allowLocalRequestsFromWebHooksAndServices(value) {
        this._allowLocalRequestsFromWebHooksAndServices = value;
    }
    resetAllowLocalRequestsFromWebHooksAndServices() {
        this._allowLocalRequestsFromWebHooksAndServices = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowLocalRequestsFromWebHooksAndServicesInput() {
        return this._allowLocalRequestsFromWebHooksAndServices;
    }
    get archiveBuildsInHumanReadable() {
        return this.getStringAttribute('archive_builds_in_human_readable');
    }
    set archiveBuildsInHumanReadable(value) {
        this._archiveBuildsInHumanReadable = value;
    }
    resetArchiveBuildsInHumanReadable() {
        this._archiveBuildsInHumanReadable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get archiveBuildsInHumanReadableInput() {
        return this._archiveBuildsInHumanReadable;
    }
    get assetProxyAllowlist() {
        return this.getListAttribute('asset_proxy_allowlist');
    }
    set assetProxyAllowlist(value) {
        this._assetProxyAllowlist = value;
    }
    resetAssetProxyAllowlist() {
        this._assetProxyAllowlist = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get assetProxyAllowlistInput() {
        return this._assetProxyAllowlist;
    }
    get assetProxyEnabled() {
        return this.getBooleanAttribute('asset_proxy_enabled');
    }
    set assetProxyEnabled(value) {
        this._assetProxyEnabled = value;
    }
    resetAssetProxyEnabled() {
        this._assetProxyEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get assetProxyEnabledInput() {
        return this._assetProxyEnabled;
    }
    get assetProxySecretKey() {
        return this.getStringAttribute('asset_proxy_secret_key');
    }
    set assetProxySecretKey(value) {
        this._assetProxySecretKey = value;
    }
    resetAssetProxySecretKey() {
        this._assetProxySecretKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get assetProxySecretKeyInput() {
        return this._assetProxySecretKey;
    }
    get assetProxyUrl() {
        return this.getStringAttribute('asset_proxy_url');
    }
    set assetProxyUrl(value) {
        this._assetProxyUrl = value;
    }
    resetAssetProxyUrl() {
        this._assetProxyUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get assetProxyUrlInput() {
        return this._assetProxyUrl;
    }
    get authorizedKeysEnabled() {
        return this.getBooleanAttribute('authorized_keys_enabled');
    }
    set authorizedKeysEnabled(value) {
        this._authorizedKeysEnabled = value;
    }
    resetAuthorizedKeysEnabled() {
        this._authorizedKeysEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authorizedKeysEnabledInput() {
        return this._authorizedKeysEnabled;
    }
    get autoDevopsDomain() {
        return this.getStringAttribute('auto_devops_domain');
    }
    set autoDevopsDomain(value) {
        this._autoDevopsDomain = value;
    }
    resetAutoDevopsDomain() {
        this._autoDevopsDomain = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoDevopsDomainInput() {
        return this._autoDevopsDomain;
    }
    get autoDevopsEnabled() {
        return this.getBooleanAttribute('auto_devops_enabled');
    }
    set autoDevopsEnabled(value) {
        this._autoDevopsEnabled = value;
    }
    resetAutoDevopsEnabled() {
        this._autoDevopsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoDevopsEnabledInput() {
        return this._autoDevopsEnabled;
    }
    get automaticPurchasedStorageAllocation() {
        return this.getBooleanAttribute('automatic_purchased_storage_allocation');
    }
    set automaticPurchasedStorageAllocation(value) {
        this._automaticPurchasedStorageAllocation = value;
    }
    resetAutomaticPurchasedStorageAllocation() {
        this._automaticPurchasedStorageAllocation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get automaticPurchasedStorageAllocationInput() {
        return this._automaticPurchasedStorageAllocation;
    }
    get checkNamespacePlan() {
        return this.getBooleanAttribute('check_namespace_plan');
    }
    set checkNamespacePlan(value) {
        this._checkNamespacePlan = value;
    }
    resetCheckNamespacePlan() {
        this._checkNamespacePlan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get checkNamespacePlanInput() {
        return this._checkNamespacePlan;
    }
    get commitEmailHostname() {
        return this.getStringAttribute('commit_email_hostname');
    }
    set commitEmailHostname(value) {
        this._commitEmailHostname = value;
    }
    resetCommitEmailHostname() {
        this._commitEmailHostname = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitEmailHostnameInput() {
        return this._commitEmailHostname;
    }
    get containerExpirationPoliciesEnableHistoricEntries() {
        return this.getBooleanAttribute('container_expiration_policies_enable_historic_entries');
    }
    set containerExpirationPoliciesEnableHistoricEntries(value) {
        this._containerExpirationPoliciesEnableHistoricEntries = value;
    }
    resetContainerExpirationPoliciesEnableHistoricEntries() {
        this._containerExpirationPoliciesEnableHistoricEntries = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerExpirationPoliciesEnableHistoricEntriesInput() {
        return this._containerExpirationPoliciesEnableHistoricEntries;
    }
    get containerRegistryCleanupTagsServiceMaxListSize() {
        return this.getNumberAttribute('container_registry_cleanup_tags_service_max_list_size');
    }
    set containerRegistryCleanupTagsServiceMaxListSize(value) {
        this._containerRegistryCleanupTagsServiceMaxListSize = value;
    }
    resetContainerRegistryCleanupTagsServiceMaxListSize() {
        this._containerRegistryCleanupTagsServiceMaxListSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryCleanupTagsServiceMaxListSizeInput() {
        return this._containerRegistryCleanupTagsServiceMaxListSize;
    }
    get containerRegistryDeleteTagsServiceTimeout() {
        return this.getNumberAttribute('container_registry_delete_tags_service_timeout');
    }
    set containerRegistryDeleteTagsServiceTimeout(value) {
        this._containerRegistryDeleteTagsServiceTimeout = value;
    }
    resetContainerRegistryDeleteTagsServiceTimeout() {
        this._containerRegistryDeleteTagsServiceTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryDeleteTagsServiceTimeoutInput() {
        return this._containerRegistryDeleteTagsServiceTimeout;
    }
    get containerRegistryExpirationPoliciesCaching() {
        return this.getBooleanAttribute('container_registry_expiration_policies_caching');
    }
    set containerRegistryExpirationPoliciesCaching(value) {
        this._containerRegistryExpirationPoliciesCaching = value;
    }
    resetContainerRegistryExpirationPoliciesCaching() {
        this._containerRegistryExpirationPoliciesCaching = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryExpirationPoliciesCachingInput() {
        return this._containerRegistryExpirationPoliciesCaching;
    }
    get containerRegistryExpirationPoliciesWorkerCapacity() {
        return this.getNumberAttribute('container_registry_expiration_policies_worker_capacity');
    }
    set containerRegistryExpirationPoliciesWorkerCapacity(value) {
        this._containerRegistryExpirationPoliciesWorkerCapacity = value;
    }
    resetContainerRegistryExpirationPoliciesWorkerCapacity() {
        this._containerRegistryExpirationPoliciesWorkerCapacity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryExpirationPoliciesWorkerCapacityInput() {
        return this._containerRegistryExpirationPoliciesWorkerCapacity;
    }
    get containerRegistryTokenExpireDelay() {
        return this.getNumberAttribute('container_registry_token_expire_delay');
    }
    set containerRegistryTokenExpireDelay(value) {
        this._containerRegistryTokenExpireDelay = value;
    }
    resetContainerRegistryTokenExpireDelay() {
        this._containerRegistryTokenExpireDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryTokenExpireDelayInput() {
        return this._containerRegistryTokenExpireDelay;
    }
    get deactivateDormantUsers() {
        return this.getBooleanAttribute('deactivate_dormant_users');
    }
    set deactivateDormantUsers(value) {
        this._deactivateDormantUsers = value;
    }
    resetDeactivateDormantUsers() {
        this._deactivateDormantUsers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deactivateDormantUsersInput() {
        return this._deactivateDormantUsers;
    }
    get defaultArtifactsExpireIn() {
        return this.getStringAttribute('default_artifacts_expire_in');
    }
    set defaultArtifactsExpireIn(value) {
        this._defaultArtifactsExpireIn = value;
    }
    resetDefaultArtifactsExpireIn() {
        this._defaultArtifactsExpireIn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultArtifactsExpireInInput() {
        return this._defaultArtifactsExpireIn;
    }
    get defaultBranchName() {
        return this.getStringAttribute('default_branch_name');
    }
    set defaultBranchName(value) {
        this._defaultBranchName = value;
    }
    resetDefaultBranchName() {
        this._defaultBranchName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultBranchNameInput() {
        return this._defaultBranchName;
    }
    get defaultBranchProtection() {
        return this.getNumberAttribute('default_branch_protection');
    }
    set defaultBranchProtection(value) {
        this._defaultBranchProtection = value;
    }
    resetDefaultBranchProtection() {
        this._defaultBranchProtection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultBranchProtectionInput() {
        return this._defaultBranchProtection;
    }
    get defaultCiConfigPath() {
        return this.getStringAttribute('default_ci_config_path');
    }
    set defaultCiConfigPath(value) {
        this._defaultCiConfigPath = value;
    }
    resetDefaultCiConfigPath() {
        this._defaultCiConfigPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultCiConfigPathInput() {
        return this._defaultCiConfigPath;
    }
    get defaultGroupVisibility() {
        return this.getStringAttribute('default_group_visibility');
    }
    set defaultGroupVisibility(value) {
        this._defaultGroupVisibility = value;
    }
    resetDefaultGroupVisibility() {
        this._defaultGroupVisibility = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultGroupVisibilityInput() {
        return this._defaultGroupVisibility;
    }
    get defaultProjectCreation() {
        return this.getNumberAttribute('default_project_creation');
    }
    set defaultProjectCreation(value) {
        this._defaultProjectCreation = value;
    }
    resetDefaultProjectCreation() {
        this._defaultProjectCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultProjectCreationInput() {
        return this._defaultProjectCreation;
    }
    get defaultProjectVisibility() {
        return this.getStringAttribute('default_project_visibility');
    }
    set defaultProjectVisibility(value) {
        this._defaultProjectVisibility = value;
    }
    resetDefaultProjectVisibility() {
        this._defaultProjectVisibility = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultProjectVisibilityInput() {
        return this._defaultProjectVisibility;
    }
    get defaultProjectsLimit() {
        return this.getNumberAttribute('default_projects_limit');
    }
    set defaultProjectsLimit(value) {
        this._defaultProjectsLimit = value;
    }
    resetDefaultProjectsLimit() {
        this._defaultProjectsLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultProjectsLimitInput() {
        return this._defaultProjectsLimit;
    }
    get defaultSnippetVisibility() {
        return this.getStringAttribute('default_snippet_visibility');
    }
    set defaultSnippetVisibility(value) {
        this._defaultSnippetVisibility = value;
    }
    resetDefaultSnippetVisibility() {
        this._defaultSnippetVisibility = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultSnippetVisibilityInput() {
        return this._defaultSnippetVisibility;
    }
    get delayedGroupDeletion() {
        return this.getBooleanAttribute('delayed_group_deletion');
    }
    set delayedGroupDeletion(value) {
        this._delayedGroupDeletion = value;
    }
    resetDelayedGroupDeletion() {
        this._delayedGroupDeletion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get delayedGroupDeletionInput() {
        return this._delayedGroupDeletion;
    }
    get delayedProjectDeletion() {
        return this.getBooleanAttribute('delayed_project_deletion');
    }
    set delayedProjectDeletion(value) {
        this._delayedProjectDeletion = value;
    }
    resetDelayedProjectDeletion() {
        this._delayedProjectDeletion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get delayedProjectDeletionInput() {
        return this._delayedProjectDeletion;
    }
    get deleteInactiveProjects() {
        return this.getBooleanAttribute('delete_inactive_projects');
    }
    set deleteInactiveProjects(value) {
        this._deleteInactiveProjects = value;
    }
    resetDeleteInactiveProjects() {
        this._deleteInactiveProjects = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInactiveProjectsInput() {
        return this._deleteInactiveProjects;
    }
    get deletionAdjournedPeriod() {
        return this.getNumberAttribute('deletion_adjourned_period');
    }
    set deletionAdjournedPeriod(value) {
        this._deletionAdjournedPeriod = value;
    }
    resetDeletionAdjournedPeriod() {
        this._deletionAdjournedPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deletionAdjournedPeriodInput() {
        return this._deletionAdjournedPeriod;
    }
    get diffMaxFiles() {
        return this.getNumberAttribute('diff_max_files');
    }
    set diffMaxFiles(value) {
        this._diffMaxFiles = value;
    }
    resetDiffMaxFiles() {
        this._diffMaxFiles = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get diffMaxFilesInput() {
        return this._diffMaxFiles;
    }
    get diffMaxLines() {
        return this.getNumberAttribute('diff_max_lines');
    }
    set diffMaxLines(value) {
        this._diffMaxLines = value;
    }
    resetDiffMaxLines() {
        this._diffMaxLines = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get diffMaxLinesInput() {
        return this._diffMaxLines;
    }
    get diffMaxPatchBytes() {
        return this.getNumberAttribute('diff_max_patch_bytes');
    }
    set diffMaxPatchBytes(value) {
        this._diffMaxPatchBytes = value;
    }
    resetDiffMaxPatchBytes() {
        this._diffMaxPatchBytes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get diffMaxPatchBytesInput() {
        return this._diffMaxPatchBytes;
    }
    get disableFeedToken() {
        return this.getBooleanAttribute('disable_feed_token');
    }
    set disableFeedToken(value) {
        this._disableFeedToken = value;
    }
    resetDisableFeedToken() {
        this._disableFeedToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableFeedTokenInput() {
        return this._disableFeedToken;
    }
    get disabledOauthSignInSources() {
        return this.getListAttribute('disabled_oauth_sign_in_sources');
    }
    set disabledOauthSignInSources(value) {
        this._disabledOauthSignInSources = value;
    }
    resetDisabledOauthSignInSources() {
        this._disabledOauthSignInSources = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disabledOauthSignInSourcesInput() {
        return this._disabledOauthSignInSources;
    }
    get dnsRebindingProtectionEnabled() {
        return this.getBooleanAttribute('dns_rebinding_protection_enabled');
    }
    set dnsRebindingProtectionEnabled(value) {
        this._dnsRebindingProtectionEnabled = value;
    }
    resetDnsRebindingProtectionEnabled() {
        this._dnsRebindingProtectionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dnsRebindingProtectionEnabledInput() {
        return this._dnsRebindingProtectionEnabled;
    }
    get domainAllowlist() {
        return this.getListAttribute('domain_allowlist');
    }
    set domainAllowlist(value) {
        this._domainAllowlist = value;
    }
    resetDomainAllowlist() {
        this._domainAllowlist = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get domainAllowlistInput() {
        return this._domainAllowlist;
    }
    get domainDenylist() {
        return this.getListAttribute('domain_denylist');
    }
    set domainDenylist(value) {
        this._domainDenylist = value;
    }
    resetDomainDenylist() {
        this._domainDenylist = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get domainDenylistInput() {
        return this._domainDenylist;
    }
    get domainDenylistEnabled() {
        return this.getBooleanAttribute('domain_denylist_enabled');
    }
    set domainDenylistEnabled(value) {
        this._domainDenylistEnabled = value;
    }
    resetDomainDenylistEnabled() {
        this._domainDenylistEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get domainDenylistEnabledInput() {
        return this._domainDenylistEnabled;
    }
    get dsaKeyRestriction() {
        return this.getNumberAttribute('dsa_key_restriction');
    }
    set dsaKeyRestriction(value) {
        this._dsaKeyRestriction = value;
    }
    resetDsaKeyRestriction() {
        this._dsaKeyRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dsaKeyRestrictionInput() {
        return this._dsaKeyRestriction;
    }
    get ecdsaKeyRestriction() {
        return this.getNumberAttribute('ecdsa_key_restriction');
    }
    set ecdsaKeyRestriction(value) {
        this._ecdsaKeyRestriction = value;
    }
    resetEcdsaKeyRestriction() {
        this._ecdsaKeyRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ecdsaKeyRestrictionInput() {
        return this._ecdsaKeyRestriction;
    }
    get ecdsaSkKeyRestriction() {
        return this.getNumberAttribute('ecdsa_sk_key_restriction');
    }
    set ecdsaSkKeyRestriction(value) {
        this._ecdsaSkKeyRestriction = value;
    }
    resetEcdsaSkKeyRestriction() {
        this._ecdsaSkKeyRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ecdsaSkKeyRestrictionInput() {
        return this._ecdsaSkKeyRestriction;
    }
    get ed25519KeyRestriction() {
        return this.getNumberAttribute('ed25519_key_restriction');
    }
    set ed25519KeyRestriction(value) {
        this._ed25519KeyRestriction = value;
    }
    resetEd25519KeyRestriction() {
        this._ed25519KeyRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ed25519KeyRestrictionInput() {
        return this._ed25519KeyRestriction;
    }
    get ed25519SkKeyRestriction() {
        return this.getNumberAttribute('ed25519_sk_key_restriction');
    }
    set ed25519SkKeyRestriction(value) {
        this._ed25519SkKeyRestriction = value;
    }
    resetEd25519SkKeyRestriction() {
        this._ed25519SkKeyRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ed25519SkKeyRestrictionInput() {
        return this._ed25519SkKeyRestriction;
    }
    get eksAccessKeyId() {
        return this.getStringAttribute('eks_access_key_id');
    }
    set eksAccessKeyId(value) {
        this._eksAccessKeyId = value;
    }
    resetEksAccessKeyId() {
        this._eksAccessKeyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eksAccessKeyIdInput() {
        return this._eksAccessKeyId;
    }
    get eksAccountId() {
        return this.getStringAttribute('eks_account_id');
    }
    set eksAccountId(value) {
        this._eksAccountId = value;
    }
    resetEksAccountId() {
        this._eksAccountId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eksAccountIdInput() {
        return this._eksAccountId;
    }
    get eksIntegrationEnabled() {
        return this.getBooleanAttribute('eks_integration_enabled');
    }
    set eksIntegrationEnabled(value) {
        this._eksIntegrationEnabled = value;
    }
    resetEksIntegrationEnabled() {
        this._eksIntegrationEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eksIntegrationEnabledInput() {
        return this._eksIntegrationEnabled;
    }
    get eksSecretAccessKey() {
        return this.getStringAttribute('eks_secret_access_key');
    }
    set eksSecretAccessKey(value) {
        this._eksSecretAccessKey = value;
    }
    resetEksSecretAccessKey() {
        this._eksSecretAccessKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eksSecretAccessKeyInput() {
        return this._eksSecretAccessKey;
    }
    get elasticsearchAws() {
        return this.getBooleanAttribute('elasticsearch_aws');
    }
    set elasticsearchAws(value) {
        this._elasticsearchAws = value;
    }
    resetElasticsearchAws() {
        this._elasticsearchAws = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchAwsInput() {
        return this._elasticsearchAws;
    }
    get elasticsearchAwsAccessKey() {
        return this.getStringAttribute('elasticsearch_aws_access_key');
    }
    set elasticsearchAwsAccessKey(value) {
        this._elasticsearchAwsAccessKey = value;
    }
    resetElasticsearchAwsAccessKey() {
        this._elasticsearchAwsAccessKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchAwsAccessKeyInput() {
        return this._elasticsearchAwsAccessKey;
    }
    get elasticsearchAwsRegion() {
        return this.getStringAttribute('elasticsearch_aws_region');
    }
    set elasticsearchAwsRegion(value) {
        this._elasticsearchAwsRegion = value;
    }
    resetElasticsearchAwsRegion() {
        this._elasticsearchAwsRegion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchAwsRegionInput() {
        return this._elasticsearchAwsRegion;
    }
    get elasticsearchAwsSecretAccessKey() {
        return this.getStringAttribute('elasticsearch_aws_secret_access_key');
    }
    set elasticsearchAwsSecretAccessKey(value) {
        this._elasticsearchAwsSecretAccessKey = value;
    }
    resetElasticsearchAwsSecretAccessKey() {
        this._elasticsearchAwsSecretAccessKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchAwsSecretAccessKeyInput() {
        return this._elasticsearchAwsSecretAccessKey;
    }
    get elasticsearchIndexedFieldLengthLimit() {
        return this.getNumberAttribute('elasticsearch_indexed_field_length_limit');
    }
    set elasticsearchIndexedFieldLengthLimit(value) {
        this._elasticsearchIndexedFieldLengthLimit = value;
    }
    resetElasticsearchIndexedFieldLengthLimit() {
        this._elasticsearchIndexedFieldLengthLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchIndexedFieldLengthLimitInput() {
        return this._elasticsearchIndexedFieldLengthLimit;
    }
    get elasticsearchIndexedFileSizeLimitKb() {
        return this.getNumberAttribute('elasticsearch_indexed_file_size_limit_kb');
    }
    set elasticsearchIndexedFileSizeLimitKb(value) {
        this._elasticsearchIndexedFileSizeLimitKb = value;
    }
    resetElasticsearchIndexedFileSizeLimitKb() {
        this._elasticsearchIndexedFileSizeLimitKb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchIndexedFileSizeLimitKbInput() {
        return this._elasticsearchIndexedFileSizeLimitKb;
    }
    get elasticsearchIndexing() {
        return this.getBooleanAttribute('elasticsearch_indexing');
    }
    set elasticsearchIndexing(value) {
        this._elasticsearchIndexing = value;
    }
    resetElasticsearchIndexing() {
        this._elasticsearchIndexing = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchIndexingInput() {
        return this._elasticsearchIndexing;
    }
    get elasticsearchLimitIndexing() {
        return this.getBooleanAttribute('elasticsearch_limit_indexing');
    }
    set elasticsearchLimitIndexing(value) {
        this._elasticsearchLimitIndexing = value;
    }
    resetElasticsearchLimitIndexing() {
        this._elasticsearchLimitIndexing = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchLimitIndexingInput() {
        return this._elasticsearchLimitIndexing;
    }
    get elasticsearchMaxBulkConcurrency() {
        return this.getNumberAttribute('elasticsearch_max_bulk_concurrency');
    }
    set elasticsearchMaxBulkConcurrency(value) {
        this._elasticsearchMaxBulkConcurrency = value;
    }
    resetElasticsearchMaxBulkConcurrency() {
        this._elasticsearchMaxBulkConcurrency = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchMaxBulkConcurrencyInput() {
        return this._elasticsearchMaxBulkConcurrency;
    }
    get elasticsearchMaxBulkSizeMb() {
        return this.getNumberAttribute('elasticsearch_max_bulk_size_mb');
    }
    set elasticsearchMaxBulkSizeMb(value) {
        this._elasticsearchMaxBulkSizeMb = value;
    }
    resetElasticsearchMaxBulkSizeMb() {
        this._elasticsearchMaxBulkSizeMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchMaxBulkSizeMbInput() {
        return this._elasticsearchMaxBulkSizeMb;
    }
    get elasticsearchNamespaceIds() {
        return this.getListAttribute('elasticsearch_namespace_ids');
    }
    set elasticsearchNamespaceIds(value) {
        this._elasticsearchNamespaceIds = value;
    }
    resetElasticsearchNamespaceIds() {
        this._elasticsearchNamespaceIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchNamespaceIdsInput() {
        return this._elasticsearchNamespaceIds;
    }
    get elasticsearchPassword() {
        return this.getStringAttribute('elasticsearch_password');
    }
    set elasticsearchPassword(value) {
        this._elasticsearchPassword = value;
    }
    resetElasticsearchPassword() {
        this._elasticsearchPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchPasswordInput() {
        return this._elasticsearchPassword;
    }
    get elasticsearchProjectIds() {
        return this.getListAttribute('elasticsearch_project_ids');
    }
    set elasticsearchProjectIds(value) {
        this._elasticsearchProjectIds = value;
    }
    resetElasticsearchProjectIds() {
        this._elasticsearchProjectIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchProjectIdsInput() {
        return this._elasticsearchProjectIds;
    }
    get elasticsearchSearch() {
        return this.getBooleanAttribute('elasticsearch_search');
    }
    set elasticsearchSearch(value) {
        this._elasticsearchSearch = value;
    }
    resetElasticsearchSearch() {
        this._elasticsearchSearch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchSearchInput() {
        return this._elasticsearchSearch;
    }
    get elasticsearchUrl() {
        return this.getListAttribute('elasticsearch_url');
    }
    set elasticsearchUrl(value) {
        this._elasticsearchUrl = value;
    }
    resetElasticsearchUrl() {
        this._elasticsearchUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchUrlInput() {
        return this._elasticsearchUrl;
    }
    get elasticsearchUsername() {
        return this.getStringAttribute('elasticsearch_username');
    }
    set elasticsearchUsername(value) {
        this._elasticsearchUsername = value;
    }
    resetElasticsearchUsername() {
        this._elasticsearchUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchUsernameInput() {
        return this._elasticsearchUsername;
    }
    get emailAdditionalText() {
        return this.getStringAttribute('email_additional_text');
    }
    set emailAdditionalText(value) {
        this._emailAdditionalText = value;
    }
    resetEmailAdditionalText() {
        this._emailAdditionalText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailAdditionalTextInput() {
        return this._emailAdditionalText;
    }
    get emailAuthorInBody() {
        return this.getBooleanAttribute('email_author_in_body');
    }
    set emailAuthorInBody(value) {
        this._emailAuthorInBody = value;
    }
    resetEmailAuthorInBody() {
        this._emailAuthorInBody = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailAuthorInBodyInput() {
        return this._emailAuthorInBody;
    }
    get enabledGitAccessProtocol() {
        return this.getStringAttribute('enabled_git_access_protocol');
    }
    set enabledGitAccessProtocol(value) {
        this._enabledGitAccessProtocol = value;
    }
    resetEnabledGitAccessProtocol() {
        this._enabledGitAccessProtocol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledGitAccessProtocolInput() {
        return this._enabledGitAccessProtocol;
    }
    get enforceNamespaceStorageLimit() {
        return this.getBooleanAttribute('enforce_namespace_storage_limit');
    }
    set enforceNamespaceStorageLimit(value) {
        this._enforceNamespaceStorageLimit = value;
    }
    resetEnforceNamespaceStorageLimit() {
        this._enforceNamespaceStorageLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enforceNamespaceStorageLimitInput() {
        return this._enforceNamespaceStorageLimit;
    }
    get enforceTerms() {
        return this.getBooleanAttribute('enforce_terms');
    }
    set enforceTerms(value) {
        this._enforceTerms = value;
    }
    resetEnforceTerms() {
        this._enforceTerms = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enforceTermsInput() {
        return this._enforceTerms;
    }
    get externalAuthClientCert() {
        return this.getStringAttribute('external_auth_client_cert');
    }
    set externalAuthClientCert(value) {
        this._externalAuthClientCert = value;
    }
    resetExternalAuthClientCert() {
        this._externalAuthClientCert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthClientCertInput() {
        return this._externalAuthClientCert;
    }
    get externalAuthClientKey() {
        return this.getStringAttribute('external_auth_client_key');
    }
    set externalAuthClientKey(value) {
        this._externalAuthClientKey = value;
    }
    resetExternalAuthClientKey() {
        this._externalAuthClientKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthClientKeyInput() {
        return this._externalAuthClientKey;
    }
    get externalAuthClientKeyPass() {
        return this.getStringAttribute('external_auth_client_key_pass');
    }
    set externalAuthClientKeyPass(value) {
        this._externalAuthClientKeyPass = value;
    }
    resetExternalAuthClientKeyPass() {
        this._externalAuthClientKeyPass = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthClientKeyPassInput() {
        return this._externalAuthClientKeyPass;
    }
    get externalAuthorizationServiceDefaultLabel() {
        return this.getStringAttribute('external_authorization_service_default_label');
    }
    set externalAuthorizationServiceDefaultLabel(value) {
        this._externalAuthorizationServiceDefaultLabel = value;
    }
    resetExternalAuthorizationServiceDefaultLabel() {
        this._externalAuthorizationServiceDefaultLabel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthorizationServiceDefaultLabelInput() {
        return this._externalAuthorizationServiceDefaultLabel;
    }
    get externalAuthorizationServiceEnabled() {
        return this.getBooleanAttribute('external_authorization_service_enabled');
    }
    set externalAuthorizationServiceEnabled(value) {
        this._externalAuthorizationServiceEnabled = value;
    }
    resetExternalAuthorizationServiceEnabled() {
        this._externalAuthorizationServiceEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthorizationServiceEnabledInput() {
        return this._externalAuthorizationServiceEnabled;
    }
    get externalAuthorizationServiceTimeout() {
        return this.getNumberAttribute('external_authorization_service_timeout');
    }
    set externalAuthorizationServiceTimeout(value) {
        this._externalAuthorizationServiceTimeout = value;
    }
    resetExternalAuthorizationServiceTimeout() {
        this._externalAuthorizationServiceTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthorizationServiceTimeoutInput() {
        return this._externalAuthorizationServiceTimeout;
    }
    get externalAuthorizationServiceUrl() {
        return this.getStringAttribute('external_authorization_service_url');
    }
    set externalAuthorizationServiceUrl(value) {
        this._externalAuthorizationServiceUrl = value;
    }
    resetExternalAuthorizationServiceUrl() {
        this._externalAuthorizationServiceUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthorizationServiceUrlInput() {
        return this._externalAuthorizationServiceUrl;
    }
    get externalPipelineValidationServiceTimeout() {
        return this.getNumberAttribute('external_pipeline_validation_service_timeout');
    }
    set externalPipelineValidationServiceTimeout(value) {
        this._externalPipelineValidationServiceTimeout = value;
    }
    resetExternalPipelineValidationServiceTimeout() {
        this._externalPipelineValidationServiceTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalPipelineValidationServiceTimeoutInput() {
        return this._externalPipelineValidationServiceTimeout;
    }
    get externalPipelineValidationServiceToken() {
        return this.getStringAttribute('external_pipeline_validation_service_token');
    }
    set externalPipelineValidationServiceToken(value) {
        this._externalPipelineValidationServiceToken = value;
    }
    resetExternalPipelineValidationServiceToken() {
        this._externalPipelineValidationServiceToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalPipelineValidationServiceTokenInput() {
        return this._externalPipelineValidationServiceToken;
    }
    get externalPipelineValidationServiceUrl() {
        return this.getStringAttribute('external_pipeline_validation_service_url');
    }
    set externalPipelineValidationServiceUrl(value) {
        this._externalPipelineValidationServiceUrl = value;
    }
    resetExternalPipelineValidationServiceUrl() {
        this._externalPipelineValidationServiceUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalPipelineValidationServiceUrlInput() {
        return this._externalPipelineValidationServiceUrl;
    }
    get fileTemplateProjectId() {
        return this.getNumberAttribute('file_template_project_id');
    }
    set fileTemplateProjectId(value) {
        this._fileTemplateProjectId = value;
    }
    resetFileTemplateProjectId() {
        this._fileTemplateProjectId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fileTemplateProjectIdInput() {
        return this._fileTemplateProjectId;
    }
    get firstDayOfWeek() {
        return this.getNumberAttribute('first_day_of_week');
    }
    set firstDayOfWeek(value) {
        this._firstDayOfWeek = value;
    }
    resetFirstDayOfWeek() {
        this._firstDayOfWeek = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get firstDayOfWeekInput() {
        return this._firstDayOfWeek;
    }
    get geoNodeAllowedIps() {
        return this.getStringAttribute('geo_node_allowed_ips');
    }
    set geoNodeAllowedIps(value) {
        this._geoNodeAllowedIps = value;
    }
    resetGeoNodeAllowedIps() {
        this._geoNodeAllowedIps = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get geoNodeAllowedIpsInput() {
        return this._geoNodeAllowedIps;
    }
    get geoStatusTimeout() {
        return this.getNumberAttribute('geo_status_timeout');
    }
    set geoStatusTimeout(value) {
        this._geoStatusTimeout = value;
    }
    resetGeoStatusTimeout() {
        this._geoStatusTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get geoStatusTimeoutInput() {
        return this._geoStatusTimeout;
    }
    get gitRateLimitUsersAllowlist() {
        return this.getListAttribute('git_rate_limit_users_allowlist');
    }
    set gitRateLimitUsersAllowlist(value) {
        this._gitRateLimitUsersAllowlist = value;
    }
    resetGitRateLimitUsersAllowlist() {
        this._gitRateLimitUsersAllowlist = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gitRateLimitUsersAllowlistInput() {
        return this._gitRateLimitUsersAllowlist;
    }
    get gitTwoFactorSessionExpiry() {
        return this.getNumberAttribute('git_two_factor_session_expiry');
    }
    set gitTwoFactorSessionExpiry(value) {
        this._gitTwoFactorSessionExpiry = value;
    }
    resetGitTwoFactorSessionExpiry() {
        this._gitTwoFactorSessionExpiry = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gitTwoFactorSessionExpiryInput() {
        return this._gitTwoFactorSessionExpiry;
    }
    get gitalyTimeoutDefault() {
        return this.getNumberAttribute('gitaly_timeout_default');
    }
    set gitalyTimeoutDefault(value) {
        this._gitalyTimeoutDefault = value;
    }
    resetGitalyTimeoutDefault() {
        this._gitalyTimeoutDefault = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gitalyTimeoutDefaultInput() {
        return this._gitalyTimeoutDefault;
    }
    get gitalyTimeoutFast() {
        return this.getNumberAttribute('gitaly_timeout_fast');
    }
    set gitalyTimeoutFast(value) {
        this._gitalyTimeoutFast = value;
    }
    resetGitalyTimeoutFast() {
        this._gitalyTimeoutFast = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gitalyTimeoutFastInput() {
        return this._gitalyTimeoutFast;
    }
    get gitalyTimeoutMedium() {
        return this.getNumberAttribute('gitaly_timeout_medium');
    }
    set gitalyTimeoutMedium(value) {
        this._gitalyTimeoutMedium = value;
    }
    resetGitalyTimeoutMedium() {
        this._gitalyTimeoutMedium = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gitalyTimeoutMediumInput() {
        return this._gitalyTimeoutMedium;
    }
    get grafanaEnabled() {
        return this.getBooleanAttribute('grafana_enabled');
    }
    set grafanaEnabled(value) {
        this._grafanaEnabled = value;
    }
    resetGrafanaEnabled() {
        this._grafanaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get grafanaEnabledInput() {
        return this._grafanaEnabled;
    }
    get grafanaUrl() {
        return this.getStringAttribute('grafana_url');
    }
    set grafanaUrl(value) {
        this._grafanaUrl = value;
    }
    resetGrafanaUrl() {
        this._grafanaUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get grafanaUrlInput() {
        return this._grafanaUrl;
    }
    get gravatarEnabled() {
        return this.getBooleanAttribute('gravatar_enabled');
    }
    set gravatarEnabled(value) {
        this._gravatarEnabled = value;
    }
    resetGravatarEnabled() {
        this._gravatarEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gravatarEnabledInput() {
        return this._gravatarEnabled;
    }
    get groupOwnersCanManageDefaultBranchProtection() {
        return this.getBooleanAttribute('group_owners_can_manage_default_branch_protection');
    }
    set groupOwnersCanManageDefaultBranchProtection(value) {
        this._groupOwnersCanManageDefaultBranchProtection = value;
    }
    resetGroupOwnersCanManageDefaultBranchProtection() {
        this._groupOwnersCanManageDefaultBranchProtection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupOwnersCanManageDefaultBranchProtectionInput() {
        return this._groupOwnersCanManageDefaultBranchProtection;
    }
    get hashedStorageEnabled() {
        return this.getBooleanAttribute('hashed_storage_enabled');
    }
    set hashedStorageEnabled(value) {
        this._hashedStorageEnabled = value;
    }
    resetHashedStorageEnabled() {
        this._hashedStorageEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hashedStorageEnabledInput() {
        return this._hashedStorageEnabled;
    }
    get helpPageHideCommercialContent() {
        return this.getBooleanAttribute('help_page_hide_commercial_content');
    }
    set helpPageHideCommercialContent(value) {
        this._helpPageHideCommercialContent = value;
    }
    resetHelpPageHideCommercialContent() {
        this._helpPageHideCommercialContent = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get helpPageHideCommercialContentInput() {
        return this._helpPageHideCommercialContent;
    }
    get helpPageSupportUrl() {
        return this.getStringAttribute('help_page_support_url');
    }
    set helpPageSupportUrl(value) {
        this._helpPageSupportUrl = value;
    }
    resetHelpPageSupportUrl() {
        this._helpPageSupportUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get helpPageSupportUrlInput() {
        return this._helpPageSupportUrl;
    }
    get helpPageText() {
        return this.getStringAttribute('help_page_text');
    }
    set helpPageText(value) {
        this._helpPageText = value;
    }
    resetHelpPageText() {
        this._helpPageText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get helpPageTextInput() {
        return this._helpPageText;
    }
    get helpText() {
        return this.getStringAttribute('help_text');
    }
    set helpText(value) {
        this._helpText = value;
    }
    resetHelpText() {
        this._helpText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get helpTextInput() {
        return this._helpText;
    }
    get hideThirdPartyOffers() {
        return this.getBooleanAttribute('hide_third_party_offers');
    }
    set hideThirdPartyOffers(value) {
        this._hideThirdPartyOffers = value;
    }
    resetHideThirdPartyOffers() {
        this._hideThirdPartyOffers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hideThirdPartyOffersInput() {
        return this._hideThirdPartyOffers;
    }
    get homePageUrl() {
        return this.getStringAttribute('home_page_url');
    }
    set homePageUrl(value) {
        this._homePageUrl = value;
    }
    resetHomePageUrl() {
        this._homePageUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get homePageUrlInput() {
        return this._homePageUrl;
    }
    get housekeepingEnabled() {
        return this.getBooleanAttribute('housekeeping_enabled');
    }
    set housekeepingEnabled(value) {
        this._housekeepingEnabled = value;
    }
    resetHousekeepingEnabled() {
        this._housekeepingEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get housekeepingEnabledInput() {
        return this._housekeepingEnabled;
    }
    get housekeepingFullRepackPeriod() {
        return this.getNumberAttribute('housekeeping_full_repack_period');
    }
    set housekeepingFullRepackPeriod(value) {
        this._housekeepingFullRepackPeriod = value;
    }
    resetHousekeepingFullRepackPeriod() {
        this._housekeepingFullRepackPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get housekeepingFullRepackPeriodInput() {
        return this._housekeepingFullRepackPeriod;
    }
    get housekeepingGcPeriod() {
        return this.getNumberAttribute('housekeeping_gc_period');
    }
    set housekeepingGcPeriod(value) {
        this._housekeepingGcPeriod = value;
    }
    resetHousekeepingGcPeriod() {
        this._housekeepingGcPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get housekeepingGcPeriodInput() {
        return this._housekeepingGcPeriod;
    }
    get housekeepingIncrementalRepackPeriod() {
        return this.getNumberAttribute('housekeeping_incremental_repack_period');
    }
    set housekeepingIncrementalRepackPeriod(value) {
        this._housekeepingIncrementalRepackPeriod = value;
    }
    resetHousekeepingIncrementalRepackPeriod() {
        this._housekeepingIncrementalRepackPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get housekeepingIncrementalRepackPeriodInput() {
        return this._housekeepingIncrementalRepackPeriod;
    }
    get htmlEmailsEnabled() {
        return this.getBooleanAttribute('html_emails_enabled');
    }
    set htmlEmailsEnabled(value) {
        this._htmlEmailsEnabled = value;
    }
    resetHtmlEmailsEnabled() {
        this._htmlEmailsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get htmlEmailsEnabledInput() {
        return this._htmlEmailsEnabled;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get importSources() {
        return this.getListAttribute('import_sources');
    }
    set importSources(value) {
        this._importSources = value;
    }
    resetImportSources() {
        this._importSources = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get importSourcesInput() {
        return this._importSources;
    }
    get inProductMarketingEmailsEnabled() {
        return this.getBooleanAttribute('in_product_marketing_emails_enabled');
    }
    set inProductMarketingEmailsEnabled(value) {
        this._inProductMarketingEmailsEnabled = value;
    }
    resetInProductMarketingEmailsEnabled() {
        this._inProductMarketingEmailsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get inProductMarketingEmailsEnabledInput() {
        return this._inProductMarketingEmailsEnabled;
    }
    get inactiveProjectsDeleteAfterMonths() {
        return this.getNumberAttribute('inactive_projects_delete_after_months');
    }
    set inactiveProjectsDeleteAfterMonths(value) {
        this._inactiveProjectsDeleteAfterMonths = value;
    }
    resetInactiveProjectsDeleteAfterMonths() {
        this._inactiveProjectsDeleteAfterMonths = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get inactiveProjectsDeleteAfterMonthsInput() {
        return this._inactiveProjectsDeleteAfterMonths;
    }
    get inactiveProjectsMinSizeMb() {
        return this.getNumberAttribute('inactive_projects_min_size_mb');
    }
    set inactiveProjectsMinSizeMb(value) {
        this._inactiveProjectsMinSizeMb = value;
    }
    resetInactiveProjectsMinSizeMb() {
        this._inactiveProjectsMinSizeMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get inactiveProjectsMinSizeMbInput() {
        return this._inactiveProjectsMinSizeMb;
    }
    get inactiveProjectsSendWarningEmailAfterMonths() {
        return this.getNumberAttribute('inactive_projects_send_warning_email_after_months');
    }
    set inactiveProjectsSendWarningEmailAfterMonths(value) {
        this._inactiveProjectsSendWarningEmailAfterMonths = value;
    }
    resetInactiveProjectsSendWarningEmailAfterMonths() {
        this._inactiveProjectsSendWarningEmailAfterMonths = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get inactiveProjectsSendWarningEmailAfterMonthsInput() {
        return this._inactiveProjectsSendWarningEmailAfterMonths;
    }
    get invisibleCaptchaEnabled() {
        return this.getBooleanAttribute('invisible_captcha_enabled');
    }
    set invisibleCaptchaEnabled(value) {
        this._invisibleCaptchaEnabled = value;
    }
    resetInvisibleCaptchaEnabled() {
        this._invisibleCaptchaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get invisibleCaptchaEnabledInput() {
        return this._invisibleCaptchaEnabled;
    }
    get issuesCreateLimit() {
        return this.getNumberAttribute('issues_create_limit');
    }
    set issuesCreateLimit(value) {
        this._issuesCreateLimit = value;
    }
    resetIssuesCreateLimit() {
        this._issuesCreateLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesCreateLimitInput() {
        return this._issuesCreateLimit;
    }
    get keepLatestArtifact() {
        return this.getBooleanAttribute('keep_latest_artifact');
    }
    set keepLatestArtifact(value) {
        this._keepLatestArtifact = value;
    }
    resetKeepLatestArtifact() {
        this._keepLatestArtifact = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keepLatestArtifactInput() {
        return this._keepLatestArtifact;
    }
    get localMarkdownVersion() {
        return this.getNumberAttribute('local_markdown_version');
    }
    set localMarkdownVersion(value) {
        this._localMarkdownVersion = value;
    }
    resetLocalMarkdownVersion() {
        this._localMarkdownVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localMarkdownVersionInput() {
        return this._localMarkdownVersion;
    }
    get mailgunEventsEnabled() {
        return this.getBooleanAttribute('mailgun_events_enabled');
    }
    set mailgunEventsEnabled(value) {
        this._mailgunEventsEnabled = value;
    }
    resetMailgunEventsEnabled() {
        this._mailgunEventsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mailgunEventsEnabledInput() {
        return this._mailgunEventsEnabled;
    }
    get mailgunSigningKey() {
        return this.getStringAttribute('mailgun_signing_key');
    }
    set mailgunSigningKey(value) {
        this._mailgunSigningKey = value;
    }
    resetMailgunSigningKey() {
        this._mailgunSigningKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mailgunSigningKeyInput() {
        return this._mailgunSigningKey;
    }
    get maintenanceMode() {
        return this.getBooleanAttribute('maintenance_mode');
    }
    set maintenanceMode(value) {
        this._maintenanceMode = value;
    }
    resetMaintenanceMode() {
        this._maintenanceMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maintenanceModeInput() {
        return this._maintenanceMode;
    }
    get maintenanceModeMessage() {
        return this.getStringAttribute('maintenance_mode_message');
    }
    set maintenanceModeMessage(value) {
        this._maintenanceModeMessage = value;
    }
    resetMaintenanceModeMessage() {
        this._maintenanceModeMessage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maintenanceModeMessageInput() {
        return this._maintenanceModeMessage;
    }
    get maxArtifactsSize() {
        return this.getNumberAttribute('max_artifacts_size');
    }
    set maxArtifactsSize(value) {
        this._maxArtifactsSize = value;
    }
    resetMaxArtifactsSize() {
        this._maxArtifactsSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxArtifactsSizeInput() {
        return this._maxArtifactsSize;
    }
    get maxAttachmentSize() {
        return this.getNumberAttribute('max_attachment_size');
    }
    set maxAttachmentSize(value) {
        this._maxAttachmentSize = value;
    }
    resetMaxAttachmentSize() {
        this._maxAttachmentSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxAttachmentSizeInput() {
        return this._maxAttachmentSize;
    }
    get maxExportSize() {
        return this.getNumberAttribute('max_export_size');
    }
    set maxExportSize(value) {
        this._maxExportSize = value;
    }
    resetMaxExportSize() {
        this._maxExportSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxExportSizeInput() {
        return this._maxExportSize;
    }
    get maxImportSize() {
        return this.getNumberAttribute('max_import_size');
    }
    set maxImportSize(value) {
        this._maxImportSize = value;
    }
    resetMaxImportSize() {
        this._maxImportSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxImportSizeInput() {
        return this._maxImportSize;
    }
    get maxNumberOfRepositoryDownloads() {
        return this.getNumberAttribute('max_number_of_repository_downloads');
    }
    set maxNumberOfRepositoryDownloads(value) {
        this._maxNumberOfRepositoryDownloads = value;
    }
    resetMaxNumberOfRepositoryDownloads() {
        this._maxNumberOfRepositoryDownloads = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxNumberOfRepositoryDownloadsInput() {
        return this._maxNumberOfRepositoryDownloads;
    }
    get maxNumberOfRepositoryDownloadsWithinTimePeriod() {
        return this.getNumberAttribute('max_number_of_repository_downloads_within_time_period');
    }
    set maxNumberOfRepositoryDownloadsWithinTimePeriod(value) {
        this._maxNumberOfRepositoryDownloadsWithinTimePeriod = value;
    }
    resetMaxNumberOfRepositoryDownloadsWithinTimePeriod() {
        this._maxNumberOfRepositoryDownloadsWithinTimePeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxNumberOfRepositoryDownloadsWithinTimePeriodInput() {
        return this._maxNumberOfRepositoryDownloadsWithinTimePeriod;
    }
    get maxPagesSize() {
        return this.getNumberAttribute('max_pages_size');
    }
    set maxPagesSize(value) {
        this._maxPagesSize = value;
    }
    resetMaxPagesSize() {
        this._maxPagesSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxPagesSizeInput() {
        return this._maxPagesSize;
    }
    get maxPersonalAccessTokenLifetime() {
        return this.getNumberAttribute('max_personal_access_token_lifetime');
    }
    set maxPersonalAccessTokenLifetime(value) {
        this._maxPersonalAccessTokenLifetime = value;
    }
    resetMaxPersonalAccessTokenLifetime() {
        this._maxPersonalAccessTokenLifetime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxPersonalAccessTokenLifetimeInput() {
        return this._maxPersonalAccessTokenLifetime;
    }
    get maxSshKeyLifetime() {
        return this.getNumberAttribute('max_ssh_key_lifetime');
    }
    set maxSshKeyLifetime(value) {
        this._maxSshKeyLifetime = value;
    }
    resetMaxSshKeyLifetime() {
        this._maxSshKeyLifetime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxSshKeyLifetimeInput() {
        return this._maxSshKeyLifetime;
    }
    get metricsMethodCallThreshold() {
        return this.getNumberAttribute('metrics_method_call_threshold');
    }
    set metricsMethodCallThreshold(value) {
        this._metricsMethodCallThreshold = value;
    }
    resetMetricsMethodCallThreshold() {
        this._metricsMethodCallThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get metricsMethodCallThresholdInput() {
        return this._metricsMethodCallThreshold;
    }
    get mirrorAvailable() {
        return this.getBooleanAttribute('mirror_available');
    }
    set mirrorAvailable(value) {
        this._mirrorAvailable = value;
    }
    resetMirrorAvailable() {
        this._mirrorAvailable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorAvailableInput() {
        return this._mirrorAvailable;
    }
    get mirrorCapacityThreshold() {
        return this.getNumberAttribute('mirror_capacity_threshold');
    }
    set mirrorCapacityThreshold(value) {
        this._mirrorCapacityThreshold = value;
    }
    resetMirrorCapacityThreshold() {
        this._mirrorCapacityThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorCapacityThresholdInput() {
        return this._mirrorCapacityThreshold;
    }
    get mirrorMaxCapacity() {
        return this.getNumberAttribute('mirror_max_capacity');
    }
    set mirrorMaxCapacity(value) {
        this._mirrorMaxCapacity = value;
    }
    resetMirrorMaxCapacity() {
        this._mirrorMaxCapacity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorMaxCapacityInput() {
        return this._mirrorMaxCapacity;
    }
    get mirrorMaxDelay() {
        return this.getNumberAttribute('mirror_max_delay');
    }
    set mirrorMaxDelay(value) {
        this._mirrorMaxDelay = value;
    }
    resetMirrorMaxDelay() {
        this._mirrorMaxDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorMaxDelayInput() {
        return this._mirrorMaxDelay;
    }
    get npmPackageRequestsForwarding() {
        return this.getBooleanAttribute('npm_package_requests_forwarding');
    }
    set npmPackageRequestsForwarding(value) {
        this._npmPackageRequestsForwarding = value;
    }
    resetNpmPackageRequestsForwarding() {
        this._npmPackageRequestsForwarding = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get npmPackageRequestsForwardingInput() {
        return this._npmPackageRequestsForwarding;
    }
    get outboundLocalRequestsWhitelist() {
        return this.getListAttribute('outbound_local_requests_whitelist');
    }
    set outboundLocalRequestsWhitelist(value) {
        this._outboundLocalRequestsWhitelist = value;
    }
    resetOutboundLocalRequestsWhitelist() {
        this._outboundLocalRequestsWhitelist = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get outboundLocalRequestsWhitelistInput() {
        return this._outboundLocalRequestsWhitelist;
    }
    get packageRegistryCleanupPoliciesWorkerCapacity() {
        return this.getNumberAttribute('package_registry_cleanup_policies_worker_capacity');
    }
    set packageRegistryCleanupPoliciesWorkerCapacity(value) {
        this._packageRegistryCleanupPoliciesWorkerCapacity = value;
    }
    resetPackageRegistryCleanupPoliciesWorkerCapacity() {
        this._packageRegistryCleanupPoliciesWorkerCapacity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get packageRegistryCleanupPoliciesWorkerCapacityInput() {
        return this._packageRegistryCleanupPoliciesWorkerCapacity;
    }
    get pagesDomainVerificationEnabled() {
        return this.getBooleanAttribute('pages_domain_verification_enabled');
    }
    set pagesDomainVerificationEnabled(value) {
        this._pagesDomainVerificationEnabled = value;
    }
    resetPagesDomainVerificationEnabled() {
        this._pagesDomainVerificationEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pagesDomainVerificationEnabledInput() {
        return this._pagesDomainVerificationEnabled;
    }
    get passwordAuthenticationEnabledForGit() {
        return this.getBooleanAttribute('password_authentication_enabled_for_git');
    }
    set passwordAuthenticationEnabledForGit(value) {
        this._passwordAuthenticationEnabledForGit = value;
    }
    resetPasswordAuthenticationEnabledForGit() {
        this._passwordAuthenticationEnabledForGit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordAuthenticationEnabledForGitInput() {
        return this._passwordAuthenticationEnabledForGit;
    }
    get passwordAuthenticationEnabledForWeb() {
        return this.getBooleanAttribute('password_authentication_enabled_for_web');
    }
    set passwordAuthenticationEnabledForWeb(value) {
        this._passwordAuthenticationEnabledForWeb = value;
    }
    resetPasswordAuthenticationEnabledForWeb() {
        this._passwordAuthenticationEnabledForWeb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordAuthenticationEnabledForWebInput() {
        return this._passwordAuthenticationEnabledForWeb;
    }
    get passwordLowercaseRequired() {
        return this.getBooleanAttribute('password_lowercase_required');
    }
    set passwordLowercaseRequired(value) {
        this._passwordLowercaseRequired = value;
    }
    resetPasswordLowercaseRequired() {
        this._passwordLowercaseRequired = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordLowercaseRequiredInput() {
        return this._passwordLowercaseRequired;
    }
    get passwordNumberRequired() {
        return this.getBooleanAttribute('password_number_required');
    }
    set passwordNumberRequired(value) {
        this._passwordNumberRequired = value;
    }
    resetPasswordNumberRequired() {
        this._passwordNumberRequired = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordNumberRequiredInput() {
        return this._passwordNumberRequired;
    }
    get passwordSymbolRequired() {
        return this.getBooleanAttribute('password_symbol_required');
    }
    set passwordSymbolRequired(value) {
        this._passwordSymbolRequired = value;
    }
    resetPasswordSymbolRequired() {
        this._passwordSymbolRequired = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordSymbolRequiredInput() {
        return this._passwordSymbolRequired;
    }
    get passwordUppercaseRequired() {
        return this.getBooleanAttribute('password_uppercase_required');
    }
    set passwordUppercaseRequired(value) {
        this._passwordUppercaseRequired = value;
    }
    resetPasswordUppercaseRequired() {
        this._passwordUppercaseRequired = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordUppercaseRequiredInput() {
        return this._passwordUppercaseRequired;
    }
    get performanceBarAllowedGroupPath() {
        return this.getStringAttribute('performance_bar_allowed_group_path');
    }
    set performanceBarAllowedGroupPath(value) {
        this._performanceBarAllowedGroupPath = value;
    }
    resetPerformanceBarAllowedGroupPath() {
        this._performanceBarAllowedGroupPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get performanceBarAllowedGroupPathInput() {
        return this._performanceBarAllowedGroupPath;
    }
    get personalAccessTokenPrefix() {
        return this.getStringAttribute('personal_access_token_prefix');
    }
    set personalAccessTokenPrefix(value) {
        this._personalAccessTokenPrefix = value;
    }
    resetPersonalAccessTokenPrefix() {
        this._personalAccessTokenPrefix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get personalAccessTokenPrefixInput() {
        return this._personalAccessTokenPrefix;
    }
    get pipelineLimitPerProjectUserSha() {
        return this.getNumberAttribute('pipeline_limit_per_project_user_sha');
    }
    set pipelineLimitPerProjectUserSha(value) {
        this._pipelineLimitPerProjectUserSha = value;
    }
    resetPipelineLimitPerProjectUserSha() {
        this._pipelineLimitPerProjectUserSha = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pipelineLimitPerProjectUserShaInput() {
        return this._pipelineLimitPerProjectUserSha;
    }
    get plantumlEnabled() {
        return this.getBooleanAttribute('plantuml_enabled');
    }
    set plantumlEnabled(value) {
        this._plantumlEnabled = value;
    }
    resetPlantumlEnabled() {
        this._plantumlEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get plantumlEnabledInput() {
        return this._plantumlEnabled;
    }
    get plantumlUrl() {
        return this.getStringAttribute('plantuml_url');
    }
    set plantumlUrl(value) {
        this._plantumlUrl = value;
    }
    resetPlantumlUrl() {
        this._plantumlUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get plantumlUrlInput() {
        return this._plantumlUrl;
    }
    get pollingIntervalMultiplier() {
        return this.getNumberAttribute('polling_interval_multiplier');
    }
    set pollingIntervalMultiplier(value) {
        this._pollingIntervalMultiplier = value;
    }
    resetPollingIntervalMultiplier() {
        this._pollingIntervalMultiplier = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pollingIntervalMultiplierInput() {
        return this._pollingIntervalMultiplier;
    }
    get projectExportEnabled() {
        return this.getBooleanAttribute('project_export_enabled');
    }
    set projectExportEnabled(value) {
        this._projectExportEnabled = value;
    }
    resetProjectExportEnabled() {
        this._projectExportEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectExportEnabledInput() {
        return this._projectExportEnabled;
    }
    get prometheusMetricsEnabled() {
        return this.getBooleanAttribute('prometheus_metrics_enabled');
    }
    set prometheusMetricsEnabled(value) {
        this._prometheusMetricsEnabled = value;
    }
    resetPrometheusMetricsEnabled() {
        this._prometheusMetricsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get prometheusMetricsEnabledInput() {
        return this._prometheusMetricsEnabled;
    }
    get protectedCiVariables() {
        return this.getBooleanAttribute('protected_ci_variables');
    }
    set protectedCiVariables(value) {
        this._protectedCiVariables = value;
    }
    resetProtectedCiVariables() {
        this._protectedCiVariables = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get protectedCiVariablesInput() {
        return this._protectedCiVariables;
    }
    get pushEventActivitiesLimit() {
        return this.getNumberAttribute('push_event_activities_limit');
    }
    set pushEventActivitiesLimit(value) {
        this._pushEventActivitiesLimit = value;
    }
    resetPushEventActivitiesLimit() {
        this._pushEventActivitiesLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushEventActivitiesLimitInput() {
        return this._pushEventActivitiesLimit;
    }
    get pushEventHooksLimit() {
        return this.getNumberAttribute('push_event_hooks_limit');
    }
    set pushEventHooksLimit(value) {
        this._pushEventHooksLimit = value;
    }
    resetPushEventHooksLimit() {
        this._pushEventHooksLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushEventHooksLimitInput() {
        return this._pushEventHooksLimit;
    }
    get pypiPackageRequestsForwarding() {
        return this.getBooleanAttribute('pypi_package_requests_forwarding');
    }
    set pypiPackageRequestsForwarding(value) {
        this._pypiPackageRequestsForwarding = value;
    }
    resetPypiPackageRequestsForwarding() {
        this._pypiPackageRequestsForwarding = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pypiPackageRequestsForwardingInput() {
        return this._pypiPackageRequestsForwarding;
    }
    get rateLimitingResponseText() {
        return this.getStringAttribute('rate_limiting_response_text');
    }
    set rateLimitingResponseText(value) {
        this._rateLimitingResponseText = value;
    }
    resetRateLimitingResponseText() {
        this._rateLimitingResponseText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rateLimitingResponseTextInput() {
        return this._rateLimitingResponseText;
    }
    get rawBlobRequestLimit() {
        return this.getNumberAttribute('raw_blob_request_limit');
    }
    set rawBlobRequestLimit(value) {
        this._rawBlobRequestLimit = value;
    }
    resetRawBlobRequestLimit() {
        this._rawBlobRequestLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rawBlobRequestLimitInput() {
        return this._rawBlobRequestLimit;
    }
    get recaptchaEnabled() {
        return this.getBooleanAttribute('recaptcha_enabled');
    }
    set recaptchaEnabled(value) {
        this._recaptchaEnabled = value;
    }
    resetRecaptchaEnabled() {
        this._recaptchaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recaptchaEnabledInput() {
        return this._recaptchaEnabled;
    }
    get recaptchaPrivateKey() {
        return this.getStringAttribute('recaptcha_private_key');
    }
    set recaptchaPrivateKey(value) {
        this._recaptchaPrivateKey = value;
    }
    resetRecaptchaPrivateKey() {
        this._recaptchaPrivateKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recaptchaPrivateKeyInput() {
        return this._recaptchaPrivateKey;
    }
    get recaptchaSiteKey() {
        return this.getStringAttribute('recaptcha_site_key');
    }
    set recaptchaSiteKey(value) {
        this._recaptchaSiteKey = value;
    }
    resetRecaptchaSiteKey() {
        this._recaptchaSiteKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recaptchaSiteKeyInput() {
        return this._recaptchaSiteKey;
    }
    get receiveMaxInputSize() {
        return this.getNumberAttribute('receive_max_input_size');
    }
    set receiveMaxInputSize(value) {
        this._receiveMaxInputSize = value;
    }
    resetReceiveMaxInputSize() {
        this._receiveMaxInputSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get receiveMaxInputSizeInput() {
        return this._receiveMaxInputSize;
    }
    get repositoryChecksEnabled() {
        return this.getBooleanAttribute('repository_checks_enabled');
    }
    set repositoryChecksEnabled(value) {
        this._repositoryChecksEnabled = value;
    }
    resetRepositoryChecksEnabled() {
        this._repositoryChecksEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryChecksEnabledInput() {
        return this._repositoryChecksEnabled;
    }
    get repositorySizeLimit() {
        return this.getNumberAttribute('repository_size_limit');
    }
    set repositorySizeLimit(value) {
        this._repositorySizeLimit = value;
    }
    resetRepositorySizeLimit() {
        this._repositorySizeLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositorySizeLimitInput() {
        return this._repositorySizeLimit;
    }
    get repositoryStorages() {
        return this.getListAttribute('repository_storages');
    }
    set repositoryStorages(value) {
        this._repositoryStorages = value;
    }
    resetRepositoryStorages() {
        this._repositoryStorages = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryStoragesInput() {
        return this._repositoryStorages;
    }
    get repositoryStoragesWeighted() {
        return this.getNumberMapAttribute('repository_storages_weighted');
    }
    set repositoryStoragesWeighted(value) {
        this._repositoryStoragesWeighted = value;
    }
    resetRepositoryStoragesWeighted() {
        this._repositoryStoragesWeighted = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryStoragesWeightedInput() {
        return this._repositoryStoragesWeighted;
    }
    get requireAdminApprovalAfterUserSignup() {
        return this.getBooleanAttribute('require_admin_approval_after_user_signup');
    }
    set requireAdminApprovalAfterUserSignup(value) {
        this._requireAdminApprovalAfterUserSignup = value;
    }
    resetRequireAdminApprovalAfterUserSignup() {
        this._requireAdminApprovalAfterUserSignup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requireAdminApprovalAfterUserSignupInput() {
        return this._requireAdminApprovalAfterUserSignup;
    }
    get requireTwoFactorAuthentication() {
        return this.getBooleanAttribute('require_two_factor_authentication');
    }
    set requireTwoFactorAuthentication(value) {
        this._requireTwoFactorAuthentication = value;
    }
    resetRequireTwoFactorAuthentication() {
        this._requireTwoFactorAuthentication = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requireTwoFactorAuthenticationInput() {
        return this._requireTwoFactorAuthentication;
    }
    get restrictedVisibilityLevels() {
        return this.getListAttribute('restricted_visibility_levels');
    }
    set restrictedVisibilityLevels(value) {
        this._restrictedVisibilityLevels = value;
    }
    resetRestrictedVisibilityLevels() {
        this._restrictedVisibilityLevels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get restrictedVisibilityLevelsInput() {
        return this._restrictedVisibilityLevels;
    }
    get rsaKeyRestriction() {
        return this.getNumberAttribute('rsa_key_restriction');
    }
    set rsaKeyRestriction(value) {
        this._rsaKeyRestriction = value;
    }
    resetRsaKeyRestriction() {
        this._rsaKeyRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rsaKeyRestrictionInput() {
        return this._rsaKeyRestriction;
    }
    get searchRateLimit() {
        return this.getNumberAttribute('search_rate_limit');
    }
    set searchRateLimit(value) {
        this._searchRateLimit = value;
    }
    resetSearchRateLimit() {
        this._searchRateLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get searchRateLimitInput() {
        return this._searchRateLimit;
    }
    get searchRateLimitUnauthenticated() {
        return this.getNumberAttribute('search_rate_limit_unauthenticated');
    }
    set searchRateLimitUnauthenticated(value) {
        this._searchRateLimitUnauthenticated = value;
    }
    resetSearchRateLimitUnauthenticated() {
        this._searchRateLimitUnauthenticated = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get searchRateLimitUnauthenticatedInput() {
        return this._searchRateLimitUnauthenticated;
    }
    get sendUserConfirmationEmail() {
        return this.getBooleanAttribute('send_user_confirmation_email');
    }
    set sendUserConfirmationEmail(value) {
        this._sendUserConfirmationEmail = value;
    }
    resetSendUserConfirmationEmail() {
        this._sendUserConfirmationEmail = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sendUserConfirmationEmailInput() {
        return this._sendUserConfirmationEmail;
    }
    get sessionExpireDelay() {
        return this.getNumberAttribute('session_expire_delay');
    }
    set sessionExpireDelay(value) {
        this._sessionExpireDelay = value;
    }
    resetSessionExpireDelay() {
        this._sessionExpireDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sessionExpireDelayInput() {
        return this._sessionExpireDelay;
    }
    get sharedRunnersEnabled() {
        return this.getBooleanAttribute('shared_runners_enabled');
    }
    set sharedRunnersEnabled(value) {
        this._sharedRunnersEnabled = value;
    }
    resetSharedRunnersEnabled() {
        this._sharedRunnersEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedRunnersEnabledInput() {
        return this._sharedRunnersEnabled;
    }
    get sharedRunnersMinutes() {
        return this.getNumberAttribute('shared_runners_minutes');
    }
    set sharedRunnersMinutes(value) {
        this._sharedRunnersMinutes = value;
    }
    resetSharedRunnersMinutes() {
        this._sharedRunnersMinutes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedRunnersMinutesInput() {
        return this._sharedRunnersMinutes;
    }
    get sharedRunnersText() {
        return this.getStringAttribute('shared_runners_text');
    }
    set sharedRunnersText(value) {
        this._sharedRunnersText = value;
    }
    resetSharedRunnersText() {
        this._sharedRunnersText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedRunnersTextInput() {
        return this._sharedRunnersText;
    }
    get sidekiqJobLimiterCompressionThresholdBytes() {
        return this.getNumberAttribute('sidekiq_job_limiter_compression_threshold_bytes');
    }
    set sidekiqJobLimiterCompressionThresholdBytes(value) {
        this._sidekiqJobLimiterCompressionThresholdBytes = value;
    }
    resetSidekiqJobLimiterCompressionThresholdBytes() {
        this._sidekiqJobLimiterCompressionThresholdBytes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sidekiqJobLimiterCompressionThresholdBytesInput() {
        return this._sidekiqJobLimiterCompressionThresholdBytes;
    }
    get sidekiqJobLimiterLimitBytes() {
        return this.getNumberAttribute('sidekiq_job_limiter_limit_bytes');
    }
    set sidekiqJobLimiterLimitBytes(value) {
        this._sidekiqJobLimiterLimitBytes = value;
    }
    resetSidekiqJobLimiterLimitBytes() {
        this._sidekiqJobLimiterLimitBytes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sidekiqJobLimiterLimitBytesInput() {
        return this._sidekiqJobLimiterLimitBytes;
    }
    get sidekiqJobLimiterMode() {
        return this.getStringAttribute('sidekiq_job_limiter_mode');
    }
    set sidekiqJobLimiterMode(value) {
        this._sidekiqJobLimiterMode = value;
    }
    resetSidekiqJobLimiterMode() {
        this._sidekiqJobLimiterMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sidekiqJobLimiterModeInput() {
        return this._sidekiqJobLimiterMode;
    }
    get signInText() {
        return this.getStringAttribute('sign_in_text');
    }
    set signInText(value) {
        this._signInText = value;
    }
    resetSignInText() {
        this._signInText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get signInTextInput() {
        return this._signInText;
    }
    get signupEnabled() {
        return this.getBooleanAttribute('signup_enabled');
    }
    set signupEnabled(value) {
        this._signupEnabled = value;
    }
    resetSignupEnabled() {
        this._signupEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get signupEnabledInput() {
        return this._signupEnabled;
    }
    get slackAppEnabled() {
        return this.getBooleanAttribute('slack_app_enabled');
    }
    set slackAppEnabled(value) {
        this._slackAppEnabled = value;
    }
    resetSlackAppEnabled() {
        this._slackAppEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get slackAppEnabledInput() {
        return this._slackAppEnabled;
    }
    get slackAppId() {
        return this.getStringAttribute('slack_app_id');
    }
    set slackAppId(value) {
        this._slackAppId = value;
    }
    resetSlackAppId() {
        this._slackAppId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get slackAppIdInput() {
        return this._slackAppId;
    }
    get slackAppSecret() {
        return this.getStringAttribute('slack_app_secret');
    }
    set slackAppSecret(value) {
        this._slackAppSecret = value;
    }
    resetSlackAppSecret() {
        this._slackAppSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get slackAppSecretInput() {
        return this._slackAppSecret;
    }
    get slackAppSigningSecret() {
        return this.getStringAttribute('slack_app_signing_secret');
    }
    set slackAppSigningSecret(value) {
        this._slackAppSigningSecret = value;
    }
    resetSlackAppSigningSecret() {
        this._slackAppSigningSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get slackAppSigningSecretInput() {
        return this._slackAppSigningSecret;
    }
    get slackAppVerificationToken() {
        return this.getStringAttribute('slack_app_verification_token');
    }
    set slackAppVerificationToken(value) {
        this._slackAppVerificationToken = value;
    }
    resetSlackAppVerificationToken() {
        this._slackAppVerificationToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get slackAppVerificationTokenInput() {
        return this._slackAppVerificationToken;
    }
    get snippetSizeLimit() {
        return this.getNumberAttribute('snippet_size_limit');
    }
    set snippetSizeLimit(value) {
        this._snippetSizeLimit = value;
    }
    resetSnippetSizeLimit() {
        this._snippetSizeLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snippetSizeLimitInput() {
        return this._snippetSizeLimit;
    }
    get snowplowAppId() {
        return this.getStringAttribute('snowplow_app_id');
    }
    set snowplowAppId(value) {
        this._snowplowAppId = value;
    }
    resetSnowplowAppId() {
        this._snowplowAppId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snowplowAppIdInput() {
        return this._snowplowAppId;
    }
    get snowplowCollectorHostname() {
        return this.getStringAttribute('snowplow_collector_hostname');
    }
    set snowplowCollectorHostname(value) {
        this._snowplowCollectorHostname = value;
    }
    resetSnowplowCollectorHostname() {
        this._snowplowCollectorHostname = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snowplowCollectorHostnameInput() {
        return this._snowplowCollectorHostname;
    }
    get snowplowCookieDomain() {
        return this.getStringAttribute('snowplow_cookie_domain');
    }
    set snowplowCookieDomain(value) {
        this._snowplowCookieDomain = value;
    }
    resetSnowplowCookieDomain() {
        this._snowplowCookieDomain = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snowplowCookieDomainInput() {
        return this._snowplowCookieDomain;
    }
    get snowplowEnabled() {
        return this.getBooleanAttribute('snowplow_enabled');
    }
    set snowplowEnabled(value) {
        this._snowplowEnabled = value;
    }
    resetSnowplowEnabled() {
        this._snowplowEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snowplowEnabledInput() {
        return this._snowplowEnabled;
    }
    get sourcegraphEnabled() {
        return this.getBooleanAttribute('sourcegraph_enabled');
    }
    set sourcegraphEnabled(value) {
        this._sourcegraphEnabled = value;
    }
    resetSourcegraphEnabled() {
        this._sourcegraphEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourcegraphEnabledInput() {
        return this._sourcegraphEnabled;
    }
    get sourcegraphPublicOnly() {
        return this.getBooleanAttribute('sourcegraph_public_only');
    }
    set sourcegraphPublicOnly(value) {
        this._sourcegraphPublicOnly = value;
    }
    resetSourcegraphPublicOnly() {
        this._sourcegraphPublicOnly = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourcegraphPublicOnlyInput() {
        return this._sourcegraphPublicOnly;
    }
    get sourcegraphUrl() {
        return this.getStringAttribute('sourcegraph_url');
    }
    set sourcegraphUrl(value) {
        this._sourcegraphUrl = value;
    }
    resetSourcegraphUrl() {
        this._sourcegraphUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourcegraphUrlInput() {
        return this._sourcegraphUrl;
    }
    get spamCheckApiKey() {
        return this.getStringAttribute('spam_check_api_key');
    }
    set spamCheckApiKey(value) {
        this._spamCheckApiKey = value;
    }
    resetSpamCheckApiKey() {
        this._spamCheckApiKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get spamCheckApiKeyInput() {
        return this._spamCheckApiKey;
    }
    get spamCheckEndpointEnabled() {
        return this.getBooleanAttribute('spam_check_endpoint_enabled');
    }
    set spamCheckEndpointEnabled(value) {
        this._spamCheckEndpointEnabled = value;
    }
    resetSpamCheckEndpointEnabled() {
        this._spamCheckEndpointEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get spamCheckEndpointEnabledInput() {
        return this._spamCheckEndpointEnabled;
    }
    get spamCheckEndpointUrl() {
        return this.getStringAttribute('spam_check_endpoint_url');
    }
    set spamCheckEndpointUrl(value) {
        this._spamCheckEndpointUrl = value;
    }
    resetSpamCheckEndpointUrl() {
        this._spamCheckEndpointUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get spamCheckEndpointUrlInput() {
        return this._spamCheckEndpointUrl;
    }
    get suggestPipelineEnabled() {
        return this.getBooleanAttribute('suggest_pipeline_enabled');
    }
    set suggestPipelineEnabled(value) {
        this._suggestPipelineEnabled = value;
    }
    resetSuggestPipelineEnabled() {
        this._suggestPipelineEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get suggestPipelineEnabledInput() {
        return this._suggestPipelineEnabled;
    }
    get terminalMaxSessionTime() {
        return this.getNumberAttribute('terminal_max_session_time');
    }
    set terminalMaxSessionTime(value) {
        this._terminalMaxSessionTime = value;
    }
    resetTerminalMaxSessionTime() {
        this._terminalMaxSessionTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get terminalMaxSessionTimeInput() {
        return this._terminalMaxSessionTime;
    }
    get terms() {
        return this.getStringAttribute('terms');
    }
    set terms(value) {
        this._terms = value;
    }
    resetTerms() {
        this._terms = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get termsInput() {
        return this._terms;
    }
    get throttleAuthenticatedApiEnabled() {
        return this.getBooleanAttribute('throttle_authenticated_api_enabled');
    }
    set throttleAuthenticatedApiEnabled(value) {
        this._throttleAuthenticatedApiEnabled = value;
    }
    resetThrottleAuthenticatedApiEnabled() {
        this._throttleAuthenticatedApiEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedApiEnabledInput() {
        return this._throttleAuthenticatedApiEnabled;
    }
    get throttleAuthenticatedApiPeriodInSeconds() {
        return this.getNumberAttribute('throttle_authenticated_api_period_in_seconds');
    }
    set throttleAuthenticatedApiPeriodInSeconds(value) {
        this._throttleAuthenticatedApiPeriodInSeconds = value;
    }
    resetThrottleAuthenticatedApiPeriodInSeconds() {
        this._throttleAuthenticatedApiPeriodInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedApiPeriodInSecondsInput() {
        return this._throttleAuthenticatedApiPeriodInSeconds;
    }
    get throttleAuthenticatedApiRequestsPerPeriod() {
        return this.getNumberAttribute('throttle_authenticated_api_requests_per_period');
    }
    set throttleAuthenticatedApiRequestsPerPeriod(value) {
        this._throttleAuthenticatedApiRequestsPerPeriod = value;
    }
    resetThrottleAuthenticatedApiRequestsPerPeriod() {
        this._throttleAuthenticatedApiRequestsPerPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedApiRequestsPerPeriodInput() {
        return this._throttleAuthenticatedApiRequestsPerPeriod;
    }
    get throttleAuthenticatedPackagesApiEnabled() {
        return this.getBooleanAttribute('throttle_authenticated_packages_api_enabled');
    }
    set throttleAuthenticatedPackagesApiEnabled(value) {
        this._throttleAuthenticatedPackagesApiEnabled = value;
    }
    resetThrottleAuthenticatedPackagesApiEnabled() {
        this._throttleAuthenticatedPackagesApiEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedPackagesApiEnabledInput() {
        return this._throttleAuthenticatedPackagesApiEnabled;
    }
    get throttleAuthenticatedPackagesApiPeriodInSeconds() {
        return this.getNumberAttribute('throttle_authenticated_packages_api_period_in_seconds');
    }
    set throttleAuthenticatedPackagesApiPeriodInSeconds(value) {
        this._throttleAuthenticatedPackagesApiPeriodInSeconds = value;
    }
    resetThrottleAuthenticatedPackagesApiPeriodInSeconds() {
        this._throttleAuthenticatedPackagesApiPeriodInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedPackagesApiPeriodInSecondsInput() {
        return this._throttleAuthenticatedPackagesApiPeriodInSeconds;
    }
    get throttleAuthenticatedPackagesApiRequestsPerPeriod() {
        return this.getNumberAttribute('throttle_authenticated_packages_api_requests_per_period');
    }
    set throttleAuthenticatedPackagesApiRequestsPerPeriod(value) {
        this._throttleAuthenticatedPackagesApiRequestsPerPeriod = value;
    }
    resetThrottleAuthenticatedPackagesApiRequestsPerPeriod() {
        this._throttleAuthenticatedPackagesApiRequestsPerPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedPackagesApiRequestsPerPeriodInput() {
        return this._throttleAuthenticatedPackagesApiRequestsPerPeriod;
    }
    get throttleAuthenticatedWebEnabled() {
        return this.getBooleanAttribute('throttle_authenticated_web_enabled');
    }
    set throttleAuthenticatedWebEnabled(value) {
        this._throttleAuthenticatedWebEnabled = value;
    }
    resetThrottleAuthenticatedWebEnabled() {
        this._throttleAuthenticatedWebEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedWebEnabledInput() {
        return this._throttleAuthenticatedWebEnabled;
    }
    get throttleAuthenticatedWebPeriodInSeconds() {
        return this.getNumberAttribute('throttle_authenticated_web_period_in_seconds');
    }
    set throttleAuthenticatedWebPeriodInSeconds(value) {
        this._throttleAuthenticatedWebPeriodInSeconds = value;
    }
    resetThrottleAuthenticatedWebPeriodInSeconds() {
        this._throttleAuthenticatedWebPeriodInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedWebPeriodInSecondsInput() {
        return this._throttleAuthenticatedWebPeriodInSeconds;
    }
    get throttleAuthenticatedWebRequestsPerPeriod() {
        return this.getNumberAttribute('throttle_authenticated_web_requests_per_period');
    }
    set throttleAuthenticatedWebRequestsPerPeriod(value) {
        this._throttleAuthenticatedWebRequestsPerPeriod = value;
    }
    resetThrottleAuthenticatedWebRequestsPerPeriod() {
        this._throttleAuthenticatedWebRequestsPerPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleAuthenticatedWebRequestsPerPeriodInput() {
        return this._throttleAuthenticatedWebRequestsPerPeriod;
    }
    get throttleUnauthenticatedApiEnabled() {
        return this.getBooleanAttribute('throttle_unauthenticated_api_enabled');
    }
    set throttleUnauthenticatedApiEnabled(value) {
        this._throttleUnauthenticatedApiEnabled = value;
    }
    resetThrottleUnauthenticatedApiEnabled() {
        this._throttleUnauthenticatedApiEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedApiEnabledInput() {
        return this._throttleUnauthenticatedApiEnabled;
    }
    get throttleUnauthenticatedApiPeriodInSeconds() {
        return this.getNumberAttribute('throttle_unauthenticated_api_period_in_seconds');
    }
    set throttleUnauthenticatedApiPeriodInSeconds(value) {
        this._throttleUnauthenticatedApiPeriodInSeconds = value;
    }
    resetThrottleUnauthenticatedApiPeriodInSeconds() {
        this._throttleUnauthenticatedApiPeriodInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedApiPeriodInSecondsInput() {
        return this._throttleUnauthenticatedApiPeriodInSeconds;
    }
    get throttleUnauthenticatedApiRequestsPerPeriod() {
        return this.getNumberAttribute('throttle_unauthenticated_api_requests_per_period');
    }
    set throttleUnauthenticatedApiRequestsPerPeriod(value) {
        this._throttleUnauthenticatedApiRequestsPerPeriod = value;
    }
    resetThrottleUnauthenticatedApiRequestsPerPeriod() {
        this._throttleUnauthenticatedApiRequestsPerPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedApiRequestsPerPeriodInput() {
        return this._throttleUnauthenticatedApiRequestsPerPeriod;
    }
    get throttleUnauthenticatedPackagesApiEnabled() {
        return this.getBooleanAttribute('throttle_unauthenticated_packages_api_enabled');
    }
    set throttleUnauthenticatedPackagesApiEnabled(value) {
        this._throttleUnauthenticatedPackagesApiEnabled = value;
    }
    resetThrottleUnauthenticatedPackagesApiEnabled() {
        this._throttleUnauthenticatedPackagesApiEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedPackagesApiEnabledInput() {
        return this._throttleUnauthenticatedPackagesApiEnabled;
    }
    get throttleUnauthenticatedPackagesApiPeriodInSeconds() {
        return this.getNumberAttribute('throttle_unauthenticated_packages_api_period_in_seconds');
    }
    set throttleUnauthenticatedPackagesApiPeriodInSeconds(value) {
        this._throttleUnauthenticatedPackagesApiPeriodInSeconds = value;
    }
    resetThrottleUnauthenticatedPackagesApiPeriodInSeconds() {
        this._throttleUnauthenticatedPackagesApiPeriodInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedPackagesApiPeriodInSecondsInput() {
        return this._throttleUnauthenticatedPackagesApiPeriodInSeconds;
    }
    get throttleUnauthenticatedPackagesApiRequestsPerPeriod() {
        return this.getNumberAttribute('throttle_unauthenticated_packages_api_requests_per_period');
    }
    set throttleUnauthenticatedPackagesApiRequestsPerPeriod(value) {
        this._throttleUnauthenticatedPackagesApiRequestsPerPeriod = value;
    }
    resetThrottleUnauthenticatedPackagesApiRequestsPerPeriod() {
        this._throttleUnauthenticatedPackagesApiRequestsPerPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedPackagesApiRequestsPerPeriodInput() {
        return this._throttleUnauthenticatedPackagesApiRequestsPerPeriod;
    }
    get throttleUnauthenticatedWebEnabled() {
        return this.getBooleanAttribute('throttle_unauthenticated_web_enabled');
    }
    set throttleUnauthenticatedWebEnabled(value) {
        this._throttleUnauthenticatedWebEnabled = value;
    }
    resetThrottleUnauthenticatedWebEnabled() {
        this._throttleUnauthenticatedWebEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedWebEnabledInput() {
        return this._throttleUnauthenticatedWebEnabled;
    }
    get throttleUnauthenticatedWebPeriodInSeconds() {
        return this.getNumberAttribute('throttle_unauthenticated_web_period_in_seconds');
    }
    set throttleUnauthenticatedWebPeriodInSeconds(value) {
        this._throttleUnauthenticatedWebPeriodInSeconds = value;
    }
    resetThrottleUnauthenticatedWebPeriodInSeconds() {
        this._throttleUnauthenticatedWebPeriodInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedWebPeriodInSecondsInput() {
        return this._throttleUnauthenticatedWebPeriodInSeconds;
    }
    get throttleUnauthenticatedWebRequestsPerPeriod() {
        return this.getNumberAttribute('throttle_unauthenticated_web_requests_per_period');
    }
    set throttleUnauthenticatedWebRequestsPerPeriod(value) {
        this._throttleUnauthenticatedWebRequestsPerPeriod = value;
    }
    resetThrottleUnauthenticatedWebRequestsPerPeriod() {
        this._throttleUnauthenticatedWebRequestsPerPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttleUnauthenticatedWebRequestsPerPeriodInput() {
        return this._throttleUnauthenticatedWebRequestsPerPeriod;
    }
    get timeTrackingLimitToHours() {
        return this.getBooleanAttribute('time_tracking_limit_to_hours');
    }
    set timeTrackingLimitToHours(value) {
        this._timeTrackingLimitToHours = value;
    }
    resetTimeTrackingLimitToHours() {
        this._timeTrackingLimitToHours = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeTrackingLimitToHoursInput() {
        return this._timeTrackingLimitToHours;
    }
    get twoFactorGracePeriod() {
        return this.getNumberAttribute('two_factor_grace_period');
    }
    set twoFactorGracePeriod(value) {
        this._twoFactorGracePeriod = value;
    }
    resetTwoFactorGracePeriod() {
        this._twoFactorGracePeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get twoFactorGracePeriodInput() {
        return this._twoFactorGracePeriod;
    }
    get uniqueIpsLimitEnabled() {
        return this.getBooleanAttribute('unique_ips_limit_enabled');
    }
    set uniqueIpsLimitEnabled(value) {
        this._uniqueIpsLimitEnabled = value;
    }
    resetUniqueIpsLimitEnabled() {
        this._uniqueIpsLimitEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uniqueIpsLimitEnabledInput() {
        return this._uniqueIpsLimitEnabled;
    }
    get uniqueIpsLimitPerUser() {
        return this.getNumberAttribute('unique_ips_limit_per_user');
    }
    set uniqueIpsLimitPerUser(value) {
        this._uniqueIpsLimitPerUser = value;
    }
    resetUniqueIpsLimitPerUser() {
        this._uniqueIpsLimitPerUser = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uniqueIpsLimitPerUserInput() {
        return this._uniqueIpsLimitPerUser;
    }
    get uniqueIpsLimitTimeWindow() {
        return this.getNumberAttribute('unique_ips_limit_time_window');
    }
    set uniqueIpsLimitTimeWindow(value) {
        this._uniqueIpsLimitTimeWindow = value;
    }
    resetUniqueIpsLimitTimeWindow() {
        this._uniqueIpsLimitTimeWindow = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uniqueIpsLimitTimeWindowInput() {
        return this._uniqueIpsLimitTimeWindow;
    }
    get usagePingEnabled() {
        return this.getBooleanAttribute('usage_ping_enabled');
    }
    set usagePingEnabled(value) {
        this._usagePingEnabled = value;
    }
    resetUsagePingEnabled() {
        this._usagePingEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usagePingEnabledInput() {
        return this._usagePingEnabled;
    }
    get userDeactivationEmailsEnabled() {
        return this.getBooleanAttribute('user_deactivation_emails_enabled');
    }
    set userDeactivationEmailsEnabled(value) {
        this._userDeactivationEmailsEnabled = value;
    }
    resetUserDeactivationEmailsEnabled() {
        this._userDeactivationEmailsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userDeactivationEmailsEnabledInput() {
        return this._userDeactivationEmailsEnabled;
    }
    get userDefaultExternal() {
        return this.getBooleanAttribute('user_default_external');
    }
    set userDefaultExternal(value) {
        this._userDefaultExternal = value;
    }
    resetUserDefaultExternal() {
        this._userDefaultExternal = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userDefaultExternalInput() {
        return this._userDefaultExternal;
    }
    get userDefaultInternalRegex() {
        return this.getStringAttribute('user_default_internal_regex');
    }
    set userDefaultInternalRegex(value) {
        this._userDefaultInternalRegex = value;
    }
    resetUserDefaultInternalRegex() {
        this._userDefaultInternalRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userDefaultInternalRegexInput() {
        return this._userDefaultInternalRegex;
    }
    get userOauthApplications() {
        return this.getBooleanAttribute('user_oauth_applications');
    }
    set userOauthApplications(value) {
        this._userOauthApplications = value;
    }
    resetUserOauthApplications() {
        this._userOauthApplications = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userOauthApplicationsInput() {
        return this._userOauthApplications;
    }
    get userShowAddSshKeyMessage() {
        return this.getBooleanAttribute('user_show_add_ssh_key_message');
    }
    set userShowAddSshKeyMessage(value) {
        this._userShowAddSshKeyMessage = value;
    }
    resetUserShowAddSshKeyMessage() {
        this._userShowAddSshKeyMessage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userShowAddSshKeyMessageInput() {
        return this._userShowAddSshKeyMessage;
    }
    get versionCheckEnabled() {
        return this.getBooleanAttribute('version_check_enabled');
    }
    set versionCheckEnabled(value) {
        this._versionCheckEnabled = value;
    }
    resetVersionCheckEnabled() {
        this._versionCheckEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get versionCheckEnabledInput() {
        return this._versionCheckEnabled;
    }
    get webIdeClientsidePreviewEnabled() {
        return this.getBooleanAttribute('web_ide_clientside_preview_enabled');
    }
    set webIdeClientsidePreviewEnabled(value) {
        this._webIdeClientsidePreviewEnabled = value;
    }
    resetWebIdeClientsidePreviewEnabled() {
        this._webIdeClientsidePreviewEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get webIdeClientsidePreviewEnabledInput() {
        return this._webIdeClientsidePreviewEnabled;
    }
    get whatsNewVariant() {
        return this.getStringAttribute('whats_new_variant');
    }
    set whatsNewVariant(value) {
        this._whatsNewVariant = value;
    }
    resetWhatsNewVariant() {
        this._whatsNewVariant = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whatsNewVariantInput() {
        return this._whatsNewVariant;
    }
    get wikiPageMaxContentBytes() {
        return this.getNumberAttribute('wiki_page_max_content_bytes');
    }
    set wikiPageMaxContentBytes(value) {
        this._wikiPageMaxContentBytes = value;
    }
    resetWikiPageMaxContentBytes() {
        this._wikiPageMaxContentBytes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiPageMaxContentBytesInput() {
        return this._wikiPageMaxContentBytes;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            abuse_notification_email: cdktf.stringToTerraform(this._abuseNotificationEmail),
            admin_mode: cdktf.booleanToTerraform(this._adminMode),
            after_sign_out_path: cdktf.stringToTerraform(this._afterSignOutPath),
            after_sign_up_text: cdktf.stringToTerraform(this._afterSignUpText),
            akismet_api_key: cdktf.stringToTerraform(this._akismetApiKey),
            akismet_enabled: cdktf.booleanToTerraform(this._akismetEnabled),
            allow_group_owners_to_manage_ldap: cdktf.booleanToTerraform(this._allowGroupOwnersToManageLdap),
            allow_local_requests_from_system_hooks: cdktf.booleanToTerraform(this._allowLocalRequestsFromSystemHooks),
            allow_local_requests_from_web_hooks_and_services: cdktf.booleanToTerraform(this._allowLocalRequestsFromWebHooksAndServices),
            archive_builds_in_human_readable: cdktf.stringToTerraform(this._archiveBuildsInHumanReadable),
            asset_proxy_allowlist: cdktf.listMapper(cdktf.stringToTerraform, false)(this._assetProxyAllowlist),
            asset_proxy_enabled: cdktf.booleanToTerraform(this._assetProxyEnabled),
            asset_proxy_secret_key: cdktf.stringToTerraform(this._assetProxySecretKey),
            asset_proxy_url: cdktf.stringToTerraform(this._assetProxyUrl),
            authorized_keys_enabled: cdktf.booleanToTerraform(this._authorizedKeysEnabled),
            auto_devops_domain: cdktf.stringToTerraform(this._autoDevopsDomain),
            auto_devops_enabled: cdktf.booleanToTerraform(this._autoDevopsEnabled),
            automatic_purchased_storage_allocation: cdktf.booleanToTerraform(this._automaticPurchasedStorageAllocation),
            check_namespace_plan: cdktf.booleanToTerraform(this._checkNamespacePlan),
            commit_email_hostname: cdktf.stringToTerraform(this._commitEmailHostname),
            container_expiration_policies_enable_historic_entries: cdktf.booleanToTerraform(this._containerExpirationPoliciesEnableHistoricEntries),
            container_registry_cleanup_tags_service_max_list_size: cdktf.numberToTerraform(this._containerRegistryCleanupTagsServiceMaxListSize),
            container_registry_delete_tags_service_timeout: cdktf.numberToTerraform(this._containerRegistryDeleteTagsServiceTimeout),
            container_registry_expiration_policies_caching: cdktf.booleanToTerraform(this._containerRegistryExpirationPoliciesCaching),
            container_registry_expiration_policies_worker_capacity: cdktf.numberToTerraform(this._containerRegistryExpirationPoliciesWorkerCapacity),
            container_registry_token_expire_delay: cdktf.numberToTerraform(this._containerRegistryTokenExpireDelay),
            deactivate_dormant_users: cdktf.booleanToTerraform(this._deactivateDormantUsers),
            default_artifacts_expire_in: cdktf.stringToTerraform(this._defaultArtifactsExpireIn),
            default_branch_name: cdktf.stringToTerraform(this._defaultBranchName),
            default_branch_protection: cdktf.numberToTerraform(this._defaultBranchProtection),
            default_ci_config_path: cdktf.stringToTerraform(this._defaultCiConfigPath),
            default_group_visibility: cdktf.stringToTerraform(this._defaultGroupVisibility),
            default_project_creation: cdktf.numberToTerraform(this._defaultProjectCreation),
            default_project_visibility: cdktf.stringToTerraform(this._defaultProjectVisibility),
            default_projects_limit: cdktf.numberToTerraform(this._defaultProjectsLimit),
            default_snippet_visibility: cdktf.stringToTerraform(this._defaultSnippetVisibility),
            delayed_group_deletion: cdktf.booleanToTerraform(this._delayedGroupDeletion),
            delayed_project_deletion: cdktf.booleanToTerraform(this._delayedProjectDeletion),
            delete_inactive_projects: cdktf.booleanToTerraform(this._deleteInactiveProjects),
            deletion_adjourned_period: cdktf.numberToTerraform(this._deletionAdjournedPeriod),
            diff_max_files: cdktf.numberToTerraform(this._diffMaxFiles),
            diff_max_lines: cdktf.numberToTerraform(this._diffMaxLines),
            diff_max_patch_bytes: cdktf.numberToTerraform(this._diffMaxPatchBytes),
            disable_feed_token: cdktf.booleanToTerraform(this._disableFeedToken),
            disabled_oauth_sign_in_sources: cdktf.listMapper(cdktf.stringToTerraform, false)(this._disabledOauthSignInSources),
            dns_rebinding_protection_enabled: cdktf.booleanToTerraform(this._dnsRebindingProtectionEnabled),
            domain_allowlist: cdktf.listMapper(cdktf.stringToTerraform, false)(this._domainAllowlist),
            domain_denylist: cdktf.listMapper(cdktf.stringToTerraform, false)(this._domainDenylist),
            domain_denylist_enabled: cdktf.booleanToTerraform(this._domainDenylistEnabled),
            dsa_key_restriction: cdktf.numberToTerraform(this._dsaKeyRestriction),
            ecdsa_key_restriction: cdktf.numberToTerraform(this._ecdsaKeyRestriction),
            ecdsa_sk_key_restriction: cdktf.numberToTerraform(this._ecdsaSkKeyRestriction),
            ed25519_key_restriction: cdktf.numberToTerraform(this._ed25519KeyRestriction),
            ed25519_sk_key_restriction: cdktf.numberToTerraform(this._ed25519SkKeyRestriction),
            eks_access_key_id: cdktf.stringToTerraform(this._eksAccessKeyId),
            eks_account_id: cdktf.stringToTerraform(this._eksAccountId),
            eks_integration_enabled: cdktf.booleanToTerraform(this._eksIntegrationEnabled),
            eks_secret_access_key: cdktf.stringToTerraform(this._eksSecretAccessKey),
            elasticsearch_aws: cdktf.booleanToTerraform(this._elasticsearchAws),
            elasticsearch_aws_access_key: cdktf.stringToTerraform(this._elasticsearchAwsAccessKey),
            elasticsearch_aws_region: cdktf.stringToTerraform(this._elasticsearchAwsRegion),
            elasticsearch_aws_secret_access_key: cdktf.stringToTerraform(this._elasticsearchAwsSecretAccessKey),
            elasticsearch_indexed_field_length_limit: cdktf.numberToTerraform(this._elasticsearchIndexedFieldLengthLimit),
            elasticsearch_indexed_file_size_limit_kb: cdktf.numberToTerraform(this._elasticsearchIndexedFileSizeLimitKb),
            elasticsearch_indexing: cdktf.booleanToTerraform(this._elasticsearchIndexing),
            elasticsearch_limit_indexing: cdktf.booleanToTerraform(this._elasticsearchLimitIndexing),
            elasticsearch_max_bulk_concurrency: cdktf.numberToTerraform(this._elasticsearchMaxBulkConcurrency),
            elasticsearch_max_bulk_size_mb: cdktf.numberToTerraform(this._elasticsearchMaxBulkSizeMb),
            elasticsearch_namespace_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._elasticsearchNamespaceIds),
            elasticsearch_password: cdktf.stringToTerraform(this._elasticsearchPassword),
            elasticsearch_project_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._elasticsearchProjectIds),
            elasticsearch_search: cdktf.booleanToTerraform(this._elasticsearchSearch),
            elasticsearch_url: cdktf.listMapper(cdktf.stringToTerraform, false)(this._elasticsearchUrl),
            elasticsearch_username: cdktf.stringToTerraform(this._elasticsearchUsername),
            email_additional_text: cdktf.stringToTerraform(this._emailAdditionalText),
            email_author_in_body: cdktf.booleanToTerraform(this._emailAuthorInBody),
            enabled_git_access_protocol: cdktf.stringToTerraform(this._enabledGitAccessProtocol),
            enforce_namespace_storage_limit: cdktf.booleanToTerraform(this._enforceNamespaceStorageLimit),
            enforce_terms: cdktf.booleanToTerraform(this._enforceTerms),
            external_auth_client_cert: cdktf.stringToTerraform(this._externalAuthClientCert),
            external_auth_client_key: cdktf.stringToTerraform(this._externalAuthClientKey),
            external_auth_client_key_pass: cdktf.stringToTerraform(this._externalAuthClientKeyPass),
            external_authorization_service_default_label: cdktf.stringToTerraform(this._externalAuthorizationServiceDefaultLabel),
            external_authorization_service_enabled: cdktf.booleanToTerraform(this._externalAuthorizationServiceEnabled),
            external_authorization_service_timeout: cdktf.numberToTerraform(this._externalAuthorizationServiceTimeout),
            external_authorization_service_url: cdktf.stringToTerraform(this._externalAuthorizationServiceUrl),
            external_pipeline_validation_service_timeout: cdktf.numberToTerraform(this._externalPipelineValidationServiceTimeout),
            external_pipeline_validation_service_token: cdktf.stringToTerraform(this._externalPipelineValidationServiceToken),
            external_pipeline_validation_service_url: cdktf.stringToTerraform(this._externalPipelineValidationServiceUrl),
            file_template_project_id: cdktf.numberToTerraform(this._fileTemplateProjectId),
            first_day_of_week: cdktf.numberToTerraform(this._firstDayOfWeek),
            geo_node_allowed_ips: cdktf.stringToTerraform(this._geoNodeAllowedIps),
            geo_status_timeout: cdktf.numberToTerraform(this._geoStatusTimeout),
            git_rate_limit_users_allowlist: cdktf.listMapper(cdktf.stringToTerraform, false)(this._gitRateLimitUsersAllowlist),
            git_two_factor_session_expiry: cdktf.numberToTerraform(this._gitTwoFactorSessionExpiry),
            gitaly_timeout_default: cdktf.numberToTerraform(this._gitalyTimeoutDefault),
            gitaly_timeout_fast: cdktf.numberToTerraform(this._gitalyTimeoutFast),
            gitaly_timeout_medium: cdktf.numberToTerraform(this._gitalyTimeoutMedium),
            grafana_enabled: cdktf.booleanToTerraform(this._grafanaEnabled),
            grafana_url: cdktf.stringToTerraform(this._grafanaUrl),
            gravatar_enabled: cdktf.booleanToTerraform(this._gravatarEnabled),
            group_owners_can_manage_default_branch_protection: cdktf.booleanToTerraform(this._groupOwnersCanManageDefaultBranchProtection),
            hashed_storage_enabled: cdktf.booleanToTerraform(this._hashedStorageEnabled),
            help_page_hide_commercial_content: cdktf.booleanToTerraform(this._helpPageHideCommercialContent),
            help_page_support_url: cdktf.stringToTerraform(this._helpPageSupportUrl),
            help_page_text: cdktf.stringToTerraform(this._helpPageText),
            help_text: cdktf.stringToTerraform(this._helpText),
            hide_third_party_offers: cdktf.booleanToTerraform(this._hideThirdPartyOffers),
            home_page_url: cdktf.stringToTerraform(this._homePageUrl),
            housekeeping_enabled: cdktf.booleanToTerraform(this._housekeepingEnabled),
            housekeeping_full_repack_period: cdktf.numberToTerraform(this._housekeepingFullRepackPeriod),
            housekeeping_gc_period: cdktf.numberToTerraform(this._housekeepingGcPeriod),
            housekeeping_incremental_repack_period: cdktf.numberToTerraform(this._housekeepingIncrementalRepackPeriod),
            html_emails_enabled: cdktf.booleanToTerraform(this._htmlEmailsEnabled),
            id: cdktf.stringToTerraform(this._id),
            import_sources: cdktf.listMapper(cdktf.stringToTerraform, false)(this._importSources),
            in_product_marketing_emails_enabled: cdktf.booleanToTerraform(this._inProductMarketingEmailsEnabled),
            inactive_projects_delete_after_months: cdktf.numberToTerraform(this._inactiveProjectsDeleteAfterMonths),
            inactive_projects_min_size_mb: cdktf.numberToTerraform(this._inactiveProjectsMinSizeMb),
            inactive_projects_send_warning_email_after_months: cdktf.numberToTerraform(this._inactiveProjectsSendWarningEmailAfterMonths),
            invisible_captcha_enabled: cdktf.booleanToTerraform(this._invisibleCaptchaEnabled),
            issues_create_limit: cdktf.numberToTerraform(this._issuesCreateLimit),
            keep_latest_artifact: cdktf.booleanToTerraform(this._keepLatestArtifact),
            local_markdown_version: cdktf.numberToTerraform(this._localMarkdownVersion),
            mailgun_events_enabled: cdktf.booleanToTerraform(this._mailgunEventsEnabled),
            mailgun_signing_key: cdktf.stringToTerraform(this._mailgunSigningKey),
            maintenance_mode: cdktf.booleanToTerraform(this._maintenanceMode),
            maintenance_mode_message: cdktf.stringToTerraform(this._maintenanceModeMessage),
            max_artifacts_size: cdktf.numberToTerraform(this._maxArtifactsSize),
            max_attachment_size: cdktf.numberToTerraform(this._maxAttachmentSize),
            max_export_size: cdktf.numberToTerraform(this._maxExportSize),
            max_import_size: cdktf.numberToTerraform(this._maxImportSize),
            max_number_of_repository_downloads: cdktf.numberToTerraform(this._maxNumberOfRepositoryDownloads),
            max_number_of_repository_downloads_within_time_period: cdktf.numberToTerraform(this._maxNumberOfRepositoryDownloadsWithinTimePeriod),
            max_pages_size: cdktf.numberToTerraform(this._maxPagesSize),
            max_personal_access_token_lifetime: cdktf.numberToTerraform(this._maxPersonalAccessTokenLifetime),
            max_ssh_key_lifetime: cdktf.numberToTerraform(this._maxSshKeyLifetime),
            metrics_method_call_threshold: cdktf.numberToTerraform(this._metricsMethodCallThreshold),
            mirror_available: cdktf.booleanToTerraform(this._mirrorAvailable),
            mirror_capacity_threshold: cdktf.numberToTerraform(this._mirrorCapacityThreshold),
            mirror_max_capacity: cdktf.numberToTerraform(this._mirrorMaxCapacity),
            mirror_max_delay: cdktf.numberToTerraform(this._mirrorMaxDelay),
            npm_package_requests_forwarding: cdktf.booleanToTerraform(this._npmPackageRequestsForwarding),
            outbound_local_requests_whitelist: cdktf.listMapper(cdktf.stringToTerraform, false)(this._outboundLocalRequestsWhitelist),
            package_registry_cleanup_policies_worker_capacity: cdktf.numberToTerraform(this._packageRegistryCleanupPoliciesWorkerCapacity),
            pages_domain_verification_enabled: cdktf.booleanToTerraform(this._pagesDomainVerificationEnabled),
            password_authentication_enabled_for_git: cdktf.booleanToTerraform(this._passwordAuthenticationEnabledForGit),
            password_authentication_enabled_for_web: cdktf.booleanToTerraform(this._passwordAuthenticationEnabledForWeb),
            password_lowercase_required: cdktf.booleanToTerraform(this._passwordLowercaseRequired),
            password_number_required: cdktf.booleanToTerraform(this._passwordNumberRequired),
            password_symbol_required: cdktf.booleanToTerraform(this._passwordSymbolRequired),
            password_uppercase_required: cdktf.booleanToTerraform(this._passwordUppercaseRequired),
            performance_bar_allowed_group_path: cdktf.stringToTerraform(this._performanceBarAllowedGroupPath),
            personal_access_token_prefix: cdktf.stringToTerraform(this._personalAccessTokenPrefix),
            pipeline_limit_per_project_user_sha: cdktf.numberToTerraform(this._pipelineLimitPerProjectUserSha),
            plantuml_enabled: cdktf.booleanToTerraform(this._plantumlEnabled),
            plantuml_url: cdktf.stringToTerraform(this._plantumlUrl),
            polling_interval_multiplier: cdktf.numberToTerraform(this._pollingIntervalMultiplier),
            project_export_enabled: cdktf.booleanToTerraform(this._projectExportEnabled),
            prometheus_metrics_enabled: cdktf.booleanToTerraform(this._prometheusMetricsEnabled),
            protected_ci_variables: cdktf.booleanToTerraform(this._protectedCiVariables),
            push_event_activities_limit: cdktf.numberToTerraform(this._pushEventActivitiesLimit),
            push_event_hooks_limit: cdktf.numberToTerraform(this._pushEventHooksLimit),
            pypi_package_requests_forwarding: cdktf.booleanToTerraform(this._pypiPackageRequestsForwarding),
            rate_limiting_response_text: cdktf.stringToTerraform(this._rateLimitingResponseText),
            raw_blob_request_limit: cdktf.numberToTerraform(this._rawBlobRequestLimit),
            recaptcha_enabled: cdktf.booleanToTerraform(this._recaptchaEnabled),
            recaptcha_private_key: cdktf.stringToTerraform(this._recaptchaPrivateKey),
            recaptcha_site_key: cdktf.stringToTerraform(this._recaptchaSiteKey),
            receive_max_input_size: cdktf.numberToTerraform(this._receiveMaxInputSize),
            repository_checks_enabled: cdktf.booleanToTerraform(this._repositoryChecksEnabled),
            repository_size_limit: cdktf.numberToTerraform(this._repositorySizeLimit),
            repository_storages: cdktf.listMapper(cdktf.stringToTerraform, false)(this._repositoryStorages),
            repository_storages_weighted: cdktf.hashMapper(cdktf.numberToTerraform)(this._repositoryStoragesWeighted),
            require_admin_approval_after_user_signup: cdktf.booleanToTerraform(this._requireAdminApprovalAfterUserSignup),
            require_two_factor_authentication: cdktf.booleanToTerraform(this._requireTwoFactorAuthentication),
            restricted_visibility_levels: cdktf.listMapper(cdktf.stringToTerraform, false)(this._restrictedVisibilityLevels),
            rsa_key_restriction: cdktf.numberToTerraform(this._rsaKeyRestriction),
            search_rate_limit: cdktf.numberToTerraform(this._searchRateLimit),
            search_rate_limit_unauthenticated: cdktf.numberToTerraform(this._searchRateLimitUnauthenticated),
            send_user_confirmation_email: cdktf.booleanToTerraform(this._sendUserConfirmationEmail),
            session_expire_delay: cdktf.numberToTerraform(this._sessionExpireDelay),
            shared_runners_enabled: cdktf.booleanToTerraform(this._sharedRunnersEnabled),
            shared_runners_minutes: cdktf.numberToTerraform(this._sharedRunnersMinutes),
            shared_runners_text: cdktf.stringToTerraform(this._sharedRunnersText),
            sidekiq_job_limiter_compression_threshold_bytes: cdktf.numberToTerraform(this._sidekiqJobLimiterCompressionThresholdBytes),
            sidekiq_job_limiter_limit_bytes: cdktf.numberToTerraform(this._sidekiqJobLimiterLimitBytes),
            sidekiq_job_limiter_mode: cdktf.stringToTerraform(this._sidekiqJobLimiterMode),
            sign_in_text: cdktf.stringToTerraform(this._signInText),
            signup_enabled: cdktf.booleanToTerraform(this._signupEnabled),
            slack_app_enabled: cdktf.booleanToTerraform(this._slackAppEnabled),
            slack_app_id: cdktf.stringToTerraform(this._slackAppId),
            slack_app_secret: cdktf.stringToTerraform(this._slackAppSecret),
            slack_app_signing_secret: cdktf.stringToTerraform(this._slackAppSigningSecret),
            slack_app_verification_token: cdktf.stringToTerraform(this._slackAppVerificationToken),
            snippet_size_limit: cdktf.numberToTerraform(this._snippetSizeLimit),
            snowplow_app_id: cdktf.stringToTerraform(this._snowplowAppId),
            snowplow_collector_hostname: cdktf.stringToTerraform(this._snowplowCollectorHostname),
            snowplow_cookie_domain: cdktf.stringToTerraform(this._snowplowCookieDomain),
            snowplow_enabled: cdktf.booleanToTerraform(this._snowplowEnabled),
            sourcegraph_enabled: cdktf.booleanToTerraform(this._sourcegraphEnabled),
            sourcegraph_public_only: cdktf.booleanToTerraform(this._sourcegraphPublicOnly),
            sourcegraph_url: cdktf.stringToTerraform(this._sourcegraphUrl),
            spam_check_api_key: cdktf.stringToTerraform(this._spamCheckApiKey),
            spam_check_endpoint_enabled: cdktf.booleanToTerraform(this._spamCheckEndpointEnabled),
            spam_check_endpoint_url: cdktf.stringToTerraform(this._spamCheckEndpointUrl),
            suggest_pipeline_enabled: cdktf.booleanToTerraform(this._suggestPipelineEnabled),
            terminal_max_session_time: cdktf.numberToTerraform(this._terminalMaxSessionTime),
            terms: cdktf.stringToTerraform(this._terms),
            throttle_authenticated_api_enabled: cdktf.booleanToTerraform(this._throttleAuthenticatedApiEnabled),
            throttle_authenticated_api_period_in_seconds: cdktf.numberToTerraform(this._throttleAuthenticatedApiPeriodInSeconds),
            throttle_authenticated_api_requests_per_period: cdktf.numberToTerraform(this._throttleAuthenticatedApiRequestsPerPeriod),
            throttle_authenticated_packages_api_enabled: cdktf.booleanToTerraform(this._throttleAuthenticatedPackagesApiEnabled),
            throttle_authenticated_packages_api_period_in_seconds: cdktf.numberToTerraform(this._throttleAuthenticatedPackagesApiPeriodInSeconds),
            throttle_authenticated_packages_api_requests_per_period: cdktf.numberToTerraform(this._throttleAuthenticatedPackagesApiRequestsPerPeriod),
            throttle_authenticated_web_enabled: cdktf.booleanToTerraform(this._throttleAuthenticatedWebEnabled),
            throttle_authenticated_web_period_in_seconds: cdktf.numberToTerraform(this._throttleAuthenticatedWebPeriodInSeconds),
            throttle_authenticated_web_requests_per_period: cdktf.numberToTerraform(this._throttleAuthenticatedWebRequestsPerPeriod),
            throttle_unauthenticated_api_enabled: cdktf.booleanToTerraform(this._throttleUnauthenticatedApiEnabled),
            throttle_unauthenticated_api_period_in_seconds: cdktf.numberToTerraform(this._throttleUnauthenticatedApiPeriodInSeconds),
            throttle_unauthenticated_api_requests_per_period: cdktf.numberToTerraform(this._throttleUnauthenticatedApiRequestsPerPeriod),
            throttle_unauthenticated_packages_api_enabled: cdktf.booleanToTerraform(this._throttleUnauthenticatedPackagesApiEnabled),
            throttle_unauthenticated_packages_api_period_in_seconds: cdktf.numberToTerraform(this._throttleUnauthenticatedPackagesApiPeriodInSeconds),
            throttle_unauthenticated_packages_api_requests_per_period: cdktf.numberToTerraform(this._throttleUnauthenticatedPackagesApiRequestsPerPeriod),
            throttle_unauthenticated_web_enabled: cdktf.booleanToTerraform(this._throttleUnauthenticatedWebEnabled),
            throttle_unauthenticated_web_period_in_seconds: cdktf.numberToTerraform(this._throttleUnauthenticatedWebPeriodInSeconds),
            throttle_unauthenticated_web_requests_per_period: cdktf.numberToTerraform(this._throttleUnauthenticatedWebRequestsPerPeriod),
            time_tracking_limit_to_hours: cdktf.booleanToTerraform(this._timeTrackingLimitToHours),
            two_factor_grace_period: cdktf.numberToTerraform(this._twoFactorGracePeriod),
            unique_ips_limit_enabled: cdktf.booleanToTerraform(this._uniqueIpsLimitEnabled),
            unique_ips_limit_per_user: cdktf.numberToTerraform(this._uniqueIpsLimitPerUser),
            unique_ips_limit_time_window: cdktf.numberToTerraform(this._uniqueIpsLimitTimeWindow),
            usage_ping_enabled: cdktf.booleanToTerraform(this._usagePingEnabled),
            user_deactivation_emails_enabled: cdktf.booleanToTerraform(this._userDeactivationEmailsEnabled),
            user_default_external: cdktf.booleanToTerraform(this._userDefaultExternal),
            user_default_internal_regex: cdktf.stringToTerraform(this._userDefaultInternalRegex),
            user_oauth_applications: cdktf.booleanToTerraform(this._userOauthApplications),
            user_show_add_ssh_key_message: cdktf.booleanToTerraform(this._userShowAddSshKeyMessage),
            version_check_enabled: cdktf.booleanToTerraform(this._versionCheckEnabled),
            web_ide_clientside_preview_enabled: cdktf.booleanToTerraform(this._webIdeClientsidePreviewEnabled),
            whats_new_variant: cdktf.stringToTerraform(this._whatsNewVariant),
            wiki_page_max_content_bytes: cdktf.numberToTerraform(this._wikiPageMaxContentBytes),
        };
    }
}
exports.ApplicationSettings = ApplicationSettings;
_a = JSII_RTTI_SYMBOL_1;
ApplicationSettings[_a] = { fqn: "@cdktf/provider-gitlab.applicationSettings.ApplicationSettings", version: "6.0.2" };
// =================
// STATIC PROPERTIES
// =================
ApplicationSettings.tfResourceType = "gitlab_application_settings";
//# sourceMappingURL=data:application/json;base64,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