[![Build Status](https://travis-ci.org/ArduPilot/pymavlink.svg?branch=master)](https://travis-ci.org/ArduPilot/pymavlink)
# Pymavlink
This is a python implementation of the MAVLink protocol.
It includes a source code generator (generator/mavgen.py) to create MAVLink protocol implementations for other programming languages as well.
Also contains tools for analizing flight logs.

# Documentation

Please see http://ardupilot.org/dev/docs/mavlink-commands.html for documentation.

For realtime discussion please see the pymavlink gitter channel here
https://gitter.im/ArduPilot/pymavlink


# Installation 

Pymavlink supports both python2 and python3.

The following instructions assume you are using Python 2 and a Debian-based (like Ubuntu) installation.

## Dependencies

Pymavlink has several dependencies :

    - future : for python 2 and python 3 interoperability (http://python-future.org/)
    - lxml : for checking and parsing xml file (http://lxml.de/installation.html)
    - python-dev : for mavnative
    - a C compiler : for mavnative

Optional :

    - numpy : for FFT
    - pytest : for tests

### On linux

lxml has some additional dependencies that can be installed with your package manager (here with `apt-get`) :

```bash
sudo apt-get install gcc python-dev libxml2-dev libxslt-dev
```

Optional for FFT scripts and tests:

```bash
sudo apt-get install python-numpy python-pytest
```

Using pip you can install the required dependencies for pymavlink :

```bash
sudo pip2 install -U future lxml
```

The -U parameter allows updating future and lxml version if it is already installed.

### On Windows

Use pip to install future as for linux.
Lxml can be installed with a windows installer from here : https://pypi.python.org/pypi/lxml/3.6.0


## Installation

### For users

It is recommended to install pymavlink from PyPi with pip, that way dependencies should be auto install by pip.

```bash
sudo pip2 install -U pymavlink
```

The -U parameter allow to update pymavlink version if it is already installed.

#### Mavnative

By default, pymavlink will try to compile and install mavnative which is a C extension for parsing mavlink. Mavnative only supports mavlink1.
To skip mavnative installation and reduce dependencies like `gcc` and `python-dev`, you can pass `DISABLE_MAVNATIVE=True` environment variable to the installation command:

```bash
sudo DISABLE_MAVNATIVE=True pip2 install -U pymavlink
```

### For developers

On the pymavlink directory, you can use :

```bash
sudo MDEF=PATH_TO_message_definitions pip2 install . -v
```

The -v parameter will output the installation commands on the terminal.
The MDEF usage is require as pip install is done from /tmp directory, so it is necessary to use MDEF variable to 
point on the message_definitions directory.
Use pip should auto install dependencies and allow to keep them up-to-date with pip. 

Or:

```bash
sudo python2 setup.py install
```


### Advanced usage

Please see Pip documentation : https://pip.pypa.io/en/stable/

# License
---------

pymavlink is released under the GNU Lesser General Public License v3 or later.

The source code generated by generator/mavgen.py is available under the permissive MIT License.

