from setuptools import setup, find_packages

setup(
    name="bazarrbulksync",
    version="0.1.0",
    description="An optimized command-line tool for bulk syncing media subtitles in Bazarr",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    author="Brian Wei Hao Ma",
    author_email="brianmaytc@gmail.com",
    license="MIT",
    url="https://github.com/BrianWeiHaoMa/bazarrbulksync",
    classifiers=[
        "Development Status :: 4 - Beta",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Topic :: Utilities",
        "Topic :: Multimedia :: Video",
        "Intended Audience :: System Administrators",
        "Intended Audience :: End Users/Desktop",
        "Intended Audience :: Information Technology",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Programming Language :: Python :: 3.13",
        "Programming Language :: Python :: 3 :: Only",
    ],
    keywords=[
        "bazarr",
        "subtitles",
        "subtitle-sync",
        "subtitle-synchronization",
        "media",
        "video",
        "movies",
        "tv",
        "cli",
        "command-line",
        "automation",
        "bulk",
        "sync",
        "media-server",
        "plex",
        "emby",
        "jellyfin",
        "sonarr",
        "radarr",
        "streaming",
    ],
    python_requires=">=3.10",
    packages=find_packages(exclude=("tests")),
    install_requires=[
        "PyYAML>=6.0.0, <7.0.0",
        "requests>=2.32.0, <3.0.0",
    ],
    entry_points={
        "console_scripts": [
            "bazarrbulksync=cli.cli:main",
        ],
    },
)
