"""initial

Revision ID: a4da44eeca08
Revises: 
Create Date: 2022-06-17 02:28:48.502682

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "a4da44eeca08"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "groups",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "users",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("email", sa.Text(), nullable=False),
        sa.Column("password", sa.Text(), nullable=False),
        sa.Column("active", sa.Boolean(), nullable=True),
        sa.Column("admin", sa.Boolean(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("email"),
    )
    op.create_table(
        "groupusers",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("user", sa.Integer(), nullable=True),
        sa.Column("group", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["group"], ["groups.id"], name="fk_groupusers_groups_id_group"
        ),
        sa.ForeignKeyConstraint(
            ["user"], ["users.id"], name="fk_groupusers_users_id_user"
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("user", "group", name="uc_groupusers_user_group"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("groupusers")
    op.drop_table("users")
    op.drop_table("groups")
    # ### end Alembic commands ###
