# scrapy-slackbot

[![pdm-managed](https://img.shields.io/badge/pdm-managed-blueviolet)](https://pdm.fming.dev)
[![LICENSE](https://img.shields.io/github/license/rudeigerc/scrapy-slackbot.svg)](https://github.com/rudeigerc/scrapy-slackbot/blob/master/LICENSE)

A Scrapy extension to send notification to the Slack channel.

## Installation

```shell
$ pip install scrapy-slackbot
```

## Settings

In `settings.py`:

```python
EXTENSIONS = {
    'scrapyslackbot.extensions.SlackBot': 500,
}

SLACK_ENABLED = True
SLACK_BOT_TOKEN = ''
SLACK_CHANNEL = ''
```

### SLACK_ENABLED

A boolean which specifies whether the bot is enabled.

### SLACK_BOT_TOKEN

`Bot User OAuth Access Token` generated by **Slack**.

Follow the instructions of [Slack API](https://api.slack.com/slack-apps), visit `Features > OAuth & Permissions` and generate the token.

### SLACK_CHANNEL

The ID of the channel in your workspace.

## Development

```shell
$ pdm install
```

## Demo

![demo](demo.jpg)

## License

MIT
