# Decode Server Flask

A middleware for Flask for authenticating requests from [Decode Auth Server](https://decodeauth.com/).


## Installing

Install using pip:

```sh
pip install decode_server_flask
```

## A simple example

To integrate your Flask app with Decode Auth you only need to import the middleware and register it with the app.
A simple example on how to do it:

```python
from flask import Flask
from decode_server_flask import decode_server_flask
from os import environ

app = Flask(__name__)

# To setup the middleware, you need to get the Decode's RSA Public Key.
# You can read the key from a file or from an ENV variable.
app.config["DECODE_PUBLIC_KEY"] = os.environ["DECODE_PUBLIC_KEY"]

# Then just pass the key to the middleware
app.wsgi_app = decode_server_flask(app.wsgi_app, app.config["DECODE_PUBLIC_KEY"])


# Now all the routes are protected!
# To call them you need a valid JWT which only the Decode Auth server can generate.
@app.route("/me", methods=["GET"])
def me_api():
    return {
        "user": "Paul Muad'Dib",
        "affiliation": "Fremen",
        "house": "Atreides",
    }
```


## Developing

To install Decode Server Flask, alogn with the tools you need to develop and run tests, run the following in your virtualenv:

```sh
pip install -e .[dev]
```
