#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import dill as pkl
from os import path
from glob import glob
from dateutil.parser import parse
import SplatStats.Battle as bat
import SplatStats.parsers as par
import SplatStats.auxiliary as aux

class History:
    """
    Attributes
    ----------
    historyFiles : list of paths
        List of battle history filepaths

    Methods
    -------
    """
    ###########################################################################
    # History info
    ###########################################################################
    def __init__(self, iPath, oPath):
        self.outputPath = oPath
        self.inputPath = iPath
        # Get history filepaths -----------------------------------------------
        hFolders = aux.getHistoryFolders(iPath, expPat='export-*')
        hFiles = aux.getHistoryFiles(hFolders, pattern='results.json')
        self.historyFiles = hFiles
        # Start the battle files list as empty --------------------------------
        self.battleFilepaths = []

    ###########################################################################
    # Dump all battles
    ###########################################################################
    def dumpBattlesFromJSONS(self):
        for fName in self.historyFiles:
            with open(fName, 'r') as file:
                data = json.load(file)
            histSize = len(data)
            for i in range(histSize):
                bDetail = data[i]['data']['vsHistoryDetail']
                # Process battle history --------------------------------------
                battle = bat.Battle(bDetail)
                battle.alliedTeam
                # Export battle history ---------------------------------------
                battle.dumpBattle(self.outputPath)
                
    ###########################################################################
    # Read present battles
    ###########################################################################
    def getBattleFilepaths(self):
        battleFilepaths = glob(path.join(self.outputPath, '*.pkl'))
        self.battleFilepaths = battleFilepaths