#!/usr/bin/env python

from os.path import abspath, dirname, join

import pathlib

from setuptools import setup

import pkg_resources

with pathlib.Path('requirements.txt').open() as requirements_txt:
    install_reqs = [
        str(requirement)
        for requirement
        in pkg_resources.parse_requirements(requirements_txt)
    ]

here = abspath(dirname(__file__))

with open(join(here, 'VERSION')) as f:
    VERSION = f.read()

setup(
    name='apsconnectcli',
    author='CloudBlue',
    version=VERSION,
    keywords='aps apsconnect connector automation',
    extras_require={
        ':python_version<="2.7"': ['backports.tempfile==1.0']},
    packages=['apsconnectcli'],
    description='A command line tool that automates lifecycle management of APS packages '
                'generated by CloudBlue Connect into the CloudBlue Commerce instance.',
    url='https://github.com/cloudblue/apsconnect-cli',
    license='Apache Software License',
    include_package_data=True,
    install_requires=install_reqs,
    entry_points={
        'console_scripts': [
            'apsconnect = apsconnectcli.apsconnect:main',
        ]
    },
    classifiers=[
        'Development Status :: 4 - Beta',

        'Intended Audience :: Developers',
        'Topic :: Software Development :: Libraries :: Python Modules',

        'License :: OSI Approved :: Apache Software License',

        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',

        'Operating System :: OS Independent',
        'Operating System :: POSIX',
        'Operating System :: MacOS',
        'Operating System :: Unix',
    ],
)
