/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.capnproto.BufferedInputStream;
import org.capnproto.BufferedInputStreamWrapper;
import org.capnproto.BufferedOutputStream;
import org.capnproto.BufferedOutputStreamWrapper;
import org.capnproto.MessageBuilder;
import org.capnproto.MessageReader;
import org.capnproto.PackedInputStream;
import org.capnproto.PackedOutputStream;
import org.capnproto.ReaderOptions;
import org.capnproto.Serialize;

public final class SerializePacked {
    public static MessageReader read(BufferedInputStream bufferedInputStream) throws IOException {
        return SerializePacked.read(bufferedInputStream, ReaderOptions.DEFAULT_READER_OPTIONS);
    }

    public static MessageReader read(BufferedInputStream bufferedInputStream, ReaderOptions readerOptions) throws IOException {
        PackedInputStream packedInputStream = new PackedInputStream(bufferedInputStream);
        return Serialize.read(packedInputStream, readerOptions);
    }

    public static MessageReader readFromUnbuffered(ReadableByteChannel readableByteChannel) throws IOException {
        return SerializePacked.readFromUnbuffered(readableByteChannel, ReaderOptions.DEFAULT_READER_OPTIONS);
    }

    public static MessageReader readFromUnbuffered(ReadableByteChannel readableByteChannel, ReaderOptions readerOptions) throws IOException {
        PackedInputStream packedInputStream = new PackedInputStream(new BufferedInputStreamWrapper(readableByteChannel));
        return Serialize.read(packedInputStream, readerOptions);
    }

    public static void write(BufferedOutputStream bufferedOutputStream, MessageBuilder messageBuilder) throws IOException {
        PackedOutputStream packedOutputStream = new PackedOutputStream(bufferedOutputStream);
        Serialize.write(packedOutputStream, messageBuilder);
    }

    public static void writeToUnbuffered(WritableByteChannel writableByteChannel, MessageBuilder messageBuilder) throws IOException {
        BufferedOutputStreamWrapper bufferedOutputStreamWrapper = new BufferedOutputStreamWrapper(writableByteChannel);
        SerializePacked.write(bufferedOutputStreamWrapper, messageBuilder);
        bufferedOutputStreamWrapper.flush();
    }
}

