/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.capnproto.BufferedOutputStream;

public final class BufferedOutputStreamWrapper
implements BufferedOutputStream {
    private final WritableByteChannel inner;
    private final ByteBuffer buf;

    public BufferedOutputStreamWrapper(WritableByteChannel writableByteChannel) {
        this.inner = writableByteChannel;
        this.buf = ByteBuffer.allocate(8192);
    }

    @Override
    public final int write(ByteBuffer byteBuffer) throws IOException {
        int n2 = this.buf.remaining();
        int n3 = byteBuffer.remaining();
        if (n3 <= n2) {
            this.buf.put(byteBuffer);
        } else if (n3 <= this.buf.capacity()) {
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.limit(n2);
            this.buf.put(byteBuffer2);
            this.buf.rewind();
            while (this.buf.hasRemaining()) {
                this.inner.write(this.buf);
            }
            this.buf.rewind();
            byteBuffer.position(byteBuffer.position() + n2);
            this.buf.put(byteBuffer);
        } else {
            int n4 = this.buf.position();
            this.buf.rewind();
            ByteBuffer byteBuffer3 = this.buf.slice();
            byteBuffer3.limit(n4);
            while (byteBuffer3.hasRemaining()) {
                this.inner.write(byteBuffer3);
            }
            while (byteBuffer.hasRemaining()) {
                this.inner.write(byteBuffer);
            }
        }
        return n3;
    }

    @Override
    public final ByteBuffer getWriteBuffer() {
        return this.buf;
    }

    @Override
    public final void close() throws IOException {
        this.inner.close();
    }

    @Override
    public final boolean isOpen() {
        return this.inner.isOpen();
    }

    @Override
    public final void flush() throws IOException {
        int n2 = this.buf.position();
        this.buf.rewind();
        this.buf.limit(n2);
        this.inner.write(this.buf);
        this.buf.clear();
    }
}

