/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.rulefit;

import hex.genmodel.MultiModelMojoReader;
import hex.genmodel.algos.rulefit.MojoCondition;
import hex.genmodel.algos.rulefit.MojoRule;
import hex.genmodel.algos.rulefit.MojoRuleEnsemble;
import hex.genmodel.algos.rulefit.RuleFitMojoModel;
import java.io.IOException;

public class RuleFitMojoReader
extends MultiModelMojoReader<RuleFitMojoModel> {
    @Override
    protected void readParentModelData() throws IOException {
        int i2;
        ((RuleFitMojoModel)this._model)._linearModel = this.getModel((String)this.readkv("linear_model"));
        int modelType = (Integer)this.readkv("model_type");
        ((RuleFitMojoModel)this._model)._modelType = modelType == 0 ? RuleFitMojoModel.ModelType.LINEAR : (modelType == 1 ? RuleFitMojoModel.ModelType.RULES_AND_LINEAR : RuleFitMojoModel.ModelType.RULES);
        ((RuleFitMojoModel)this._model)._depth = (Integer)this.readkv("depth");
        ((RuleFitMojoModel)this._model)._ntrees = (Integer)this.readkv("ntrees");
        if (!((RuleFitMojoModel)this._model)._modelType.equals((Object)RuleFitMojoModel.ModelType.LINEAR)) {
            ((RuleFitMojoModel)this._model)._ruleEnsemble = this.readRuleEnseble();
        }
        int len = (Integer)this.readkv("data_from_rules_codes_len");
        ((RuleFitMojoModel)this._model)._dataFromRulesCodes = new String[len];
        for (i2 = 0; i2 < len; ++i2) {
            ((RuleFitMojoModel)this._model)._dataFromRulesCodes[i2] = (String)this.readkv("data_from_rules_codes_" + i2);
        }
        ((RuleFitMojoModel)this._model)._weightsColumn = (String)this.readkv("weights_column");
        len = (Integer)this.readkv("linear_names_len");
        ((RuleFitMojoModel)this._model)._linearNames = new String[len];
        for (i2 = 0; i2 < len; ++i2) {
            ((RuleFitMojoModel)this._model)._linearNames[i2] = (String)this.readkv("linear_names_" + i2);
        }
    }

    @Override
    public String getModelName() {
        return "rulefit";
    }

    @Override
    protected RuleFitMojoModel makeModel(String[] columns, String[][] domains, String responseColumn) {
        return new RuleFitMojoModel(columns, domains, responseColumn);
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }

    MojoRuleEnsemble readRuleEnseble() throws IOException {
        MojoRuleEnsemble ruleEnsemble = new MojoRuleEnsemble(this.readOrderedRuleEnseble());
        return ruleEnsemble;
    }

    MojoRule[][][] readOrderedRuleEnseble() throws IOException {
        MojoRule[][][] orderedRules = new MojoRule[((RuleFitMojoModel)this._model)._depth][((RuleFitMojoModel)this._model)._ntrees][];
        for (int i2 = 0; i2 < ((RuleFitMojoModel)this._model)._depth; ++i2) {
            for (int j2 = 0; j2 < ((RuleFitMojoModel)this._model)._ntrees; ++j2) {
                int currNumRules = (Integer)this.readkv("num_rules_M".concat(String.valueOf(i2)).concat("T").concat(String.valueOf(j2)));
                MojoRule[] currRules = new MojoRule[currNumRules];
                String currIdPrefix = i2 + "_" + j2 + "_";
                for (int k2 = 0; k2 < currNumRules; ++k2) {
                    currRules[k2] = this.readRule(currIdPrefix + k2);
                }
                orderedRules[i2][j2] = currRules;
            }
        }
        return orderedRules;
    }

    MojoRule readRule(String ruleId) throws IOException {
        MojoRule rule = new MojoRule();
        int numConditions = (Integer)this.readkv("num_conditions_rule_id_" + ruleId);
        MojoCondition[] conditions = new MojoCondition[numConditions];
        for (int i2 = 0; i2 < numConditions; ++i2) {
            conditions[i2] = this.readCondition(i2, ruleId);
        }
        rule._conditions = conditions;
        rule._predictionValue = (Double)this.readkv("prediction_value_rule_id_" + ruleId);
        rule._languageRule = (String)this.readkv("language_rule_rule_id_" + ruleId);
        rule._coefficient = (Double)this.readkv("coefficient_rule_id_" + ruleId);
        rule._varName = (String)this.readkv("var_name_rule_id_" + ruleId);
        rule._support = this.readkv("support_rule_id_" + ruleId) != null ? (Double)this.readkv("support_rule_id_" + ruleId) : Double.NaN;
        return rule;
    }

    MojoCondition readCondition(int conditionId, String ruleId) {
        MojoCondition condition = new MojoCondition();
        String conditionIdentifier = conditionId + "_" + ruleId;
        condition._featureIndex = (Integer)this.readkv("feature_index_" + conditionIdentifier);
        int type = (Integer)this.readkv("type_" + conditionIdentifier);
        if (type == 0) {
            condition._type = MojoCondition.Type.Categorical;
            int languageCatTresholdLength = (Integer)this.readkv("language_cat_treshold_length_" + conditionIdentifier);
            String[] languageCatTreshold = new String[languageCatTresholdLength];
            for (int i2 = 0; i2 < languageCatTresholdLength; ++i2) {
                languageCatTreshold[i2] = this.readkv("language_cat_treshold_" + i2 + "_" + conditionIdentifier).toString();
            }
            condition._languageCatThreshold = languageCatTreshold;
            int catTresholdLength = (Integer)this.readkv("cat_treshold_length_" + conditionIdentifier);
            int[] catTreshold = new int[catTresholdLength];
            for (int i3 = 0; i3 < catTresholdLength; ++i3) {
                catTreshold[i3] = (Integer)this.readkv("cat_treshold_length_" + i3 + "_" + conditionIdentifier);
            }
            condition._catThreshold = catTreshold;
        } else {
            condition._type = MojoCondition.Type.Numerical;
            condition._numThreshold = (Double)this.readkv("num_treshold" + conditionIdentifier);
        }
        int operator = (Integer)this.readkv("operator_" + conditionIdentifier);
        condition._operator = operator == 0 ? MojoCondition.Operator.LessThan : (operator == 1 ? MojoCondition.Operator.GreaterThanOrEqual : MojoCondition.Operator.In);
        condition._featureName = (String)this.readkv("feature_name_" + conditionIdentifier);
        condition._NAsIncluded = (Boolean)this.readkv("nas_included_" + conditionIdentifier);
        condition._languageCondition = (String)this.readkv("language_condition" + conditionIdentifier);
        return condition;
    }
}

