"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dashboard = exports.PeriodOverride = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const cloudwatch_generated_1 = require("./cloudwatch.generated");
const layout_1 = require("./layout");
/**
 * Specify the period for graphs when the CloudWatch dashboard loads.
 *
 * @stability stable
 */
var PeriodOverride;
(function (PeriodOverride) {
    PeriodOverride["AUTO"] = "auto";
    PeriodOverride["INHERIT"] = "inherit";
})(PeriodOverride = exports.PeriodOverride || (exports.PeriodOverride = {}));
/**
 * A CloudWatch dashboard.
 *
 * @stability stable
 */
class Dashboard extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.dashboardName,
        });
        this.rows = [];
        {
            const { dashboardName } = props;
            if (dashboardName && !core_1.Token.isUnresolved(dashboardName) && !dashboardName.match(/^[\w-]+$/)) {
                throw new Error([
                    `The value ${dashboardName} for field dashboardName contains invalid characters.`,
                    'It can only contain alphanumerics, dash (-) and underscore (_).',
                ].join(' '));
            }
        }
        new cloudwatch_generated_1.CfnDashboard(this, 'Resource', {
            dashboardName: this.physicalName,
            dashboardBody: core_1.Lazy.string({
                produce: () => {
                    const column = new layout_1.Column(...this.rows);
                    column.position(0, 0);
                    return core_1.Stack.of(this).toJsonString({
                        start: props.start,
                        end: props.end,
                        periodOverride: props.periodOverride,
                        widgets: column.toJson(),
                    });
                },
            }),
        });
        (props.widgets || []).forEach(row => {
            this.addWidgets(...row);
        });
    }
    /**
     * Add a widget to the dashboard.
     *
     * Widgets given in multiple calls to add() will be laid out stacked on
     * top of each other.
     *
     * Multiple widgets added in the same call to add() will be laid out next
     * to each other.
     *
     * @stability stable
     */
    addWidgets(...widgets) {
        if (widgets.length === 0) {
            return;
        }
        const w = widgets.length > 1 ? new layout_1.Row(...widgets) : widgets[0];
        this.rows.push(w);
    }
}
exports.Dashboard = Dashboard;
_a = JSII_RTTI_SYMBOL_1;
Dashboard[_a] = { fqn: "@aws-cdk/aws-cloudwatch.Dashboard", version: "1.116.0" };
//# sourceMappingURL=data:application/json;base64,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