#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..input.kqi_source_filter_input import KqiSourceFilterInput
from ..input.kqi_source_order import KqiSourceOrder


# fmt: off
QUERY: List[str] = ["""
query kqiSources(
$after: Cursor
$first: Int
$before: Cursor
$last: Int
$orderBy: KqiSourceOrder
$filterBy: [KqiSourceFilterInput!]
){
  kqiSources(after: $after, first: $first, before: $before, last: $last, orderBy: $orderBy, filterBy: $filterBy){
    totalCount
    edges{
      node{
        id
        name
      }
      cursor
    }
    pageInfo{
      hasNextPage
      hasPreviousPage
      startCursor
      endCursor
    }
  }
}
"""
]


class kqiSources:
    @dataclass(frozen=True)
    class kqiSourcesData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class KqiSourceConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class KqiSourceEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class KqiSource(DataClassJsonMixin):
                    id: str
                    name: str

                node: Optional[KqiSource]
                cursor: str

            @dataclass(frozen=True)
            class PageInfo(DataClassJsonMixin):
                hasNextPage: bool
                hasPreviousPage: bool
                startCursor: Optional[str]
                endCursor: Optional[str]

            totalCount: int
            edges: List[KqiSourceEdge]
            pageInfo: PageInfo

        kqiSources: KqiSourceConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[KqiSourceOrder] = None, filterBy: List[KqiSourceFilterInput] = []) -> kqiSourcesData.KqiSourceConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.kqiSourcesData.from_dict(response_text)
        return res.kqiSources

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[KqiSourceOrder] = None, filterBy: List[KqiSourceFilterInput] = []) -> kqiSourcesData.KqiSourceConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.kqiSourcesData.from_dict(response_text)
        return res.kqiSources
