"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalTable = void 0;
const dynamodb = require("@aws-cdk/aws-dynamodb");
const cdk = require("@aws-cdk/core");
const global_table_coordinator_1 = require("./global-table-coordinator");
/**
 * This class works by deploying an AWS DynamoDB table into each region specified in  GlobalTableProps.regions[],
 * then triggering a CloudFormation Custom Resource Lambda to link them all together to create linked AWS Global DynamoDB tables.
 *
 * @deprecated use `@aws-cdk/aws-dynamodb.Table.replicationRegions` instead
 */
class GlobalTable extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Creates dynamoDB tables across regions that will be able to be globbed together into a global table
         */
        this._regionalTables = new Array();
        cdk.Annotations.of(this).addWarning('The @aws-cdk/aws-dynamodb-global module has been deprecated in favor of @aws-cdk/aws-dynamodb.Table.replicationRegions');
        this._regionalTables = [];
        if (props.stream != null && props.stream !== dynamodb.StreamViewType.NEW_AND_OLD_IMAGES) {
            throw new Error('dynamoProps.stream MUST be set to dynamodb.StreamViewType.NEW_AND_OLD_IMAGES');
        }
        // need to set this stream specification, otherwise global tables don't work
        // And no way to set a default value in an interface
        const regionalTableProps = {
            ...props,
            removalPolicy: props.removalPolicy,
            stream: dynamodb.StreamViewType.NEW_AND_OLD_IMAGES,
        };
        this.lambdaGlobalTableCoordinator = new global_table_coordinator_1.GlobalTableCoordinator(scope, id + '-CustomResource', props);
        const scopeStack = cdk.Stack.of(scope);
        // here we loop through the configured regions.
        // in each region we'll deploy a separate stack with a DynamoDB Table with identical properties in the individual stacks
        for (const region of props.regions) {
            const regionalStack = new cdk.Stack(this, id + '-' + region, { env: { region, account: scopeStack.account } });
            const regionalTable = new dynamodb.Table(regionalStack, `${id}-GlobalTable-${region}`, regionalTableProps);
            this._regionalTables.push(regionalTable);
            // deploy the regional stack before the Lambda coordinator stack
            this.lambdaGlobalTableCoordinator.addDependency(regionalStack);
        }
    }
    /**
     * Obtain tables deployed in other each region
     */
    get regionalTables() {
        return this._regionalTables.map(x => x);
    }
}
exports.GlobalTable = GlobalTable;
//# sourceMappingURL=data:application/json;base64,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