import { ConcreteWidget } from './widget';
/**
 * Properties for a Text widget
 */
export interface TextWidgetProps {
    /**
     * The text to display, in MarkDown format
     */
    readonly markdown: string;
    /**
     * Width of the widget, in a grid of 24 units wide
     *
     * @default 6
     */
    readonly width?: number;
    /**
     * Height of the widget
     *
     * @default 2
     */
    readonly height?: number;
}
/**
 * A dashboard widget that displays MarkDown
 */
export declare class TextWidget extends ConcreteWidget {
    private readonly markdown;
    constructor(props: TextWidgetProps);
    position(x: number, y: number): void;
    toJson(): any[];
}
