# -*- coding: utf-8 -*-
# Generated by Django 2.1.5 on 2019-08-23 09:19

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Account',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=63, unique=True, verbose_name='帐号名称')),
                ('apikey', models.CharField(max_length=63, unique=True, verbose_name='APIKEY')),
            ],
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mobile', models.CharField(max_length=14, verbose_name='手机号')),
                ('status', models.CharField(choices=[('发送成功', '发送成功')], max_length=7, verbose_name='状态')),
                ('params', models.TextField(default='{}', help_text='用json.dumps后的参数', verbose_name='短信参数')),
                ('time', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='Sign',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=31, verbose_name='签名内容')),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_yunpian.Account')),
            ],
        ),
        migrations.CreateModel(
            name='Template',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False, unique=True)),
                ('_type', models.CharField(choices=[('验证码类', '验证码类'), ('通知类', '通知类'), ('会员营销类', '会员营销类')], max_length=5, verbose_name='短信类型')),
                ('content', models.TextField(verbose_name='模板内容')),
                ('sign', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_yunpian.Sign')),
            ],
        ),
        migrations.AddField(
            model_name='message',
            name='template',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_yunpian.Template'),
        ),
    ]
