from typing import Any, Dict, Sequence, Type, overload

class AbstractRepository(object):

    model: Type[Any]

    def create(self, **attrs) -> Any: ...
    def merge(self, instance: Any, **attrs) -> Any: ...
    def has_pk(self, instance: Any) -> bool: ...
    def get_pk(self, instance: Any) -> Dict[str, Any] | Any: ...
    async def count(self, *where, **attrs) -> int: ...
    async def update(self, *where, values: Dict[str, Any], **attrs) -> None: ...
    async def delete(self, *where, **attrs) -> None: ...
    async def find(self, *where, **attrs) -> Sequence[Any]: ...
    async def find_one(self, *where, **attrs) -> Any | None: ...
    async def find_one_or_fail(self, *where, **attrs) -> Any: ...
    @overload
    async def remove(self, instance: Any) -> None: ...
    @overload
    async def remove(self, instances: Sequence[Any]) -> None: ...
    @overload
    async def pre_save(self, instance: Any) -> Any: ...
    @overload
    async def pre_save(self, instances: Sequence[Any]) -> Sequence[Any]: ...
    @overload
    async def save(self, instance: Any) -> Any: ...
    @overload
    async def save(self, instances: Sequence[Any]) -> Sequence[Any]: ...
