# SpringLabs-Django

[![N|Solid](https://media-exp1.licdn.com/dms/image/C510BAQFwuqeqniHBZA/company-logo_200_200/0?e=2159024400&v=beta&t=6NzQE2q0ajsrE0Sqk3wwduccebQ1GltG4_6FCIeVUrY)](https://springlabs.ai)

Springlabs-Django is a CLI Application to manage Django projects with a defined structure to springlabs.
  - Create version
  - Create group
  - Create api
    - Model
    - Open
  - Create graph
    - Model
    - Open

> Primero resuelve el problema,
> despues escribe el código.  — John Johnson

## Tech

Springlabs-Django uses a number of open source projects to work properly:
* [Django] - high-level Python Web framework
* [DjangoRestFramework] - powerful and flexible toolkit for building Web APIs.
* [Graphene-Django] - provides some additional abstractions that make it easy to add GraphQL functionality to your Django project

## Installation

Springlabs-Django requires [Python](https://www.python.org/downloads/release/python-3611/) v3.6+ to run.

Install and update using [pip](https://pip.pypa.io/en/stable/quickstart/).

```sh
$ pip install -U springlabs-django
```
Install latest version
```sh
$ pip install springlabs-django
```
Install specific version
```sh
$ pip install springlabs-django==[version]
```
## Usage
### Helpers
After install the library
Open your favorite Terminal and run these commands.

Help:
```sh
$ springlabs_django --help
```
Console output
~~~
Usage: springlabs_django [OPTIONS] COMMAND [ARGS]...

  Springlabs Django Manager.

Options:
  --version  Show the version and exit.
  --help     Show this message and exit.

Commands:
  create-api      Create a new api for django project
  create-graph    Create a new graph for django project
  create-group    Create a new group for django project
  create-version  Create a new version for django project
~~~
Version:
```sh
$ springlabs_django --version
```
Console output
~~~
Springlabs Django Manager, v[version]
~~~
Create Version Help:
```sh
$ springlabs_django create-version --help
```
Console output
~~~
Usage: springlabs_django create-version [OPTIONS]

  Create a new version for django project

Options:
  -ve, --version TEXT  New version for the application
  --help               Show this message and exit.
~~~
Create Group Help:
```sh
$ springlabs_django create-group --help
```
Console output
~~~
Usage: springlabs_django create-group [OPTIONS]

  Create a new group for django project

Options:
  -ve, --version [1]  Version to which the group will be added
  -gr, --group TEXT   New group for the application
  --help              Show this message and exit.
~~~
Create API Help:
```sh
$ springlabs_django create-api --help
```
Console output
~~~
Usage: springlabs_django create-api [OPTIONS]

  Create a new api for django project

Options:
  -ve, --version [1]              Version to use
  -g, --group [options]           Group to use
  -n, --name TEXT                 API name
  -http, --http_verb [POST|PUT|DELETE]
                                  HTTP verb to use in the api  [default: POST]
  -t, --type_api [model|open]     API type  [default: open]
  -u, --url TEXT                  API url
  -a, --availability [public|private]
                                  API availability  [default: public]
  --help                          Show this message and exit.
~~~
Create GraphQL Help:
```sh
$ springlabs_django create-graph --help
```
Console output
~~~
Usage: springlabs_django create-graph [OPTIONS]

  Create a new graph for django project

Options:
  -ve, --version [1]             Version to use
  -g, --group [options]          Group to use
  -n, --name TEXT                GraphQL name
  -t, --type_graph [model|open]  Graph type  [default: open]
  --help                         Show this message and exit
~~~

### Create Version
**Create version with interactive CLI**
```sh
$ springlabs_django create-version
```
Console output
~~~
Insert the version number: 4
Version '4' was created successfully
~~~
**Create version shortcut**
To create a version simple shortcut use the options --flag send the value after flag
Example:
```sh
$ springlabs_django create-version --version 2
```
Console output
~~~
Version '2' was created successfully
~~~
Alternative use -flag instead of --flag send the value after flag
Example:
```sh
$ springlabs_django create-version -ve 2
```
Console output
~~~
Version '2' was created successfully
~~~

### Create Group
**Create group with interactive CLI**
```sh
$ springlabs_django create-group
```
Console output
~~~
Insert version (1, 2, 3, 4): 4
Insert group name: groupname
Group 'groupname' was created successfully
~~~
**Create group shortcut**
To create a group simple shortcut use the options --flag send the value after flag
Example:
```sh
$ springlabs_django create-group --version 4 --group groupname
```
Console output
~~~
Group 'groupname' was created successfully
~~~
Alternative use -flag instead of --flag send the value after flag
Example:
```sh
$ springlabs_django create-group -ve 2 -gr groupname
```
Console output
~~~
Group 'groupname' was created successfully
~~~

### Create API
**Create API with interactive CLI**
```sh
$ springlabs_django create-api
```
Console output
~~~
Insert version (1, 2, 3, 4): 4
Insert group (users, groupname): groupname
Insert api name: apiname
Insert http verb (POST, PUT, DELETE) [POST]: POST
Insert api type (model, open) [open]: open
Insert api url: apiname/parameter
Insert api availability (public, private) [public]: public
The api 'apiname' was created successfully
~~~
**Create API shortcut**
To create a API simple shortcut use the options --flag send the value after flag
Example:
```sh
$ springlabs_django create-api --version 4 --group groupname --name apiname --http_verb POST --type_api open --url apiname/parameter --availability public
```
Console output
~~~
The api 'apiname' was created successfully
~~~
Alternative use -flag instead of --flag send the value after flag
Example:
```sh
$ springlabs_django create-api -ve 4 -g groupname -n apiname -http POST -t open -u apiname/parameter -a public
```
Console output
~~~
The api 'apiname' was created successfully
~~~

### Create Graph
**Create Graph with interactive CLI**
```sh
$ springlabs_django create-graph
```
Console output
~~~
Insert version (1, 2, 3, 4): 4
Insert group (users, groupname): groupname
Insert graph name: graphname
Insert graph type (model, open) [open]: open
Graph 'graphname' was successfully created
~~~
**Create Graph shortcut**
To create a Graph simple shortcut use the options --flag send the value after flag
Example:
```sh
$ springlabs_django create-graph --version 4 --group groupname --name graphname --type_graph open
```
Console output
~~~
Graph 'graphname' was successfully created
~~~
Alternative use -flag instead of --flag send the value after flag
Example:
```sh
$ springlabs_django create-graph -ve 4 -g groupname -n graphname -t open
```
Console output
~~~
Graph 'graphname' was successfully created
~~~

## Commands
**springlabs_python**

| Command | Short |    Long   |
|:-------:|:-----:|:---------:|
|   Help  |       |   --help  |
| Version |       | --version |

**springlabs_python create-version**

|  Command  | Short |     Long    |
|:---------:|:-----:|:-----------:|
|    Help   |       |    --help   |
|  Version  |  -ve  |  --version  |

**springlabs_python create-group**

|  Command  | Short |     Long    |
|:---------:|:-----:|:-----------:|
|    Help   |       |  --help     |
|  Version  |  -ve  |  --version  |
|  Group    |  -gr  |  --group    |

**springlabs_python create-api**

|  Command  | Short |     Long    |
|:---------:|:-----:|:-----------:|
|    Help   |       |    --help   |
|  Version  |  -ve  |  --version  |
|  Group    |  -g   |  --group    |
|  Name     |  -n   |  --name     |
|  HTTP Verb| -http |  --http_verb|
|  Type API |  -t   |  --type_api |
|  URL      |  -u   |  --url      |
| Availability  |-a |  --availability |

**springlabs_python create-graph**

|  Command  | Short |     Long    |
|:---------:|:-----:|:-----------:|
|    Help   |       |    --help   |
|  Version  |  -ve  |  --version  |
|  Group    |  -g   |  --group    |
|  Name     |  -n   |  --name     |
|  Type Graph |  -t |  --type_graph |


# Links
- Website https://springlabs.ai/
- Code https://gitlab.com/AlejandroBarcenas/springlabs-django-cli
- Releases https://pypi.org/project/springlabs-django/#history

License
----
MIT

[//]: # (These are reference links used in the body of this note and get stripped out when the markdown processor does its job. There is no need to format nicely because it shouldn't be seen. Thanks SO - http://stackoverflow.com/questions/4823468/store-comments-in-markdown-syntax)
   [Django]: <https://www.djangoproject.com/>
   [DjangoRestFramework]: <https://www.django-rest-framework.org/>
   [Graphene-Django]: <https://docs.graphene-python.org/projects/django/en/latest/>
   [Python]: <https://www.python.org/downloads/release/python-3611/>
