"""

PCB442 Data as numpy array dictionary

"""

"""


Parse the .tsp file in TSPLIB format,
if other instances need to be parsed in same format.


re_node_line = re.compile("(\d+) ([0-9]*\.?[0-9]+)([eE][-+]?[0-9]+)? ([0-9]*\.?[0-9]+)([eE][-+]?[0-9]+)?")
nodes_dict = {}
pcb442_path = DATA_PATH + 'pcb442.tsp'


with open(pcb442_path) as f:
	for line in f:
		result = re_node_line.match(line)
		if result:
			node_id = int(result.group(1))
			
			x_coord = float(result.group(2) + result.group(3))
			y_coord = float(result.group(4) + result.group(5))

			nodes_dict[ node_id ] = (x_coord, y_coord)

nodes_count = max(nodes_dict.keys())
nodes = np.zeros( (nodes_count,2) )

for k in nodes_dict:
	nodes[k-1] = np.array( nodes_dict[k] )

"""

import numpy as np

nodes_count = 442

pcb442_nodes = np.array([[ 200.,  400.],
	[ 200.,  500.],
	[ 200.,  600.],
	[ 200.,  700.],
	[ 200.,  800.],
	[ 200.,  900.],
	[ 200., 1000.],
	[ 200., 1100.],
	[ 200., 1200.],
	[ 200., 1300.],
	[ 200., 1400.],
	[ 200., 1500.],
	[ 200., 1600.],
	[ 200., 1700.],
	[ 200., 1800.],
	[ 200., 1900.],
	[ 200., 2000.],
	[ 200., 2100.],
	[ 200., 2200.],
	[ 200., 2300.],
	[ 200., 2400.],
	[ 200., 2500.],
	[ 200., 2600.],
	[ 200., 2700.],
	[ 200., 2800.],
	[ 200., 2900.],
	[ 200., 3000.],
	[ 200., 3100.],
	[ 200., 3200.],
	[ 200., 3300.],
	[ 200., 3400.],
	[ 200., 3500.],
	[ 200., 3600.],
	[ 300.,  400.],
	[ 300.,  500.],
	[ 300.,  600.],
	[ 300.,  700.],
	[ 300.,  800.],
	[ 300.,  900.],
	[ 300., 1000.],
	[ 300., 1100.],
	[ 300., 1200.],
	[ 300., 1300.],
	[ 300., 1400.],
	[ 300., 1500.],
	[ 300., 1600.],
	[ 300., 1700.],
	[ 300., 1800.],
	[ 300., 1900.],
	[ 300., 2000.],
	[ 300., 2100.],
	[ 300., 2200.],
	[ 300., 2300.],
	[ 300., 2400.],
	[ 300., 2500.],
	[ 300., 2600.],
	[ 300., 2700.],
	[ 300., 2800.],
	[ 300., 2900.],
	[ 300., 3000.],
	[ 300., 3100.],
	[ 300., 3200.],
	[ 300., 3300.],
	[ 300., 3400.],
	[ 300., 3500.],
	[ 400.,  400.],
	[ 400.,  500.],
	[ 400.,  600.],
	[ 400.,  700.],
	[ 400.,  800.],
	[ 400.,  900.],
	[ 400., 1000.],
	[ 400., 1100.],
	[ 400., 1200.],
	[ 400., 1300.],
	[ 400., 1400.],
	[ 400., 1500.],
	[ 400., 1600.],
	[ 400., 1700.],
	[ 400., 1800.],
	[ 400., 1900.],
	[ 400., 2000.],
	[ 400., 2100.],
	[ 400., 2200.],
	[ 400., 2300.],
	[ 400., 2400.],
	[ 400., 2500.],
	[ 400., 2600.],
	[ 400., 2700.],
	[ 400., 2800.],
	[ 400., 2900.],
	[ 400., 3000.],
	[ 400., 3100.],
	[ 400., 3200.],
	[ 400., 3300.],
	[ 400., 3400.],
	[ 400., 3500.],
	[ 400., 3600.],
	[ 500., 1500.],
	[ 500., 1829.],
	[ 500., 3100.],
	[ 600.,  400.],
	[ 700.,  300.],
	[ 700.,  600.],
	[ 700., 1500.],
	[ 700., 1600.],
	[ 700., 1800.],
	[ 700., 2100.],
	[ 700., 2400.],
	[ 700., 2700.],
	[ 700., 3000.],
	[ 700., 3300.],
	[ 700., 3600.],
	[ 800.,  300.],
	[ 800.,  600.],
	[ 800., 1030.],
	[ 800., 1500.],
	[ 800., 1800.],
	[ 800., 2100.],
	[ 800., 2400.],
	[ 800., 2600.],
	[ 800., 2700.],
	[ 800., 3000.],
	[ 800., 3300.],
	[ 800., 3600.],
	[ 900.,  300.],
	[ 900.,  600.],
	[ 900., 1500.],
	[ 900., 1800.],
	[ 900., 2100.],
	[ 900., 2400.],
	[ 900., 2700.],
	[ 900., 3000.],
	[ 900., 3300.],
	[ 900., 3600.],
	[1000.,  300.],
	[1000.,  600.],
	[1000., 1100.],
	[1000., 1500.],
	[1000., 1629.],
	[1000., 1800.],
	[1000., 2100.],
	[1000., 2400.],
	[1000., 2600.],
	[1000., 2700.],
	[1000., 3000.],
	[1000., 3300.],
	[1000., 3600.],
	[1100.,  300.],
	[1100.,  600.],
	[1100.,  700.],
	[1100.,  900.],
	[1100., 1500.],
	[1100., 1800.],
	[1100., 2100.],
	[1100., 2400.],
	[1100., 2700.],
	[1100., 3000.],
	[1100., 3300.],
	[1100., 3600.],
	[1200.,  300.],
	[1200.,  600.],
	[1200., 1500.],
	[1200., 1700.],
	[1200., 1800.],
	[1200., 2100.],
	[1200., 2400.],
	[1200., 2700.],
	[1200., 3000.],
	[1200., 3300.],
	[1200., 3600.],
	[1300.,  300.],
	[1300.,  600.],
	[1300.,  700.],
	[1300., 1130.],
	[1300., 1500.],
	[1300., 1800.],
	[1300., 2100.],
	[1300., 2200.],
	[1300., 2400.],
	[1300., 2700.],
	[1300., 3000.],
	[1300., 3300.],
	[1300., 3600.],
	[1400.,  300.],
	[1400.,  600.],
	[1400.,  930.],
	[1400., 1500.],
	[1400., 1800.],
	[1400., 2000.],
	[1400., 2100.],
	[1400., 2400.],
	[1400., 2500.],
	[1400., 2700.],
	[1400., 2820.],
	[1400., 2900.],
	[1400., 3000.],
	[1400., 3300.],
	[1400., 3600.],
	[1500., 1500.],
	[1500., 1800.],
	[1500., 1900.],
	[1500., 2100.],
	[1500., 2400.],
	[1500., 2700.],
	[1500., 2800.],
	[1500., 2860.],
	[1500., 3000.],
	[1500., 3300.],
	[1500., 3600.],
	[1600., 1100.],
	[1600., 1300.],
	[1600., 1500.],
	[1600., 1800.],
	[1600., 2100.],
	[1600., 2400.],
	[1600., 2700.],
	[1600., 3000.],
	[1600., 3300.],
	[1600., 3600.],
	[1700., 1200.],
	[1700., 1500.],
	[1700., 1800.],
	[1700., 2100.],
	[1700., 2400.],
	[1700., 3600.],
	[1800.,  300.],
	[1800.,  600.],
	[1800., 1230.],
	[1800., 1500.],
	[1800., 1800.],
	[1800., 2100.],
	[1800., 2400.],
	[1900.,  300.],
	[1900.,  600.],
	[1900., 3000.],
	[1900., 3520.],
	[2000.,  300.],
	[2000.,  370.],
	[2000.,  600.],
	[2000.,  800.],
	[2000.,  900.],
	[2000., 1000.],
	[2000., 1100.],
	[2000., 1200.],
	[2000., 1300.],
	[2000., 1400.],
	[2000., 1500.],
	[2000., 1600.],
	[2000., 1700.],
	[2000., 1800.],
	[2000., 1900.],
	[2000., 2000.],
	[2000., 2100.],
	[2000., 2200.],
	[2000., 2300.],
	[2000., 2400.],
	[2000., 2500.],
	[2000., 2600.],
	[2000., 2700.],
	[2000., 2800.],
	[2000., 2900.],
	[2000., 3000.],
	[2000., 3100.],
	[2000., 3500.],
	[2100.,  300.],
	[2100.,  600.],
	[2100., 3200.],
	[2200.,  300.],
	[2200.,  469.],
	[2200.,  600.],
	[2200., 3200.],
	[2300.,  300.],
	[2300.,  600.],
	[2300., 3400.],
	[2400.,  300.],
	[2400.,  600.],
	[2400., 2100.],
	[2500.,  300.],
	[2500.,  800.],
	[2600.,  400.],
	[2600.,  500.],
	[2600.,  800.],
	[2600.,  900.],
	[2600., 1000.],
	[2600., 1100.],
	[2600., 1200.],
	[2600., 1300.],
	[2600., 1400.],
	[2600., 1500.],
	[2600., 1600.],
	[2600., 1700.],
	[2600., 1800.],
	[2600., 1900.],
	[2600., 2000.],
	[2600., 2100.],
	[2600., 2200.],
	[2600., 2300.],
	[2600., 2400.],
	[2600., 2500.],
	[2600., 2600.],
	[2600., 2700.],
	[2600., 2800.],
	[2600., 2900.],
	[2600., 3000.],
	[2600., 3100.],
	[2600., 3400.],
	[2700.,  700.],
	[2700.,  800.],
	[2700.,  900.],
	[2700., 1000.],
	[2700., 1100.],
	[2700., 1200.],
	[2700., 1300.],
	[2700., 1400.],
	[2700., 1500.],
	[2700., 1600.],
	[2700., 1700.],
	[2700., 1800.],
	[2700., 1900.],
	[2700., 2000.],
	[2700., 2100.],
	[2700., 2200.],
	[2700., 2300.],
	[2700., 2500.],
	[2700., 2600.],
	[2700., 2700.],
	[2700., 2800.],
	[2700., 2900.],
	[2700., 3000.],
	[2700., 3100.],
	[2700., 3200.],
	[2700., 3300.],
	[2700., 3400.],
	[2700., 3500.],
	[2700., 3600.],
	[2700., 3700.],
	[2700., 3800.],
	[2800.,  900.],
	[2800., 1130.],
	[2900.,  400.],
	[2900.,  500.],
	[2900., 1400.],
	[2900., 2400.],
	[2900., 3000.],
	[3000.,  700.],
	[3000.,  800.],
	[3000.,  900.],
	[3000., 1000.],
	[3000., 1100.],
	[3000., 1200.],
	[3000., 1300.],
	[3000., 1500.],
	[3000., 1600.],
	[3000., 1700.],
	[3000., 1800.],
	[3000., 1900.],
	[3000., 2000.],
	[3000., 2100.],
	[3000., 2200.],
	[3000., 2300.],
	[3000., 2500.],
	[3000., 2600.],
	[3000., 2700.],
	[3000., 2800.],
	[3000., 2900.],
	[3000., 3000.],
	[3000., 3100.],
	[3000., 3200.],
	[3000., 3300.],
	[3000., 3400.],
	[3000., 3500.],
	[3000., 3600.],
	[3000., 3700.],
	[3000., 3800.],
	[ 150., 3500.],
	[ 150., 3550.],
	[ 469., 2550.],
	[ 469., 3350.],
	[ 469., 3450.],
	[ 540., 2330.],
	[ 540., 2430.],
	[ 620., 3650.],
	[ 620., 3709.],
	[ 750., 2550.],
	[ 850.,  520.],
	[ 850.,  700.],
	[ 850., 2280.],
	[ 939.,  740.],
	[ 950., 2220.],
	[ 910., 2600.],
	[1050., 1050.],
	[1150., 1350.],
	[1170., 2280.],
	[1220., 2210.],
	[1350.,  750.],
	[1350., 1700.],
	[1350., 2140.],
	[1450.,  770.],
	[1550.,  300.],
	[1550.,  500.],
	[1550., 1850.],
	[1650., 1050.],
	[1690., 2680.],
	[1710.,  310.],
	[1710.,  510.],
	[1750.,  750.],
	[1790., 2580.],
	[1720., 2610.],
	[1790., 3330.],
	[1720., 3409.],
	[1829., 2700.],
	[1829., 2800.],
	[1829., 3450.],
	[2060., 1650.],
	[2050., 3150.],
	[2170., 1900.],
	[2110., 2000.],
	[2120., 2750.],
	[2150., 3250.],
	[2290., 1400.],
	[2220., 2820.],
	[2280., 3250.],
	[2390., 1300.],
	[2320., 1500.],
	[2450.,  710.],
	[2620., 3650.],
	[2750.,  520.],
	[2760., 2360.],
	[2850., 2200.],
	[2850., 2700.],
	[2850., 3350.],
	[2930.,  950.],
	[2950., 1750.],
	[2950., 2050.],
	[ 520., 3200.],
	[2300., 3500.],
	[2320., 3150.],
	[ 530., 2100.],
	[2550.,  710.],
	[ 750.,  490.],
	[   0.,    0.]])