/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.utils.graph;

import codeintelligence.codeanalysis.utils.graph.AbstractPropertyGraph;
import codeintelligence.codeanalysis.utils.graph.Digraph;
import codeintelligence.codeanalysis.utils.graph.Edge;
import codeintelligence.codeanalysis.utils.graph.Graph;
import codeintelligence.codeanalysis.utils.graph.UndiGraph;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class GraphReader {
    public static List<Graph<String, String>> readDotDataset(String dirPath) throws IOException {
        File dir = new File(dirPath);
        if (!dir.exists()) {
            throw new IllegalArgumentException("Path not found!");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Path is not a directory!");
        }
        ArrayList<Graph<String, String>> graphDataset = new ArrayList<Graph<String, String>>(dir.list().length);
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(".dot")) continue;
            graphDataset.add(GraphReader.readDOT(file.getPath()));
        }
        return graphDataset;
    }

    public static Graph<String, String> readDOT(String filePath) throws IOException {
        if (!filePath.toLowerCase().endsWith(".dot")) {
            throw new IllegalArgumentException("File-path does not end with .dot suffix!");
        }
        try (BufferedReader dot = new BufferedReader(new FileReader(filePath));){
            int end;
            int start;
            String[] tokens;
            String line = dot.readLine().trim();
            AbstractPropertyGraph graph = line.startsWith("digraph") ? new Digraph() : new UndiGraph();
            while (!(line = dot.readLine()).trim().equals("// graph-vertices")) {
            }
            LinkedHashMap<String, String> vertexMap = new LinkedHashMap<String, String>();
            while (!(line = dot.readLine()).trim().equals("// graph-edges")) {
                line = line.trim();
                tokens = line.split("\\s+");
                start = line.indexOf("[label=\"") + 8;
                end = line.lastIndexOf("\"];");
                String vertex = line.substring(start, end);
                vertexMap.put(tokens[0], vertex);
                graph.addVertex((String)vertex);
            }
            while (!(line = dot.readLine()).trim().equals("// end-of-graph")) {
                tokens = (line = line.trim()).split("\\s+");
                if (tokens.length > 3) {
                    start = line.indexOf("[label=\"") + 8;
                    end = line.lastIndexOf("\"];");
                    String label = line.substring(start, end);
                    graph.addEdge(new Edge(vertexMap.get(tokens[0]), label, vertexMap.get(tokens[2])));
                    continue;
                }
                tokens[2] = tokens[2].substring(0, tokens[2].length() - 1);
                graph.addEdge(new Edge(vertexMap.get(tokens[0]), null, vertexMap.get(tokens[2])));
            }
            Digraph<String, String> digraph = graph;
            return digraph;
        }
    }

    public static <V, E> Graph<V, E> readJSON(String filePath) {
        throw new UnsupportedOperationException("Reading Graphs from JSON is NOT Implemented Yet!");
    }
}

