/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.extractors.dependence.pdg;

import codeintelligence.codeanalysis.extractors.dependence.DEPEdge;
import codeintelligence.codeanalysis.extractors.dependence.DEPNode;
import codeintelligence.codeanalysis.extractors.dependence.pdg.ProgramDependenceGraph;
import codeintelligence.codeanalysis.utils.graph.Edge;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class CFPathTraversal
implements Iterator {
    private final DEPNode start;
    private final ProgramDependenceGraph pdg;
    private final Deque<Edge<DEPNode, DEPEdge>> paths;
    private DEPNode current;
    private boolean continueNextPath;
    private Edge<DEPNode, DEPEdge> nextEdge;

    public CFPathTraversal(ProgramDependenceGraph pdg, DEPNode startNode) {
        this.pdg = pdg;
        this.start = startNode;
        this.paths = new ArrayDeque<Edge<DEPNode, DEPEdge>>();
        this.continueNextPath = false;
        this.current = null;
        this.nextEdge = null;
    }

    private DEPNode start() {
        this.nextEdge = null;
        this.current = this.start;
        return this.current;
    }

    @Override
    public boolean hasNext() {
        return this.current == null || !this.paths.isEmpty() || this.pdg.outCtrlEdges(this.current).size() > 0 && !this.continueNextPath;
    }

    public DEPNode next() {
        if (this.current == null) {
            return this.start();
        }
        if (!this.continueNextPath) {
            for (Edge<DEPNode, DEPEdge> out : this.pdg.outCtrlEdges(this.current)) {
                this.paths.push(out);
            }
        }
        this.continueNextPath = false;
        if (this.paths.isEmpty()) {
            return null;
        }
        this.nextEdge = this.paths.pop();
        this.current = (DEPNode)this.nextEdge.target;
        return this.current;
    }

    public void continueNextPath() {
        this.continueNextPath = true;
    }
}

