# coding: utf-8

"""
    Signadot API

    API for Signadot Sandboxes  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from signadot_sdk.api_client import ApiClient


class SandboxesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_new_sandbox(self, org_name, data, **kwargs):  # noqa: E501
        """Create a new sandbox  # noqa: E501

        Creates a new sandbox with the provided parameters  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_new_sandbox(org_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param CreateSandboxRequest data: Request to create sandbox (required)
        :return: CreateSandboxResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_new_sandbox_with_http_info(org_name, data, **kwargs)  # noqa: E501
        else:
            (data) = self.create_new_sandbox_with_http_info(org_name, data, **kwargs)  # noqa: E501
            return data

    def create_new_sandbox_with_http_info(self, org_name, data, **kwargs):  # noqa: E501
        """Create a new sandbox  # noqa: E501

        Creates a new sandbox with the provided parameters  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_new_sandbox_with_http_info(org_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param CreateSandboxRequest data: Request to create sandbox (required)
        :return: CreateSandboxResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_new_sandbox" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_name' is set
        if self.api_client.client_side_validation and ('org_name' not in params or
                                                       params['org_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org_name` when calling `create_new_sandbox`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in params or
                                                       params['data'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `data` when calling `create_new_sandbox`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_name' in params:
            path_params['orgName'] = params['org_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgName}/sandboxes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateSandboxResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_sandbox_by_id(self, org_name, sandbox_id, **kwargs):  # noqa: E501
        """Delete a Sandbox by ID  # noqa: E501

        Delete the sandbox when its ID is specified  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sandbox_by_id(org_name, sandbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str sandbox_id: Sandbox ID (required)
        :param bool force: force
        :return: HandlerEmptyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_sandbox_by_id_with_http_info(org_name, sandbox_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_sandbox_by_id_with_http_info(org_name, sandbox_id, **kwargs)  # noqa: E501
            return data

    def delete_sandbox_by_id_with_http_info(self, org_name, sandbox_id, **kwargs):  # noqa: E501
        """Delete a Sandbox by ID  # noqa: E501

        Delete the sandbox when its ID is specified  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sandbox_by_id_with_http_info(org_name, sandbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str sandbox_id: Sandbox ID (required)
        :param bool force: force
        :return: HandlerEmptyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_name', 'sandbox_id', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sandbox_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_name' is set
        if self.api_client.client_side_validation and ('org_name' not in params or
                                                       params['org_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org_name` when calling `delete_sandbox_by_id`")  # noqa: E501
        # verify the required parameter 'sandbox_id' is set
        if self.api_client.client_side_validation and ('sandbox_id' not in params or
                                                       params['sandbox_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `sandbox_id` when calling `delete_sandbox_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_name' in params:
            path_params['orgName'] = params['org_name']  # noqa: E501
        if 'sandbox_id' in params:
            path_params['sandboxID'] = params['sandbox_id']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgName}/sandboxes/{sandboxID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HandlerEmptyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_sandbox_by_name(self, org_name, name, **kwargs):  # noqa: E501
        """Delete Sandbox By Name  # noqa: E501

        Delete Sandbox with given name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sandbox_by_name(org_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str name: Sandbox Name to search for (required)
        :param bool force: force
        :return: HandlerEmptyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_sandbox_by_name_with_http_info(org_name, name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_sandbox_by_name_with_http_info(org_name, name, **kwargs)  # noqa: E501
            return data

    def delete_sandbox_by_name_with_http_info(self, org_name, name, **kwargs):  # noqa: E501
        """Delete Sandbox By Name  # noqa: E501

        Delete Sandbox with given name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sandbox_by_name_with_http_info(org_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str name: Sandbox Name to search for (required)
        :param bool force: force
        :return: HandlerEmptyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_name', 'name', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sandbox_by_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_name' is set
        if self.api_client.client_side_validation and ('org_name' not in params or
                                                       params['org_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org_name` when calling `delete_sandbox_by_name`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `delete_sandbox_by_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_name' in params:
            path_params['orgName'] = params['org_name']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgName}/sandboxes/by-name/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HandlerEmptyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sandbox_by_id(self, org_name, sandbox_id, **kwargs):  # noqa: E501
        """Get a Sandbox by ID  # noqa: E501

        Fetch the details about a sandbox when its ID is specified  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sandbox_by_id(org_name, sandbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str sandbox_id: Sandbox ID (required)
        :return: GetSandboxByIdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sandbox_by_id_with_http_info(org_name, sandbox_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sandbox_by_id_with_http_info(org_name, sandbox_id, **kwargs)  # noqa: E501
            return data

    def get_sandbox_by_id_with_http_info(self, org_name, sandbox_id, **kwargs):  # noqa: E501
        """Get a Sandbox by ID  # noqa: E501

        Fetch the details about a sandbox when its ID is specified  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sandbox_by_id_with_http_info(org_name, sandbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str sandbox_id: Sandbox ID (required)
        :return: GetSandboxByIdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_name', 'sandbox_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sandbox_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_name' is set
        if self.api_client.client_side_validation and ('org_name' not in params or
                                                       params['org_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org_name` when calling `get_sandbox_by_id`")  # noqa: E501
        # verify the required parameter 'sandbox_id' is set
        if self.api_client.client_side_validation and ('sandbox_id' not in params or
                                                       params['sandbox_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `sandbox_id` when calling `get_sandbox_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_name' in params:
            path_params['orgName'] = params['org_name']  # noqa: E501
        if 'sandbox_id' in params:
            path_params['sandboxID'] = params['sandbox_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgName}/sandboxes/{sandboxID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSandboxByIdResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sandbox_ready(self, org_name, sandbox_id, **kwargs):  # noqa: E501
        """Check sandbox readiness  # noqa: E501

        Checks readiness of a sandbox with rate limiting enforced by polling.  Deprecated, please use getSandboxStatusById instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sandbox_ready(org_name, sandbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str sandbox_id: Sandbox ID (required)
        :return: SandboxReadyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sandbox_ready_with_http_info(org_name, sandbox_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sandbox_ready_with_http_info(org_name, sandbox_id, **kwargs)  # noqa: E501
            return data

    def get_sandbox_ready_with_http_info(self, org_name, sandbox_id, **kwargs):  # noqa: E501
        """Check sandbox readiness  # noqa: E501

        Checks readiness of a sandbox with rate limiting enforced by polling.  Deprecated, please use getSandboxStatusById instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sandbox_ready_with_http_info(org_name, sandbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str sandbox_id: Sandbox ID (required)
        :return: SandboxReadyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_name', 'sandbox_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sandbox_ready" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_name' is set
        if self.api_client.client_side_validation and ('org_name' not in params or
                                                       params['org_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org_name` when calling `get_sandbox_ready`")  # noqa: E501
        # verify the required parameter 'sandbox_id' is set
        if self.api_client.client_side_validation and ('sandbox_id' not in params or
                                                       params['sandbox_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `sandbox_id` when calling `get_sandbox_ready`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_name' in params:
            path_params['orgName'] = params['org_name']  # noqa: E501
        if 'sandbox_id' in params:
            path_params['sandboxID'] = params['sandbox_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgName}/sandboxes/{sandboxID}/ready', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SandboxReadyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sandbox_status_by_id(self, org_name, sandbox_id, **kwargs):  # noqa: E501
        """Get Sandbox Status by Sandbox ID with rate limiting.  # noqa: E501

        Gets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sandbox_status_by_id(org_name, sandbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str sandbox_id: Sandbox ID (required)
        :return: SandboxStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sandbox_status_by_id_with_http_info(org_name, sandbox_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sandbox_status_by_id_with_http_info(org_name, sandbox_id, **kwargs)  # noqa: E501
            return data

    def get_sandbox_status_by_id_with_http_info(self, org_name, sandbox_id, **kwargs):  # noqa: E501
        """Get Sandbox Status by Sandbox ID with rate limiting.  # noqa: E501

        Gets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sandbox_status_by_id_with_http_info(org_name, sandbox_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str sandbox_id: Sandbox ID (required)
        :return: SandboxStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_name', 'sandbox_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sandbox_status_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_name' is set
        if self.api_client.client_side_validation and ('org_name' not in params or
                                                       params['org_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org_name` when calling `get_sandbox_status_by_id`")  # noqa: E501
        # verify the required parameter 'sandbox_id' is set
        if self.api_client.client_side_validation and ('sandbox_id' not in params or
                                                       params['sandbox_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `sandbox_id` when calling `get_sandbox_status_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_name' in params:
            path_params['orgName'] = params['org_name']  # noqa: E501
        if 'sandbox_id' in params:
            path_params['sandboxID'] = params['sandbox_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgName}/sandboxes/{sandboxID}/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SandboxStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sandboxes(self, org_name, **kwargs):  # noqa: E501
        """List Sandboxes  # noqa: E501

        List all sandboxes under the specified Signadot org.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sandboxes(org_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :return: GetSandboxesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sandboxes_with_http_info(org_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sandboxes_with_http_info(org_name, **kwargs)  # noqa: E501
            return data

    def get_sandboxes_with_http_info(self, org_name, **kwargs):  # noqa: E501
        """List Sandboxes  # noqa: E501

        List all sandboxes under the specified Signadot org.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sandboxes_with_http_info(org_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :return: GetSandboxesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sandboxes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_name' is set
        if self.api_client.client_side_validation and ('org_name' not in params or
                                                       params['org_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org_name` when calling `get_sandboxes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_name' in params:
            path_params['orgName'] = params['org_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgName}/sandboxes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSandboxesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upsert_pr_workspace(self, github_org, github_repo, pr_number, data, **kwargs):  # noqa: E501
        """Create or Update workspace from Pull Request  # noqa: E501

        Create a workspace that is associated with a specified pull request. If no workspaces already exist for the given pull request, this creates a new workspace. Otherwise, the new changes are applied to the existing workspaces. This endpoint uses the old terminology \"workspace\" instead of \"sandbox\" for backward compatability. ### Example  Here's an example to create/update a workspace from a pull request in the [HotROD](https://github.com/signadot/hotrod) application. To simplify the use case, consider that only the [Route Service](https://github.com/signadot/hotrod/tree/main/services/route) had changes, and that the changes were published to an image file named `signadot/hotrod-route` and tag `4e75b0b822ecbbbb4c917b0fffeb337589d82456`. This could be tagged as anything e.g. `latest`, `e2e-test` etc.  As a part of workspace creation, Signadot creates forked Kubernetes workloads (such as deployments) from existing workloads using the provided images. In order to access the forked workloads(s), `endpoints` are specified and corresponding to each endpoint, a preview URL is generated. These preview URLs are returned as part of the response. In the example below, we're dealing with a deployment named `route` in the `hotrod` namespace that is running the docker image `signadot/hotrod-route`.  In the below request to create a workspace, the deployment named `route` is forked and the fork will be created with the new docker image tag as specified by `newTag`. The new deployment that is created will be running the a new docker image tag as specified by `newTag`. There will be a single preview URL associated with this workspace as specified in `endpoints` and it will point to the fork of the `route` deployment that was created.  ```json {   \"cluster\": \"signadot\",   \"namespace\": \"hotrod\",   \"headCommit\": \"5e35abfa94626c4853eca51ecd435a779ded4123\",   \"images\": [     {       \"name\": \"signadot/hotrod-route\",       \"newTag\": \"4e75b0b822ecbbbb4c917b0fffeb337589d82456\"     }   ],   \"endpoints\": [     {       \"routeType\": \"fork\",       \"protocol\": \"http\",       \"forkOf\": {         \"kind\": \"Deployment\",         \"name\": \"route\",         \"namespace\": \"hotrod\"       }     }   ] } ```  In response the API call returns us a confirmation of the workspace created / updated along with the information on preview endpoints.  ```json {   \"workspaceIDs\": [     \"xtc54uh8p2rhs\"   ],   \"previewEndpoints\": [     {       \"id\": \"fbm4983sxb111\",       \"routeType\": \"fork\",       \"name\": \"route\",       \"protocol\": \"http\",       \"clusterID\": \"55rjfjf3rn222\",       \"cluster\": \"signadot\",       \"forkOf\": {         \"kind\": \"Deployment\",         \"namespace\": \"hotrod\",         \"name\": \"route\"       },       \"previewURL\": \"https://route--hotrod-131.preview.signadot.com\"     }   ] }  ```  You can parse the `previewEndpoints` section in the response to find the previewURL associated with the endpoint created as part of the workspace.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsert_pr_workspace(github_org, github_repo, pr_number, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str github_org: GitHub Org Name (required)
        :param str github_repo: GitHub Repository Name (required)
        :param int pr_number: Pull Request Number (required)
        :param UpsertPRWorkspacesRequest data: Request to upsert workspace (required)
        :return: UpsertWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upsert_pr_workspace_with_http_info(github_org, github_repo, pr_number, data, **kwargs)  # noqa: E501
        else:
            (data) = self.upsert_pr_workspace_with_http_info(github_org, github_repo, pr_number, data, **kwargs)  # noqa: E501
            return data

    def upsert_pr_workspace_with_http_info(self, github_org, github_repo, pr_number, data, **kwargs):  # noqa: E501
        """Create or Update workspace from Pull Request  # noqa: E501

        Create a workspace that is associated with a specified pull request. If no workspaces already exist for the given pull request, this creates a new workspace. Otherwise, the new changes are applied to the existing workspaces. This endpoint uses the old terminology \"workspace\" instead of \"sandbox\" for backward compatability. ### Example  Here's an example to create/update a workspace from a pull request in the [HotROD](https://github.com/signadot/hotrod) application. To simplify the use case, consider that only the [Route Service](https://github.com/signadot/hotrod/tree/main/services/route) had changes, and that the changes were published to an image file named `signadot/hotrod-route` and tag `4e75b0b822ecbbbb4c917b0fffeb337589d82456`. This could be tagged as anything e.g. `latest`, `e2e-test` etc.  As a part of workspace creation, Signadot creates forked Kubernetes workloads (such as deployments) from existing workloads using the provided images. In order to access the forked workloads(s), `endpoints` are specified and corresponding to each endpoint, a preview URL is generated. These preview URLs are returned as part of the response. In the example below, we're dealing with a deployment named `route` in the `hotrod` namespace that is running the docker image `signadot/hotrod-route`.  In the below request to create a workspace, the deployment named `route` is forked and the fork will be created with the new docker image tag as specified by `newTag`. The new deployment that is created will be running the a new docker image tag as specified by `newTag`. There will be a single preview URL associated with this workspace as specified in `endpoints` and it will point to the fork of the `route` deployment that was created.  ```json {   \"cluster\": \"signadot\",   \"namespace\": \"hotrod\",   \"headCommit\": \"5e35abfa94626c4853eca51ecd435a779ded4123\",   \"images\": [     {       \"name\": \"signadot/hotrod-route\",       \"newTag\": \"4e75b0b822ecbbbb4c917b0fffeb337589d82456\"     }   ],   \"endpoints\": [     {       \"routeType\": \"fork\",       \"protocol\": \"http\",       \"forkOf\": {         \"kind\": \"Deployment\",         \"name\": \"route\",         \"namespace\": \"hotrod\"       }     }   ] } ```  In response the API call returns us a confirmation of the workspace created / updated along with the information on preview endpoints.  ```json {   \"workspaceIDs\": [     \"xtc54uh8p2rhs\"   ],   \"previewEndpoints\": [     {       \"id\": \"fbm4983sxb111\",       \"routeType\": \"fork\",       \"name\": \"route\",       \"protocol\": \"http\",       \"clusterID\": \"55rjfjf3rn222\",       \"cluster\": \"signadot\",       \"forkOf\": {         \"kind\": \"Deployment\",         \"namespace\": \"hotrod\",         \"name\": \"route\"       },       \"previewURL\": \"https://route--hotrod-131.preview.signadot.com\"     }   ] }  ```  You can parse the `previewEndpoints` section in the response to find the previewURL associated with the endpoint created as part of the workspace.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsert_pr_workspace_with_http_info(github_org, github_repo, pr_number, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str github_org: GitHub Org Name (required)
        :param str github_repo: GitHub Repository Name (required)
        :param int pr_number: Pull Request Number (required)
        :param UpsertPRWorkspacesRequest data: Request to upsert workspace (required)
        :return: UpsertWorkspaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['github_org', 'github_repo', 'pr_number', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_pr_workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'github_org' is set
        if self.api_client.client_side_validation and ('github_org' not in params or
                                                       params['github_org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `github_org` when calling `upsert_pr_workspace`")  # noqa: E501
        # verify the required parameter 'github_repo' is set
        if self.api_client.client_side_validation and ('github_repo' not in params or
                                                       params['github_repo'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `github_repo` when calling `upsert_pr_workspace`")  # noqa: E501
        # verify the required parameter 'pr_number' is set
        if self.api_client.client_side_validation and ('pr_number' not in params or
                                                       params['pr_number'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `pr_number` when calling `upsert_pr_workspace`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in params or
                                                       params['data'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `data` when calling `upsert_pr_workspace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'github_org' in params:
            path_params['githubOrg'] = params['github_org']  # noqa: E501
        if 'github_repo' in params:
            path_params['githubRepo'] = params['github_repo']  # noqa: E501
        if 'pr_number' in params:
            path_params['prNumber'] = params['pr_number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{githubOrg}/{githubRepo}/pulls/{prNumber}/workspaces', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpsertWorkspaceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
