# Generated by Django 3.0.6 on 2020-06-01 01:31

import address.models
from django.db import migrations, models
import django.db.models.deletion
import phonenumber_field.modelfields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('address', '0002_auto_20160213_1726'),
    ]

    operations = [
        migrations.CreateModel(
            name='BusinessFormModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prime_number', models.UUIDField(default=uuid.uuid4, editable=False, help_text='prime number is unique code for any master data', verbose_name='prime number')),
                ('code', models.CharField(blank=True, default='', help_text='Law-abiding master data code', max_length=100, null=True, verbose_name='code')),
                ('name', models.CharField(default=None, help_text='Humanized name of master data', max_length=100, verbose_name='name')),
            ],
            options={
                'verbose_name': 'business form',
                'verbose_name_plural': 'business forms',
            },
        ),
        migrations.CreateModel(
            name='DependenceLegitimacyModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prime_number', models.UUIDField(default=uuid.uuid4, editable=False, help_text='prime number is unique code for any master data', verbose_name='prime number')),
                ('code', models.CharField(blank=True, default='', help_text='Law-abiding master data code', max_length=100, null=True, verbose_name='code')),
                ('name', models.CharField(default=None, help_text='Humanized name of master data', max_length=100, verbose_name='name')),
            ],
            options={
                'verbose_name': 'dependence legitimacy',
                'verbose_name_plural': 'dependence legitimacies',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DependenceQualityModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prime_number', models.UUIDField(default=uuid.uuid4, editable=False, help_text='prime number is unique code for any master data', verbose_name='prime number')),
                ('code', models.CharField(blank=True, default='', help_text='Law-abiding master data code', max_length=100, null=True, verbose_name='code')),
                ('name', models.CharField(default=None, help_text='Humanized name of master data', max_length=100, verbose_name='name')),
            ],
            options={
                'verbose_name': 'dependence quality',
                'verbose_name_plural': 'dependence qualities',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EnvironmentalClassificationModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prime_number', models.UUIDField(default=uuid.uuid4, editable=False, help_text='prime number is unique code for any master data', verbose_name='prime number')),
                ('code', models.CharField(blank=True, default='', help_text='Law-abiding master data code', max_length=100, null=True, verbose_name='code')),
                ('name', models.CharField(default=None, help_text='Humanized name of master data', max_length=100, verbose_name='name')),
            ],
            options={
                'verbose_name': 'Environmental Classification',
                'verbose_name_plural': 'Environmental Classifications',
            },
        ),
        migrations.CreateModel(
            name='IndependentActivityDeclarationCostModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prime_number', models.UUIDField(default=uuid.uuid4, editable=False, help_text='prime number is unique code for any master data', verbose_name='prime number')),
                ('code', models.CharField(blank=True, default='', help_text='Law-abiding master data code', max_length=100, null=True, verbose_name='code')),
                ('name', models.CharField(default=None, help_text='Humanized name of master data', max_length=100, verbose_name='name')),
            ],
            options={
                'verbose_name': 'independent-actvitiy declaration cost',
                'verbose_name_plural': 'independent-actvitiy declaration costs',
            },
        ),
        migrations.CreateModel(
            name='InsuranceSuspensionModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prime_number', models.UUIDField(default=uuid.uuid4, editable=False, help_text='prime number is unique code for any master data', verbose_name='prime number')),
                ('code', models.CharField(blank=True, default='', help_text='Law-abiding master data code', max_length=100, null=True, verbose_name='code')),
                ('name', models.CharField(default=None, help_text='Humanized name of master data', max_length=100, verbose_name='name')),
            ],
            options={
                'verbose_name': 'Insurance suspension',
                'verbose_name_plural': 'Insurance suspensions',
            },
        ),
        migrations.CreateModel(
            name='LegalTypeModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prime_number', models.UUIDField(default=uuid.uuid4, editable=False, help_text='prime number is unique code for any master data', verbose_name='prime number')),
                ('code', models.CharField(blank=True, default='', help_text='Law-abiding master data code', max_length=100, null=True, verbose_name='code')),
                ('name', models.CharField(default=None, help_text='Humanized name of master data', max_length=100, verbose_name='name')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SubAccount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('bank_account_number', models.CharField(help_text='Please provide bank account number.', max_length=24, verbose_name='bank account number')),
            ],
            options={
                'verbose_name': 'sub account',
            },
        ),
        migrations.CreateModel(
            name='PersonModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prime_number', models.UUIDField(default=uuid.uuid4, editable=False, help_text='prime number is unique code for any master data', verbose_name='prime number')),
                ('code', models.CharField(blank=True, default='', help_text='Law-abiding master data code', max_length=100, null=True, verbose_name='code')),
                ('name', models.CharField(default=None, help_text='Humanized name of master data', max_length=100, verbose_name='name')),
                ('name_prefix', models.CharField(blank=True, choices=[('junior', 'Junior'), ('senior', 'Senior'), ('doctor', 'Doctor'), ('professor', 'Professor'), ('widow', 'Widow')], default=None, max_length=10, null=True, verbose_name='name prefix')),
                ('first_name', models.CharField(max_length=100, verbose_name='first name')),
                ('middle_name', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='middle name')),
                ('last_name', models.CharField(max_length=100, verbose_name='last name')),
                ('name_suffix', models.CharField(blank=True, default=None, max_length=10, null=True, verbose_name='name suffix')),
                ('birthdate', models.DateField(verbose_name='birth date')),
                ('birthplace', models.CharField(max_length=200, verbose_name='birth place')),
                ('name_of_mother', models.CharField(default=None, max_length=200, verbose_name='name of mother')),
                ('tax_number', models.CharField(max_length=100, verbose_name='tax number')),
                ('primary', models.CharField(max_length=100, verbose_name='nationality')),
                ('inland_resident', models.BooleanField(default=True, help_text='Has inland address.', verbose_name='has inland residence')),
                ('gender', models.CharField(blank=True, choices=[('female', 'Female'), ('male', 'Male')], default=None, max_length=10, null=True, verbose_name='gender')),
                ('phone_number', phonenumber_field.modelfields.PhoneNumberField(help_text='Phone number, desc.', max_length=128, region=None, verbose_name='phone number')),
                ('email', models.EmailField(help_text='Primary email address', max_length=254, verbose_name='email')),
                ('permanent_address', address.models.AddressField(help_text='Permanent address, desc.', on_delete=django.db.models.deletion.CASCADE, related_name='permanent_residents', to='address.Address', verbose_name='permanent address')),
                ('temporary_address', address.models.AddressField(blank=True, default=None, help_text='temporary address, desc.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='termorary_residents', to='address.Address', verbose_name='temporary address')),
            ],
            options={
                'verbose_name': 'person',
                'verbose_name_plural': 'people',
            },
        ),
        migrations.CreateModel(
            name='OrganizationModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prime_number', models.UUIDField(default=uuid.uuid4, editable=False, help_text='prime number is unique code for any master data', verbose_name='prime number')),
                ('code', models.CharField(blank=True, default='', help_text='Law-abiding master data code', max_length=100, null=True, verbose_name='code')),
                ('name', models.CharField(default=None, help_text='Humanized name of master data', max_length=100, verbose_name='name')),
                ('registration_number', models.CharField(max_length=500, verbose_name='registration_number')),
                ('business_form', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='organizations', to='corgy_mdm.BusinessFormModel', verbose_name='business_form')),
            ],
            options={
                'verbose_name': 'organization',
                'verbose_name_plural': 'organizations',
            },
        ),
    ]
