"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const kong_core_1 = require("kong-core");
const index_1 = require("./resources/helm-charts/kong/index");
/**
 * @summary The KongEks class.
 */
class KongEks extends constructs_1.Construct {
    //   public readonly rdsCluster: rds.DatabaseInstance;
    //   public readonly eksCluster: eks.Cluster;
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        //TODO : Modularize this further
        const kong_namespace = 'kong-dp';
        const data_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'DPSecretsKey');
        // const data_plane_secretskey = new kms.Key(this, 'DataPlaneSecretsKey');
        // const artifactoryBucket = new s3.Bucket(this, 'ArtifactoryBucket');
        const data_plane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'DP', {
            ...props.dataPlaneClusterProps,
            secretsEncryptionKey: data_plane_secretskey,
            defaultCapacity: 0,
        });
        const dp_nodegroup = data_plane.addNodegroupCapacity('DpASG', props.dataPlaneNodeProps);
        new kong_core_1.AutoScalar(this, 'AutoScalar', {
            cluster: data_plane,
            nodegroup: dp_nodegroup,
            namespace: 'kube-system',
        });
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: data_plane,
        //   nodegroup: dp_nodegroup,
        // });
        // TODO : Make a new construct class for all helm charts
        new kong_core_1.MetricsServer(this, 'MetricsServer', {
            cluster: data_plane,
        });
        new kong_core_1.Telemetry(this, 'KongLogging', {
            cluster: data_plane,
            namespace: 'telemetry',
        });
        new kong_core_1.ElastiCacheStack(this, 'KongCache', {
            numberofnodegroups: 3,
            vpc: data_plane.vpc,
        });
        new kong_core_1.SecretsManager(this, 'KongSMProvider', {
            cluster: data_plane,
            nodegroup: dp_nodegroup,
            namespace: kong_namespace,
        });
        new kong_core_1.CertManager(this, 'KongPCA', {
            cluster: data_plane,
            nodegroup: dp_nodegroup,
            namespace: kong_namespace,
            privateCaArn: props.privateCaArn,
            cacertname: 'kong-dp-ca-cert',
            clusterIssuerName: 'kong-dp-cluster-issuer',
            // commonname: 'www.dummy.com',
            hostedZoneName: 'kong-dp.internal',
            dnsNames: [
                'kong-dp.internal',
                'admin.kong-cp.internal',
                'cluster.kong-cp.internal',
                'telemetry.kong-cp.internal',
                'manager.kong-cp.internal',
            ],
        });
        new index_1.KongDataPlane(this, 'KongCPHelmInstall', {
            cluster: data_plane,
            namespace: kong_namespace,
            cluster_dns: props.clusterDns,
            telemetry_dns: props.telemetryDns,
            nodegroup: dp_nodegroup,
            license_secret_name: props.licenseSecretsName,
        });
    }
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-data-plane.KongEks", version: "2.0.2" };
//# sourceMappingURL=data:application/json;base64,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