# pip-licenses-reader

The pip-licenses-reader provides a simple reader for JSON files generated by [pip-licenses](https://pypi.org/project/pip-licenses/). 

## Setting up the data

Create a file called `bill_of_materials.json` using the following command:

```shell
  pip-licenses --format=json --output-file=bill_of_materials.json --with-authors --with-urls
```

and place it next to your start-up script.

**NOTE**: If you use another file name or location, the file path must set at run-time.

## Usage

```pyhton
from pip_licenses_reader import read_file

license_collection = read_file()
```

The resulting element will be read-only. It provides a value called `projects`, which is iterable. For each item, the following properties are set:

- author
- name
- url
- version (as `packaging.version.Version` from `setuptools` or `packaging`)
- license

Hence, the data can be considered as bill of materials for your project, if it was created from a virtual env.

If you used another file path or name, this can be passed as the first argument called `file`.

Errors will be logged using the a regular `Logger` from pythons `logging` module.

## License

This project is licensed under the BSD-3-Clause license.
