# Generated by Django 2.0.5 on 2018-05-29 09:15

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    replaces = [
        ("djasana", "0001_squashed_0001_initial"),
        ("djasana", "0002_alter_name_max_len_etc"),
        ("djasana", "0003_project_allows_blank"),
        ("djasana", "0004_adds_synctoken"),
        ("djasana", "0005_adds_webhook"),
        ("djasana", "0006_adds_defaults"),
        ("djasana", "0007_alter_task_completed"),
        ("djasana", "0008_adds_task_blank_null"),
        ("djasana", "0009_default_ordering"),
        ("djasana", "0010_short_webhook_secret"),
        ("djasana", "0011_modifies_choices"),
        ("djasana", "0012_project_team_allows_null"),
        ("djasana", "0013_adds_on_delete"),
        ("djasana", "0014_user_email_allows_null"),
        ("djasana", "0015_adds_task_start_on"),
    ]

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Attachment",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "remote_id",
                    models.BigIntegerField(
                        db_index=True,
                        help_text="The id of this object in Asana.",
                        unique=True,
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="name")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("download_url", models.URLField()),
                ("host", models.CharField(choices=[("asana", "asana")], max_length=24)),
                ("permanent_url", models.URLField()),
                ("view_url", models.URLField()),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Project",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "remote_id",
                    models.BigIntegerField(
                        db_index=True,
                        help_text="The id of this object in Asana.",
                        unique=True,
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="name")),
                ("archived", models.BooleanField()),
                ("color", models.CharField(max_length=16, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "current_status",
                    models.CharField(
                        choices=[
                            ("inbox", "inbox"),
                            ("upcoming", "upcoming"),
                            ("later", "later"),
                        ],
                        max_length=16,
                        null=True,
                    ),
                ),
                ("due_date", models.DateField(null=True)),
                ("layout", models.CharField(choices=[("list", "list")], max_length=16)),
                ("modified_at", models.DateTimeField()),
                ("notes", models.TextField()),
                ("public", models.BooleanField()),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Story",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "remote_id",
                    models.BigIntegerField(
                        db_index=True,
                        help_text="The id of this object in Asana.",
                        unique=True,
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="name")),
                ("hearted", models.BooleanField(default=False)),
                ("num_hearts", models.SmallIntegerField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("target", models.BigIntegerField(db_index=True)),
                ("source", models.CharField(choices=[("web", "web")], max_length=16)),
                ("text", models.CharField(max_length=50)),
                (
                    "type",
                    models.CharField(
                        choices=[("comment", "comment"), ("system", "system")],
                        max_length=16,
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "stories",
            },
        ),
        migrations.CreateModel(
            name="Tag",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "remote_id",
                    models.BigIntegerField(
                        db_index=True,
                        help_text="The id of this object in Asana.",
                        unique=True,
                    ),
                ),
                ("name", models.CharField(max_length=1024, verbose_name="name")),
            ],
            options={
                "abstract": False,
                "ordering": ("name",),
            },
        ),
        migrations.CreateModel(
            name="Task",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "remote_id",
                    models.BigIntegerField(
                        db_index=True,
                        help_text="The id of this object in Asana.",
                        unique=True,
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="name")),
                ("hearted", models.BooleanField(default=False)),
                ("num_hearts", models.SmallIntegerField()),
                (
                    "assignee_status",
                    models.CharField(choices=[("inbox", "inbox")], max_length=16),
                ),
                ("completed", models.BooleanField()),
                ("completed_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("due_at", models.DateTimeField(null=True)),
                ("due_on", models.DateField(null=True)),
                ("modified_at", models.DateTimeField()),
                ("notes", models.TextField()),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Team",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "remote_id",
                    models.BigIntegerField(
                        db_index=True,
                        help_text="The id of this object in Asana.",
                        unique=True,
                    ),
                ),
                ("name", models.CharField(max_length=1024, verbose_name="name")),
                ("organization_id", models.BigIntegerField(null=True)),
                ("organization_name", models.CharField(max_length=50)),
            ],
            options={
                "abstract": False,
                "ordering": ("name",),
            },
        ),
        migrations.CreateModel(
            name="User",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "remote_id",
                    models.BigIntegerField(
                        db_index=True,
                        help_text="The id of this object in Asana.",
                        unique=True,
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="name")),
                (
                    "email",
                    models.EmailField(
                        blank=True, max_length=254, verbose_name="email address"
                    ),
                ),
                (
                    "photo",
                    models.CharField(max_length=255, null=True, verbose_name="photo"),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Workspace",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "remote_id",
                    models.BigIntegerField(
                        db_index=True,
                        help_text="The id of this object in Asana.",
                        unique=True,
                    ),
                ),
                ("name", models.CharField(max_length=1024, verbose_name="name")),
                ("is_organization", models.BooleanField(default=True)),
            ],
            options={
                "abstract": False,
                "ordering": ("name",),
            },
        ),
        migrations.AddField(
            model_name="user",
            name="workspaces",
            field=models.ManyToManyField(to="djasana.Workspace"),
        ),
        migrations.AddField(
            model_name="task",
            name="assignee",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="assigned_tasks",
                to="djasana.User",
                to_field="remote_id",
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="followers",
            field=models.ManyToManyField(
                related_name="tasks_following", to="djasana.User"
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="hearts",
            field=models.ManyToManyField(
                related_name="task_hearted", to="djasana.User"
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="parent",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="djasana.Task",
                to_field="remote_id",
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="projects",
            field=models.ManyToManyField(to="djasana.Project"),
        ),
        migrations.AddField(
            model_name="task",
            name="tags",
            field=models.ManyToManyField(to="djasana.Tag"),
        ),
        migrations.AddField(
            model_name="story",
            name="created_by",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="djasana.User",
                to_field="remote_id",
            ),
        ),
        migrations.AddField(
            model_name="story",
            name="hearts",
            field=models.ManyToManyField(
                related_name="story_hearted", to="djasana.User"
            ),
        ),
        migrations.AddField(
            model_name="project",
            name="followers",
            field=models.ManyToManyField(
                blank=True, related_name="projects_following", to="djasana.User"
            ),
        ),
        migrations.AddField(
            model_name="project",
            name="members",
            field=models.ManyToManyField(blank=True, to="djasana.User"),
        ),
        migrations.AddField(
            model_name="project",
            name="owner",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="projects_owned",
                to="djasana.User",
                to_field="remote_id",
            ),
        ),
        migrations.AddField(
            model_name="project",
            name="team",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="djasana.Team",
                to_field="remote_id",
            ),
        ),
        migrations.AddField(
            model_name="project",
            name="workspace",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="djasana.Workspace",
                to_field="remote_id",
            ),
        ),
        migrations.AddField(
            model_name="attachment",
            name="parent",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="djasana.Task",
                to_field="remote_id",
            ),
        ),
        migrations.AlterField(
            model_name="attachment",
            name="download_url",
            field=models.URLField(max_length=1024),
        ),
        migrations.AlterField(
            model_name="attachment",
            name="name",
            field=models.CharField(max_length=1024, verbose_name="name"),
        ),
        migrations.AlterField(
            model_name="attachment",
            name="permanent_url",
            field=models.URLField(max_length=1024),
        ),
        migrations.AlterField(
            model_name="attachment",
            name="view_url",
            field=models.URLField(max_length=1024),
        ),
        migrations.AlterField(
            model_name="project",
            name="name",
            field=models.CharField(max_length=1024, verbose_name="name"),
        ),
        migrations.AlterField(
            model_name="story",
            name="name",
            field=models.CharField(max_length=1024, verbose_name="name"),
        ),
        migrations.AlterField(
            model_name="story",
            name="num_hearts",
            field=models.SmallIntegerField(default=0),
        ),
        migrations.AlterField(
            model_name="story",
            name="text",
            field=models.CharField(max_length=1024),
        ),
        migrations.AlterField(
            model_name="task",
            name="assignee_status",
            field=models.CharField(
                choices=[
                    ("inbox", "inbox"),
                    ("upcoming", "upcoming"),
                    ("later", "later"),
                ],
                max_length=16,
            ),
        ),
        migrations.AlterField(
            model_name="task",
            name="name",
            field=models.CharField(max_length=1024, verbose_name="name"),
        ),
        migrations.AlterField(
            model_name="task",
            name="num_hearts",
            field=models.SmallIntegerField(default=0),
        ),
        migrations.AlterField(
            model_name="user",
            name="name",
            field=models.CharField(max_length=1024, verbose_name="name"),
        ),
        migrations.AlterField(
            model_name="project",
            name="color",
            field=models.CharField(blank=True, max_length=16, null=True),
        ),
        migrations.AlterField(
            model_name="project",
            name="current_status",
            field=models.CharField(
                blank=True,
                choices=[
                    ("inbox", "inbox"),
                    ("upcoming", "upcoming"),
                    ("later", "later"),
                ],
                max_length=16,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="project",
            name="due_date",
            field=models.DateField(blank=True, null=True),
        ),
        migrations.CreateModel(
            name="SyncToken",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("sync", models.CharField(max_length=36)),
                (
                    "project",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djasana.Project",
                        to_field="remote_id",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Webhook",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "secret",
                    models.CharField(
                        max_length=64,
                        validators=[django.core.validators.MinValueValidator(32)],
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djasana.Project",
                        to_field="remote_id",
                    ),
                ),
            ],
        ),
        migrations.AlterField(
            model_name="project",
            name="archived",
            field=models.BooleanField(default=False),
        ),
        migrations.AlterField(
            model_name="project",
            name="modified_at",
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AlterField(
            model_name="project",
            name="public",
            field=models.BooleanField(default=False),
        ),
        migrations.AlterField(
            model_name="task",
            name="completed",
            field=models.BooleanField(default=False),
        ),
        migrations.AlterField(
            model_name="task",
            name="modified_at",
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AlterField(
            model_name="task",
            name="completed_at",
            field=models.DateTimeField(null=True),
        ),
        migrations.AlterField(
            model_name="task",
            name="completed_at",
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name="task",
            name="due_at",
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name="task",
            name="due_on",
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name="task",
            name="notes",
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AlterModelOptions(
            name="attachment",
            options={"ordering": ("name",)},
        ),
        migrations.AlterModelOptions(
            name="project",
            options={"ordering": ("name",)},
        ),
        migrations.AlterModelOptions(
            name="user",
            options={"ordering": ("name",)},
        ),
        migrations.AlterField(
            model_name="project",
            name="color",
            field=models.CharField(
                blank=True,
                choices=[
                    ("dark-pink", "dark-pink"),
                    ("dark-green", "dark-green"),
                    ("dark-blue", "dark-blue"),
                    ("dark-red", "dark-red"),
                    ("dark-teal", "dark-teal"),
                    ("dark-brown", "dark-brown"),
                    ("dark-orange", "dark-orange"),
                    ("dark-purple", "dark-purple"),
                    ("dark-warm-gray", "dark-warm-gray"),
                    ("light-pink", "light-pink"),
                    ("light-green", "light-green"),
                    ("light-blue", "light-blue"),
                    ("light-red", "light-red"),
                    ("light-teal", "light-teal"),
                    ("light-yellow", "light-yellow"),
                    ("light-orange", "light-orange"),
                    ("light-purple", "light-purple"),
                    ("light-warm-gray", "light-warm-gray"),
                ],
                max_length=16,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="project",
            name="layout",
            field=models.CharField(
                choices=[("board", "board"), ("list", "list")], max_length=16
            ),
        ),
        migrations.AlterField(
            model_name="project",
            name="team",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="djasana.Team",
                to_field="remote_id",
            ),
        ),
        migrations.AlterField(
            model_name="project",
            name="owner",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="projects_owned",
                to="djasana.User",
                to_field="remote_id",
            ),
        ),
        migrations.AlterField(
            model_name="project",
            name="team",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="djasana.Team",
                to_field="remote_id",
            ),
        ),
        migrations.AlterField(
            model_name="user",
            name="email",
            field=models.EmailField(
                blank=True, max_length=254, null=True, verbose_name="email address"
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="start_on",
            field=models.DateField(blank=True, null=True),
        ),
    ]
