# Generated by Django 3.2.15 on 2022-08-25 08:47

from django.db import migrations, models

import privates.fields
import privates.storages

import simple_certmanager.mixins


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Certificate",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "label",
                    models.CharField(
                        help_text="Recognisable label for the certificate",
                        max_length=100,
                        verbose_name="label",
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("key_pair", "Key-pair"),
                            ("cert_only", "Certificate only"),
                        ],
                        help_text=(
                            "Is this only a certificate or is there an "
                            "associated private key?"
                        ),
                        max_length=20,
                        verbose_name="type",
                    ),
                ),
                (
                    "public_certificate",
                    privates.fields.PrivateMediaFileField(
                        help_text="The content of the certificate",
                        storage=privates.storages.PrivateMediaFileSystemStorage(),
                        upload_to="ssl_certs_keys/%Y/%m/%d",
                        verbose_name="public certificate",
                    ),
                ),
                (
                    "private_key",
                    privates.fields.PrivateMediaFileField(
                        blank=True,
                        help_text="The content of the private key",
                        storage=privates.storages.PrivateMediaFileSystemStorage(),
                        upload_to="ssl_certs_keys/%Y/%m/%d",
                        verbose_name="private key",
                    ),
                ),
            ],
            options={
                "verbose_name": "certificate",
                "verbose_name_plural": "certificates",
            },
            bases=(simple_certmanager.mixins.DeleteFileFieldFilesMixin, models.Model),
        ),
    ]
