goog.module('grrUi.forms.autoGeneratedAes128KeyFormDirective');



/**
 * Generate hex-encoded byte sequence of a given length.
 *
 * @param {number} length Number of bytes to generate.
 * @return {string} Hex-encoded bytes sequence.
 */
exports.generateRandomBytes = function(length) {
  const tokens = '0123456789abcdef';
  const result = [];
  for (let i = 0; i < length * 2; ++i) {
    result.push(tokens[Math.floor(Math.random() * 16)]);
  }
  return result.join('');
};


/**
 * Controller for AutoGeneratedAES128KeyFormDirective.
 * @unrestricted
 */
const AutoGeneratedAES128KeyFormController = class {
  /**
   * @param {!angular.Scope} $scope
   * @ngInject
   */
  constructor($scope) {
    /** @private {!angular.Scope} */
    this.scope_ = $scope;

    this.scope_.$watch('value', this.onValueChange_.bind(this));
  }

  /**
   * Handles changes in the value binding.
   *
   * @param {Object} newValue New binding value.
   * @private
   */
  onValueChange_(newValue) {
    if (angular.isDefined(newValue) && !newValue['value']) {
      newValue['value'] = exports.generateRandomBytes(16);
    }
  }
};



/**
 * AutoGeneratedAES128KeyFormDirective renders a form corresponding to a given
 * RDFProtoStruct.
 *
 * @return {!angular.Directive} Directive definition object.
 */
exports.AutoGeneratedAES128KeyFormDirective = function() {
  return {
    scope: {value: '=', metadata: '=?', hiddenFields: '=?'},
    restrict: 'E',
    templateUrl: '/static/angular-components/forms/' +
        'auto-generated-aes128-key-form.html',
    controller: AutoGeneratedAES128KeyFormController,
    controllerAs: 'controller'
  };
};


/**
 * Name of the directive in Angular.
 *
 * @const
 * @export
 */
exports.AutoGeneratedAES128KeyFormDirective.directive_name =
    'grrFormAutoGeneratedAes128Key';


/**
 * Semantic type corresponding to this directive.
 *
 * @const
 * @export
 */
exports.AutoGeneratedAES128KeyFormDirective.semantic_type =
    'AutoGeneratedAES128Key';
