/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.sys;

import java.io.File;
import java.io.FileFilter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.Txn;
import org.apache.jena.tdb.StoreConnection;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.nodetable.NodeTable;
import org.apache.jena.tdb.sys.TDBMaker;
import org.apache.jena.tdb.transaction.DatasetGraphTransaction;
import org.apache.jena.tdb.transaction.TransactionManager;

public class TDBInternal {
    static FileFilter fileFilterNewDB = pathname -> {
        String fn = pathname.getName();
        if (fn.equals(".") || fn.equals("..")) {
            return false;
        }
        if (pathname.isDirectory()) {
            return true;
        }
        return !fn.equals("tdb.cfg");
    };

    public static boolean isTDB1(DatasetGraph dsg) {
        return dsg instanceof DatasetGraphTransaction;
    }

    public static NodeId getNodeId(Dataset ds, Node node) {
        return TDBInternal.getNodeId(ds.asDatasetGraph(), node);
    }

    public static NodeId getNodeId(DatasetGraph ds, Node node) {
        DatasetGraphTDB dsg = TDBInternal.getDatasetGraphTDB(ds);
        return TDBInternal.getNodeId(dsg, node);
    }

    public static NodeId getNodeId(DatasetGraphTDB dsg, Node node) {
        if (dsg == null) {
            return null;
        }
        NodeTable nodeTable = dsg.getQuadTable().getNodeTupleTable().getNodeTable();
        NodeId nodeId = nodeTable.getNodeIdForNode(node);
        return nodeId;
    }

    public static Node getNode(Dataset ds, NodeId nodeId) {
        return TDBInternal.getNode(ds.asDatasetGraph(), nodeId);
    }

    public static Node getNode(DatasetGraph ds, NodeId nodeId) {
        DatasetGraphTDB dsg = TDBInternal.getDatasetGraphTDB(ds);
        return TDBInternal.getNode(dsg, nodeId);
    }

    public static Node getNode(DatasetGraphTDB dsg, NodeId nodeId) {
        if (dsg == null) {
            return null;
        }
        NodeTable nodeTable = dsg.getQuadTable().getNodeTupleTable().getNodeTable();
        Node node = nodeTable.getNodeForNodeId(nodeId);
        return node;
    }

    public static DatasetGraphTDB getDatasetGraphTDB(Dataset ds) {
        return TDBInternal.getDatasetGraphTDB(ds.asDatasetGraph());
    }

    public static DatasetGraphTDB getDatasetGraphTDB(DatasetGraph dsg) {
        if (dsg instanceof DatasetGraphTransaction) {
            return ((DatasetGraphTransaction)dsg).getDatasetGraphToQuery();
        }
        if (dsg instanceof DatasetGraphTDB) {
            return (DatasetGraphTDB)dsg;
        }
        return null;
    }

    public static DatasetGraphTDB getBaseDatasetGraphTDB(DatasetGraph dsg) {
        return TDBInternal.getStoreConnection(dsg).getBaseDataset();
    }

    public static TransactionManager getTransactionManager(DatasetGraph dsg) {
        return TDBInternal.getStoreConnection(dsg).getTransactionManager();
    }

    public static StoreConnection getStoreConnection(DatasetGraph dsg) {
        if (dsg instanceof DatasetGraphTransaction) {
            return ((DatasetGraphTransaction)dsg).getStoreConnection();
        }
        throw new TDBException("Not a suitable TDB-backed DatasetGraph: " + Lib.classShortName(dsg.getClass()));
    }

    public static synchronized void expel(DatasetGraph dsg) {
        DatasetGraphTDB dsgtdb = (DatasetGraphTDB)((Object)Txn.calculate((Transactional)dsg, () -> TDBInternal.getDatasetGraphTDB(dsg)));
        if (dsgtdb == null) {
            return;
        }
        TDBInternal.expel(dsgtdb.getLocation());
    }

    public static synchronized void expel(Location location) {
        TDBInternal.expel(location, false);
    }

    public static synchronized void expel(Location location, boolean force) {
        TDBInternal.releaseDSG(location);
        StoreConnection.expel(location, force);
    }

    public static synchronized void releaseDSG(Location location) {
        TDBMaker.uncache(location);
    }

    public static boolean isNewDatabaseArea(Location location) {
        StoreConnection sConn = StoreConnection.getExisting(location);
        if (sConn != null) {
            return false;
        }
        if (location.isMem()) {
            return true;
        }
        File d = new File(location.getDirectoryPath());
        if (!d.exists()) {
            return true;
        }
        FileFilter ff = fileFilterNewDB;
        File[] entries = d.listFiles(ff);
        return entries.length == 0;
    }

    public static synchronized void reset() {
        StoreConnection.reset();
        TDBMaker.resetCache();
    }
}

