/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.transforms;

import com.github.owlcs.ontapi.jena.OntVocabulary;
import com.github.owlcs.ontapi.jena.UnionGraph;
import com.github.owlcs.ontapi.jena.utils.Graphs;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import com.github.owlcs.ontapi.transforms.TransformException;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.WrappedGraph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransformationModel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(TransformationModel.class);
    protected final Graph graph;
    protected final OntVocabulary builtins;
    protected final Model queryModel;
    protected final Model workModel;

    public TransformationModel(Graph graph) {
        this(graph, OntVocabulary.Factory.get());
    }

    public TransformationModel(Graph graph, OntVocabulary vocabulary) throws NullPointerException {
        this.builtins = Objects.requireNonNull(vocabulary, "Null builtins vocabulary.");
        this.graph = Objects.requireNonNull(graph, "Null graph.");
        if (graph instanceof UnionGraph) {
            UnionGraph u = (UnionGraph)graph;
            UnionGraph g = Graphs.withBase((Graph)new TrackedGraph(u.getBaseGraph()), u);
            this.queryModel = this.createModel(u.getBaseGraph());
            this.workModel = this.createModel((Graph)g);
        } else {
            this.queryModel = this.createModel(graph);
            this.workModel = this.createModel((Graph)new TrackedGraph(graph));
        }
    }

    public Stream<Triple> process() throws TransformException {
        if (this.test()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Process <%s> on <%s>", this.name(), Graphs.getName(this.getBaseGraph())));
            }
            this.perform();
        }
        return this.uncertainTriples();
    }

    public abstract void perform() throws TransformException;

    public boolean test() {
        return true;
    }

    public Stream<Triple> uncertainTriples() {
        return Stream.empty();
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    public Graph getGraph() {
        return this.graph;
    }

    protected Graph getBaseGraph() {
        return this.graph instanceof UnionGraph ? ((UnionGraph)this.graph).getBaseGraph() : this.graph;
    }

    protected Model getQueryModel() {
        return this.queryModel;
    }

    protected Model getWorkModel() {
        return this.workModel;
    }

    protected Model createModel(Graph graph) {
        return ModelFactory.createModelForGraph((Graph)Objects.requireNonNull(graph));
    }

    protected void changeType(Resource foundType, Resource newType) {
        this.listStatements(null, RDF.type, (RDFNode)foundType).toList().forEach(s -> this.undeclare(s.getSubject(), foundType).declare(s.getSubject(), newType));
    }

    protected TransformationModel declare(Resource subject, Resource type) {
        subject.addProperty(RDF.type, (RDFNode)Objects.requireNonNull(type, "Declare: null type for resource '" + subject + "'"));
        return this;
    }

    protected TransformationModel undeclare(Resource subject, Resource type) {
        this.getWorkModel().removeAll(subject, RDF.type, (RDFNode)Objects.requireNonNull(type, "Undeclare: null type for resource '" + subject + "'"));
        return this;
    }

    boolean containsType(Resource type) {
        return this.getQueryModel().contains(null, RDF.type, (RDFNode)type);
    }

    boolean hasType(Resource resource, Resource type) {
        return resource.hasProperty(RDF.type, (RDFNode)type);
    }

    boolean hasAnyPredicate(Resource resource, Collection<Property> predicates) {
        return predicates.stream().anyMatch(arg_0 -> ((Resource)resource).hasProperty(arg_0));
    }

    boolean hasAnyType(Resource resource, Collection<Resource> types) {
        return types.stream().anyMatch(t -> this.hasType(resource, (Resource)t));
    }

    protected final Stream<Statement> statements(Resource s, Property p, RDFNode o) {
        return Iter.asStream(this.listStatements(s, p, o));
    }

    protected ExtendedIterator<Statement> listStatements(Resource s, Property p, RDFNode o) {
        return this.queryModel.listStatements(s, p, o).mapWith(x -> this.workModel.asStatement(x.asTriple()));
    }

    public String toString() {
        return String.format("[%s:%s]", this.name(), Graphs.getName(this.getBaseGraph()));
    }

    public static class TrackedGraph
    extends WrappedGraph {
        public TrackedGraph(Graph base) {
            super(Objects.requireNonNull(base));
        }

        public void add(Triple t) {
            if (this.base.contains(t)) {
                return;
            }
            super.add(t);
        }

        public void delete(Triple t) {
            if (!this.base.contains(t)) {
                return;
            }
            super.delete(t);
        }
    }
}

