/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.transforms;

import com.github.owlcs.ontapi.jena.OntVocabulary;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.Models;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import com.github.owlcs.ontapi.jena.vocabulary.SWRL;
import com.github.owlcs.ontapi.transforms.TransformException;
import com.github.owlcs.ontapi.transforms.TransformationModel;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;

public class SWRLTransform
extends TransformationModel {
    protected Set<Statement> unparsed = new HashSet<Statement>();

    public SWRLTransform(Graph graph) {
        super(graph, OntVocabulary.Factory.get());
    }

    @Override
    public void perform() throws TransformException {
        this.fixAtomLists();
    }

    protected void fixAtomLists() {
        this.fixList(SWRL.body);
        this.fixList(SWRL.head);
    }

    protected void fixList(Property predicate) {
        Model m = this.getWorkModel();
        this.listStatements(null, predicate, null).toList().forEach(s -> {
            if (!s.getObject().isAnon()) {
                this.unparsed.add((Statement)s);
                return;
            }
            Resource o = s.getResource();
            if (this.isEmptyList((RDFNode)o)) {
                m.removeAll(o, null, null).remove(s).add(s.getSubject(), s.getPredicate(), (RDFNode)RDF.nil);
                return;
            }
            if (!o.canAs(RDFList.class)) {
                this.unparsed.add((Statement)s);
                return;
            }
            if (o.hasProperty(RDF.type, (RDFNode)SWRL.AtomList)) {
                return;
            }
            Iter.create(Models.getListStatements((RDFList)o.as(RDFList.class))).mapWith(Statement::getSubject).toSet().forEach(x -> this.declare((Resource)x, SWRL.AtomList));
        });
    }

    private boolean isEmptyList(RDFNode r) {
        return r.isAnon() && r.asResource().hasProperty(RDF.type, (RDFNode)SWRL.AtomList) && r.asResource().listProperties().toList().size() == 1;
    }

    @Override
    public boolean test() {
        return this.graph.contains(Node.ANY, RDF.type.asNode(), SWRL.Imp.asNode());
    }

    @Override
    public Stream<Triple> uncertainTriples() {
        return this.unparsed.stream().map(FrontsTriple::asTriple);
    }
}

