/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.transforms;

import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import com.github.owlcs.ontapi.transforms.BaseDeclarator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;

public class ReasonerDeclarator
extends BaseDeclarator {
    protected final int maxRerunCount;
    protected Strategy decider;
    protected final Map<Statement, Function<Statement, Res>> rerun;
    protected Set<Statement> unparsed = new HashSet<Statement>();

    public ReasonerDeclarator(Graph graph) {
        this(graph, DefaultStrategies.FIRST, 10);
    }

    public ReasonerDeclarator(Graph graph, Strategy decider, int count) {
        this(graph, new LinkedHashMap<Statement, Function<Statement, Res>>(), decider, count);
    }

    protected ReasonerDeclarator(Graph graph, Map<Statement, Function<Statement, Res>> rerun, Strategy decider, int count) {
        super(graph);
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        this.rerun = Objects.requireNonNull(rerun);
        this.decider = Objects.requireNonNull(decider);
        this.maxRerunCount = count;
    }

    protected void parse(Statement s, Function<Statement, Res> function) {
        Res res = function.apply(s);
        if (res != Res.UNKNOWN) {
            return;
        }
        this.rerun.put(s, function);
    }

    @Override
    public void perform() {
        try {
            this.parse();
            this.unparsed.addAll(this.parseTail());
        }
        finally {
            this.rerun.clear();
        }
    }

    protected void parse() {
        this.parseDataAndObjectRestrictions();
        this.parsePropertyDomains();
        this.parseRanges();
        this.parseEquivalentClasses();
        this.parseUnionAndIntersectionClassExpressions();
        this.parseEquivalentAndDisjointProperties();
        this.parseAllDisjointProperties();
        this.parseSubProperties();
        this.parsePropertyAssertions();
    }

    protected Set<Statement> parseTail() {
        LinkedHashMap<Object, Function<Object, Res>> prev = new LinkedHashMap<Statement, Function<Statement, Res>>(this.rerun);
        LinkedHashMap next = new LinkedHashMap();
        int count = 0;
        while (count++ < this.maxRerunCount) {
            for (Statement s : prev.keySet()) {
                Function func = (Function)prev.get(s);
                if (Res.UNKNOWN != func.apply(s)) continue;
                next.put(s, prev.get(s));
            }
            if (next.isEmpty()) {
                return Collections.emptySet();
            }
            if (next.size() == prev.size()) {
                this.decider = this.decider.next();
            }
            if (this.decider == null) break;
            prev = next;
            next = new LinkedHashMap();
        }
        LOGGER.warn("Ambiguous statements {}", next.keySet());
        return next.keySet();
    }

    @Override
    public Stream<Triple> uncertainTriples() {
        return this.unparsed.stream().map(FrontsTriple::asTriple);
    }

    protected void parseDataAndObjectRestrictions() {
        Iter.flatMap(Iter.of(new Property[]{OWL.allValuesFrom, OWL.someValuesFrom}), p -> this.listStatements(null, (Property)p, null)).forEachRemaining(s -> this.parse((Statement)s, this::testRestrictions));
    }

    protected Res testRestrictions(Statement statement) {
        Resource p = this.getObjectResource(statement.getSubject(), OWL.onProperty);
        Resource c = this.getObjectResource(statement.getSubject(), statement.getPredicate());
        if (p == null || c == null) {
            return Res.FALSE;
        }
        this.declare(statement.getSubject(), OWL.Restriction);
        if (this.isClassExpression(c) || this.isObjectPropertyExpression(p)) {
            this.declareObjectProperty(p);
            if (this.declareClass(c)) {
                return Res.TRUE;
            }
        }
        if (this.isDataRange(c) || this.isDataProperty(p)) {
            this.declareDataProperty(p).declareDatatype(c);
            return Res.TRUE;
        }
        if (this.decider.chooseClass()) {
            if (this.canBeClass(c)) {
                this.declareObjectProperty(p).declareClass(c);
            } else if (this.canBeDatatype(c)) {
                this.declareDataProperty(p).declareDatatype(c);
            } else {
                return Res.FALSE;
            }
            return Res.TRUE;
        }
        return Res.UNKNOWN;
    }

    protected void parsePropertyDomains() {
        this.listStatements(null, RDFS.domain, null).filterKeep(s -> s.getObject().isResource()).forEachRemaining(s -> this.parse((Statement)s, this::testDomains));
    }

    public Res testDomains(Statement statement) {
        Resource left = statement.getSubject();
        Resource right = statement.getResource();
        if (this.isAnnotationProperty(left) && right.isURIResource()) {
            return Res.TRUE;
        }
        if ((this.isDataProperty(left) || this.isObjectPropertyExpression(left)) && this.declareClass(right)) {
            return Res.TRUE;
        }
        if (right.isAnon()) {
            this.declareClass(right);
        }
        if (this.decider.chooseAnnotationProperty()) {
            this.declareAnnotationProperty(left);
            return Res.TRUE;
        }
        return Res.UNKNOWN;
    }

    protected void parseRanges() {
        this.listStatements(null, RDFS.range, null).filterKeep(s -> s.getObject().isResource()).forEachRemaining(s -> this.parse((Statement)s, this::testPropertyRanges));
    }

    protected Res testPropertyRanges(Statement statement) {
        Resource left = statement.getSubject();
        Resource right = statement.getObject().asResource();
        if (this.isAnnotationProperty(left) && right.isURIResource()) {
            return Res.TRUE;
        }
        if (this.isClassExpression(right)) {
            this.declareObjectProperty(left);
            return Res.TRUE;
        }
        if (this.isDataRange(right)) {
            this.declareDataProperty(left);
            return Res.TRUE;
        }
        if (this.decider.chooseAnnotationProperty()) {
            this.declareAnnotationProperty(left);
            return Res.TRUE;
        }
        return Res.UNKNOWN;
    }

    protected void parsePropertyAssertions() {
        final HashMap<Resource, Resource> add = new HashMap<Resource, Resource>();
        final HashMap<Resource, Resource> del = new HashMap<Resource, Resource>();
        final ReasonerDeclarator self = this;
        new ReasonerDeclarator(this.getGraph(), this.rerun, this.decider, this.maxRerunCount){

            @Override
            protected ReasonerDeclarator declare(Resource subject, Resource type) {
                add.put(subject, type);
                return this;
            }

            @Override
            protected ReasonerDeclarator undeclare(Resource subject, Resource type) {
                del.put(subject, type);
                return this;
            }

            private void parse(Statement s) {
                Res res = super.testPropertyAssertions(s);
                if (res != Res.UNKNOWN) {
                    return;
                }
                this.rerun.put(s, self::testPropertyAssertions);
            }

            @Override
            protected void parsePropertyAssertions() {
                this.listStatements(null, null, null).filterDrop(s -> this.builtins.getSystemProperties().contains(s.getPredicate())).forEachRemaining(this::parse);
            }
        }.parsePropertyAssertions();
        add.forEach(this::declare);
        del.forEach(this::undeclare);
    }

    protected Res testPropertyAssertions(Statement statement) {
        Resource subject = statement.getSubject();
        RDFNode right = statement.getObject();
        Property property = statement.getPredicate();
        if (this.isAnnotationProperty((Resource)property)) {
            return Res.TRUE;
        }
        if (right.isLiteral()) {
            this.declareDatatype(right.asNode().getLiteralDatatypeURI());
            if (this.isDataProperty((Resource)property)) {
                this.declareIndividual(subject);
                return Res.TRUE;
            }
            if (this.isIndividual(subject) && this.canBeDataPropertyInAssertion(property)) {
                this.declareDataProperty((Resource)property);
                return Res.TRUE;
            }
            if (this.mustBeDataOrObjectProperty((Resource)property)) {
                this.declareDataProperty((Resource)property).declareIndividual(subject);
                return Res.TRUE;
            }
            if (this.isClass(subject)) {
                this.declareIndividual(subject).declareAnnotationProperty((Resource)property);
                return Res.TRUE;
            }
        } else {
            Resource object = right.asResource();
            if (this.isIndividual(object) || this.canBeIndividual((RDFNode)object)) {
                if (this.isObjectPropertyExpression((Resource)property)) {
                    this.declareIndividual(subject).declareIndividual(object);
                    return Res.TRUE;
                }
                if (this.isIndividual(subject)) {
                    this.declareObjectProperty((Resource)property).declareIndividual(object);
                    return Res.TRUE;
                }
                if (this.mustBeDataOrObjectProperty((Resource)property)) {
                    this.declareObjectProperty((Resource)property).declareIndividual(subject).declareIndividual(object);
                    return Res.TRUE;
                }
            }
        }
        if (this.decider.chooseAnnotationProperty()) {
            this.declareAnnotationProperty((Resource)property);
            return Res.TRUE;
        }
        return Res.UNKNOWN;
    }

    protected boolean mustBeDataOrObjectProperty(Resource candidate) {
        if (candidate.hasProperty(RDF.type, (RDFNode)OWL.FunctionalProperty)) {
            return true;
        }
        ExtendedIterator lists = this.listStatements(null, OWL.hasKey, null).mapWith(Statement::getObject).filterKeep(o -> o.canAs(RDFList.class)).mapWith(o -> (RDFList)o.as(RDFList.class));
        return Iter.anyMatch(Iter.flatMap(lists, RDFList::iterator), arg_0 -> ((Resource)candidate).equals(arg_0));
    }

    protected boolean canBeIndividual(RDFNode candidate) {
        return candidate.isResource() && (candidate.isAnon() ? !candidate.canAs(RDFList.class) : !this.builtins.getSystemALL().contains(candidate.asResource()));
    }

    protected boolean canBeDataPropertyInAssertion(Property candidate) {
        return Iter.findFirst(this.listStatements(null, candidate, null).filterKeep(x -> x.getObject().isLiteral()).mapWith(Statement::getLiteral).filterDrop(s -> XSDDatatype.XSDstring.equals(s.getDatatype()))).isPresent();
    }

    protected boolean canBeClass(Resource resource) {
        return this.builtins.getBuiltinClasses().contains(resource) || !this.builtins.getBuiltinDatatypes().contains(resource);
    }

    protected boolean canBeDatatype(Resource resource) {
        return this.builtins.getBuiltinDatatypes().contains(resource) || !this.builtins.getBuiltinClasses().contains(resource);
    }

    protected void parseEquivalentClasses() {
        this.listStatements(null, OWL.equivalentClass, null).filterKeep(s -> s.getObject().isResource()).forEachRemaining(s -> this.parse((Statement)s, this::testEquivalentClasses));
    }

    protected Res testEquivalentClasses(Statement statement) {
        Resource b;
        Resource a = statement.getSubject();
        if (Iter.anyMatch(Iter.of(new Resource[]{a, b = statement.getObject().asResource()}), this::isClassExpression)) {
            this.declareClass(a);
            this.declareClass(b);
            return Res.TRUE;
        }
        if (a.isURIResource() && Iter.anyMatch(Iter.of(new Resource[]{a, b}), this::isDataRange)) {
            this.declareDatatype(a);
            this.declareDatatype(b);
            return Res.TRUE;
        }
        return Res.UNKNOWN;
    }

    protected void parseUnionAndIntersectionClassExpressions() {
        Iter.flatMap(Iter.of(new Property[]{OWL.unionOf, OWL.intersectionOf}), p -> this.listStatements(null, (Property)p, null)).filterKeep(s -> s.getSubject().isAnon() && s.getObject().canAs(RDFList.class)).forEachRemaining(s -> this.parse((Statement)s, this::testUnionAndIntersectionClassExpressions));
    }

    protected Res testUnionAndIntersectionClassExpressions(Statement statement) {
        Set set = this.subjectAndObjects(statement).toSet();
        if (Iter.anyMatch(Iter.create(set), this::isClassExpression)) {
            set.forEach(this::declareClass);
            return Res.TRUE;
        }
        if (Iter.anyMatch(Iter.create(set), this::isDataRange)) {
            set.forEach(this::declareDatatype);
            return Res.TRUE;
        }
        if (this.decider.chooseClass()) {
            if (Iter.allMatch(Iter.create(set), this::canBeClass)) {
                set.forEach(this::declareClass);
            } else if (Iter.allMatch(Iter.create(set), this::canBeDatatype)) {
                set.forEach(this::declareDatatype);
            } else {
                return Res.FALSE;
            }
            return Res.TRUE;
        }
        return Res.UNKNOWN;
    }

    protected void parseEquivalentAndDisjointProperties() {
        Iter.flatMap(Iter.of(new Property[]{OWL.equivalentProperty, OWL.propertyDisjointWith}), p -> this.listStatements(null, (Property)p, null)).filterKeep(s -> s.getObject().isResource()).forEachRemaining(s -> this.parse((Statement)s, this::testEquivalentAndDisjointProperties));
    }

    protected Res testEquivalentAndDisjointProperties(Statement statement) {
        Resource a = statement.getSubject();
        Resource b = statement.getResource();
        if (Stream.of(a, b).anyMatch(this::isObjectPropertyExpression)) {
            this.declareObjectProperty(a, this.builtins.getBuiltinOWLProperties());
            this.declareObjectProperty(b, this.builtins.getBuiltinOWLProperties());
            return Res.TRUE;
        }
        if (Stream.of(a, b).anyMatch(this::isDataProperty)) {
            this.declareDataProperty(a, this.builtins.getBuiltinOWLProperties());
            this.declareDataProperty(b, this.builtins.getBuiltinOWLProperties());
            return Res.TRUE;
        }
        return Res.UNKNOWN;
    }

    protected void parseAllDisjointProperties() {
        this.listStatements(null, RDF.type, (RDFNode)OWL.AllDisjointProperties).filterKeep(s -> s.getSubject().isAnon() && s.getSubject().hasProperty(OWL.members)).forEachRemaining(s -> this.parse((Statement)s, this::testAllDisjointProperties));
    }

    protected Res testAllDisjointProperties(Statement statement) {
        Set set = this.members(statement.getSubject(), OWL.members).toSet();
        if (set.isEmpty()) {
            return Res.FALSE;
        }
        if (set.stream().anyMatch(this::isObjectPropertyExpression)) {
            set.forEach(this::declareObjectProperty);
            return Res.TRUE;
        }
        if (set.stream().anyMatch(this::isDataProperty)) {
            set.forEach(this::declareDataProperty);
            return Res.TRUE;
        }
        return Res.UNKNOWN;
    }

    protected void parseSubProperties() {
        this.listStatements(null, RDFS.subPropertyOf, null).filterKeep(s -> s.getObject().isResource()).forEachRemaining(s -> this.parse((Statement)s, this::testSubProperties));
    }

    protected Res testSubProperties(Statement statement) {
        Resource a = statement.getSubject();
        Resource b = statement.getResource();
        Res res = Res.UNKNOWN;
        if (Stream.of(a, b).anyMatch(this::isObjectPropertyExpression)) {
            this.declareObjectProperty(a, this.builtins.getBuiltinOWLProperties());
            this.declareObjectProperty(b, this.builtins.getBuiltinOWLProperties());
            res = Res.TRUE;
        }
        if (Stream.of(a, b).anyMatch(this::isDataProperty)) {
            this.declareDataProperty(a, this.builtins.getBuiltinOWLProperties());
            this.declareDataProperty(b, this.builtins.getBuiltinOWLProperties());
            res = Res.TRUE;
        }
        if (Stream.of(a, b).anyMatch(this::isAnnotationProperty) || Res.UNKNOWN.equals((Object)res) && this.decider.chooseAnnotationProperty()) {
            this.declareAnnotationProperty(a, this.builtins.getBuiltinOWLProperties());
            this.declareAnnotationProperty(b, this.builtins.getBuiltinOWLProperties());
            res = Res.TRUE;
        }
        return res;
    }

    public static enum DefaultStrategies implements Strategy
    {
        FIRST(false, false){

            @Override
            public Strategy next() {
                return SECOND;
            }
        }
        ,
        SECOND(false, true){

            @Override
            public Strategy next() {
                return THIRD;
            }
        }
        ,
        THIRD(true, true){

            @Override
            public Strategy next() {
                return null;
            }
        };

        private final boolean chooseAnnotationProperty;
        private final boolean chooseClass;

        private DefaultStrategies(boolean chooseAnnotationProperty, boolean chooseClass) {
            this.chooseAnnotationProperty = chooseAnnotationProperty;
            this.chooseClass = chooseClass;
        }

        @Override
        public boolean chooseAnnotationProperty() {
            return this.chooseAnnotationProperty;
        }

        @Override
        public boolean chooseClass() {
            return this.chooseClass;
        }

        @Override
        public abstract Strategy next();
    }

    public static interface Strategy {
        public boolean chooseAnnotationProperty();

        public boolean chooseClass();

        public Strategy next();
    }

    public static enum Res {
        TRUE,
        FALSE,
        UNKNOWN;

    }
}

