/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.transforms;

import com.github.owlcs.ontapi.jena.OntVocabulary;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import com.github.owlcs.ontapi.transforms.TransformationModel;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDFS;

public class RDFSTransform
extends TransformationModel {
    protected final boolean useAnnotationPropertyInUnclearCase;

    public RDFSTransform(Graph graph) {
        this(graph, OntVocabulary.Factory.get(), true);
    }

    public RDFSTransform(Graph graph, OntVocabulary vocabulary, boolean useAnnotationProperty) {
        super(graph, vocabulary);
        this.useAnnotationPropertyInUnclearCase = useAnnotationProperty;
    }

    @Override
    public void perform() {
        this.parseClasses();
        this.parseProperties();
    }

    public void parseClasses() {
        this.listStatements(null, RDF.type, (RDFNode)RDFS.Class).mapWith(Statement::getSubject).forEachRemaining(this::processRDFSClass);
    }

    protected void processRDFSClass(Resource resource) {
        if (this.hasType(resource, RDFS.Datatype)) {
            return;
        }
        this.declare(resource, OWL.Class);
    }

    public void parseProperties() {
        List rest1 = this.listStatements(null, RDF.type, (RDFNode)RDF.Property).mapWith(Statement::getSubject).filterKeep(RDFNode::isURIResource).mapWith(this::processRDFProperty).filterKeep(Objects::nonNull).toList();
        List<Resource> rest2 = rest1.stream().map(this::processRDFProperty).filter(Objects::nonNull).collect(Collectors.toList());
        if (this.useAnnotationPropertyInUnclearCase) {
            rest2.forEach(r -> this.declare((Resource)r, OWL.AnnotationProperty));
        }
    }

    protected Resource processRDFProperty(Resource property) {
        Resource type;
        Resource range = property.getPropertyResourceValue(RDFS.range);
        Resource domain = property.getPropertyResourceValue(RDFS.domain);
        Resource superProperty = property.getPropertyResourceValue(RDFS.subPropertyOf);
        if (this.useAnnotationPropertyInUnclearCase && range == null && domain == null && superProperty == null) {
            this.declare(property, OWL.AnnotationProperty);
            return null;
        }
        if (range != null && domain != null && this.isClass(domain)) {
            Object object = this.isClass(range) ? OWL.ObjectProperty : (type = this.isDataRange(range) ? OWL.DatatypeProperty : null);
            if (type != null) {
                this.declare(property, type);
                return null;
            }
        }
        if (superProperty != null) {
            Object object = this.isAnnotationProperty(property) ? OWL.AnnotationProperty : (this.isObjectProperty(property) ? OWL.ObjectProperty : (type = this.isDataProperty(property) ? OWL.DatatypeProperty : null));
            if (type != null) {
                this.declare(property, type);
                return null;
            }
        }
        return property;
    }

    public boolean isObjectProperty(Resource candidate) {
        return this.builtins.getBuiltinObjectProperties().contains(candidate) || this.hasType(candidate, OWL.ObjectProperty);
    }

    public boolean isDataProperty(Resource candidate) {
        return this.builtins.getBuiltinDatatypeProperties().contains(candidate) || this.hasType(candidate, OWL.DatatypeProperty);
    }

    public boolean isAnnotationProperty(Resource candidate) {
        return this.builtins.getBuiltinAnnotationProperties().contains(candidate) || this.hasType(candidate, OWL.AnnotationProperty);
    }

    protected boolean isDataRange(Resource candidate) {
        return this.builtins.getBuiltinDatatypes().contains(candidate) || this.hasType(candidate, RDFS.Datatype);
    }

    protected boolean isClass(Resource candidate) {
        return this.builtins.getBuiltinClasses().contains(candidate) || this.hasType(candidate, OWL.Class);
    }

    @Override
    public boolean test() {
        return this.isRDFS() && !this.isOWL();
    }

    protected boolean isRDFS() {
        return this.containsType(RDFS.Class) || this.containsType(RDF.Property);
    }

    protected boolean isOWL() {
        return this.containsType(OWL.Class) || this.containsType(OWL.NamedIndividual) || this.containsType(OWL.AnnotationProperty) || this.containsType(OWL.DatatypeProperty) || this.containsType(OWL.ObjectProperty) || this.containsType(OWL.Restriction);
    }
}

