/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.transforms;

import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import com.github.owlcs.ontapi.transforms.ManifestDeclarator;
import com.github.owlcs.ontapi.transforms.ReasonerDeclarator;
import com.github.owlcs.ontapi.transforms.TransformationModel;
import com.github.owlcs.ontapi.transforms.vocabulary.AVC;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDFS;

public class OWLDeclarationTransform
extends TransformationModel {
    private static final List<Resource> PROPERTY_TYPES = Stream.of(OWL.DatatypeProperty, OWL.ObjectProperty, OWL.AnnotationProperty).collect(Iter.toUnmodifiableList());
    private static final List<Resource> CLASS_TYPES = Stream.of(OWL.Class, RDFS.Datatype).collect(Iter.toUnmodifiableList());
    protected final TransformationModel manifestDeclarator;
    protected final TransformationModel reasonerDeclarator;

    public OWLDeclarationTransform(Graph graph) {
        super(graph);
        this.manifestDeclarator = new ManifestDeclarator(graph);
        this.reasonerDeclarator = new ReasonerDeclarator(graph);
    }

    @Override
    public void perform() {
        try {
            this.manifestDeclarator.perform();
            this.reasonerDeclarator.perform();
        }
        finally {
            this.finalActions();
        }
    }

    @Override
    public Stream<Triple> uncertainTriples() {
        return this.reasonerDeclarator.uncertainTriples();
    }

    protected void finalActions() {
        this.getWorkModel().removeAll(null, RDF.type, (RDFNode)AVC.AnonymousIndividual);
        this.listStatements(null, RDF.type, (RDFNode)RDF.Property).mapWith(Statement::getSubject).filterKeep(RDFNode::isURIResource).filterKeep(s -> this.hasAnyType((Resource)s, (Collection<Resource>)PROPERTY_TYPES)).toList().forEach(p -> this.undeclare((Resource)p, RDF.Property));
        this.listStatements(null, RDF.type, (RDFNode)RDFS.Class).mapWith(Statement::getSubject).filterKeep(RDFNode::isURIResource).filterKeep(s -> this.hasAnyType((Resource)s, (Collection<Resource>)CLASS_TYPES)).toList().forEach(c -> this.undeclare((Resource)c, RDFS.Class));
    }
}

