/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.transforms;

import com.github.owlcs.ontapi.transforms.Transform;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;

public class GraphStats {
    protected final Graph graph;
    protected Map<Type, Map<String, Set<Triple>>> triples = new EnumMap<Type, Map<String, Set<Triple>>>(Type.class);
    protected Set<GraphStats> sub = new HashSet<GraphStats>();

    protected GraphStats(Graph graph) {
        this.graph = Objects.requireNonNull(graph);
    }

    protected void putTriples(Transform transform, Set<Triple> added, Set<Triple> deleted, Set<Triple> unparsed) {
        String name = transform.id();
        this.put(Type.ADDED, name, added);
        this.put(Type.DELETED, name, deleted);
        this.put(Type.UNPARSED, name, unparsed);
    }

    protected void put(Type type, String name, Set<Triple> triples) {
        this.map(type).computeIfAbsent(name, s -> new HashSet()).addAll(triples);
    }

    protected void putStats(GraphStats other) {
        this.sub.add(other);
    }

    public Set<Triple> getTriples(Type type, String name) {
        return GraphStats.getUnmodifiable(this.map(type), name);
    }

    public Stream<Triple> triples(Type type) {
        return this.map(type).values().stream().flatMap(Collection::stream);
    }

    public boolean hasTriples(Type type, String name) {
        if (!this.triples.containsKey((Object)type)) {
            return false;
        }
        if (!this.triples.get((Object)type).containsKey(name)) {
            return false;
        }
        return !this.triples.get((Object)type).get(name).isEmpty();
    }

    public boolean hasTriples(Type type) {
        if (!this.triples.containsKey((Object)type)) {
            return false;
        }
        return this.triples.get((Object)type).values().stream().anyMatch(x -> !x.isEmpty());
    }

    public boolean hasTriples() {
        return !this.triples.isEmpty();
    }

    public boolean isNotEmpty() {
        return this.hasTriples() && Arrays.stream(Type.values()).anyMatch(this::hasTriples);
    }

    protected Map<String, Set<Triple>> map(Type type) {
        return this.triples.computeIfAbsent(type, t -> new HashMap());
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Stream<GraphStats> stats(boolean deep) {
        if (!deep) {
            return this.sub.stream();
        }
        return this.sub.stream().flatMap(s -> Stream.concat(Stream.of(s), s.stats(true)));
    }

    private static <T> Set<T> getUnmodifiable(Map<String, Set<T>> map, String key) {
        return map.containsKey(key) ? Collections.unmodifiableSet(map.get(key)) : Collections.emptySet();
    }

    public static enum Type {
        ADDED,
        DELETED,
        UNPARSED;

    }
}

