/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.owlapi.axioms;

import com.github.owlcs.ontapi.owlapi.axioms.OWLClassAxiomImpl;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class OWLSubClassOfAxiomImpl
extends OWLClassAxiomImpl
implements OWLSubClassOfAxiom {
    private final OWLClassExpression subClass;
    private final OWLClassExpression superClass;

    public OWLSubClassOfAxiomImpl(OWLClassExpression subClass, OWLClassExpression superClass, Collection<OWLAnnotation> annotations) {
        super(annotations);
        this.subClass = Objects.requireNonNull(subClass, "subClass cannot be null");
        this.superClass = Objects.requireNonNull(superClass, "superClass cannot be null");
    }

    public <T extends OWLAxiom> T getAnnotatedAxiom(@Nonnull Stream<OWLAnnotation> anns) {
        return (T)new OWLSubClassOfAxiomImpl(this.subClass, this.superClass, OWLSubClassOfAxiomImpl.mergeAnnotations((HasAnnotations)this, anns));
    }

    public OWLSubClassOfAxiomImpl getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLSubClassOfAxiomImpl(this.subClass, this.superClass, NO_ANNOTATIONS);
    }

    public OWLClassExpression getSubClass() {
        return this.subClass;
    }

    public OWLClassExpression getSuperClass() {
        return this.superClass;
    }

    public boolean isGCI() {
        return this.subClass.isAnonymous();
    }
}

