/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.owlapi;

import com.github.owlcs.ontapi.jena.utils.Iter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.HasIndex;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.AbstractCollectorEx;
import org.semanticweb.owlapi.util.OWLClassExpressionCollector;
import org.semanticweb.owlapi.util.OWLEntityCollector;
import org.semanticweb.owlapi.util.SimpleRenderer;

@ParametersAreNonnullByDefault
public abstract class OWLObjectImpl
implements OWLObject,
Serializable {
    public static final Comparator<OWLObject> DEFAULT_COMPARATOR = Comparator.comparingInt(HasIndex::typeIndex).thenComparing(o -> o.components().iterator(), OWLObjectImpl::compareIterators);
    protected static final List<OWLAnnotation> NO_ANNOTATIONS = Collections.emptyList();
    protected int hashCode;

    @SafeVarargs
    protected static <X> Set<X> createSet(X ... values) {
        return new HashSet<X>(Arrays.asList(values));
    }

    protected static <X> Set<X> createSet(X value) {
        return Collections.singleton(value);
    }

    protected static <X> Set<X> createSet() {
        return Collections.emptySet();
    }

    public static <X extends Comparable<?>> Set<X> createSortedSet() {
        return new TreeSet();
    }

    public static <X> Set<X> createSortedSet(Comparator<X> comparator) {
        return new TreeSet<X>(comparator);
    }

    protected static <X> List<X> toContentList(Collection<? extends X> input, String msg) {
        return OWLObjectImpl.forOutput(Objects.requireNonNull(input, msg).stream()).collect(Iter.toUnmodifiableList());
    }

    protected static <X> Stream<X> forOutput(Stream<X> stream) {
        return stream.map(Objects::requireNonNull).sorted().distinct();
    }

    protected static List<OWLAnnotation> mergeAnnotations(HasAnnotations withAnnotations, Stream<OWLAnnotation> other) {
        return OWLObjectImpl.forOutput(Stream.concat(other, withAnnotations.annotations())).collect(Iter.toUnmodifiableList());
    }

    protected static List<OWLAnnotation> prepareAnnotations(Collection<OWLAnnotation> annotations) {
        if (annotations == NO_ANNOTATIONS) {
            return NO_ANNOTATIONS;
        }
        if (Objects.requireNonNull(annotations, "Annotations cannot be null").isEmpty()) {
            return NO_ANNOTATIONS;
        }
        return OWLObjectImpl.forOutput(annotations.stream()).collect(Iter.toUnmodifiableList());
    }

    protected static boolean equalIterators(Iterator<?> left, Iterator<?> right) {
        while (left.hasNext() && right.hasNext()) {
            Object a = left.next();
            Object b = right.next();
            if (!(a instanceof Stream && b instanceof Stream ? !OWLObjectImpl.equalStreams((Stream)a, (Stream)b) : !a.equals(b))) continue;
            return false;
        }
        return left.hasNext() == right.hasNext();
    }

    protected static boolean equalStreams(Stream<?> left, Stream<?> right) {
        return OWLObjectImpl.equalIterators(left.iterator(), right.iterator());
    }

    protected static int compareIterators(Iterator<?> left, Iterator<?> right) {
        while (left.hasNext() && right.hasNext()) {
            int res;
            Object o1 = left.next();
            Object o2 = right.next();
            if (o1 instanceof Stream && o2 instanceof Stream) {
                res = OWLObjectImpl.compareIterators(((Stream)o1).iterator(), ((Stream)o2).iterator());
            } else if (o1 instanceof Collection && o2 instanceof Collection) {
                res = OWLObjectImpl.compareIterators(((Collection)o1).iterator(), ((Collection)o2).iterator());
            } else if (o1 instanceof Comparable && o2 instanceof Comparable) {
                res = ((Comparable)o1).compareTo(o2);
            } else {
                throw new IllegalArgumentException(String.format("Incomparable types: '%s' with class %s, '%s' with class %s found while comparing iterators", o1, o1.getClass(), o2, o2.getClass()));
            }
            if (res == 0) continue;
            return res;
        }
        return Boolean.compare(left.hasNext(), right.hasNext());
    }

    public boolean containsEntityInSignature(@Nullable OWLEntity entity) {
        return this.getSignatureSet().contains(entity);
    }

    public final Stream<OWLEntity> signature() {
        return this.getSignatureSet().stream();
    }

    public final Stream<OWLClass> classesInSignature() {
        return this.getNamedClassSet().stream();
    }

    public final Stream<OWLClassExpression> nestedClassExpressions() {
        return this.getClassExpressionSet().stream();
    }

    public final Stream<OWLNamedIndividual> individualsInSignature() {
        return this.getNamedIndividualSet().stream();
    }

    public final Stream<OWLAnonymousIndividual> anonymousIndividuals() {
        return this.getAnonymousIndividualSet().stream();
    }

    public final Stream<OWLDatatype> datatypesInSignature() {
        return this.getDatatypeSet().stream();
    }

    public final Stream<OWLDataProperty> dataPropertiesInSignature() {
        return this.getDataPropertySet().stream();
    }

    public final Stream<OWLObjectProperty> objectPropertiesInSignature() {
        return this.getObjectPropertySet().stream();
    }

    public final Stream<OWLAnnotationProperty> annotationPropertiesInSignature() {
        return this.getAnnotationPropertySet().stream();
    }

    public final Set<OWLClass> getClassesInSignature() {
        return this.getNamedClassSet();
    }

    public final Set<OWLNamedIndividual> getIndividualsInSignature() {
        return this.getNamedIndividualSet();
    }

    public final Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        return this.getAnonymousIndividualSet();
    }

    public final Set<OWLDatatype> getDatatypesInSignature() {
        return this.getDatatypeSet();
    }

    public final Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return this.getObjectPropertySet();
    }

    public final Set<OWLDataProperty> getDataPropertiesInSignature() {
        return this.getDataPropertySet();
    }

    public final Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        return this.getAnnotationPropertySet();
    }

    public final Set<OWLEntity> getSignature() {
        return this.getSignatureSet();
    }

    public final Set<OWLClassExpression> getNestedClassExpressions() {
        return this.getClassExpressionSet();
    }

    protected Set<OWLEntity> getSignatureSet() {
        return (Set)this.accept((OWLObjectVisitorEx)new OWLEntityCollector(OWLObjectImpl.createSortedSet()));
    }

    protected Set<OWLClass> getNamedClassSet() {
        Set<OWLClass> res = OWLObjectImpl.createSortedSet();
        this.accept((OWLObjectVisitorEx)new AbstractCollectorEx<OWLClass>(res){

            public Collection<OWLClass> visit(OWLClass clazz) {
                this.objects.add(clazz);
                return this.objects;
            }
        });
        return res;
    }

    protected Set<OWLClassExpression> getClassExpressionSet() {
        return (Set)this.accept((OWLObjectVisitorEx)new OWLClassExpressionCollector());
    }

    protected Set<OWLNamedIndividual> getNamedIndividualSet() {
        Set<OWLNamedIndividual> res = OWLObjectImpl.createSortedSet();
        this.accept((OWLObjectVisitorEx)new AbstractCollectorEx<OWLNamedIndividual>(res){

            public Collection<OWLNamedIndividual> visit(OWLNamedIndividual individual) {
                this.objects.add(individual);
                return this.objects;
            }
        });
        return res;
    }

    protected Set<OWLAnonymousIndividual> getAnonymousIndividualSet() {
        Set<OWLAnonymousIndividual> res = OWLObjectImpl.createSortedSet();
        this.accept((OWLObjectVisitorEx)new AbstractCollectorEx<OWLAnonymousIndividual>(res){

            public Collection<OWLAnonymousIndividual> visit(OWLAnonymousIndividual individual) {
                this.objects.add(individual);
                return this.objects;
            }
        });
        return res;
    }

    protected Set<OWLDatatype> getDatatypeSet() {
        Set<OWLDatatype> res = OWLObjectImpl.createSortedSet();
        this.accept((OWLObjectVisitorEx)new AbstractCollectorEx<OWLDatatype>(res){

            public Collection<OWLDatatype> visit(OWLDatatype datatype) {
                this.objects.add(datatype);
                return this.objects;
            }
        });
        return res;
    }

    protected Set<OWLObjectProperty> getObjectPropertySet() {
        Set<OWLObjectProperty> res = OWLObjectImpl.createSortedSet();
        this.accept((OWLObjectVisitorEx)new AbstractCollectorEx<OWLObjectProperty>(res){

            public Collection<OWLObjectProperty> visit(OWLObjectProperty property) {
                this.objects.add(property);
                return this.objects;
            }
        });
        return res;
    }

    protected Set<OWLDataProperty> getDataPropertySet() {
        Set<OWLDataProperty> res = OWLObjectImpl.createSortedSet();
        this.accept((OWLObjectVisitorEx)new AbstractCollectorEx<OWLDataProperty>(res){

            public Collection<OWLDataProperty> visit(OWLDataProperty property) {
                this.objects.add(property);
                return this.objects;
            }
        });
        return res;
    }

    protected Set<OWLAnnotationProperty> getAnnotationPropertySet() {
        Set<OWLAnnotationProperty> res = OWLObjectImpl.createSortedSet();
        this.accept((OWLObjectVisitorEx)new AbstractCollectorEx<OWLAnnotationProperty>(res){

            public Collection<OWLAnnotationProperty> visit(OWLAnnotationProperty property) {
                this.objects.add(property);
                return this.objects;
            }
        });
        return res;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OWLObject)) {
            return false;
        }
        OWLObject other = (OWLObject)obj;
        return this.typeIndex() == other.typeIndex() && this.hashCode() == other.hashCode() && OWLObjectImpl.equalIterators(this.components().iterator(), other.components().iterator());
    }

    protected boolean notSame(OWLObjectImpl other) {
        return this.hashCode != 0 && other.hashCode != 0 && this.hashCode != other.hashCode;
    }

    public final int hashCode() {
        return this.hashCode == 0 ? (this.hashCode = this.initHashCode()) : this.hashCode;
    }

    public int compareTo(@Nullable OWLObject o) {
        return DEFAULT_COMPARATOR.compare(this, Objects.requireNonNull(o));
    }

    public String toString() {
        return new SimpleRenderer().render((OWLObject)this);
    }
}

