/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.utils;

import com.github.owlcs.ontapi.jena.RWLockedGraph;
import com.github.owlcs.ontapi.jena.UnionGraph;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.Dyadic;
import org.apache.jena.graph.compose.Polyadic;
import org.apache.jena.mem.GraphMem;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.graph.GraphWrapper;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;

public class Graphs {
    public static final String NULL_ONTOLOGY_IDENTIFIER = "NullOntology";
    public static final String RECURSIVE_GRAPH_IDENTIFIER = "Recursion";

    public static Stream<Graph> subGraphs(Graph graph) {
        if (graph instanceof UnionGraph) {
            return ((UnionGraph)graph).getUnderlying().graphs();
        }
        if (graph instanceof Polyadic) {
            return ((Polyadic)graph).getSubGraphs().stream();
        }
        if (graph instanceof Dyadic) {
            return Stream.of(((Dyadic)graph).getR());
        }
        return Stream.empty();
    }

    public static Graph getBase(Graph graph) {
        if (graph instanceof GraphMem) {
            return graph;
        }
        if (graph instanceof GraphWrapper) {
            return Graphs.getBase(((GraphWrapper)graph).get());
        }
        if (graph instanceof RWLockedGraph) {
            return Graphs.getBase(((RWLockedGraph)graph).get());
        }
        if (graph instanceof UnionGraph) {
            return Graphs.getBase(((UnionGraph)graph).getBaseGraph());
        }
        if (graph instanceof Polyadic) {
            return Graphs.getBase(((Polyadic)graph).getBaseGraph());
        }
        if (graph instanceof Dyadic) {
            return Graphs.getBase(((Dyadic)graph).getL());
        }
        return graph;
    }

    public static Stream<Graph> baseGraphs(Graph graph) {
        if (graph == null) {
            return Stream.empty();
        }
        if (graph instanceof UnionGraph) {
            return Iter.asStream(((UnionGraph)graph).listBaseGraphs().mapWith(Graphs::getBase));
        }
        return Stream.concat(Stream.of(Graphs.getBase(graph)), Graphs.subGraphs(graph).flatMap(Graphs::baseGraphs));
    }

    public static boolean isSameBase(Graph left, Graph right) {
        return Objects.equals(Graphs.getBase(left), Graphs.getBase(right));
    }

    public static boolean isDistinct(Graph graph) {
        if (graph instanceof GraphMem) {
            return true;
        }
        if (graph instanceof UnionGraph) {
            UnionGraph u = (UnionGraph)graph;
            return u.isDistinct() || u.getUnderlying().isEmpty() && Graphs.isDistinct(Graphs.getBase((Graph)u));
        }
        return false;
    }

    public static boolean isSized(Graph graph) {
        if (graph instanceof GraphMem) {
            return true;
        }
        if (graph instanceof UnionGraph) {
            UnionGraph u = (UnionGraph)graph;
            return u.getUnderlying().isEmpty() && Graphs.isSized(Graphs.getBase((Graph)u));
        }
        return false;
    }

    public static long size(Graph graph) {
        Graph bg;
        if (graph instanceof GraphMem) {
            return graph.size();
        }
        if (graph instanceof UnionGraph && ((UnionGraph)graph).getUnderlying().isEmpty() && (bg = ((UnionGraph)graph).getBaseGraph()) instanceof GraphMem) {
            return bg.size();
        }
        return Iter.count(graph.find());
    }

    public static UnionGraph toUnion(Graph g) {
        if (g instanceof UnionGraph) {
            return (UnionGraph)g;
        }
        if (g instanceof GraphMem) {
            return new UnionGraph(g);
        }
        return Graphs.toUnion(Graphs.getBase(g), Graphs.baseGraphs(g).collect(Collectors.toSet()));
    }

    public static UnionGraph toUnion(Graph graph, Collection<Graph> repository) {
        Graph base = Graphs.getBase(graph);
        Set<String> imports = Graphs.getImports(base);
        UnionGraph res = new UnionGraph(base);
        repository.stream().filter(x -> !Graphs.isSameBase(base, x)).filter(g -> imports.contains(Graphs.getURI(g))).forEach(g -> res.addGraph((Graph)Graphs.toUnion(g, repository)));
        return res;
    }

    public static UnionGraph withBase(Graph base, UnionGraph union) {
        return new UnionGraph(base, union.getUnderlying(), union.getEventManager(), union.isDistinct());
    }

    public static String getURI(Graph graph) {
        return Graphs.ontologyNode(Graphs.getBase(graph)).filter(Node::isURI).map(Node::getURI).orElse(null);
    }

    public static String getName(Graph graph) {
        Optional<Node> res = Graphs.ontologyNode(Graphs.getBase(graph));
        if (!res.isPresent()) {
            return NULL_ONTOLOGY_IDENTIFIER;
        }
        List versions = graph.find(res.get(), OWL.versionIRI.asNode(), Node.ANY).mapWith(Triple::getObject).mapWith(Node::toString).toList();
        if (versions.isEmpty()) {
            return String.format("<%s>", res.get().toString());
        }
        return String.format("<%s%s>", res.get().toString(), versions.toString());
    }

    public static Optional<Node> ontologyNode(Graph g) {
        List res = g.find(Node.ANY, RDF.Nodes.type, OWL.Ontology.asNode()).mapWith(t -> {
            Node n = t.getSubject();
            return n.isURI() || n.isBlank() ? n : null;
        }).filterDrop(Objects::isNull).toList();
        if (res.isEmpty()) {
            return Optional.empty();
        }
        res.sort(Graphs.rootNodeComparator(g));
        return Optional.of(res.get(0));
    }

    public static Comparator<Node> rootNodeComparator(Graph graph) {
        return Comparator.comparing(Node::isURI).reversed().thenComparing(Comparator.comparingInt(x -> graph.find(x, Node.ANY, Node.ANY).toList().size()).reversed());
    }

    public static Set<String> getImports(Graph graph) {
        return Graphs.listImports(graph).toSet();
    }

    public static ExtendedIterator<String> listImports(Graph graph) {
        return graph.find(Node.ANY, OWL.imports.asNode(), Node.ANY).mapWith(t -> {
            Node n = t.getObject();
            return n.isURI() ? n.getURI() : null;
        }).filterDrop(Objects::isNull);
    }

    public static String importsTreeAsString(Graph graph) {
        Function<Graph, String> printDefaultGraphName = g -> g.getClass().getSimpleName() + "@" + Integer.toHexString(g.hashCode());
        return Graphs.makeImportsTree(graph, g -> {
            if (g.isClosed()) {
                return "Closed(" + (String)printDefaultGraphName.apply((Graph)g) + ")";
            }
            String res = Graphs.getName(g);
            if (NULL_ONTOLOGY_IDENTIFIER.equals(res)) {
                res = res + "(" + (String)printDefaultGraphName.apply((Graph)g) + ")";
            }
            return res;
        }, "\t", "\t", new HashSet<Graph>()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder makeImportsTree(Graph graph, Function<Graph, String> getName, String indent, String step, Set<Graph> seen) {
        StringBuilder res = new StringBuilder();
        Graph base = Graphs.getBase(graph);
        String name = getName.apply(base);
        try {
            if (!seen.add(graph)) {
                StringBuilder stringBuilder = res.append(RECURSIVE_GRAPH_IDENTIFIER).append(": ").append(name);
                return stringBuilder;
            }
            res.append(name).append("\n");
            Graphs.subGraphs(graph).sorted(Comparator.comparingLong(o -> Graphs.subGraphs(o).count())).forEach(sub -> res.append(indent).append((CharSequence)Graphs.makeImportsTree(sub, getName, indent + step, step, seen)));
            StringBuilder stringBuilder = res;
            return stringBuilder;
        }
        finally {
            seen.remove(graph);
        }
    }

    public static String toTurtleString(Graph g) {
        StringWriter sw = new StringWriter();
        RDFDataMgr.write((StringWriter)sw, (Graph)g, (Lang)Lang.TURTLE);
        return sw.toString();
    }

    public static PrefixMapping collectPrefixes(Iterable<Graph> graphs) {
        PrefixMapping res = PrefixMapping.Factory.create();
        graphs.forEach(g -> res.setNsPrefixes(g.getPrefixMapping()));
        return res.lock();
    }

    public static Graph asConcurrent(Graph graph, ReadWriteLock lock) {
        if (graph instanceof RWLockedGraph) {
            return Graphs.asConcurrent(((RWLockedGraph)graph).get(), lock);
        }
        if (!(graph instanceof UnionGraph)) {
            return new RWLockedGraph(graph, lock);
        }
        UnionGraph u = (UnionGraph)graph;
        Graph base = Graphs.asConcurrent(u.getBaseGraph(), lock);
        UnionGraph res = new UnionGraph(base);
        u.getUnderlying().listGraphs().mapWith(Graphs::asNonConcurrent).forEachRemaining(res::addGraph);
        return res;
    }

    public static Graph asNonConcurrent(Graph graph) {
        if (graph instanceof RWLockedGraph) {
            return ((RWLockedGraph)graph).get();
        }
        if (!(graph instanceof UnionGraph)) {
            return graph;
        }
        UnionGraph u = (UnionGraph)graph;
        Graph base = Graphs.asNonConcurrent(u.getBaseGraph());
        UnionGraph res = new UnionGraph(base);
        u.getUnderlying().listGraphs().mapWith(Graphs::asNonConcurrent).forEachRemaining(res::addGraph);
        return res;
    }

    public static boolean dependsOn(Graph left, Graph right) {
        return left == right || left != null && left.dependsOn(right);
    }

    public static Node createNode(String iri) {
        return iri == null ? NodeFactory.createBlankNode() : NodeFactory.createURI((String)iri);
    }

    public static ExtendedIterator<Node> listSubjects(Graph g) {
        return Iter.create(() -> Collections.unmodifiableSet(g.find().mapWith(Triple::getSubject).toSet()).iterator());
    }

    public static ExtendedIterator<Node> listSubjectsAndObjects(Graph g) {
        return Iter.create(() -> Collections.unmodifiableSet(Iter.flatMap(g.find(), t -> Iter.of(new Node[]{t.getSubject(), t.getObject()})).toSet()).iterator());
    }

    public static ExtendedIterator<Node> listAllNodes(Graph g) {
        return Iter.create(() -> Collections.unmodifiableSet(Iter.flatMap(g.find(), t -> Iter.of(new Node[]{t.getSubject(), t.getPredicate(), t.getObject()})).toSet()).iterator());
    }
}

