/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.model;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import com.github.owlcs.ontapi.jena.model.OntNamedProperty;
import com.github.owlcs.ontapi.jena.model.OntNegativeAssertion;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public interface OntIndividual
extends OntObject {
    public OntIndividual detachClass(Resource var1);

    public Stream<OntClass> classes(boolean var1);

    @Override
    public Stream<OntStatement> content();

    default public Stream<OntClass> classes() {
        return this.objects(RDF.type, OntClass.class);
    }

    default public Stream<OntIndividual> sameIndividuals() {
        return this.objects(OWL.sameAs, OntIndividual.class);
    }

    default public Stream<OntIndividual> differentIndividuals() {
        return this.objects(OWL.differentFrom, OntIndividual.class);
    }

    default public Stream<OntStatement> positiveAssertions() {
        return this.statements().filter(s -> s.getPredicate().canAs(OntNamedProperty.class));
    }

    default public Stream<OntStatement> positiveAssertions(OntNamedProperty predicate) {
        return this.statements(predicate);
    }

    default public Stream<OntNegativeAssertion> negativeAssertions() {
        return this.getModel().statements(null, OWL.sourceIndividual, (RDFNode)this).map(x -> x.getSubject().getAs(OntNegativeAssertion.class)).filter(Objects::nonNull);
    }

    default public Stream<OntNegativeAssertion> negativeAssertions(OntNamedProperty property) {
        return this.negativeAssertions().filter(x -> property == null || x.getProperty().equals(property));
    }

    default public OntStatement addClassAssertion(OntClass clazz) {
        return this.addStatement(RDF.type, (RDFNode)clazz);
    }

    default public OntStatement addDifferentFromStatement(OntIndividual other) {
        return this.addStatement(OWL.differentFrom, (RDFNode)other);
    }

    default public OntStatement addSameAsStatement(OntIndividual other) {
        return this.addStatement(OWL.sameAs, (RDFNode)other);
    }

    default public OntIndividual attachClass(OntClass clazz) {
        this.addClassAssertion(clazz);
        return this;
    }

    default public OntIndividual addDifferentIndividual(OntIndividual other) {
        this.addDifferentFromStatement(other);
        return this;
    }

    default public OntIndividual addSameIndividual(OntIndividual other) {
        this.addSameAsStatement(other);
        return this;
    }

    default public OntIndividual addAssertion(OntAnnotationProperty property, RDFNode value) {
        return this.addProperty(property, value);
    }

    default public OntIndividual addAssertion(OntDataProperty property, Literal value) {
        return this.addProperty(property, (RDFNode)value);
    }

    default public OntIndividual addAssertion(OntObjectProperty.Named property, OntIndividual value) {
        return this.addProperty(property, (RDFNode)value);
    }

    default public OntIndividual addProperty(OntNamedProperty property, RDFNode value) {
        this.addStatement(property, value);
        return this;
    }

    default public OntIndividual addNegativeAssertion(OntObjectProperty property, OntIndividual value) {
        property.addNegativeAssertion(this, value);
        return this;
    }

    default public OntIndividual addNegativeAssertion(OntDataProperty property, Literal value) {
        property.addNegativeAssertion(this, value);
        return this;
    }

    default public OntIndividual removeAssertion(OntNamedProperty property, RDFNode value) {
        this.statements(property).filter(x -> x.getPredicate().canAs(OntNamedProperty.class) && (value == null || value.equals(x.getObject()))).collect(Collectors.toList()).forEach(x -> x.getModel().remove(x.clearAnnotations()));
        return this;
    }

    default public OntIndividual removeNegativeAssertion(OntNamedProperty property, RDFNode value) {
        this.negativeAssertions(property).filter(x -> value == null || value.equals(x.getTarget())).collect(Collectors.toList()).forEach(x -> this.getModel().removeOntObject((OntObject)x));
        return this;
    }

    default public OntIndividual removeDifferentIndividual(Resource other) {
        this.remove(OWL.differentFrom, (RDFNode)other);
        return this;
    }

    default public OntIndividual removeSameIndividual(Resource other) {
        this.remove(OWL.sameAs, (RDFNode)other);
        return this;
    }

    @Override
    default public OntIndividual addComment(String txt) {
        return this.addComment(txt, null);
    }

    @Override
    default public OntIndividual addComment(String txt, String lang) {
        return this.annotate(this.getModel().getRDFSComment(), txt, lang);
    }

    @Override
    default public OntIndividual addLabel(String txt) {
        return this.addLabel(txt, null);
    }

    @Override
    default public OntIndividual addLabel(String txt, String lang) {
        return this.annotate(this.getModel().getRDFSLabel(), txt, lang);
    }

    @Override
    default public OntIndividual annotate(OntAnnotationProperty predicate, String txt, String lang) {
        return this.annotate(predicate, (RDFNode)this.getModel().createLiteral(txt, lang));
    }

    @Override
    default public OntIndividual annotate(OntAnnotationProperty predicate, RDFNode value) {
        this.addAnnotation(predicate, value);
        return this;
    }

    public static interface Anonymous
    extends OntIndividual {
        @Override
        public Anonymous detachClass(Resource var1) throws OntJenaException;
    }

    public static interface Named
    extends OntIndividual,
    OntEntity {
    }
}

