/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.model;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public interface OntID
extends OntObject {
    public String getVersionIRI();

    public OntID setVersionIRI(String var1) throws OntApiException;

    public OntID addImport(String var1) throws OntApiException;

    public OntID removeImport(String var1);

    public Stream<String> imports();

    default public boolean sameAs(OntID other) {
        return this.equals(other) && Objects.equals(this.getVersionIRI(), other.getVersionIRI());
    }

    default public String getImportsIRI() {
        String res = this.getVersionIRI();
        if (res != null) {
            return res;
        }
        return this.getURI();
    }

    @Override
    default public OntID addComment(String txt) {
        return this.addComment(txt, null);
    }

    @Override
    default public OntID addComment(String txt, String lang) {
        return this.annotate(this.getModel().getRDFSComment(), txt, lang);
    }

    default public OntID addVersionInfo(String txt) {
        return this.addVersionInfo(txt, null);
    }

    default public OntID addVersionInfo(String txt, String lang) {
        return this.annotate(this.getModel().getAnnotationProperty((Resource)OWL.versionInfo), txt, lang);
    }

    default public String getVersionInfo() {
        return this.getVersionInfo(null);
    }

    default public String getVersionInfo(String lang) {
        try (Stream<String> res = this.annotationValues(this.getModel().getAnnotationProperty((Resource)OWL.versionInfo), lang);){
            String string = res.findFirst().orElse(null);
            return string;
        }
    }

    @Override
    default public OntID annotate(OntAnnotationProperty predicate, String txt, String lang) {
        return this.annotate(predicate, (RDFNode)this.getModel().createLiteral(txt, lang));
    }

    @Override
    default public OntID annotate(OntAnnotationProperty predicate, RDFNode value) {
        this.addAnnotation(predicate, value);
        return this;
    }
}

