/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl.conf;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.impl.conf.Vocabulary;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;

abstract class VocabularyImpl<T extends Resource>
implements Vocabulary<T> {
    private final Map<Class<? extends T>, Set<Node>> map;

    VocabularyImpl(Map<Class<? extends T>, Set<Node>> map) {
        this.map = Objects.requireNonNull(map);
    }

    @Override
    public Set<Node> get(Class<? extends T> key) throws OntJenaException {
        Set<Node> res = this.map.get(OntJenaException.notNull(key, "Null key"));
        if (res == null) {
            throw new OntJenaException.Unsupported("Unsupported class-type " + key);
        }
        if (res.isEmpty()) {
            return Collections.emptySet();
        }
        return res;
    }

    static class ReservedIml
    extends VocabularyImpl<Resource>
    implements OntPersonality.Reserved {
        private Set<Node> resources;
        private Set<Node> properties;
        private Map<String, Set<Node>> nodes = new HashMap<String, Set<Node>>();

        ReservedIml(Map<Class<? extends Resource>, Set<Node>> map) {
            super(map);
        }

        @Override
        public Set<Node> get(String key, Supplier<Set<Node>> loader) {
            return this.nodes.computeIfAbsent(key, k -> (Set)loader.get());
        }

        @Override
        public Set<Node> getResources() {
            return this.resources == null ? (this.resources = this.get(Resource.class)) : this.resources;
        }

        @Override
        public Set<Node> getProperties() {
            return this.properties == null ? (this.properties = this.get(Property.class)) : this.properties;
        }
    }

    static class EntitiesImpl
    extends VocabularyImpl<OntObject>
    implements OntPersonality.Builtins,
    OntPersonality.Punnings {
        private Set<Node> classes;
        private Set<Node> datatypes;
        private Set<Node> objectProperties;
        private Set<Node> datatypeProperties;
        private Set<Node> annotationProperties;
        private Set<Node> allProperties;
        private Set<Node> individuals;

        EntitiesImpl(Map<Class<? extends OntObject>, Set<Node>> map) {
            super(map);
        }

        @Override
        public Set<Node> getClasses() {
            return this.classes == null ? (this.classes = this.get(OntClass.Named.class)) : this.classes;
        }

        @Override
        public Set<Node> getDatatypes() {
            return this.datatypes == null ? (this.datatypes = this.get(OntDataRange.Named.class)) : this.datatypes;
        }

        @Override
        public Set<Node> getObjectProperties() {
            return this.objectProperties == null ? (this.objectProperties = this.get(OntObjectProperty.Named.class)) : this.objectProperties;
        }

        @Override
        public Set<Node> getDatatypeProperties() {
            return this.datatypeProperties == null ? (this.datatypeProperties = this.get(OntDataProperty.class)) : this.datatypeProperties;
        }

        @Override
        public Set<Node> getAnnotationProperties() {
            return this.annotationProperties == null ? (this.annotationProperties = this.get(OntAnnotationProperty.class)) : this.annotationProperties;
        }

        @Override
        public Set<Node> getIndividuals() {
            return this.individuals == null ? (this.individuals = this.get(OntIndividual.Named.class)) : this.individuals;
        }

        @Override
        public Set<Node> getProperties() {
            if (this.allProperties != null) {
                return this.allProperties;
            }
            this.allProperties = Stream.of(this.getObjectProperties(), this.getAnnotationProperties(), this.getDatatypeProperties()).flatMap(Collection::stream).collect(Iter.toUnmodifiableSet());
            return this.allProperties;
        }
    }
}

