/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl.conf;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonalityImpl;
import com.github.owlcs.ontapi.jena.impl.conf.Vocabulary;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import com.github.owlcs.ontapi.jena.model.OntObject;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public class PersonalityBuilder {
    private final Map<Class<? extends OntObject>, ObjectFactory> map;
    private final Personality<RDFNode> base;
    private OntPersonality.Punnings punnings;
    private OntPersonality.Builtins builtins;
    private OntPersonality.Reserved reserved;

    public PersonalityBuilder() {
        this(new LinkedHashMap<Class<? extends OntObject>, ObjectFactory>());
    }

    protected PersonalityBuilder(Map<Class<? extends OntObject>, ObjectFactory> factories) {
        this.map = Objects.requireNonNull(factories);
        this.base = new Personality();
    }

    public static PersonalityBuilder from(OntPersonality from) {
        return new PersonalityBuilder().addPersonality(OntPersonality.asJenaPersonality(from)).setPunnings(from.getPunnings()).setBuiltins(from.getBuiltins()).setReserved(from.getReserved());
    }

    private static <X extends Vocabulary> X require(X obj, Class<X> type) {
        if (obj == null) {
            throw new IllegalStateException("The " + type.getSimpleName() + " Vocabulary must be present in builder.");
        }
        return obj;
    }

    private static <V extends Vocabulary> V hasSpec(V voc, Class ... types) {
        Objects.requireNonNull(voc);
        Set errors = Arrays.stream(types).filter(x -> {
            try {
                return voc.get(x) == null;
            }
            catch (OntJenaException e) {
                return true;
            }
        }).collect(Collectors.toSet());
        if (errors.isEmpty()) {
            return voc;
        }
        throw new IllegalArgumentException("The vocabulary " + voc + " has missed required types: " + errors);
    }

    public PersonalityBuilder copy() {
        PersonalityBuilder res = new PersonalityBuilder(new LinkedHashMap<Class<? extends OntObject>, ObjectFactory>(this.map));
        res.addPersonality((Personality<RDFNode>)this.base.copy());
        if (this.punnings != null) {
            res.setPunnings(this.punnings);
        }
        if (this.builtins != null) {
            res.setBuiltins(this.builtins);
        }
        if (this.reserved != null) {
            res.setReserved(this.reserved);
        }
        return res;
    }

    public PersonalityBuilder add(Class<? extends OntObject> type, ObjectFactory factory) {
        this.map.put(type, factory);
        return this;
    }

    public PersonalityBuilder addPersonality(Personality<RDFNode> from) {
        this.base.add(Objects.requireNonNull(from));
        return this;
    }

    public PersonalityBuilder setPunnings(OntPersonality.Punnings punnings) {
        this.punnings = PersonalityBuilder.hasSpec(punnings, this.getEntityTypes());
        return this;
    }

    public PersonalityBuilder setBuiltins(OntPersonality.Builtins builtins) {
        this.builtins = PersonalityBuilder.hasSpec(builtins, this.getEntityTypes());
        return this;
    }

    private Class<?>[] getEntityTypes() {
        return (Class[])OntEntity.entityTypes().toArray(Class[]::new);
    }

    public PersonalityBuilder setReserved(OntPersonality.Reserved reserved) {
        this.reserved = PersonalityBuilder.hasSpec(reserved, Resource.class, Property.class);
        return this;
    }

    public OntPersonality build() throws IllegalStateException {
        OntPersonalityImpl res = new OntPersonalityImpl(this.base, this.punnings(), this.builtins(), this.reserved());
        this.map.forEach(res::register);
        return res;
    }

    private OntPersonality.Punnings punnings() {
        return PersonalityBuilder.require(this.punnings, OntPersonality.Punnings.class);
    }

    private OntPersonality.Builtins builtins() {
        return PersonalityBuilder.require(this.builtins, OntPersonality.Builtins.class);
    }

    private OntPersonality.Reserved reserved() {
        return PersonalityBuilder.require(this.reserved, OntPersonality.Reserved.class);
    }
}

