/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl.conf;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.conf.BaseFactoryImpl;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntFilter;
import com.github.owlcs.ontapi.jena.impl.conf.OntFinder;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.Node;
import org.apache.jena.util.iterator.ExtendedIterator;

public class MultiFactoryImpl
extends BaseFactoryImpl {
    private final List<ObjectFactory> factories;
    private final OntFinder finder;
    private final OntFilter fittingFilter;

    public MultiFactoryImpl(OntFinder finder, OntFilter fittingFilter, ObjectFactory ... factories) {
        this.finder = finder;
        this.fittingFilter = fittingFilter;
        if (factories.length == 0) {
            throw new IllegalArgumentException("Empty factory array");
        }
        this.factories = MultiFactoryImpl.unbend(factories);
    }

    private static List<ObjectFactory> unbend(ObjectFactory ... factories) {
        return Arrays.stream(factories).map(f -> f instanceof MultiFactoryImpl ? ((MultiFactoryImpl)f).factories.stream() : Stream.of(f)).flatMap(Function.identity()).collect(Collectors.toList());
    }

    @Override
    public EnhNode wrap(Node node, EnhGraph eg) {
        EnhNode res = this.createInstance(node, eg);
        if (res != null) {
            return res;
        }
        throw new OntJenaException.Conversion("Can't wrap node " + node + ". Use direct factory.");
    }

    @Override
    public boolean canWrap(Node node, EnhGraph eg) {
        return (this.fittingFilter == null || this.fittingFilter.test(node, eg)) && Iter.anyMatch(this.listFactories(), f -> f.canWrap(node, eg));
    }

    @Override
    public EnhNode createInstance(Node node, EnhGraph eg) {
        if (this.fittingFilter != null && !this.fittingFilter.test(node, eg)) {
            return null;
        }
        return Iter.findFirst(Iter.filter(this.listFactories(), f -> f.canWrap(node, eg)).mapWith(f -> f.createInstance(node, eg))).orElse(null);
    }

    @Override
    public ExtendedIterator<EnhNode> iterator(EnhGraph eg) {
        if (this.finder != null) {
            return this.finder.iterator(eg).mapWith(n -> this.createInstance((Node)n, eg)).filterDrop(Objects::isNull);
        }
        return Iter.distinct(Iter.flatMap(this.listFactories(), f -> f.iterator(eg)));
    }

    public OntFinder getFinder() {
        return this.finder;
    }

    public OntFilter getFilter() {
        return this.fittingFilter;
    }

    public ExtendedIterator<? extends ObjectFactory> listFactories() {
        return Iter.create(this.factories);
    }
}

