/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.OntStatementImpl;
import com.github.owlcs.ontapi.jena.impl.PersonalityModel;
import com.github.owlcs.ontapi.jena.model.OntList;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.Models;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.UnsupportedPolymorphismException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.RDFListImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.shared.PropertyNotFoundException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public abstract class OntListImpl<E extends RDFNode>
extends ResourceImpl
implements OntList<E> {
    private static final UnaryOperator<RDFList> IDENTITY = UnaryOperator.identity();
    protected final Resource subject;
    protected final Property predicate;
    protected final Class<E> elementType;
    protected final Resource listType;
    private RDFList objectRDFList;

    protected OntListImpl(Resource subject, Property predicate, RDFList object, Resource listType, OntModel model, Class<E> elementType) {
        super(object.asNode(), (EnhGraph)model);
        this.objectRDFList = object;
        this.subject = subject;
        this.predicate = predicate;
        this.elementType = elementType;
        this.listType = listType;
    }

    public static <N extends RDFNode> OntListImpl<N> create(OntGraphModelImpl model, OntObject subject, Property predicate, Class<N> elementType, Iterator<N> elements) {
        return OntListImpl.create(model, subject, predicate, null, elementType, Iter.create(elements));
    }

    public static <N extends RDFNode> OntListImpl<N> create(OntGraphModelImpl model, OntObject subject, Property predicate, Resource listType, Class<N> elementType, ExtendedIterator<N> elements) {
        OntListImpl.checkRequiredInput(model, subject, predicate, listType, elementType);
        elements = Iter.peek(elements, n -> OntJenaException.notNull(n, "OntList: null element is specified."));
        RDFList list = listType != null ? OntListImpl.createTypedList((EnhGraph)model, listType, elements) : model.createList((Iterator)elements);
        model.add(subject, predicate, (RDFNode)list);
        return new OntListImpl<N>((Resource)subject, predicate, list, listType, (OntModel)model, elementType){

            @Override
            public boolean isValid(RDFNode n) {
                return true;
            }

            @Override
            public N cast(RDFNode n) {
                return this.getModel().getNodeAs(n.asNode(), this.elementType);
            }
        };
    }

    public static <N extends RDFNode> OntListImpl<N> asOntList(RDFList list, OntGraphModelImpl model, OntObject subject, Property predicate, Resource listType, Class<N> elementType) {
        OntListImpl.checkRequiredInput(model, subject, predicate, listType, elementType);
        Objects.requireNonNull(list, "Null RDF-List");
        return new OntListImpl<N>((Resource)subject, predicate, list, listType, (OntModel)model, elementType){

            @Override
            public boolean isValid(RDFNode n) {
                return OntObjectImpl.getNodeAs(n, this.elementType) != null;
            }

            @Override
            public N cast(RDFNode n) {
                return n.as(this.elementType);
            }
        };
    }

    protected static <N extends RDFNode> OntListImpl<N> asSafeOntList(RDFList list, final OntGraphModelImpl model, OntObject subject, Property predicate, Resource listType, Class<N> elementType) {
        return new OntListImpl<N>(subject, predicate, list, listType, model, elementType){

            @Override
            public boolean isValid(RDFNode n) {
                return PersonalityModel.canAs(this.elementType, n.asNode(), (EnhGraph)model);
            }

            @Override
            public N cast(RDFNode n) {
                return model.getNodeAs(n.asNode(), this.elementType);
            }
        };
    }

    public static <N extends RDFNode> Stream<OntList<N>> stream(OntGraphModelImpl model, OntObject subject, Property predicate, Class<N> elementType) {
        return OntListImpl.stream(model, subject, predicate, null, elementType);
    }

    protected static <N extends RDFNode> Stream<OntList<N>> stream(OntGraphModelImpl model, OntObject subject, Property predicate, Resource listType, Class<N> elementType) {
        OntListImpl.checkRequiredInput(model, subject, predicate, listType, elementType);
        return subject.objects(predicate, RDFList.class).map(list -> OntListImpl.asOntList(list, model, subject, predicate, listType, elementType));
    }

    public static RDFList createTypedList(EnhGraph model, final Resource type, final Iterator<? extends RDFNode> members) {
        return new RDFListImpl(Node.ANY, model){

            public Resource listType() {
                return type;
            }

            public RDFList copy() {
                return this.copy(members);
            }
        }.copy();
    }

    private static void checkRequiredInput(OntGraphModelImpl m, OntObject s, Property p, Resource listType, Class<?> elementType) throws IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(m, "Null model");
        Objects.requireNonNull(s, "Null subject");
        Objects.requireNonNull(p, "Null predicate");
        Objects.requireNonNull(elementType, "Null type");
        if (listType == null) {
            return;
        }
        if (!listType.isURIResource()) {
            throw new IllegalArgumentException("List type must have URI");
        }
    }

    private static ExtendedIterator<Resource> listAnnotations(OntGraphModelImpl m, Resource subject, Property predicate, RDFNode obj) {
        return m.listAnnotations(OWL.Axiom, subject, predicate, obj);
    }

    public static boolean isNil(RDFNode list) {
        return RDF.nil.equals((Object)list);
    }

    private static OntStatement createRDFFirst(OntGraphModelImpl m, List<Triple> batch) {
        return OntListImpl.createListStatement(m, RDF.first, batch);
    }

    private static OntStatement createRDFRest(OntGraphModelImpl m, List<Triple> batch) {
        return OntListImpl.createListStatement(m, RDF.rest, batch);
    }

    private static OntStatement createRDFType(OntGraphModelImpl m, List<Triple> batch, Resource type) {
        return OntListImpl.createRDFType(m, batch, (n, g) -> g.getNodeAs((Node)n, Resource.class), type);
    }

    private static OntStatement createRDFType(OntGraphModelImpl m, List<Triple> batch, BiFunction<Node, OntGraphModelImpl, Resource> subject, Resource type) {
        for (Triple t : batch) {
            if (!RDF.type.asNode().equals((Object)t.getPredicate()) || !t.getObject().equals((Object)type.asNode())) continue;
            return OntStatementImpl.createNotAnnotatedOntStatementImpl(subject.apply(t.getSubject(), m), RDF.type, (RDFNode)type, m);
        }
        throw new OntJenaException.IllegalState("Can't find rdf:type=" + type + " triple in a batch " + batch);
    }

    private static OntStatement createListStatement(OntGraphModelImpl m, Property predicate, List<Triple> batch) {
        return OntListImpl.createListStatement(m, (n, g) -> g.getNodeAs((Node)n, Resource.class), predicate, (n, g) -> g.getNodeAs((Node)n, RDFNode.class), batch);
    }

    private static OntStatement createListStatement(OntGraphModelImpl m, BiFunction<Node, OntGraphModelImpl, Resource> subject, Property predicate, BiFunction<Node, OntGraphModelImpl, RDFNode> object, List<Triple> batch) {
        for (Triple t : batch) {
            if (!predicate.asNode().equals((Object)t.getPredicate())) continue;
            return OntStatementImpl.createNotAnnotatedOntStatementImpl(subject.apply(t.getSubject(), m), predicate, object.apply(t.getObject(), m), m);
        }
        throw new OntJenaException.IllegalState("Can't find []-list triple with predicate " + predicate + " in a batch " + batch);
    }

    protected int getCharacteristics() {
        return OntGraphModelImpl.getSpliteratorCharacteristics((Graph)this.getModel().getGraph());
    }

    @Override
    public OntStatement getMainStatement() {
        return this.getModel().createStatement(this.subject, this.predicate, (RDFNode)this.getRDFList());
    }

    @Override
    public Optional<Resource> type() {
        return Optional.ofNullable(this.listType);
    }

    @Override
    public OntGraphModelImpl getModel() {
        return (OntGraphModelImpl)this.enhGraph;
    }

    protected RDFList getRDFList() {
        return this.setRDFList(OntListImpl.IDENTITY).objectRDFList;
    }

    protected OntListImpl<E> setRDFList(UnaryOperator<RDFList> operation) throws OntJenaException.IllegalState {
        RDFList list;
        OntStatementImpl s;
        OntGraphModelImpl m = this.getModel();
        if (!m.contains(s = m.createStatement(this.subject, this.predicate, (RDFNode)(list = (RDFList)Objects.requireNonNull(operation).apply(this.objectRDFList))))) {
            throw new OntJenaException.IllegalState(Models.toString(s) + " does not exist");
        }
        if (!this.objectRDFList.equals(list)) {
            OntListImpl.listAnnotations(m, this.subject, this.predicate, (RDFNode)this.objectRDFList).toSet().forEach(a -> m.remove((Resource)a, OWL.annotatedTarget, (RDFNode)this.objectRDFList).add((Resource)a, OWL.annotatedTarget, (RDFNode)list));
            m.getNodeCache().remove((Object)this.objectRDFList.asNode());
        }
        this.objectRDFList = list;
        return this;
    }

    public Node asNode() {
        return this.getRDFList().asNode();
    }

    public <T extends RDFNode> T as(Class<T> t) throws UnsupportedPolymorphismException {
        if (RDFList.class.equals(t)) {
            return (T)this.getRDFList();
        }
        return (T)super.as(t);
    }

    public <X extends RDFNode> boolean canAs(Class<X> t) {
        return RDFList.class.equals(t) || super.canAs(t);
    }

    @Override
    public boolean isEmpty() {
        return this.isNil() || !Iter.findFirst(this.listMembers()).isPresent();
    }

    @Override
    public boolean isNil() {
        return OntListImpl.isNil((RDFNode)this.getRDFList());
    }

    @Override
    public Stream<E> members() {
        return Iter.asStream(this.listMembers(), 272);
    }

    public ExtendedIterator<E> listMembers() {
        Iterator<List<Triple>> it = this.createRDFListIterator();
        if (it == null) {
            return NullIterator.instance();
        }
        OntGraphModelImpl m = this.getModel();
        return Iter.create(it).mapWith(x -> OntListImpl.createRDFFirst(m, x).getObject()).filterKeep(this::isValid).mapWith(this::cast);
    }

    @Override
    public Stream<OntStatement> spec() {
        return Iter.asStream(this.listSpec(), this.getCharacteristics());
    }

    public ExtendedIterator<OntStatement> listSpec() {
        RDFList list = this.getRDFList();
        if (OntListImpl.isNil((RDFNode)list)) {
            return NullIterator.instance();
        }
        return Iter.flatMap(this.createSafeRDFListIterator(list.asNode()), this::toListStatements);
    }

    public ExtendedIterator<OntStatement> listContent() {
        return Iter.of(this.getMainStatement()).andThen(this.listSpec());
    }

    @Override
    public Stream<OntStatement> content() {
        return Iter.asStream(this.listContent(), this.getCharacteristics());
    }

    public Iterator<List<Triple>> createRDFListIterator() {
        RDFList list = this.getRDFList();
        if (OntListImpl.isNil((RDFNode)list)) {
            return null;
        }
        return this.createRDFListIterator(list.asNode());
    }

    protected ExtendedIterator<List<Triple>> createSafeRDFListIterator(Node list) {
        return Iter.create(new SafeRDFListIterator((Graph)this.getModel().getGraph(), list)).filterKeep(Objects::nonNull);
    }

    protected ExtendedIterator<List<Triple>> createRDFListIterator(Node list) {
        return Iter.create(new RDFListIterator((Graph)this.getModel().getGraph(), list));
    }

    protected ExtendedIterator<OntStatement> toListStatements(List<Triple> triples) {
        OntGraphModelImpl m = this.getModel();
        if (this.listType != null) {
            return Iter.of(new OntStatement[]{OntListImpl.createRDFType(m, triples, this.listType), OntListImpl.createRDFFirst(m, triples), OntListImpl.createRDFRest(m, triples)});
        }
        return Iter.of(new OntStatement[]{OntListImpl.createRDFFirst(m, triples), OntListImpl.createRDFRest(m, triples)});
    }

    public abstract boolean isValid(RDFNode var1);

    public abstract E cast(RDFNode var1);

    @Override
    public OntList<E> addLast(E e) {
        return this.setRDFList(list -> {
            Statement last = this.getLastRestStatement();
            Statement s = last == null ? this.getMainStatement() : last;
            OntGraphModelImpl m = this.getModel();
            Resource r = m.createResource();
            if (this.listType != null) {
                m.add(r, RDF.type, (RDFNode)this.listType);
            }
            m.add(s.getSubject(), s.getPredicate(), (RDFNode)r).add(r, RDF.first, e).add(r, RDF.rest, (RDFNode)RDF.nil).remove(s);
            return last == null ? (RDFList)r.as(RDFList.class) : list;
        });
    }

    @Override
    public OntList<E> addFirst(E e) throws PropertyNotFoundException {
        return this.setRDFList(list -> {
            Statement first = this.getFirstRestStatement();
            OntStatement root = this.getMainStatement();
            OntStatement s = first == null ? root : first;
            OntGraphModelImpl m = this.getModel();
            Resource r = m.createResource();
            if (this.listType != null) {
                m.add(r, RDF.type, (RDFNode)this.listType);
            }
            m.add(r, RDF.first, (RDFNode)e).add(r, RDF.rest, (RDFNode)(first == null ? RDF.nil : s.getSubject())).add(this.subject, this.predicate, (RDFNode)r).remove((Statement)root);
            return (RDFList)r.as(RDFList.class);
        });
    }

    @Override
    public OntList<E> removeLast() {
        return this.setRDFList(list -> {
            List<Statement> stmps = this.getLastTwoRestStatements();
            if (stmps == null) {
                return list;
            }
            OntGraphModelImpl m = this.getModel();
            Resource last = stmps.get(stmps.size() - 1).getSubject();
            OntStatement prev = stmps.size() == 1 ? this.getMainStatement() : stmps.get(0);
            m.add(prev.getSubject(), prev.getPredicate(), (RDFNode)RDF.nil).removeAll(last, null, null).remove(prev);
            return stmps.size() == 1 ? (RDFList)RDF.nil.inModel((Model)m).as(RDFList.class) : list;
        });
    }

    @Override
    public OntList<E> removeFirst() throws PropertyNotFoundException {
        return this.setRDFList(list -> {
            List<Statement> stmps = this.getFirstTwoRestStatements();
            if (stmps == null) {
                return list;
            }
            OntGraphModelImpl m = this.getModel();
            OntStatement root = this.getMainStatement();
            Resource first = stmps.get(0).getSubject();
            Resource next = stmps.size() == 1 ? RDF.nil.inModel((Model)m) : stmps.get(1).getSubject();
            m.add(root.getSubject(), root.getPredicate(), (RDFNode)next).removeAll(first, null, null).remove(root);
            return (RDFList)next.as(RDFList.class);
        });
    }

    @Override
    public OntList<E> clear() {
        return this.setRDFList(list -> {
            OntGraphModelImpl m = this.getModel();
            RDFList res = (RDFList)RDF.nil.inModel((Model)m).as(RDFList.class);
            Iterator<List<Triple>> it = this.createRDFListIterator();
            if (it == null) {
                return res;
            }
            OntStatement root = this.getMainStatement();
            if (!it.hasNext()) {
                throw new OntJenaException.IllegalState("The list " + this + " does not contain any items.");
            }
            Graph g = m.getGraph();
            do {
                it.next().forEach(arg_0 -> ((Graph)g).delete(arg_0));
            } while (it.hasNext());
            m.remove(root).add(root.getSubject(), root.getPredicate(), (RDFNode)res);
            return res;
        });
    }

    public Statement getFirstRestStatement() {
        Iterator<List<Triple>> it = this.createRDFListIterator();
        if (it == null) {
            return null;
        }
        if (!it.hasNext()) {
            throw new OntJenaException.IllegalState("Can't find any []-list batch in the list " + this);
        }
        return this.getRestStatement(it.next());
    }

    public Statement getLastRestStatement() {
        List<Triple> res;
        Iterator<List<Triple>> it = this.createRDFListIterator();
        if (it == null) {
            return null;
        }
        if (!it.hasNext()) {
            throw new OntJenaException.IllegalState("Can't find any []-list batch in the list " + this);
        }
        do {
            res = it.next();
        } while (it.hasNext());
        return this.getRestStatement(res);
    }

    public List<Statement> getFirstTwoRestStatements() {
        Iterator<List<Triple>> it = this.createRDFListIterator();
        if (it == null) {
            return null;
        }
        if (!it.hasNext()) {
            throw new OntJenaException.IllegalState("Can't find any []-list batch in the list " + this);
        }
        ArrayList<Statement> res = new ArrayList<Statement>();
        res.add(this.getRestStatement(it.next()));
        if (it.hasNext()) {
            res.add(this.getRestStatement(it.next()));
        }
        return res;
    }

    public List<Statement> getLastTwoRestStatements() {
        Iterator<List<Triple>> it = this.createRDFListIterator();
        if (it == null) {
            return null;
        }
        List<Triple> prev = null;
        List<Triple> last = null;
        while (it.hasNext()) {
            prev = last;
            last = it.next();
        }
        if (last == null) {
            throw new OntJenaException.IllegalState("Can't find last []-list batch in the list " + this);
        }
        return Stream.of(prev, last).filter(Objects::nonNull).map(this::getRestStatement).collect(Collectors.toList());
    }

    private Statement getRestStatement(List<Triple> triples) {
        OntGraphModelImpl m = this.getModel();
        return triples.stream().filter(s -> RDF.rest.asNode().equals((Object)s.getPredicate())).map(m::asStatement).findFirst().orElseThrow(() -> new OntJenaException.IllegalState("Can't find rdf:rest in the batch " + triples));
    }

    @Override
    public OntList<E> get(int index) throws PropertyNotFoundException, OntJenaException.IllegalArgument {
        if (index < 0) {
            throw new OntJenaException.IllegalArgument("Negative index: " + index);
        }
        if (index == 0) {
            return this;
        }
        RDFList list = this.getRDFList();
        int i = 0;
        OntGraphModelImpl m = this.getModel();
        while (!OntListImpl.isNil((RDFNode)list)) {
            Statement rest = list.getRequiredProperty(RDF.rest);
            list = (RDFList)rest.getObject().as(RDFList.class);
            if (++i != index) continue;
            return new OntListImpl<E>(rest.getSubject(), rest.getPredicate(), list, this.listType, m, this.elementType){

                @Override
                public OntStatement getMainStatement() {
                    return OntStatementImpl.createNotAnnotatedOntStatementImpl(this.subject, this.predicate, (RDFNode)this.getRDFList(), (OntGraphModelImpl)this.getModel());
                }

                @Override
                public boolean isValid(RDFNode n) {
                    return OntListImpl.this.isValid(n);
                }

                @Override
                public E cast(RDFNode n) {
                    return OntListImpl.this.cast(n);
                }
            };
        }
        throw new OntJenaException.IllegalArgument("Index out of bounds: " + index);
    }

    public static class RDFListIterator
    implements Iterator<List<Triple>> {
        public static final Node REST = RDF.rest.asNode();
        public static final Node NIL = RDF.nil.asNode();
        private final Graph graph;
        private Node head;

        public RDFListIterator(Graph graph, Node head) {
            this.graph = Objects.requireNonNull(graph);
            this.head = Objects.requireNonNull(head);
        }

        @Override
        public boolean hasNext() {
            return this.head != null && !NIL.equals((Object)this.head);
        }

        @Override
        public List<Triple> next() throws NoSuchElementException {
            Node next = null;
            ArrayList<Triple> triples = new ArrayList<Triple>();
            ExtendedIterator it = this.graph.find(this.head, Node.ANY, Node.ANY);
            while (it.hasNext()) {
                Triple t = (Triple)it.next();
                triples.add(t);
                if (!REST.equals((Object)t.getPredicate())) continue;
                next = t.getObject();
            }
            this.head = next;
            if (next == null) {
                throw new NoSuchElementException("No element found: " + triples);
            }
            return triples;
        }
    }

    public static class SafeRDFListIterator
    extends RDFListIterator {
        public SafeRDFListIterator(Graph graph, Node head) {
            super(graph, head);
        }

        @Override
        public List<Triple> next() {
            try {
                return super.next();
            }
            catch (NoSuchElementException n) {
                return null;
            }
        }
    }
}

