/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.Factories;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntFilter;
import com.github.owlcs.ontapi.jena.impl.conf.OntFinder;
import com.github.owlcs.ontapi.jena.model.OntID;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;

public class OntIDImpl
extends OntObjectImpl
implements OntID {
    public static ObjectFactory idFactory = Factories.createCommon(OntIDImpl.class, (OntFinder)new OntFinder.ByType(OWL.Ontology), (OntFilter)new OntFilter.HasType(OWL.Ontology), new OntFilter[0]);

    public OntIDImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    @Override
    public String getVersionIRI() {
        Statement st = this.getProperty(OWL.versionIRI);
        if (st == null || !st.getObject().isURIResource()) {
            return null;
        }
        return st.getObject().asResource().getURI();
    }

    @Override
    public OntIDImpl setVersionIRI(String uri) throws OntApiException {
        if (uri != null && this.isAnon()) {
            throw new OntJenaException.IllegalArgument("Attempt to add version IRI (" + uri + ") to anonymous ontology (" + this.asNode().toString() + ").");
        }
        this.removeAll(OWL.versionIRI);
        if (uri != null) {
            this.addProperty(OWL.versionIRI, (RDFNode)this.getModel().createResource(uri));
        }
        return this;
    }

    @Override
    public OntIDImpl addImport(String uri) throws OntApiException {
        if (OntJenaException.notNull(uri, "Null uri specified.").equals(this.getURI())) {
            throw new OntJenaException.IllegalArgument("Can't import itself: " + uri);
        }
        this.addImportResource(this.getModel().createResource(uri));
        return this;
    }

    @Override
    public OntIDImpl removeImport(String uri) {
        Resource r = this.getModel().createResource(OntJenaException.notNull(uri, "Null uri specified."));
        this.removeImportResource(r);
        return this;
    }

    @Override
    public Stream<String> imports() {
        return Iter.asStream(this.listImportResources().mapWith(Resource::getURI), this.getCharacteristics());
    }

    public ExtendedIterator<Resource> listImportResources() {
        return this.listObjects(OWL.imports).filterKeep(RDFNode::isURIResource).mapWith(RDFNode::asResource);
    }

    public void addImportResource(Resource uri) {
        this.addProperty(OWL.imports, (RDFNode)uri);
    }

    public void removeImportResource(Resource uri) {
        this.getModel().remove(this, OWL.imports, (RDFNode)uri);
    }

    @Override
    public String toString() {
        String iri = this.asNode().toString();
        String ver = this.getVersionIRI();
        if (ver != null) {
            return iri + "(" + ver + ")";
        }
        return iri;
    }
}

