/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.UnionGraph;
import com.github.owlcs.ontapi.jena.impl.OntCEImpl;
import com.github.owlcs.ontapi.jena.impl.OntDRImpl;
import com.github.owlcs.ontapi.jena.impl.OntDisjointImpl;
import com.github.owlcs.ontapi.jena.impl.OntFRImpl;
import com.github.owlcs.ontapi.jena.impl.OntIndividualImpl;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.OntSWRLImpl;
import com.github.owlcs.ontapi.jena.impl.OntStatementImpl;
import com.github.owlcs.ontapi.jena.impl.PersonalityModel;
import com.github.owlcs.ontapi.jena.impl.UnionModel;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntDisjoint;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import com.github.owlcs.ontapi.jena.model.OntFacetRestriction;
import com.github.owlcs.ontapi.jena.model.OntID;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntList;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntSWRL;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Graphs;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.InfModelImpl;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class OntGraphModelImpl
extends UnionModel
implements OntModel,
PersonalityModel {
    protected final Map<String, RDFDatatype> dtTypes = new HashMap<String, RDFDatatype>();

    public OntGraphModelImpl(Graph graph, OntPersonality personality) {
        super(graph, OntPersonality.asJenaPersonality(personality));
    }

    public static Resource createOntologyID(Model model, String uri) throws OntJenaException {
        return OntGraphModelImpl.createOntologyID(model, uri == null ? NodeFactory.createBlankNode() : NodeFactory.createURI((String)uri));
    }

    public static Resource createOntologyID(Model model, Node node) throws OntJenaException, IllegalArgumentException {
        if (!Objects.requireNonNull(node, "Null node").isURI() && !node.isBlank()) {
            throw new IllegalArgumentException("Expected uri or blank node: " + node);
        }
        List prev = Iter.flatMap(model.listStatements(null, RDF.type, (RDFNode)OWL.Ontology), s -> s.getSubject().listProperties()).toList();
        if (prev.stream().filter(s -> OWL.imports.equals(s.getPredicate())).map(Statement::getObject).filter(RDFNode::isURIResource).map(FrontsNode::asNode).anyMatch(arg_0 -> ((Node)node).equals(arg_0))) {
            throw new OntJenaException.IllegalArgument("Can't create ontology: the specified uri (<" + node + ">) is present in the imports.");
        }
        model.remove(prev);
        Resource res = model.wrapAsResource(node).addProperty(RDF.type, (RDFNode)OWL.Ontology);
        prev.forEach(s -> res.addProperty(s.getPredicate(), s.getObject()));
        return res;
    }

    public static <M extends EnhGraph, O extends OntObject> ExtendedIterator<O> listOntObjects(M m, Class<? extends O> type) {
        return ((PersonalityModel)m).getOntPersonality().getObjectFactory(type).iterator(m).mapWith(e -> (OntObject)m.getNodeAs(e.asNode(), type));
    }

    public static <M extends OntModel & PersonalityModel> ExtendedIterator<OntIndividual> listIndividuals(M model, Set<Node> system, ExtendedIterator<Triple> assertions) {
        HashSet seen = new HashSet();
        return assertions.mapWith(t -> {
            if (system.contains(t.getObject())) {
                return null;
            }
            if (seen.remove(t)) {
                return null;
            }
            if (((PersonalityModel)((Object)model)).findNodeAs(t.getObject(), OntClass.class) == null) {
                return null;
            }
            return model.asStatement((Triple)t);
        }).filterKeep(s -> {
            if (s == null) {
                return false;
            }
            OntIndividual i = s.getSubject().getAs(OntIndividual.class);
            if (i == null) {
                return false;
            }
            ((OntIndividualImpl)i).listClasses().forEachRemaining(x -> {
                if (s.getObject().equals(x)) {
                    return;
                }
                seen.add(Triple.create((Node)i.asNode(), (Node)RDF.Nodes.type, (Node)x.asNode()));
            });
            return true;
        }).mapWith(s -> s.getSubject(OntIndividual.class));
    }

    private static <X> Stream<X> asStream(Graph graph, ExtendedIterator<X> it, boolean withSize) {
        int characteristics = OntGraphModelImpl.getSpliteratorCharacteristics(graph);
        long size = -1L;
        if (withSize && Graphs.isSized(graph)) {
            size = Graphs.size(graph);
            characteristics |= 0x40;
        }
        return Iter.asStream(it, size, characteristics);
    }

    protected static int getSpliteratorCharacteristics(Graph graph) {
        int res = 256;
        if (Graphs.isDistinct(graph)) {
            return res | 1;
        }
        return res;
    }

    private static boolean isANY(Resource s, Property p, RDFNode o) {
        if (s != null) {
            return false;
        }
        if (p != null) {
            return false;
        }
        return o == null;
    }

    @Override
    public OntPersonality getOntPersonality() {
        return (OntPersonality)super.getPersonality();
    }

    @Override
    public OntID getID() {
        return this.getNodeAs(Graphs.ontologyNode(this.getBaseGraph()).orElseGet(() -> this.createResource().addProperty(RDF.type, (RDFNode)OWL.Ontology).asNode()), OntID.class);
    }

    @Override
    public OntID setID(String uri) {
        return this.getNodeAs(OntGraphModelImpl.createOntologyID(this.getBaseModel(), uri).asNode(), OntID.class);
    }

    @Override
    public OntGraphModelImpl addImport(OntModel m) {
        if (Objects.requireNonNull(m, "Null model specified.").getID().isAnon()) {
            throw new OntJenaException.IllegalArgument("Anonymous sub models are not allowed.");
        }
        String importsURI = Objects.requireNonNull(m.getID().getImportsIRI());
        if (importsURI.equals(this.getID().getURI())) {
            throw new OntJenaException.IllegalArgument("Attempt to import ontology with the same name: " + importsURI);
        }
        if (this.hasImport(importsURI)) {
            throw new OntJenaException.IllegalArgument("Ontology <" + importsURI + "> is already in imports.");
        }
        this.addImportModel(m.getGraph(), importsURI);
        return this;
    }

    @Override
    public boolean hasImport(OntModel m) {
        Objects.requireNonNull(m);
        return this.findImport(x -> Graphs.isSameBase((Graph)x.getGraph(), m.getGraph())).isPresent();
    }

    @Override
    public boolean hasImport(String uri) {
        return this.findImport(x -> Objects.equals(x.getID().getImportsIRI(), uri)).isPresent();
    }

    @Override
    public OntGraphModelImpl removeImport(OntModel m) {
        Objects.requireNonNull(m);
        this.findImport(x -> Graphs.isSameBase((Graph)x.getGraph(), m.getGraph())).ifPresent(x -> this.removeImportModel((Graph)x.getGraph(), x.getID().getImportsIRI()));
        return this;
    }

    @Override
    public OntGraphModelImpl removeImport(String uri) {
        this.findImport(x -> Objects.equals(uri, x.getID().getImportsIRI())).ifPresent(x -> this.removeImportModel((Graph)x.getGraph(), x.getID().getImportsIRI()));
        return this;
    }

    @Override
    public Stream<OntModel> imports() {
        return this.imports(this.getOntPersonality());
    }

    public Stream<OntModel> imports(OntPersonality personality) {
        return Iter.asStream(this.listImportModels(personality));
    }

    protected Optional<OntGraphModelImpl> findImport(Predicate<OntGraphModelImpl> filter) {
        return Iter.findFirst(this.listImportModels(this.getOntPersonality()).filterKeep(filter));
    }

    protected void addImportModel(Graph g, String u) {
        this.getGraph().addGraph(g);
        this.getID().addImport(u);
    }

    protected void removeImportModel(Graph g, String u) {
        this.getGraph().removeGraph(g);
        this.getID().removeImport(u);
    }

    protected final ExtendedIterator<OntGraphModelImpl> listAllModels(OntPersonality personality) {
        return this.getGraph().listUnionGraphs().mapWith(u -> new OntGraphModelImpl((Graph)u, personality));
    }

    protected final ExtendedIterator<OntGraphModelImpl> listImportModels(OntPersonality personality) {
        return this.listImportGraphs().mapWith(u -> new OntGraphModelImpl((Graph)u, personality));
    }

    protected final ExtendedIterator<UnionGraph> listImportGraphs() {
        return this.getGraph().getUnderlying().listGraphs().filterKeep(x -> x instanceof UnionGraph).mapWith(x -> (UnionGraph)((Object)x));
    }

    public OntGraphModelImpl getTopModel() {
        if (this.independent()) {
            return this;
        }
        return new OntGraphModelImpl(this.getBaseGraph(), this.getOntPersonality());
    }

    public boolean independent() {
        return this.getGraph().getUnderlying().isEmpty();
    }

    @Override
    public InfModel getInferenceModel(Reasoner reasoner) {
        return new InfModelImpl(OntJenaException.notNull(reasoner, "Null reasoner.").bind((Graph)this.getGraph()));
    }

    public <E extends OntObjectImpl> boolean isBuiltIn(E e) {
        return this.getOntPersonality().getBuiltins().get(e.getActualClass()).contains(e.asNode());
    }

    @Override
    public <O extends OntObject> Stream<O> ontObjects(Class<? extends O> type) {
        return Iter.asStream(this.listOntObjects(type), OntGraphModelImpl.getSpliteratorCharacteristics((Graph)this.getGraph()));
    }

    public <O extends OntObject> ExtendedIterator<O> listOntObjects(Class<? extends O> type) {
        return OntGraphModelImpl.listOntObjects(this, type);
    }

    public <O extends OntObject> ExtendedIterator<O> listLocalOntObjects(Class<? extends O> type) {
        return OntGraphModelImpl.listOntObjects(this.getTopModel(), type);
    }

    @Override
    public Stream<OntEntity> ontEntities() {
        return Iter.asStream(this.listOntEntities());
    }

    public ExtendedIterator<OntEntity> listOntEntities() {
        return Iter.flatMap(OntEntity.listEntityTypes(), this::listOntObjects);
    }

    public ExtendedIterator<OntEntity> listLocalOntEntities() {
        return Iter.flatMap(OntEntity.listEntityTypes(), this::listLocalOntObjects);
    }

    public Stream<OntEntity> ambiguousEntities(boolean withImports) {
        Set types = OntEntity.listEntityTypes().toSet();
        return this.ontEntities().filter(e -> withImports || e.isLocal()).filter(e -> types.stream().filter(view -> e.canAs((Class)view) && (withImports || ((OntEntity)e.as((Class)view)).isLocal())).count() > 1L);
    }

    @Override
    public Set<Node> getSystemResources(Class<? extends OntObject> type) {
        return this.getOntPersonality().getReserved().getResources().stream().filter(x -> !OntObjectImpl.wrapAsOntObject(x, (EnhGraph)this).canAs(type)).collect(Iter.toUnmodifiableSet());
    }

    @Override
    public Stream<OntIndividual> individuals() {
        return Iter.asStream(this.listIndividuals(), OntGraphModelImpl.getSpliteratorCharacteristics((Graph)this.getGraph()));
    }

    public ExtendedIterator<OntIndividual> listIndividuals() {
        return OntGraphModelImpl.listIndividuals(this, this.getSystemResources(OntClass.Named.class), (ExtendedIterator<Triple>)this.getGraph().find(Node.ANY, RDF.Nodes.type, Node.ANY));
    }

    @Override
    public <E extends OntEntity> E getOntEntity(Class<E> type, String uri) {
        return (E)((OntEntity)this.findNodeAs(NodeFactory.createURI((String)OntJenaException.notNull(uri, "Null uri.")), type));
    }

    public <T extends OntEntity> T createOntEntity(Class<T> type, String iri) {
        try {
            return (T)((OntEntity)this.createOntObject(type, iri));
        }
        catch (OntJenaException.Creation e) {
            throw new OntJenaException.Creation(String.format("Can't add entity [%s: %s]: perhaps it's illegal punning.", type.getSimpleName(), iri), (Throwable)((Object)e));
        }
    }

    public <T extends OntObject> T createOntObject(Class<T> type, String uri) {
        Node key = Graphs.createNode(uri);
        OntObject res = (OntObject)this.getOntPersonality().getObjectFactory(type).createInGraph(key, (EnhGraph)this).as(type);
        this.getNodeCache().put((Object)key, (Object)res);
        return (T)res;
    }

    @Override
    public OntGraphModelImpl removeOntObject(OntObject obj) {
        obj.clearAnnotations().content().peek(OntStatement::clearAnnotations).collect(Collectors.toSet()).forEach(this::remove);
        this.getNodeCache().remove((Object)obj.asNode());
        return this;
    }

    @Override
    public OntGraphModelImpl removeOntStatement(OntStatement statement) {
        return this.remove(statement.clearAnnotations());
    }

    @Override
    public Stream<OntStatement> statements() {
        UnionGraph g = this.getGraph();
        return OntGraphModelImpl.asStream((Graph)g, g.find().mapWith(this::asStatement), true);
    }

    @Override
    public Stream<OntStatement> statements(Resource s, Property p, RDFNode o) {
        return OntGraphModelImpl.asStream((Graph)this.getGraph(), this.listOntStatements(s, p, o), OntGraphModelImpl.isANY(s, p, o));
    }

    @Override
    public Stream<OntStatement> localStatements(Resource s, Property p, RDFNode o) {
        return OntGraphModelImpl.asStream(this.getBaseGraph(), this.listLocalStatements(s, p, o), OntGraphModelImpl.isANY(s, p, o));
    }

    public StmtIterator listStatements(Resource s, Property p, RDFNode o) {
        return Iter.createStmtIterator((ExtendedIterator<Triple>)this.getGraph().find(OntGraphModelImpl.asNode((RDFNode)s), OntGraphModelImpl.asNode((RDFNode)p), OntGraphModelImpl.asNode((RDFNode)o)), this::asStatement);
    }

    public ExtendedIterator<OntStatement> listOntStatements(Resource s, Property p, RDFNode o) {
        return Iter.create(this.getGraph().find(OntGraphModelImpl.asNode((RDFNode)s), OntGraphModelImpl.asNode((RDFNode)p), OntGraphModelImpl.asNode((RDFNode)o)).mapWith(this::asStatement));
    }

    public ExtendedIterator<OntStatement> listLocalStatements(Resource s, Property p, RDFNode o) {
        return Iter.create(this.getBaseGraph().find(OntGraphModelImpl.asNode((RDFNode)s), OntGraphModelImpl.asNode((RDFNode)p), OntGraphModelImpl.asNode((RDFNode)o)).mapWith(this::asStatement));
    }

    public OntStatementImpl createStatement(Resource s, Property p, RDFNode o) {
        return OntStatementImpl.createOntStatementImpl(s, p, o, this);
    }

    @Override
    public OntStatementImpl asStatement(Triple triple) {
        return OntStatementImpl.createOntStatementImpl(triple, this);
    }

    public ExtendedIterator<Resource> listAnnotations(Resource t, Resource s, Property p, RDFNode o) {
        return this.getGraph().find(Node.ANY, OWL.annotatedSource.asNode(), s.asNode()).mapWith(this::asStatement).filterKeep(x -> (OWL.Axiom == t ? x.belongsToOWLAxiom() : x.belongsToOWLAnnotation()) && x.hasAnnotatedProperty(p) && x.hasAnnotatedTarget(o)).mapWith(Statement::getSubject);
    }

    public OntGraphModelImpl deleteOntList(OntObject subject, Property predicate, OntList<?> object) {
        Objects.requireNonNull(subject);
        Objects.requireNonNull(predicate);
        OntJenaException.notNull(object, "Null list for subject " + subject + " and predicate " + predicate);
        boolean hasNil = !object.isNil() && this.contains(subject, predicate, (RDFNode)RDF.nil);
        object.getMainStatement().clearAnnotations();
        object.clear();
        if (!hasNil) {
            return this.remove(subject, predicate, (RDFNode)object);
        }
        return this;
    }

    @Override
    public OntDisjoint.Classes createDisjointClasses(Collection<OntClass> classes) {
        return OntDisjointImpl.createDisjointClasses(this, classes.stream());
    }

    @Override
    public OntDisjoint.Individuals createDifferentIndividuals(Collection<OntIndividual> individuals) {
        return OntDisjointImpl.createDifferentIndividuals(this, individuals.stream());
    }

    @Override
    public OntDisjoint.ObjectProperties createDisjointObjectProperties(Collection<OntObjectProperty> properties) {
        return OntDisjointImpl.createDisjointObjectProperties(this, properties.stream());
    }

    @Override
    public OntDisjoint.DataProperties createDisjointDataProperties(Collection<OntDataProperty> properties) {
        return OntDisjointImpl.createDisjointDataProperties(this, properties.stream());
    }

    public <T extends OntFacetRestriction> T createFacetRestriction(Class<T> view, Literal literal) {
        return OntFRImpl.create(this, view, literal);
    }

    @Override
    public OntDataRange.OneOf createDataOneOf(Collection<Literal> values) {
        return OntDRImpl.createOneOf(this, values.stream());
    }

    @Override
    public OntDataRange.Restriction createDataRestriction(OntDataRange.Named datatype, Collection<OntFacetRestriction> values) {
        return OntDRImpl.createRestriction(this, datatype, values.stream());
    }

    @Override
    public OntDataRange.ComplementOf createDataComplementOf(OntDataRange other) {
        return OntDRImpl.createComplementOf(this, other);
    }

    @Override
    public OntDataRange.UnionOf createDataUnionOf(Collection<OntDataRange> values) {
        return OntDRImpl.createUnionOf(this, values.stream());
    }

    @Override
    public OntDataRange.IntersectionOf createDataIntersectionOf(Collection<OntDataRange> values) {
        return OntDRImpl.createIntersectionOf(this, values.stream());
    }

    @Override
    public OntClass.ObjectSomeValuesFrom createObjectSomeValuesFrom(OntObjectProperty property, OntClass ce) {
        return OntCEImpl.createComponentRestrictionCE(this, OntClass.ObjectSomeValuesFrom.class, property, (RDFNode)ce, OWL.someValuesFrom);
    }

    @Override
    public OntClass.DataSomeValuesFrom createDataSomeValuesFrom(OntDataProperty property, OntDataRange dr) {
        return OntCEImpl.createComponentRestrictionCE(this, OntClass.DataSomeValuesFrom.class, property, (RDFNode)dr, OWL.someValuesFrom);
    }

    @Override
    public OntClass.ObjectAllValuesFrom createObjectAllValuesFrom(OntObjectProperty property, OntClass ce) {
        return OntCEImpl.createComponentRestrictionCE(this, OntClass.ObjectAllValuesFrom.class, property, (RDFNode)ce, OWL.allValuesFrom);
    }

    @Override
    public OntClass.DataAllValuesFrom createDataAllValuesFrom(OntDataProperty property, OntDataRange dr) {
        return OntCEImpl.createComponentRestrictionCE(this, OntClass.DataAllValuesFrom.class, property, (RDFNode)dr, OWL.allValuesFrom);
    }

    @Override
    public OntClass.ObjectHasValue createObjectHasValue(OntObjectProperty property, OntIndividual individual) {
        return OntCEImpl.createComponentRestrictionCE(this, OntClass.ObjectHasValue.class, property, (RDFNode)individual, OWL.hasValue);
    }

    @Override
    public OntClass.DataHasValue createDataHasValue(OntDataProperty property, Literal literal) {
        return OntCEImpl.createComponentRestrictionCE(this, OntClass.DataHasValue.class, property, (RDFNode)literal, OWL.hasValue);
    }

    @Override
    public OntClass.ObjectMinCardinality createObjectMinCardinality(OntObjectProperty property, int cardinality, OntClass ce) {
        return OntCEImpl.createCardinalityRestrictionCE(this, OntClass.ObjectMinCardinality.class, property, cardinality, ce);
    }

    @Override
    public OntClass.DataMinCardinality createDataMinCardinality(OntDataProperty property, int cardinality, OntDataRange dr) {
        return OntCEImpl.createCardinalityRestrictionCE(this, OntClass.DataMinCardinality.class, property, cardinality, dr);
    }

    @Override
    public OntClass.ObjectMaxCardinality createObjectMaxCardinality(OntObjectProperty property, int cardinality, OntClass ce) {
        return OntCEImpl.createCardinalityRestrictionCE(this, OntClass.ObjectMaxCardinality.class, property, cardinality, ce);
    }

    @Override
    public OntClass.DataMaxCardinality createDataMaxCardinality(OntDataProperty property, int cardinality, OntDataRange dr) {
        return OntCEImpl.createCardinalityRestrictionCE(this, OntClass.DataMaxCardinality.class, property, cardinality, dr);
    }

    @Override
    public OntClass.ObjectCardinality createObjectCardinality(OntObjectProperty property, int cardinality, OntClass ce) {
        return OntCEImpl.createCardinalityRestrictionCE(this, OntClass.ObjectCardinality.class, property, cardinality, ce);
    }

    @Override
    public OntClass.DataCardinality createDataCardinality(OntDataProperty property, int cardinality, OntDataRange dr) {
        return OntCEImpl.createCardinalityRestrictionCE(this, OntClass.DataCardinality.class, property, cardinality, dr);
    }

    @Override
    public OntClass.UnionOf createObjectUnionOf(Collection<OntClass> classes) {
        return OntCEImpl.createComponentsCE(this, OntClass.UnionOf.class, OntClass.class, OWL.unionOf, classes.stream());
    }

    @Override
    public OntClass.IntersectionOf createObjectIntersectionOf(Collection<OntClass> classes) {
        return OntCEImpl.createComponentsCE(this, OntClass.IntersectionOf.class, OntClass.class, OWL.intersectionOf, classes.stream());
    }

    @Override
    public OntClass.OneOf createObjectOneOf(Collection<OntIndividual> individuals) {
        return OntCEImpl.createComponentsCE(this, OntClass.OneOf.class, OntIndividual.class, OWL.oneOf, individuals.stream());
    }

    @Override
    public OntClass.HasSelf createHasSelf(OntObjectProperty property) {
        return OntCEImpl.createHasSelf(this, property);
    }

    @Override
    public OntClass.NaryDataAllValuesFrom createDataAllValuesFrom(Collection<OntDataProperty> properties, OntDataRange dr) {
        return OntCEImpl.createNaryRestrictionCE(this, OntClass.NaryDataAllValuesFrom.class, dr, properties);
    }

    @Override
    public OntClass.NaryDataSomeValuesFrom createDataSomeValuesFrom(Collection<OntDataProperty> properties, OntDataRange dr) {
        return OntCEImpl.createNaryRestrictionCE(this, OntClass.NaryDataSomeValuesFrom.class, dr, properties);
    }

    @Override
    public OntClass.ComplementOf createObjectComplementOf(OntClass ce) {
        return OntCEImpl.createComplementOf(this, ce);
    }

    @Override
    public OntSWRL.Variable createSWRLVariable(String uri) {
        return OntSWRLImpl.createVariable(this, uri);
    }

    @Override
    public OntSWRL.Atom.WithBuiltin createBuiltInSWRLAtom(Resource predicate, Collection<OntSWRL.DArg> arguments) {
        return OntSWRLImpl.createBuiltInAtom(this, predicate, arguments);
    }

    @Override
    public OntSWRL.Atom.WithClass createClassSWRLAtom(OntClass clazz, OntSWRL.IArg arg) {
        return OntSWRLImpl.createClassAtom(this, clazz, arg);
    }

    @Override
    public OntSWRL.Atom.WithDataRange createDataRangeSWRLAtom(OntDataRange range, OntSWRL.DArg arg) {
        return OntSWRLImpl.createDataRangeAtom(this, range, arg);
    }

    @Override
    public OntSWRL.Atom.WithDataProperty createDataPropertySWRLAtom(OntDataProperty dataProperty, OntSWRL.IArg firstArg, OntSWRL.DArg secondArg) {
        return OntSWRLImpl.createDataPropertyAtom(this, dataProperty, firstArg, secondArg);
    }

    @Override
    public OntSWRL.Atom.WithObjectProperty createObjectPropertySWRLAtom(OntObjectProperty dataProperty, OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        return OntSWRLImpl.createObjectPropertyAtom(this, dataProperty, firstArg, secondArg);
    }

    @Override
    public OntSWRL.Atom.WithDifferentIndividuals createDifferentIndividualsSWRLAtom(OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        return OntSWRLImpl.createDifferentIndividualsAtom(this, firstArg, secondArg);
    }

    @Override
    public OntSWRL.Atom.WithSameIndividuals createSameIndividualsSWRLAtom(OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        return OntSWRLImpl.createSameIndividualsAtom(this, firstArg, secondArg);
    }

    @Override
    public OntSWRL.Imp createSWRLImp(Collection<OntSWRL.Atom<?>> head, Collection<OntSWRL.Atom<?>> body) {
        return OntSWRLImpl.createImp(this, head, body);
    }

    public PrefixMapping getPrefixMapping() {
        return this.getGraph().getPrefixMapping();
    }

    @Override
    public OntGraphModelImpl setNsPrefix(String prefix, String uri) {
        this.getPrefixMapping().setNsPrefix(prefix, uri);
        return this;
    }

    @Override
    public OntGraphModelImpl removeNsPrefix(String prefix) {
        this.getPrefixMapping().removeNsPrefix(prefix);
        return this;
    }

    @Override
    public OntGraphModelImpl clearNsPrefixMap() {
        this.getPrefixMapping().clearNsPrefixMap();
        return this;
    }

    @Override
    public OntGraphModelImpl setNsPrefixes(PrefixMapping pm) {
        this.getPrefixMapping().setNsPrefixes(pm);
        return this;
    }

    @Override
    public OntGraphModelImpl setNsPrefixes(Map<String, String> map) {
        this.getPrefixMapping().setNsPrefixes(map);
        return this;
    }

    @Override
    public OntGraphModelImpl withDefaultMappings(PrefixMapping other) {
        this.getPrefixMapping().withDefaultMappings(other);
        return this;
    }

    public OntGraphModelImpl lock() {
        this.getPrefixMapping().lock();
        return this;
    }

    @Override
    public OntGraphModelImpl add(Statement s) {
        super.add(s);
        return this;
    }

    @Override
    public OntGraphModelImpl remove(Statement s) {
        super.remove(s);
        return this;
    }

    @Override
    public OntGraphModelImpl add(Resource s, Property p, RDFNode o) {
        super.add(s, p, o);
        return this;
    }

    @Override
    public OntGraphModelImpl remove(Resource s, Property p, RDFNode o) {
        super.remove(s, p, o);
        return this;
    }

    @Override
    public OntGraphModelImpl add(Model m) {
        super.add(m);
        return this;
    }

    @Override
    public OntGraphModelImpl remove(Model m) {
        super.remove(m);
        return this;
    }

    @Override
    public OntGraphModelImpl add(StmtIterator iter) {
        super.add(iter);
        return this;
    }

    @Override
    public OntGraphModelImpl remove(StmtIterator iter) {
        super.remove(iter);
        return this;
    }

    @Override
    public OntGraphModelImpl removeAll(Resource s, Property p, RDFNode o) {
        super.removeAll(s, p, o);
        return this;
    }

    @Override
    public OntGraphModelImpl removeAll() {
        super.removeAll();
        return this;
    }

    @Override
    public OntGraphModelImpl write(Writer writer) {
        super.write(writer);
        return this;
    }

    @Override
    public OntGraphModelImpl write(Writer writer, String lang) {
        super.write(writer, lang);
        return this;
    }

    @Override
    public OntGraphModelImpl write(Writer writer, String lang, String base) {
        super.write(writer, lang, base);
        return this;
    }

    @Override
    public OntGraphModelImpl write(OutputStream out) {
        super.write(out);
        return this;
    }

    @Override
    public OntGraphModelImpl write(OutputStream out, String lang) {
        super.write(out, lang);
        return this;
    }

    @Override
    public OntGraphModelImpl write(OutputStream out, String lang, String base) {
        super.write(out, lang, base);
        return this;
    }

    @Override
    public OntAnnotationProperty getRDFSComment() {
        return this.findNodeAs(RDFS.Nodes.comment, OntAnnotationProperty.class);
    }

    @Override
    public OntAnnotationProperty getRDFSLabel() {
        return this.findNodeAs(RDFS.Nodes.label, OntAnnotationProperty.class);
    }

    @Override
    public OntClass.Named getOWLThing() {
        return this.findNodeAs(OWL.Thing.asNode(), OntClass.Named.class);
    }

    @Override
    public OntDataRange.Named getRDFSLiteral() {
        return this.findNodeAs(RDFS.Literal.asNode(), OntDataRange.Named.class);
    }

    @Override
    public OntClass.Named getOWLNothing() {
        return this.findNodeAs(OWL.Nothing.asNode(), OntClass.Named.class);
    }

    @Override
    public OntObjectProperty.Named getOWLTopObjectProperty() {
        return this.findNodeAs(OWL.topObjectProperty.asNode(), OntObjectProperty.Named.class);
    }

    @Override
    public OntObjectProperty.Named getOWLBottomObjectProperty() {
        return this.findNodeAs(OWL.bottomObjectProperty.asNode(), OntObjectProperty.Named.class);
    }

    @Override
    public OntDataProperty getOWLTopDataProperty() {
        return this.findNodeAs(OWL.topDataProperty.asNode(), OntDataProperty.class);
    }

    @Override
    public OntDataProperty getOWLBottomDataProperty() {
        return this.findNodeAs(OWL.bottomDataProperty.asNode(), OntDataProperty.class);
    }

    @Override
    public String toString() {
        return String.format("OntGraphModel{%s}", Graphs.getName(this.getBaseGraph()));
    }
}

