/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.Factories;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntFilter;
import com.github.owlcs.ontapi.jena.impl.conf.OntFinder;
import com.github.owlcs.ontapi.jena.model.OntFacetRestriction;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import com.github.owlcs.ontapi.jena.vocabulary.XSD;
import java.util.Optional;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public abstract class OntFRImpl
extends OntObjectImpl
implements OntFacetRestriction {
    public static ObjectFactory lengthFRFactory = Factories.createCommon(LengthImpl.class, OntFRImpl.makeFinder(XSD.length), OntFRImpl.makeFilter(XSD.length), new OntFilter[0]);
    public static ObjectFactory minLengthFRFactory = Factories.createCommon(MinLengthImpl.class, OntFRImpl.makeFinder(XSD.minLength), OntFRImpl.makeFilter(XSD.minLength), new OntFilter[0]);
    public static ObjectFactory maxLengthFRFactory = Factories.createCommon(MaxLengthImpl.class, OntFRImpl.makeFinder(XSD.maxLength), OntFRImpl.makeFilter(XSD.maxLength), new OntFilter[0]);
    public static ObjectFactory minInclusiveFRFactory = Factories.createCommon(MinInclusiveImpl.class, OntFRImpl.makeFinder(XSD.minInclusive), OntFRImpl.makeFilter(XSD.minInclusive), new OntFilter[0]);
    public static ObjectFactory maxInclusiveFRFactory = Factories.createCommon(MaxInclusiveImpl.class, OntFRImpl.makeFinder(XSD.maxInclusive), OntFRImpl.makeFilter(XSD.maxInclusive), new OntFilter[0]);
    public static ObjectFactory minExclusiveFRFactory = Factories.createCommon(MinExclusiveImpl.class, OntFRImpl.makeFinder(XSD.minExclusive), OntFRImpl.makeFilter(XSD.minExclusive), new OntFilter[0]);
    public static ObjectFactory maxExclusiveFRFactory = Factories.createCommon(MaxExclusiveImpl.class, OntFRImpl.makeFinder(XSD.maxExclusive), OntFRImpl.makeFilter(XSD.maxExclusive), new OntFilter[0]);
    public static ObjectFactory totalDigitsFRFactory = Factories.createCommon(TotalDigitsImpl.class, OntFRImpl.makeFinder(XSD.totalDigits), OntFRImpl.makeFilter(XSD.totalDigits), new OntFilter[0]);
    public static ObjectFactory fractionDigitsFRFactory = Factories.createCommon(FractionDigitsImpl.class, OntFRImpl.makeFinder(XSD.fractionDigits), OntFRImpl.makeFilter(XSD.fractionDigits), new OntFilter[0]);
    public static ObjectFactory patternFRFactory = Factories.createCommon(PatternImpl.class, OntFRImpl.makeFinder(XSD.pattern), OntFRImpl.makeFilter(XSD.pattern), new OntFilter[0]);
    public static ObjectFactory langRangeFRFactory = Factories.createCommon(LangRangeImpl.class, OntFRImpl.makeFinder(RDF.langRange), OntFRImpl.makeFilter(RDF.langRange), new OntFilter[0]);
    public static ObjectFactory abstractFRFactory = Factories.createFrom(OntFinder.ANY_BLANK_SUBJECT, OntFacetRestriction.Length.class, OntFacetRestriction.MinLength.class, OntFacetRestriction.MaxLength.class, OntFacetRestriction.MinInclusive.class, OntFacetRestriction.MaxInclusive.class, OntFacetRestriction.MinExclusive.class, OntFacetRestriction.MaxExclusive.class, OntFacetRestriction.TotalDigits.class, OntFacetRestriction.FractionDigits.class, OntFacetRestriction.Pattern.class, OntFacetRestriction.LangRange.class);

    public OntFRImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return Optional.of(this.getModel().createStatement(this, OntFRImpl.predicate(this.getActualClass()), (RDFNode)this.getValue()));
    }

    @Override
    public Literal getValue() {
        return this.getRequiredObject(OntFRImpl.predicate(this.getActualClass()), Literal.class);
    }

    private static OntFinder makeFinder(Property predicate) {
        return new OntFinder.ByPredicate(predicate);
    }

    private static OntFilter makeFilter(Property predicate) {
        return OntFilter.BLANK.and((n, g) -> !g.asGraph().find(n, predicate.asNode(), Node.ANY).mapWith(Triple::getObject).filterKeep(Node::isLiteral).toList().isEmpty());
    }

    private static Property predicate(Class<?> view) {
        if (OntFacetRestriction.Length.class.equals(view)) {
            return XSD.length;
        }
        if (OntFacetRestriction.MinLength.class.equals(view)) {
            return XSD.minLength;
        }
        if (OntFacetRestriction.MaxLength.class.equals(view)) {
            return XSD.maxLength;
        }
        if (OntFacetRestriction.MinInclusive.class.equals(view)) {
            return XSD.minInclusive;
        }
        if (OntFacetRestriction.MaxInclusive.class.equals(view)) {
            return XSD.maxInclusive;
        }
        if (OntFacetRestriction.MinExclusive.class.equals(view)) {
            return XSD.minExclusive;
        }
        if (OntFacetRestriction.MaxExclusive.class.equals(view)) {
            return XSD.maxExclusive;
        }
        if (OntFacetRestriction.TotalDigits.class.equals(view)) {
            return XSD.totalDigits;
        }
        if (OntFacetRestriction.FractionDigits.class.equals(view)) {
            return XSD.fractionDigits;
        }
        if (OntFacetRestriction.Pattern.class.equals(view)) {
            return XSD.pattern;
        }
        if (OntFacetRestriction.LangRange.class.equals(view)) {
            return RDF.langRange;
        }
        throw new OntJenaException.Unsupported("Unsupported facet restriction " + view);
    }

    public static <T extends OntFacetRestriction> T create(OntGraphModelImpl model, Class<T> view, Literal literal) {
        Resource res = model.createResource();
        res.addProperty(OntFRImpl.predicate(view), (RDFNode)literal);
        return (T)((OntFacetRestriction)model.getNodeAs(res.asNode(), view));
    }

    public static class LangRangeImpl
    extends OntFRImpl
    implements OntFacetRestriction.LangRange {
        public LangRangeImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.LangRange> getActualClass() {
            return OntFacetRestriction.LangRange.class;
        }
    }

    public static class FractionDigitsImpl
    extends OntFRImpl
    implements OntFacetRestriction.FractionDigits {
        public FractionDigitsImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.FractionDigits> getActualClass() {
            return OntFacetRestriction.FractionDigits.class;
        }
    }

    public static class TotalDigitsImpl
    extends OntFRImpl
    implements OntFacetRestriction.TotalDigits {
        public TotalDigitsImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.TotalDigits> getActualClass() {
            return OntFacetRestriction.TotalDigits.class;
        }
    }

    public static class PatternImpl
    extends OntFRImpl
    implements OntFacetRestriction.Pattern {
        public PatternImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.Pattern> getActualClass() {
            return OntFacetRestriction.Pattern.class;
        }
    }

    public static class MaxExclusiveImpl
    extends OntFRImpl
    implements OntFacetRestriction.MaxExclusive {
        public MaxExclusiveImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.MaxExclusive> getActualClass() {
            return OntFacetRestriction.MaxExclusive.class;
        }
    }

    public static class MinExclusiveImpl
    extends OntFRImpl
    implements OntFacetRestriction.MinExclusive {
        public MinExclusiveImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.MinExclusive> getActualClass() {
            return OntFacetRestriction.MinExclusive.class;
        }
    }

    public static class MaxInclusiveImpl
    extends OntFRImpl
    implements OntFacetRestriction.MaxInclusive {
        public MaxInclusiveImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.MaxInclusive> getActualClass() {
            return OntFacetRestriction.MaxInclusive.class;
        }
    }

    public static class MinInclusiveImpl
    extends OntFRImpl
    implements OntFacetRestriction.MinInclusive {
        public MinInclusiveImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.MinInclusive> getActualClass() {
            return OntFacetRestriction.MinInclusive.class;
        }
    }

    public static class MaxLengthImpl
    extends OntFRImpl
    implements OntFacetRestriction.MaxLength {
        public MaxLengthImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.MaxLength> getActualClass() {
            return OntFacetRestriction.MaxLength.class;
        }
    }

    public static class MinLengthImpl
    extends OntFRImpl
    implements OntFacetRestriction.MinLength {
        public MinLengthImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.MinLength> getActualClass() {
            return OntFacetRestriction.MinLength.class;
        }
    }

    public static class LengthImpl
    extends OntFRImpl
    implements OntFacetRestriction.Length {
        public LengthImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.Length> getActualClass() {
            return OntFacetRestriction.Length.class;
        }
    }
}

