/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.Factories;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.OntListImpl;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.PersonalityModel;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntFilter;
import com.github.owlcs.ontapi.jena.impl.conf.OntFinder;
import com.github.owlcs.ontapi.jena.impl.conf.OntMaker;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDisjoint;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntRealProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.RDFListImpl;
import org.apache.jena.util.iterator.ExtendedIterator;

public abstract class OntDisjointImpl<O extends OntObject>
extends OntObjectImpl
implements OntDisjoint<O> {
    public static final OntFinder PROPERTIES_FINDER = new OntFinder.ByType(OWL.AllDisjointProperties);
    public static ObjectFactory disjointClassesFactory = OntDisjointImpl.createFactory(ClassesImpl.class, OWL.AllDisjointClasses, OntClass.class, true, OWL.members);
    public static ObjectFactory differentIndividualsFactory = OntDisjointImpl.createFactory(IndividualsImpl.class, OWL.AllDifferent, OntIndividual.class, true, OWL.members, OWL.distinctMembers);
    public static ObjectFactory objectPropertiesFactory = OntDisjointImpl.createFactory(ObjectPropertiesImpl.class, OWL.AllDisjointProperties, OntObjectProperty.class, false, OWL.members);
    public static ObjectFactory dataPropertiesFactory = OntDisjointImpl.createFactory(DataPropertiesImpl.class, OWL.AllDisjointProperties, OntDataProperty.class, false, OWL.members);
    public static ObjectFactory abstractPropertiesFactory = Factories.createFrom(PROPERTIES_FINDER, OntDisjoint.ObjectProperties.class, OntDisjoint.DataProperties.class);
    public static OntFinder DISJOINT_FINDER = Factories.createFinder(OWL.AllDisjointClasses, OWL.AllDifferent, OWL.AllDisjointProperties);
    public static ObjectFactory abstractDisjointFactory = Factories.createFrom(DISJOINT_FINDER, OntDisjoint.ObjectProperties.class, OntDisjoint.DataProperties.class, OntDisjoint.Classes.class, OntDisjoint.Individuals.class);

    public OntDisjointImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntDisjointImpl.getRequiredRootStatement(this, this.getResourceType());
    }

    protected Property getPredicate() {
        return OWL.members;
    }

    protected abstract Class<O> getComponentType();

    protected abstract Resource getResourceType();

    @Override
    public Stream<O> members() {
        return Iter.asStream(this.listMembers());
    }

    public ExtendedIterator<O> listMembers() {
        return ((OntListImpl)this.getList()).listMembers();
    }

    @Override
    public OntListImpl<O> getList() {
        return OntListImpl.asOntList(this.getRequiredObject(this.getPredicate(), RDFList.class), this.getModel(), this, this.getPredicate(), null, this.getComponentType());
    }

    @Override
    public ExtendedIterator<OntStatement> listSpec() {
        return Iter.concat(super.listSpec(), ((OntListImpl)this.getList()).listContent());
    }

    private static ObjectFactory createFactory(Class<? extends OntDisjointImpl<?>> impl, Resource type, Class<? extends RDFNode> view, boolean allowEmptyList, Property ... predicates) {
        OntMaker.WithType maker = new OntMaker.WithType(impl, type);
        OntFinder.ByType finder = new OntFinder.ByType(type);
        OntFilter filter = OntFilter.BLANK.and(new OntFilter.HasType(type));
        return Factories.createCommon(maker, (OntFinder)finder, filter.and(OntDisjointImpl.getHasPredicatesFilter(predicates)).and(OntDisjointImpl.getHasMembersOfFilter(view, allowEmptyList, predicates)), new OntFilter[0]);
    }

    private static OntFilter getHasPredicatesFilter(Property ... predicates) {
        OntFilter res = OntFilter.FALSE;
        for (Property p : predicates) {
            res = res.or(new OntFilter.HasPredicate(p));
        }
        return res;
    }

    private static OntFilter getHasMembersOfFilter(Class<? extends RDFNode> view, boolean allowEmptyList, Property ... predicates) {
        return (node, eg) -> {
            try (ExtendedIterator<Node> res = OntDisjointImpl.listRoots(node, eg.asGraph(), predicates);){
                while (res.hasNext()) {
                    if (!OntDisjointImpl.testList((Node)res.next(), eg, view, allowEmptyList)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        };
    }

    private static ExtendedIterator<Node> listRoots(Node node, Graph graph, Property ... predicates) {
        return Iter.flatMap(Iter.of(predicates), p -> graph.find(node, p.asNode(), Node.ANY).mapWith(Triple::getObject));
    }

    private static boolean testList(Node node, EnhGraph graph, Class<? extends RDFNode> view, boolean allowEmptyList) {
        if (!RDFListImpl.factory.canWrap(node, graph)) {
            return false;
        }
        if (view == null) {
            return true;
        }
        RDFList list = (RDFList)RDFListImpl.factory.wrap(node, graph).as(RDFList.class);
        return list.isEmpty() && allowEmptyList || Iter.anyMatch(list.iterator().mapWith(FrontsNode::asNode), n -> PersonalityModel.canAs(view, n, graph));
    }

    public static OntDisjoint.Classes createDisjointClasses(OntGraphModelImpl model, Stream<OntClass> classes) {
        return OntDisjointImpl.create(model, OWL.AllDisjointClasses, OntDisjoint.Classes.class, OntClass.class, classes);
    }

    public static OntDisjoint.Individuals createDifferentIndividuals(OntGraphModelImpl model, Stream<OntIndividual> individuals) {
        return OntDisjointImpl.create(model, OWL.AllDifferent, OntDisjoint.Individuals.class, OntIndividual.class, individuals);
    }

    public static OntDisjoint.ObjectProperties createDisjointObjectProperties(OntGraphModelImpl model, Stream<OntObjectProperty> properties) {
        return OntDisjointImpl.create(model, OWL.AllDisjointProperties, OntDisjoint.ObjectProperties.class, OntObjectProperty.class, properties);
    }

    public static OntDisjoint.DataProperties createDisjointDataProperties(OntGraphModelImpl model, Stream<OntDataProperty> properties) {
        return OntDisjointImpl.create(model, OWL.AllDisjointProperties, OntDisjoint.DataProperties.class, OntDataProperty.class, properties);
    }

    public static <R extends OntDisjoint<?>, E extends OntObject> R create(OntGraphModelImpl model, Resource type, Class<R> resultType, Class<E> memberType, Stream<E> members) {
        OntJenaException.notNull(members, "Null " + OntObjectImpl.viewAsString(memberType) + " members stream.");
        Resource res = model.createResource().addProperty(RDF.type, (RDFNode)type).addProperty(OWL.members, (RDFNode)model.createList(members.peek(x -> OntJenaException.notNull(x, "OntDisjoint: Null " + OntObjectImpl.viewAsString(memberType) + " is specified")).iterator()));
        return (R)((OntDisjoint)model.getNodeAs(res.asNode(), resultType));
    }

    public static class DataPropertiesImpl
    extends PropertiesImpl<OntDataProperty>
    implements OntDisjoint.DataProperties {
        public DataPropertiesImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntDisjoint.DataProperties.class;
        }

        @Override
        protected Class<OntDataProperty> getComponentType() {
            return OntDataProperty.class;
        }
    }

    public static class ObjectPropertiesImpl
    extends PropertiesImpl<OntObjectProperty>
    implements OntDisjoint.ObjectProperties {
        public ObjectPropertiesImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntDisjoint.ObjectProperties.class;
        }

        @Override
        protected Class<OntObjectProperty> getComponentType() {
            return OntObjectProperty.class;
        }
    }

    public static abstract class PropertiesImpl<P extends OntRealProperty>
    extends OntDisjointImpl<P>
    implements OntDisjoint.Properties<P> {
        public PropertiesImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        protected Resource getResourceType() {
            return OWL.AllDisjointProperties;
        }
    }

    public static class IndividualsImpl
    extends OntDisjointImpl<OntIndividual>
    implements OntDisjoint.Individuals {
        public IndividualsImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public ExtendedIterator<OntIndividual> listMembers() {
            return Iter.flatMap(this.lists(), OntListImpl::listMembers);
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iter.concat(super.listSpec(), Iter.flatMap(this.lists(), OntListImpl::listContent));
        }

        public ExtendedIterator<Property> listPredicates() {
            return Iter.of(new Property[]{this.getPredicate(), this.getAlternativePredicate()});
        }

        public ExtendedIterator<OntListImpl<OntIndividual>> lists() {
            return this.listPredicates().mapWith(this::findList).filterKeep(Optional::isPresent).mapWith(Optional::get);
        }

        @Override
        public OntListImpl<OntIndividual> getList() {
            Optional<OntListImpl<OntIndividual>> p = this.findList(this.getPredicate());
            Optional<OntListImpl<OntIndividual>> a = this.findList(this.getAlternativePredicate());
            if (p.isPresent() && a.isPresent()) {
                if (p.get().size() > a.get().size()) {
                    return p.get();
                }
                if (p.get().size() < a.get().size()) {
                    return a.get();
                }
            }
            if (p.isPresent()) {
                return p.get();
            }
            if (a.isPresent()) {
                return a.get();
            }
            throw new OntJenaException.IllegalState("Neither owl:members or owl:distinctMembers could be found");
        }

        public Optional<OntListImpl<OntIndividual>> findList(Property predicate) {
            if (!this.hasProperty(predicate)) {
                return Optional.empty();
            }
            return Optional.of(OntListImpl.asOntList(this.getRequiredObject(predicate, RDFList.class), this.getModel(), this, predicate, null, this.getComponentType()));
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntDisjoint.Individuals.class;
        }

        protected Property getAlternativePredicate() {
            return OWL.distinctMembers;
        }

        @Override
        protected Class<OntIndividual> getComponentType() {
            return OntIndividual.class;
        }

        @Override
        protected Resource getResourceType() {
            return OWL.AllDifferent;
        }
    }

    public static class ClassesImpl
    extends OntDisjointImpl<OntClass>
    implements OntDisjoint.Classes {
        public ClassesImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntDisjoint.Classes.class;
        }

        @Override
        protected Class<OntClass> getComponentType() {
            return OntClass.class;
        }

        @Override
        protected Resource getResourceType() {
            return OWL.AllDisjointClasses;
        }
    }
}

