/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.Factories;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.OntStatementImpl;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntFilter;
import com.github.owlcs.ontapi.jena.model.OntAnnotation;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.Models;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;

public class OntAnnotationImpl
extends OntObjectImpl
implements OntAnnotation {
    public static final Set<Property> REQUIRED_PROPERTIES = Stream.of(OWL.annotatedSource, OWL.annotatedProperty, OWL.annotatedTarget).collect(Iter.toUnmodifiableSet());
    private static final Set<Node> REQUIRED_PROPERTY_NODES = Iter.asUnmodifiableNodeSet(REQUIRED_PROPERTIES);
    private static final Node AXIOM = OWL.Axiom.asNode();
    private static final Node ANNOTATION = OWL.Annotation.asNode();
    public static final Set<Property> SPEC = Stream.concat(Stream.of(RDF.type), REQUIRED_PROPERTIES.stream()).collect(Iter.toUnmodifiableSet());
    public static final Set<Resource> EXTRA_ROOT_TYPES = Stream.of(OWL.AllDisjointClasses, OWL.AllDisjointProperties, OWL.AllDifferent, OWL.NegativePropertyAssertion).collect(Iter.toUnmodifiableSet());
    public static final List<Resource> ROOT_TYPES = Stream.concat(Stream.of(OWL.Axiom, OWL.Annotation), EXTRA_ROOT_TYPES.stream()).collect(Iter.toUnmodifiableList());
    public static final Set<Node> EXTRA_ROOT_TYPES_AS_NODES = Iter.asUnmodifiableNodeSet(EXTRA_ROOT_TYPES);
    public static ObjectFactory annotationFactory = Factories.createCommon(OntAnnotationImpl.class, OntAnnotationImpl::listRootAnnotations, OntAnnotationImpl::testAnnotation, new OntFilter[0]);
    public static final Comparator<OntAnnotation> DEFAULT_ANNOTATION_COMPARATOR = (left, right) -> {
        Set leftSet = OntAnnotationImpl.listRelatedStatements(left).toSet();
        Set rightSet = OntAnnotationImpl.listRelatedStatements(right).toSet();
        int res = Integer.compare(leftSet.size(), rightSet.size());
        while (res == 0) {
            OntStatement s1 = (OntStatement)OntAnnotationImpl.removeMin(leftSet, Models.STATEMENT_COMPARATOR_IGNORE_BLANK);
            OntStatement s2 = (OntStatement)OntAnnotationImpl.removeMin(rightSet, Models.STATEMENT_COMPARATOR_IGNORE_BLANK);
            res = Models.STATEMENT_COMPARATOR_IGNORE_BLANK.compare(s1, s2);
            if (!leftSet.isEmpty() && !rightSet.isEmpty()) continue;
            break;
        }
        return -res;
    };

    public OntAnnotationImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public static OntAnnotation createAnnotation(Model model, Statement base, Resource type) {
        Resource res = Objects.requireNonNull(model).createResource();
        if (!model.contains(Objects.requireNonNull(base))) {
            throw new OntJenaException.IllegalArgument("Can't find " + Models.toString(base));
        }
        res.addProperty(RDF.type, (RDFNode)type);
        res.addProperty(OWL.annotatedSource, (RDFNode)base.getSubject());
        res.addProperty(OWL.annotatedProperty, (RDFNode)base.getPredicate());
        res.addProperty(OWL.annotatedTarget, base.getObject());
        return (OntAnnotation)res.as(OntAnnotation.class);
    }

    @Override
    public ExtendedIterator<OntStatement> listSpec() {
        return this.listStatements().filterKeep(s -> SPEC.contains(s.getPredicate()) || s.isAnnotationAssertion());
    }

    @Override
    public OntStatement getBase() {
        Resource s = this.getRequiredObject(OWL.annotatedSource, Resource.class);
        Property p = this.getRequiredObject(OWL.annotatedProperty, Property.class);
        RDFNode o = this.getRequiredObject(OWL.annotatedTarget, RDFNode.class);
        return this.getModel().createStatement(s, p, o);
    }

    @Override
    public ExtendedIterator<OntStatement> listAssertions() {
        return this.listStatements().filterKeep(s -> !SPEC.contains(s.getPredicate()) && s.isAnnotationAssertion());
    }

    @Override
    public ExtendedIterator<OntStatement> listAnnotations() {
        return this.listAssertions();
    }

    @Override
    public Stream<OntAnnotation> descendants() {
        return Iter.asStream(this.listDescendants(), this.getCharacteristics());
    }

    public ExtendedIterator<OntAnnotation> listDescendants() {
        OntGraphModelImpl m = this.getModel();
        return this.listAnnotatedSources().mapWith(s -> m.findNodeAs(((OntStatementImpl)s).getSubjectNode(), OntAnnotation.class)).filterDrop(Objects::isNull);
    }

    protected ExtendedIterator<OntStatement> listAnnotatedSources() {
        return this.getModel().listOntStatements(null, OWL.annotatedSource, (RDFNode)this);
    }

    @Override
    public OntStatement addAnnotation(OntAnnotationProperty property, RDFNode value) {
        return this.getModel().add(this, property, value).createStatement(this, property, value);
    }

    @Override
    public Class<? extends OntObject> getActualClass() {
        return OntAnnotation.class;
    }

    public static ExtendedIterator<Node> listRootAnnotations(EnhGraph eg) {
        return Iter.flatMap(Iter.of(AXIOM).andThen(EXTRA_ROOT_TYPES_AS_NODES.iterator()), t -> eg.asGraph().find(Node.ANY, RDF.Nodes.type, t)).mapWith(Triple::getSubject);
    }

    public static boolean testAnnotation(Node node, EnhGraph graph) {
        return OntAnnotationImpl.testAnnotation(node, graph.asGraph());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testAnnotation(Node node, Graph graph) {
        if (!node.isBlank()) {
            return false;
        }
        try (ExtendedIterator types = graph.find(node, RDF.Nodes.type, Node.ANY).mapWith(Triple::getObject);){
            while (types.hasNext()) {
                Node t = (Node)types.next();
                if (AXIOM.equals((Object)t) || ANNOTATION.equals((Object)t)) {
                    Set props = graph.find(node, Node.ANY, Node.ANY).mapWith(Triple::getPredicate).toSet();
                    boolean bl = props.containsAll(REQUIRED_PROPERTY_NODES);
                    return bl;
                }
                if (!EXTRA_ROOT_TYPES_AS_NODES.contains(t)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static <S> S removeMin(Set<S> notEmptySet, Comparator<? super S> comparator) throws IllegalStateException {
        S res = notEmptySet.stream().min(comparator).orElseThrow(IllegalStateException::new);
        if (!notEmptySet.remove(res)) {
            throw new IllegalStateException();
        }
        return res;
    }

    public static ExtendedIterator<OntStatement> listRelatedStatements(OntAnnotation annotation) {
        OntAnnotationImpl a = (OntAnnotationImpl)annotation;
        return a.listAssertions().andThen((Iterator)a.listDescendants().mapWith(OntObject::getMainStatement));
    }
}

