/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.objects;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.objects.ModelObject;
import com.github.owlcs.ontapi.internal.objects.ONTExpressionImpl;
import com.github.owlcs.ontapi.internal.objects.ONTObjectImpl;
import com.github.owlcs.ontapi.internal.objects.WithContent;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntSWRL;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.owlapi.OWLObjectImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.AsOWLNamedIndividual;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBinaryAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLPredicate;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLUnaryAtom;
import org.semanticweb.owlapi.vocab.SWRLBuiltInsVocabulary;

public abstract class ONTSWRLAtomImpl<ONT extends OntSWRL.Atom<?>, OWL extends SWRLAtom>
extends ONTExpressionImpl<ONT>
implements SWRLAtom,
ModelObject<OWL> {
    protected ONTSWRLAtomImpl(BlankNodeId n, Supplier<OntModel> m) {
        super(n, m);
    }

    public static ONTSWRLAtomImpl create(OntSWRL.Atom<?> atom, InternalObjectFactory factory, Supplier<OntModel> model) {
        Class<OntSWRL.Atom<?>> type = OntModels.getOntType(atom);
        BlankNodeId id = atom.asNode().getBlankNodeId();
        ONTSWRLAtomImpl<?, ?> res = ONTSWRLAtomImpl.create(id, type, model);
        res.putContent(res.initContent(atom, factory));
        return res;
    }

    public static ONTSWRLAtomImpl<?, ?> create(BlankNodeId id, Class<? extends OntSWRL.Atom<?>> type, Supplier<OntModel> model) {
        if (type == OntSWRL.Atom.WithBuiltin.class) {
            return new BN(id, model);
        }
        if (type == OntSWRL.Atom.WithClass.class) {
            return new CU(id, model);
        }
        if (type == OntSWRL.Atom.WithDataRange.class) {
            return new DU(id, model);
        }
        if (type == OntSWRL.Atom.WithObjectProperty.class) {
            return new OPB(id, model);
        }
        if (type == OntSWRL.Atom.WithDataProperty.class) {
            return new DPB(id, model);
        }
        if (type == OntSWRL.Atom.WithDifferentIndividuals.class) {
            return new DIB(id, model);
        }
        if (type == OntSWRL.Atom.WithSameIndividuals.class) {
            return new SIB(id, model);
        }
        throw new OntApiException.IllegalState();
    }

    protected static Object fromIArgument(OntSWRL.IArg argument, Object object) {
        if (argument.isAnon()) {
            return argument.asNode().getBlankNodeId();
        }
        if (argument.canAs(OntSWRL.Variable.class)) {
            return object;
        }
        return argument.asNode().getURI();
    }

    protected static Object fromDArgument(OntSWRL.DArg argument, Object object) {
        if (argument.isLiteral()) {
            return argument.asNode().getLiteral();
        }
        return object;
    }

    @Override
    public OWL getOWLObject() {
        return (OWL)this;
    }

    @Override
    public boolean canContainAnnotationProperties() {
        return false;
    }

    protected Stream<OWLDatatype> datatypes() {
        return this.objects().map(x -> {
            Object a = x.getOWLObject();
            if (a instanceof OWLDatatype) {
                return (OWLDatatype)a;
            }
            if (a instanceof SWRLLiteralArgument) {
                return ((SWRLLiteralArgument)a).getLiteral().getDatatype();
            }
            return null;
        }).filter(Objects::nonNull);
    }

    protected Stream<OWLIndividual> individuals() {
        return this.objects().map(x -> {
            Object a = x.getOWLObject();
            if (a instanceof OWLIndividual) {
                return (OWLIndividual)a;
            }
            if (a instanceof SWRLIndividualArgument) {
                return ((SWRLIndividualArgument)a).getIndividual();
            }
            return null;
        }).filter(Objects::nonNull);
    }

    protected ONTObject<? extends SWRLIArgument> toIArgument(Object item, InternalObjectFactory factory) {
        if (!(item instanceof String) && !(item instanceof BlankNodeId)) {
            return (ONTObject)item;
        }
        if (factory instanceof ModelObjectFactory) {
            ModelObjectFactory mf = (ModelObjectFactory)factory;
            return item instanceof String ? mf.getSWRLArgument((String)item) : mf.getSWRLArgument((BlankNodeId)item);
        }
        Node node = item instanceof String ? NodeFactory.createURI((String)((String)item)) : NodeFactory.createBlankNode((BlankNodeId)((BlankNodeId)item));
        return factory.getSWRLArgument((OntSWRL.IArg)this.getModel().asRDFNode(node).as(OntSWRL.IArg.class));
    }

    protected ONTObject<? extends SWRLDArgument> toDArgument(Object item, InternalObjectFactory factory) {
        if (!(item instanceof LiteralLabel)) {
            return (ONTObject)item;
        }
        if (factory instanceof ModelObjectFactory) {
            ModelObjectFactory mf = (ModelObjectFactory)factory;
            return mf.getSWRLArgument((LiteralLabel)item);
        }
        Node node = NodeFactory.createLiteral((LiteralLabel)((LiteralLabel)item));
        return factory.getSWRLArgument((OntSWRL.DArg)this.getModel().asRDFNode(node).as(OntSWRL.DArg.class));
    }

    protected static abstract class Unary<ONT_P extends OntObject, ONT_A extends OntSWRL.Arg, ONT_R extends OntSWRL.Atom.Unary<ONT_P, ONT_A>, OWL_P extends OWLObject & SWRLPredicate, OWL_A extends SWRLArgument, OWL_R extends SWRLUnaryAtom<OWL_A>>
    extends ONTSWRLAtomImpl<ONT_R, SWRLUnaryAtom<OWL_A>> {
        protected Unary(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        public OWL_P getPredicate() {
            return this.getONTPredicate().getOWLObject();
        }

        public Stream<SWRLArgument> allArguments() {
            return Stream.of(this.getArgument());
        }

        public OWL_A getArgument() {
            return (OWL_A)((SWRLArgument)this.getONTArgument().getOWLObject());
        }

        public ONTObject<? extends OWL_A> getONTArgument() {
            return this.findONTArgument(this.getObjectFactory());
        }

        public ONTObject<? extends OWL_P> getONTPredicate() {
            return this.findONTPredicate(this.getObjectFactory());
        }

        protected ONTObject<? extends OWL_A> findONTArgument(InternalObjectFactory factory) {
            return this.toArgument(this.getContent()[1], factory);
        }

        protected ONTObject<? extends OWL_P> findONTPredicate(InternalObjectFactory factory) {
            return this.toPredicate(this.getContent()[0], factory);
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            InternalObjectFactory factory = this.getObjectFactory();
            return Stream.of(this.findONTPredicate(factory), this.findONTArgument(factory));
        }

        @Override
        public OWL_R eraseModel() {
            return this.fromFactory(Unary.eraseModel(this.getPredicate()), (SWRLArgument)Unary.eraseModel(this.getArgument()));
        }

        abstract OWL_R fromFactory(OWL_P var1, OWL_A var2);

        @Override
        protected Object[] collectContent(ONT_R obj, InternalObjectFactory factory) {
            Object p = obj.getPredicate();
            Object a = obj.getArg();
            ONTObject<OWL_P> predicate = this.mapPredicate(p, factory);
            ONTObject<OWL_A> argument = this.mapArgument(a, factory);
            return new Object[]{this.fromPredicate(p, predicate), this.fromArgument(a, argument)};
        }

        @Override
        protected Object[] initContent(ONT_R obj, InternalObjectFactory factory) {
            Object p = obj.getPredicate();
            Object a = obj.getArg();
            ONTObject<OWL_A> argument = this.mapArgument(a, factory);
            ONTObject<OWL_P> predicate = this.mapPredicate(p, factory);
            int res = OWLObject.hashIteration((int)this.hashIndex(), (int)argument.hashCode());
            this.hashCode = res = OWLObject.hashIteration((int)res, (int)predicate.hashCode());
            return new Object[]{this.fromPredicate(p, predicate), this.fromArgument(a, argument)};
        }

        Object fromPredicate(ONT_P predicate, Object object) {
            return predicate.isURIResource() ? predicate.asNode().getURI() : object;
        }

        abstract Object fromArgument(ONT_A var1, ONTObject<? extends OWL_A> var2);

        abstract ONTObject<? extends OWL_P> mapPredicate(ONT_P var1, InternalObjectFactory var2);

        abstract ONTObject<? extends OWL_A> mapArgument(ONT_A var1, InternalObjectFactory var2);

        abstract ONTObject<? extends OWL_P> toPredicate(Object var1, InternalObjectFactory var2);

        abstract ONTObject<? extends OWL_A> toArgument(Object var1, InternalObjectFactory var2);
    }

    protected static abstract class Binary<ONT_P extends OntObject, ONT_F extends OntSWRL.Arg, ONT_S extends OntSWRL.Arg, ONT_R extends OntSWRL.Atom.Binary<ONT_P, ONT_F, ONT_S>, OWL_P extends OWLObject & SWRLPredicate, OWL_F extends SWRLArgument, OWL_S extends SWRLArgument, OWL_R extends SWRLBinaryAtom<OWL_F, OWL_S>>
    extends ONTSWRLAtomImpl<ONT_R, OWL_R> {
        protected Binary(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        public OWL_P getPredicate() {
            return this.getONTPredicate().getOWLObject();
        }

        public Stream<SWRLArgument> allArguments() {
            return Stream.of(this.getFirstArgument(), this.getSecondArgument());
        }

        public OWL_F getFirstArgument() {
            return (OWL_F)((SWRLArgument)this.getFirstONTArgument().getOWLObject());
        }

        public OWL_S getSecondArgument() {
            return (OWL_S)((SWRLArgument)this.getSecondONTArgument().getOWLObject());
        }

        public ONTObject<? extends OWL_P> getONTPredicate() {
            return this.findONTPredicate(this.getObjectFactory());
        }

        public ONTObject<? extends OWL_F> getFirstONTArgument() {
            return this.findONTFirstArgument(this.getObjectFactory());
        }

        public ONTObject<? extends OWL_S> getSecondONTArgument() {
            return this.findONTSecondArgument(this.getObjectFactory());
        }

        protected ONTObject<? extends OWL_F> findONTFirstArgument(InternalObjectFactory factory) {
            return this.toFirstArgument(this.getContent()[1], factory);
        }

        protected ONTObject<? extends OWL_S> findONTSecondArgument(InternalObjectFactory factory) {
            return this.toSecondArgument(this.getContent()[2], factory);
        }

        protected ONTObject<? extends OWL_P> findONTPredicate(InternalObjectFactory factory) {
            return this.toPredicate(this.getContent()[0], factory);
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            InternalObjectFactory factory = this.getObjectFactory();
            return Stream.of(this.findONTPredicate(factory), this.findONTFirstArgument(factory), this.findONTSecondArgument(factory));
        }

        @Override
        public OWL_R eraseModel() {
            return this.fromFactory(this.factoryPredicate(), (SWRLArgument)Binary.eraseModel(this.getFirstArgument()), (SWRLArgument)Binary.eraseModel(this.getSecondArgument()));
        }

        OWL_P factoryPredicate() {
            return Binary.eraseModel(this.getPredicate());
        }

        abstract OWL_R fromFactory(OWL_P var1, OWL_F var2, OWL_S var3);

        @Override
        protected Object[] collectContent(ONT_R obj, InternalObjectFactory factory) {
            Object p = obj.getPredicate();
            Object f = obj.getFirstArg();
            Object s = obj.getSecondArg();
            ONTObject<OWL_P> predicate = this.mapPredicate(p, factory);
            ONTObject<OWL_F> first = this.mapFirstArgument(f, factory);
            ONTObject<OWL_S> second = this.mapSecondArgument(s, factory);
            return new Object[]{this.fromPredicate(p, predicate), this.fromFirstArgument(f, first), this.fromSecondArgument(s, second)};
        }

        @Override
        protected Object[] initContent(ONT_R obj, InternalObjectFactory factory) {
            Object p = obj.getPredicate();
            Object f = obj.getFirstArg();
            Object s = obj.getSecondArg();
            ONTObject<OWL_P> predicate = this.mapPredicate(p, factory);
            ONTObject<OWL_F> first = this.mapFirstArgument(f, factory);
            ONTObject<OWL_S> second = this.mapSecondArgument(s, factory);
            int res = OWLObject.hashIteration((int)this.hashIndex(), (int)first.hashCode());
            res = OWLObject.hashIteration((int)res, (int)second.hashCode());
            this.hashCode = res = OWLObject.hashIteration((int)res, (int)predicate.hashCode());
            return new Object[]{this.fromPredicate(p, predicate), this.fromFirstArgument(f, first), this.fromSecondArgument(s, second)};
        }

        Object fromPredicate(ONT_P predicate, Object object) {
            return predicate.isURIResource() ? predicate.asNode().getURI() : object;
        }

        abstract Object fromFirstArgument(ONT_F var1, ONTObject<? extends OWL_F> var2);

        abstract Object fromSecondArgument(ONT_S var1, ONTObject<? extends OWL_S> var2);

        abstract ONTObject<? extends OWL_P> mapPredicate(ONT_P var1, InternalObjectFactory var2);

        abstract ONTObject<? extends OWL_F> mapFirstArgument(ONT_F var1, InternalObjectFactory var2);

        abstract ONTObject<? extends OWL_S> mapSecondArgument(ONT_S var1, InternalObjectFactory var2);

        abstract ONTObject<? extends OWL_P> toPredicate(Object var1, InternalObjectFactory var2);

        abstract ONTObject<? extends OWL_F> toFirstArgument(Object var1, InternalObjectFactory var2);

        abstract ONTObject<? extends OWL_S> toSecondArgument(Object var1, InternalObjectFactory var2);
    }

    protected static abstract class ObjectBinary<ONT_P extends OntObjectProperty, OWL_P extends OWLObjectPropertyExpression, ONT_R extends OntSWRL.Atom.Binary<ONT_P, OntSWRL.IArg, OntSWRL.IArg>, OWL_R extends SWRLBinaryAtom<SWRLIArgument, SWRLIArgument>>
    extends Binary<ONT_P, OntSWRL.IArg, OntSWRL.IArg, ONT_R, OWL_P, SWRLIArgument, SWRLIArgument, OWL_R> {
        protected ObjectBinary(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        ONTObject<? extends OWL_P> mapPredicate(ONT_P p, InternalObjectFactory factory) {
            return factory.getProperty((OntObjectProperty)p);
        }

        @Override
        ONTObject<? extends SWRLIArgument> mapFirstArgument(OntSWRL.IArg a, InternalObjectFactory factory) {
            return factory.getSWRLArgument(a);
        }

        @Override
        ONTObject<? extends SWRLIArgument> mapSecondArgument(OntSWRL.IArg a, InternalObjectFactory factory) {
            return factory.getSWRLArgument(a);
        }

        @Override
        ONTObject<? extends OWL_P> toPredicate(Object item, InternalObjectFactory factory) {
            return this.toOPE(item, factory);
        }

        @Override
        ONTObject<? extends SWRLIArgument> toFirstArgument(Object item, InternalObjectFactory factory) {
            return this.toIArgument(item, factory);
        }

        @Override
        ONTObject<? extends SWRLIArgument> toSecondArgument(Object item, InternalObjectFactory factory) {
            return this.toIArgument(item, factory);
        }

        @Override
        Object fromFirstArgument(OntSWRL.IArg arg, ONTObject<? extends SWRLIArgument> object) {
            return ObjectBinary.fromIArgument(arg, object);
        }

        @Override
        Object fromSecondArgument(OntSWRL.IArg arg, ONTObject<? extends SWRLIArgument> object) {
            return ObjectBinary.fromIArgument(arg, object);
        }

        @Override
        protected Stream<OWLIndividual> individuals() {
            InternalObjectFactory factory = this.getObjectFactory();
            return Stream.of(this.findONTFirstArgument(factory), this.findONTSecondArgument(factory)).map(ONTObject::getOWLObject).filter(x -> x instanceof SWRLIndividualArgument).map(x -> ((SWRLIndividualArgument)x).getIndividual());
        }

        @Override
        public Set<OWLEntity> getSignatureSet() {
            Set<OWLEntity> res = ObjectBinary.createSortedSet();
            res.add((OWLEntity)((OWLObjectPropertyExpression)this.getPredicate()).getNamedProperty());
            this.individuals().filter(AsOWLNamedIndividual::isOWLNamedIndividual).forEach(x -> res.add((OWLEntity)x.asOWLNamedIndividual()));
            return res;
        }

        @Override
        public boolean containsObjectProperty(OWLObjectProperty property) {
            return ((OWLObjectPropertyExpression)this.getPredicate()).getNamedProperty().equals(property);
        }

        @Override
        public boolean containsNamedIndividual(OWLNamedIndividual individual) {
            return this.individuals().filter(AsOWLNamedIndividual::isOWLNamedIndividual).anyMatch(individual::equals);
        }

        @Override
        public Set<OWLObjectProperty> getObjectPropertySet() {
            return ObjectBinary.createSet(((OWLObjectPropertyExpression)this.getPredicate()).getNamedProperty());
        }

        @Override
        public Set<OWLNamedIndividual> getNamedIndividualSet() {
            return this.individuals().filter(AsOWLNamedIndividual::isOWLNamedIndividual).map(AsOWLNamedIndividual::asOWLNamedIndividual).collect(Collectors.toCollection(OWLObjectImpl::createSortedSet));
        }

        @Override
        public Set<OWLAnonymousIndividual> getAnonymousIndividualSet() {
            return this.individuals().filter(x -> !x.isOWLNamedIndividual()).map(OWLIndividual::asOWLAnonymousIndividual).collect(Collectors.toCollection(OWLObjectImpl::createSortedSet));
        }

        @Override
        public boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public boolean canContainDatatypes() {
            return false;
        }

        @Override
        public boolean canContainDataProperties() {
            return false;
        }

        @Override
        public boolean canContainClassExpressions() {
            return false;
        }
    }

    public static class OPB
    extends ObjectBinary<OntObjectProperty, OWLObjectPropertyExpression, OntSWRL.Atom.WithObjectProperty, SWRLObjectPropertyAtom>
    implements SWRLObjectPropertyAtom {
        protected OPB(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntSWRL.Atom.WithObjectProperty asRDFNode() {
            return this.as(OntSWRL.Atom.WithObjectProperty.class);
        }

        public SWRLObjectPropertyAtom getSimplified() {
            OWLObjectPropertyExpression p = (OWLObjectPropertyExpression)this.getPredicate();
            OWLObjectPropertyExpression ps = p.getSimplified();
            if (ps.equals(p)) {
                return (SWRLObjectPropertyAtom)this.eraseModel();
            }
            DataFactory df = this.getDataFactory();
            ps = OPB.eraseModel(ps);
            SWRLIArgument f = (SWRLIArgument)OPB.eraseModel(this.getFirstArgument());
            SWRLIArgument s = (SWRLIArgument)OPB.eraseModel(this.getSecondArgument());
            if (ps.isAnonymous()) {
                return df.getSWRLObjectPropertyAtom(ps.getInverseProperty(), s, f);
            }
            return df.getSWRLObjectPropertyAtom(ps, f, s);
        }

        @Override
        protected Object[] collectContent(OntSWRL.Atom.WithObjectProperty obj, InternalObjectFactory factory) {
            return new Object[]{factory.getProperty((OntObjectProperty)obj.getPredicate()), factory.getSWRLArgument((OntSWRL.IArg)obj.getFirstArg()), factory.getSWRLArgument((OntSWRL.IArg)obj.getSecondArg())};
        }

        @Override
        SWRLObjectPropertyAtom fromFactory(OWLObjectPropertyExpression p, SWRLIArgument f, SWRLIArgument s) {
            return this.getDataFactory().getSWRLObjectPropertyAtom(p, f, s);
        }
    }

    public static class DPB
    extends Binary<OntDataProperty, OntSWRL.IArg, OntSWRL.DArg, OntSWRL.Atom.WithDataProperty, OWLDataProperty, SWRLIArgument, SWRLDArgument, SWRLDataPropertyAtom>
    implements SWRLDataPropertyAtom {
        protected DPB(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntSWRL.Atom.WithDataProperty asRDFNode() {
            return this.as(OntSWRL.Atom.WithDataProperty.class);
        }

        @Override
        protected Object[] collectContent(OntSWRL.Atom.WithDataProperty obj, InternalObjectFactory factory) {
            return new Object[]{factory.getProperty((OntDataProperty)obj.getPredicate()), factory.getSWRLArgument((OntSWRL.IArg)obj.getFirstArg()), factory.getSWRLArgument((OntSWRL.DArg)obj.getSecondArg())};
        }

        @Override
        ONTObject<? extends OWLDataProperty> mapPredicate(OntDataProperty p, InternalObjectFactory factory) {
            return factory.getProperty(p);
        }

        @Override
        ONTObject<? extends SWRLIArgument> mapFirstArgument(OntSWRL.IArg a, InternalObjectFactory factory) {
            return factory.getSWRLArgument(a);
        }

        @Override
        ONTObject<? extends SWRLDArgument> mapSecondArgument(OntSWRL.DArg a, InternalObjectFactory factory) {
            return factory.getSWRLArgument(a);
        }

        @Override
        ONTObject<? extends OWLDataProperty> toPredicate(Object item, InternalObjectFactory factory) {
            return this.toNDP(item, factory);
        }

        @Override
        ONTObject<? extends SWRLIArgument> toFirstArgument(Object item, InternalObjectFactory factory) {
            return this.toIArgument(item, factory);
        }

        @Override
        ONTObject<? extends SWRLDArgument> toSecondArgument(Object item, InternalObjectFactory factory) {
            return this.toDArgument(item, factory);
        }

        @Override
        Object fromFirstArgument(OntSWRL.IArg arg, ONTObject<? extends SWRLIArgument> object) {
            return DPB.fromIArgument(arg, object);
        }

        @Override
        Object fromSecondArgument(OntSWRL.DArg arg, ONTObject<? extends SWRLDArgument> object) {
            return DPB.fromDArgument(arg, object);
        }

        @Override
        SWRLDataPropertyAtom fromFactory(OWLDataProperty d, SWRLIArgument f, SWRLDArgument s) {
            return this.getDataFactory().getSWRLDataPropertyAtom((OWLDataPropertyExpression)d, f, s);
        }

        @Override
        public boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public boolean canContainObjectProperties() {
            return false;
        }

        @Override
        public boolean canContainClassExpressions() {
            return false;
        }
    }

    public static class DIB
    extends ObjectBinary<OntObjectProperty.Named, OWLObjectProperty, OntSWRL.Atom.WithDifferentIndividuals, SWRLDifferentIndividualsAtom>
    implements SWRLDifferentIndividualsAtom {
        protected DIB(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntSWRL.Atom.WithDifferentIndividuals asRDFNode() {
            return this.as(OntSWRL.Atom.WithDifferentIndividuals.class);
        }

        @Override
        protected Object[] collectContent(OntSWRL.Atom.WithDifferentIndividuals obj, InternalObjectFactory factory) {
            return new Object[]{factory.getProperty((OntObjectProperty.Named)obj.getPredicate()), factory.getSWRLArgument((OntSWRL.IArg)obj.getFirstArg()), factory.getSWRLArgument((OntSWRL.IArg)obj.getSecondArg())};
        }

        @Override
        SWRLDifferentIndividualsAtom fromFactory(OWLObjectProperty p, SWRLIArgument f, SWRLIArgument s) {
            return this.getDataFactory().getSWRLDifferentIndividualsAtom(f, s);
        }

        @Override
        OWLObjectProperty factoryPredicate() {
            return null;
        }
    }

    public static class SIB
    extends ObjectBinary<OntObjectProperty.Named, OWLObjectProperty, OntSWRL.Atom.WithSameIndividuals, SWRLSameIndividualAtom>
    implements SWRLSameIndividualAtom {
        protected SIB(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntSWRL.Atom.WithSameIndividuals asRDFNode() {
            return this.as(OntSWRL.Atom.WithSameIndividuals.class);
        }

        @Override
        protected Object[] collectContent(OntSWRL.Atom.WithSameIndividuals obj, InternalObjectFactory factory) {
            return new Object[]{factory.getProperty((OntObjectProperty.Named)obj.getPredicate()), factory.getSWRLArgument((OntSWRL.IArg)obj.getFirstArg()), factory.getSWRLArgument((OntSWRL.IArg)obj.getSecondArg())};
        }

        @Override
        SWRLSameIndividualAtom fromFactory(OWLObjectProperty p, SWRLIArgument f, SWRLIArgument s) {
            return this.getDataFactory().getSWRLSameIndividualAtom(f, s);
        }

        @Override
        OWLObjectProperty factoryPredicate() {
            return null;
        }
    }

    public static class DU
    extends Unary<OntDataRange, OntSWRL.DArg, OntSWRL.Atom.WithDataRange, OWLDataRange, SWRLDArgument, SWRLDataRangeAtom>
    implements SWRLDataRangeAtom {
        protected DU(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntSWRL.Atom.WithDataRange asRDFNode() {
            return this.as(OntSWRL.Atom.WithDataRange.class);
        }

        @Override
        ONTObject<? extends OWLDataRange> mapPredicate(OntDataRange dr, InternalObjectFactory factory) {
            return factory.getDatatype(dr);
        }

        @Override
        ONTObject<? extends SWRLDArgument> mapArgument(OntSWRL.DArg arg, InternalObjectFactory factory) {
            return factory.getSWRLArgument(arg);
        }

        @Override
        ONTObject<? extends OWLDataRange> toPredicate(Object item, InternalObjectFactory factory) {
            return this.toDR(item, factory);
        }

        @Override
        ONTObject<? extends SWRLDArgument> toArgument(Object item, InternalObjectFactory factory) {
            return this.toDArgument(item, factory);
        }

        @Override
        Object fromArgument(OntSWRL.DArg arg, ONTObject<? extends SWRLDArgument> object) {
            return DU.fromDArgument(arg, object);
        }

        @Override
        SWRLDataRangeAtom fromFactory(OWLDataRange d, SWRLDArgument a) {
            return this.getDataFactory().getSWRLDataRangeAtom(d, a);
        }

        @Override
        public Set<OWLEntity> getSignatureSet() {
            return this.datatypes().collect(Collectors.toCollection(OWLObjectImpl::createSortedSet));
        }

        @Override
        public boolean containsDatatype(OWLDatatype datatype) {
            return this.datatypes().anyMatch(datatype::equals);
        }

        @Override
        public boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public Set<OWLDatatype> getDatatypeSet() {
            return this.datatypes().collect(Collectors.toCollection(OWLObjectImpl::createSortedSet));
        }

        @Override
        public boolean canContainNamedIndividuals() {
            return false;
        }

        @Override
        public boolean canContainDataProperties() {
            return false;
        }

        @Override
        public boolean canContainObjectProperties() {
            return false;
        }

        @Override
        public boolean canContainClassExpressions() {
            return false;
        }

        @Override
        public boolean canContainAnonymousIndividuals() {
            return false;
        }
    }

    public static class CU
    extends Unary<OntClass, OntSWRL.IArg, OntSWRL.Atom.WithClass, OWLClassExpression, SWRLIArgument, SWRLClassAtom>
    implements SWRLClassAtom {
        protected CU(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntSWRL.Atom.WithClass asRDFNode() {
            return this.as(OntSWRL.Atom.WithClass.class);
        }

        @Override
        ONTObject<? extends OWLClassExpression> mapPredicate(OntClass predicate, InternalObjectFactory factory) {
            return factory.getClass(predicate);
        }

        @Override
        ONTObject<? extends SWRLIArgument> mapArgument(OntSWRL.IArg arg, InternalObjectFactory factory) {
            return factory.getSWRLArgument(arg);
        }

        @Override
        ONTObject<? extends OWLClassExpression> toPredicate(Object item, InternalObjectFactory factory) {
            return this.toCE(item, factory);
        }

        @Override
        ONTObject<? extends SWRLIArgument> toArgument(Object item, InternalObjectFactory factory) {
            return this.toIArgument(item, factory);
        }

        @Override
        Object fromArgument(OntSWRL.IArg arg, ONTObject<? extends SWRLIArgument> object) {
            return CU.fromIArgument(arg, object);
        }

        @Override
        SWRLClassAtom fromFactory(OWLClassExpression c, SWRLIArgument a) {
            return this.getDataFactory().getSWRLClassAtom(c, a);
        }
    }

    public static class BN
    extends ONTSWRLAtomImpl<OntSWRL.Atom.WithBuiltin, SWRLBuiltInAtom>
    implements SWRLBuiltInAtom {
        protected BN(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntSWRL.Atom.WithBuiltin asRDFNode() {
            return this.as(OntSWRL.Atom.WithBuiltin.class);
        }

        public IRI getPredicate() {
            return (IRI)this.getContent()[0];
        }

        public boolean isCoreBuiltIn() {
            return SWRLBuiltInsVocabulary.getBuiltIn((IRI)this.getPredicate()) != null;
        }

        public Stream<SWRLArgument> allArguments() {
            return this.objects().map(x -> (SWRLDArgument)x.getOWLObject());
        }

        public Stream<SWRLDArgument> arguments() {
            return this.objects().map(x -> (SWRLDArgument)x.getOWLObject());
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            return this.objects(this.getObjectFactory());
        }

        protected Stream<ONTObject<? extends OWLObject>> objects(InternalObjectFactory factory) {
            List<Object> res = Arrays.asList(this.getContent());
            return res.stream().skip(1L).map(x -> this.toDArgument(x, factory));
        }

        @Override
        public SWRLBuiltInAtom eraseModel() {
            return this.getDataFactory().getSWRLBuiltInAtom(this.getPredicate(), this.arguments().map(ONTObjectImpl::eraseModel).collect(Collectors.toList()));
        }

        @Override
        protected Object[] collectContent(OntSWRL.Atom.WithBuiltin atom, InternalObjectFactory factory) {
            IRI predicate = factory.toIRI(((OntSWRL.Builtin)atom.getPredicate()).getURI());
            ArrayList<IRI> res = new ArrayList<IRI>();
            res.add(predicate);
            OntModels.listMembers(atom.getArgList()).forEachRemaining(arg -> res.add((IRI)(arg.isLiteral() ? arg.asNode().getLiteral() : factory.getSWRLArgument((OntSWRL.DArg)arg))));
            return res.toArray();
        }

        @Override
        protected Object[] initContent(OntSWRL.Atom.WithBuiltin atom, InternalObjectFactory factory) {
            IRI predicate = factory.toIRI(((OntSWRL.Builtin)atom.getPredicate()).getURI());
            ArrayList<Object> res = new ArrayList<Object>();
            res.add(predicate);
            ExtendedIterator<OntSWRL.DArg> it = OntModels.listMembers(atom.getArgList());
            int hash = 1;
            while (it.hasNext()) {
                OntSWRL.DArg r = (OntSWRL.DArg)it.next();
                ONTObject<? extends SWRLDArgument> op = factory.getSWRLArgument(r);
                hash = WithContent.hashIteration(hash, op.hashCode());
                res.add(BN.fromDArgument(r, op));
            }
            this.hashCode = OWLObject.hashIteration((int)OWLObject.hashIteration((int)this.hashIndex(), (int)hash), (int)predicate.hashCode());
            return res.toArray();
        }

        @Override
        public Set<OWLEntity> getSignatureSet() {
            return this.datatypes().collect(Collectors.toCollection(OWLObjectImpl::createSortedSet));
        }

        @Override
        public boolean containsDatatype(OWLDatatype datatype) {
            return this.datatypes().anyMatch(datatype::equals);
        }

        @Override
        public boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public Set<OWLDatatype> getDatatypeSet() {
            return this.datatypes().collect(Collectors.toCollection(OWLObjectImpl::createSortedSet));
        }

        @Override
        public boolean canContainNamedIndividuals() {
            return false;
        }

        @Override
        public boolean canContainDataProperties() {
            return false;
        }

        @Override
        public boolean canContainObjectProperties() {
            return false;
        }

        @Override
        public boolean canContainClassExpressions() {
            return false;
        }

        @Override
        public boolean canContainAnonymousIndividuals() {
            return false;
        }
    }
}

